/***************************************************************************
                                    kbattleship.h
                                  -----------------
    Developers: (c) 2000-2001 Nikolas Zimmermann <wildfox@kde.org>
                (c) 2000-2001 Daniel Molkentin <molkentin@kde.org>

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBATTLESHIP_H
#define KBATTLESHIP_H

#include <tdeaction.h>
#include <tdeapplication.h>
#include <tdeconfig.h>
#include <kiconloader.h>
#include <tdelocale.h>
#include <tdemainwindow.h>
#include <tdemenubar.h>
#include <tdemessagebox.h>
#include <kstdaction.h>

#include <tqstring.h>

#include "dialogs/infoDlg.h"

#include "kbaiplayer.h"
#include "kbattleshipclient.h"
#include "kbattleshipserver.h"
#include "kbattleshipview.h"
#include "kchatwidget.h"
#include "kclientdialog.h"
#include "konnectionhandling.h"
#include "kserverdialog.h"
#include "kship.h"
#include "kshiplist.h"
#include "kstatdialog.h"

class KBattleshipWindow : public TDEMainWindow
{
	TQ_OBJECT
  
public:
	enum{ID_STATUS_MSG, ID_PLAYER_OWN, ID_PLAYER_ENEMY};
	KBattleshipWindow();
	~KBattleshipWindow();

	void init();

	KShip *shipAt(int fieldx, int fieldy);
	KShip *enemyShipAt(int fieldx, int fieldy);

private slots:
	void changeShipPlacementDirection();
	void slotConfigureNotifications();
	void slotLost(KMessage *msg);
	void slotStatusMsg(const TQString &text);
	void slotReceivedEnemyFieldData(int fieldx, int fieldx1, int enemystate, int xstart, int xstop, int ystart, int ystop, bool death);
	void slotSendEnemyFieldState(int, int);
	void slotChangeOwnPlayer(const TQString &text);
	void slotChangeEnemyPlayer(const TQString &text);
	void slotSendVersion();
	void slotSendGreet();
	void slotShipsReady();
	void slotSetPlaceable(bool place);
	void slotSetShootable(bool shoot);
	void slotEnemyFieldClick(int fieldx, int fieldy);
	void slotSendMessage(int fieldx, int fieldy, int state);
	void slotSendMessage(KMessage *msg);
	void slotClientLost();
	void slotServerLost();
	void slotServerReplay();
	void slotClientReplay();
	void slotAIReady();
	void slotAIShootsAt(const TQPoint pos);
	void slotDeleteAI();
	void slotRestartAI();
	void slotSinglePlayer();
	void slotServerConnect();
	void slotDeleteConnectDialog();
	void slotNewServer();
	void slotDeleteServerDialog();
	void slotHighscore();
	void slotShowGrid();
	void slotStartBattleshipGame();
	void slotStartBattleshipGame(bool clearstat);
	void slotStartBattleshipServer();
	/**
	 * Get server to connect to from "Connect to server" dialog.
	 */
	void slotConnectToBattleshipServer();
 	void slotConnectToBattleshipServer(const TQString &host, int port, const TQString &nickname);
	void slotPlaceShipPreview(int fieldx, int fieldy);
	void slotPlaceShip(int fieldx, int fieldy);
	void slotChangeOwnFieldData(int fieldx, int fieldy, int type);
	void slotChangeEnemyFieldData(int fieldx, int fieldy, int type);
	void slotUpdateHighscore();
	void slotAbortNetworkGame();
	void slotReplay();
	void slotReplayRequest();
	void slotChangedNickCommand(const TQString &text);
	void slotSendChatMessage(const TQString &text);
	void slotEnemyClientInfo();
	void slotReceivedClientInformation(const TQString &client, const TQString &clientVersion, const TQString &clientInformation, const TQString &protocolVersion);

private:
	bool shift;
	void initActions();
	void initStatusBar();
	void initView();
	void initChat();
	void initShipPlacing();
	void saveOptions();
	void readOptions();

	void cleanup(bool placechange = true);
	void playSound(bool enemy, int fieldstate);
	void parseCommandLine();
		
	bool m_placeable;
	bool m_shootable;
	bool m_aiPlaying;
	bool m_serverHasClient;
	bool m_lost;
	int m_aiHits;

	TQString m_enemyClient;
	TQString m_enemyClientVersion;
	TQString m_enemyClientDescription;
	TQString m_enemyProtocolVersion;

	TDEConfig *m_config;
	KBAIPlayer *m_aiPlayer;
	KonnectionHandling *m_connection;
	KBattleshipServer *m_kbserver;
	KBattleshipClient *m_kbclient;
	KChatWidget *m_chat;
	KStatDialog *m_stat;
	KBattleshipView *m_view;
	TDEAction *m_gameServerConnect;
	TDEAction *m_gameNewServer;
	TDEAction *m_gameQuit;
	TDEAction *m_gameEnemyInfo;
	TDEAction *m_gameSingle;
	TDEToggleAction *m_configSound;
	TDEToggleAction *m_configGrid;
	KClientDialog *m_client;
	TDEServerDialog *m_server;
	KShipList *m_ownshiplist;
	KShipList *m_enemyshiplist;
	TQString m_ownNickname;
	TQString m_enemyNickname;

};
#endif
