#ifndef ATLANTIK_BOARDINFO_H
#define ATLANTIK_BOARDINFO_H

#include <tqcolor.h>
#include <tqstring.h>
#include <tqstringlist.h>
#include <tqptrlist.h>
#include <tqwidget.h>

#include <kdialogbase.h>

class KColorButton;
class KLineEdit;
class KURLLabel;

class TQVBoxLayout;

struct BoardInfo
{
	BoardInfo() { bgColor = TQt::lightGray; }
	TQString name;
	TQStringList authors;
	TQStringList credits;
	TQString description;
	TQString url;
	TQString version;
	TQColor bgColor;
};

class LotsaEdits : public TQWidget
{
	TQ_OBJECT
  

	public:
	LotsaEdits(bool, TQStringList=TQStringList(), TQWidget *parent=0, const char *name=0);

	public slots:
	TQStringList save();

	private slots:
	void more();
	void less();

	private:
	bool editable;
	TQPtrList<TQWidget> list;
	TQVBoxLayout *layout;
};

class BoardInfoDlg : public KDialogBase
{
	TQ_OBJECT
  
	
	public:
	BoardInfoDlg(bool editable, BoardInfo *, TQWidget *parent=0, const char *_name=0, bool = true);

	protected slots:
	void slotOk();
	void slotApply();

	private:
	KLineEdit *name;
	KLineEdit *url;
	KLineEdit *version;
	KLineEdit *description;
	KColorButton *bgColor;

	LotsaEdits *authors;
	LotsaEdits *credits;

	BoardInfo *info;
};

#endif
