/***************************************************************************
                          pybrowsenode.h  -  description
                             -------------------
    begin                : Mon Aug 27 2001
    copyright            : (C) 2001 by Christian Bird
    email                : chrisb@lineo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PYBROWSENODE_H
#define PYBROWSENODE_H

#include <tqlistview.h>
#include <tqpixmap.h>

#define PYCLASS 1
#define PYMETHOD 2
#define PYFUNCTION 3
#define PYVARIABLE 4
#define PYOTHER 5

/**
  *@author Christian Bird
  */



class PyBrowseNode : public TQListViewItem  {
public:
	TQPixmap *pyClassPixmap;

    PyBrowseNode(TQListView *parent, const TQString &a_name, const TQString &a_signature, int type);
	PyBrowseNode(TQListViewItem *parent, const TQString &a_name, const TQString &a_signature, int type);
	~PyBrowseNode();

    void init(const TQString &a_name, const TQString &a_signature, int nodeType);

    void setName(const TQString &name);
	TQString getName()const ;
    void setLine(int line);
    int getLine()const;
    void setSig(const TQString &signature);
	TQString getSig()const;
    void setType(int type);
    int getType()const;
    void setClass(const TQString &a_method_class);
    TQString getClass()const;

    TQString getQualifiedName()const;

private:
	TQString name;
    TQString signature;
    TQString node_class;
	int line;
	int node_type;

};

#endif
