/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999-2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>
		2001-2004 by Stanislav Visnovsky
			    <visnovsky@kde.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

  In addition, as a special exception, the copyright holders give
  permission to link the code of this program with any edition of
  the TQt library by Trolltech AS, Norway (or with modified versions
  of TQt that use the same license as TQt), and distribute linked
  combinations including the two.  You must obey the GNU General
  Public License in all respects for all of the code used other than
  TQt. If you modify this file, you may extend this exception to
  your version of the file, but you are not obligated to do so.  If
  you do not wish to do so, delete this exception statement from
  your version.

**************************************************************************** */
#ifndef CATALOGPRIVATE_H
#define CATALOGPRIVATE_H

#include <tqintcache.h>
#include <tqobject.h>
#include <tqptrlist.h>
#include <tqstringlist.h>
#include <tqmap.h>
#include <tqvaluevector.h>
#include <kurl.h>

#include "msgfmt.h"
#include "catalogsettings.h"
#include "catalogitem.h"
#include "regexpextractor.h"

class TQString;
class TQTextStream;
class KFileInfo;
class TQTextCodec;
class TQFile;
class FindOptions;
class TDEConfig;

namespace KBabel
{

class CatalogPrivate
{

public:

   /** url of the po-file, that belongs to this catalog */
   KURL _url;
   TQString _packageName;
   TQString _packageDir;

   /** holds the entries in the catalog */
   TQValueVector<CatalogItem> _entries;
   /** The header of the po-file. */
   CatalogItem _header;
   
   /** list of obsolete entries */
   TQValueList<CatalogItem> _obsoleteEntries;
   
   /** identification string for used import filter*/
   TQString _importID;
   TQString _mimeTypes;

   bool _modified;
   bool _readOnly;
   bool _generatedFromDocbook;
   bool _active;
   bool _stop;

   TQValueList<uint> _fuzzyIndex;
   TQValueList<uint> _untransIndex;
   TQValueList<uint> _errorIndex;

   TQPtrList<CatalogView> _views;

   TagSettings _tagSettings;

   TQPtrList<EditCommand> _undoList;
   TQPtrList<EditCommand> _redoList;

   TQTextCodec *fileCodec;

   TQStringList msgidDiffList;
   TQMap< TQString, TQStringList > msgstr2MsgidDiffList;
   TQIntCache<TQString> diffCache;
   
   int numberOfPluralForms;

   Project::Ptr _project;
   RegExpExtractor *_tagExtractor, *_argExtractor;
   
   TQStringList _catalogExtra;
   
   CatalogPrivate(Project::Ptr project) : 
	_packageName( TQString() ), _packageDir( TQString() ),
	_header (project), 
	_importID( TQString() ), _mimeTypes( "text/plain" ),
	_modified(false), _readOnly(false), _generatedFromDocbook(false), 
	_active(false), _stop(false),
	fileCodec(0),  diffCache(30,76), numberOfPluralForms(-1), 
	_project(project) 
   {
	_entries.clear();
	_obsoleteEntries.clear();
	diffCache.setAutoDelete(true);
	diffCache.clear();
	
	_views.setAutoDelete(false);
	
	_undoList.setAutoDelete(true);
	_redoList.setAutoDelete(true);
	_tagExtractor = new RegExpExtractor(TQStringList());
	_argExtractor = new RegExpExtractor(TQStringList());
	
	_catalogExtra.clear();
   }
   
   ~CatalogPrivate()
   {
       delete _tagExtractor;
       delete _argExtractor;
   }
};

}

#endif //CATALOGPRIVATE_H
