/***************************************************************************
 *   Copyright (C) 2005 by Pawel Nawrocki                                  *
 *   pnawrocki@interia.pl                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/


#include "wlassistant.h"

#include <tdeapplication.h>
#include <tdeaboutdata.h>
#include <tdecmdlineargs.h>
#include <tdelocale.h>

static const char description[] =
        I18N_NOOP("Wireless Assistant");

static const char version[] = "0.5.7";

static TDECmdLineOptions options[] =
        {
                //    { "+[URL]", I18N_NOOP( "Document to open" ), 0 },
                TDECmdLineLastOption
        };

int main(int argc, char **argv)
{
        TDEAboutData about("wlassistant", I18N_NOOP("Wireless Assistant"), version, description,
                         TDEAboutData::License_GPL, "(C) %{YEAR} Pawel Nawrocki", 0, 0, "pnawrocki@interia.pl");
        about.addAuthor( "Pawel Nawrocki", 0, "pnawrocki@interia.pl" );
        TDECmdLineArgs::init(argc, argv, &about);
        TDECmdLineArgs::addCmdLineOptions( options );
        TDEApplication app;
        WirelessAssistant *mainWin = 0;
                mainWin = new WirelessAssistant();
                mainWin->setCaption( TQString("%1 %2").arg(description).arg(version) );
                app.setMainWidget( mainWin );
                mainWin->show();

        // mainWin has WDestructiveClose flag by default, so it will delete itself.
        return app.exec();
}
