/***************************************************************************
                          knutpanelmeter.cpp  -  description
                             -------------------
    begin                : t b?e 16 2004
    copyright            : (C) 2004 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "knutpanelmeter.h"

#include <kdebug.h>

#include <tqlayout.h>
#include <tqlabel.h>
#include <tqfont.h>


#include <math.h>
#include <stdlib.h>
#include <unistd.h>

//#include <iostream>


extern const char *nameUpsVars1[];
extern const char *nameUpsVars2[];


KNutPanelMeter::KNutPanelMeter(TQPalette aPanelPalette, KNutVarData::upsInfoDef* activeUpsInfo, KNutVarData::SettingDataDef* settingData, KNutVarData* analogRecords, TQWidget *parent, const char *name ) : TQScrollView(parent,name,TQt::WResizeNoErase|TQt::WStaticContents) {

  m_settingData = settingData;
  m_activeUpsInfo = activeUpsInfo;
  m_analogRecords = analogRecords;
  m_aPanelPalette = aPanelPalette;

  m_analogArea = new TQLabel(this->viewport());
  addChild(m_analogArea);
  setResizePolicy ( TQScrollView::AutoOneFit ) ;


////NUTNO PAK UPRAVIT ACTIVATE A DEAKTIVATE ANALOGS
 m_analogPanels = new analogPanelRecordsDef;
    for (int i=0; i< knc::NumberOfVars; i++)
      m_analogPanels->upsAnalogs[i]=0L;

  m_widthArea =0;
  m_heightArea =0;
 }

KNutPanelMeter::~KNutPanelMeter(){

  deActivateAnalogs();
  delete m_analogPanels;
  m_analogPanels=0L;
  }



void KNutPanelMeter::deActivateAnalogs (void) {

//std::cout << "KNutPanelMeter::deActivateAnalogs" << std::endl;

  if (m_analogPanels) {
    for (int i=0; i< knc::NumberOfVars; i++) {
      if (m_analogPanels->upsAnalogs[i] != 0) {
        delete m_analogPanels->upsAnalogs[i]; // uvolnime meraky
        }
      m_analogPanels->upsAnalogs[i]=0L;
      }
    }
  m_widthArea =0;
  m_heightArea =0;
  }

void KNutPanelMeter::activateAnalogs (void) {
//tqDebug ("KNutPanelMeter::activateAnalogs start");


  KNutVarData::VarStrucDef analogMemberData;
  int ii =0;
  // deletes vatiables which ups doeasn't support 
  // vyjmeme promene ktere ups nepodporuje

  //// nasledujici radka neni nutna
  for (int i=0; i< knc::NumberOfVars; i++) m_analogPanels->upsAnalogs[i]=0L;
  for (int i=0; i< knc::NumberOfVars; i++) {
    // otestujeme zda dane UPS podporuje tuto promenou
    // pokud existuje vrati 1
    switch (m_activeUpsInfo->nutVariables) {
      case 1:
        if (!m_activeUpsInfo->upsNet->existName(nameUpsVars1[m_activeUpsInfo->record.upsVarCode[i]]))
          m_activeUpsInfo->record.upsVarCode[ii++] = m_activeUpsInfo->record.upsVarCode[i];
      break;
      case 2:
        if (!m_activeUpsInfo->upsNet->existName(nameUpsVars2[m_activeUpsInfo->record.upsVarCode[i]]))
          m_activeUpsInfo->record.upsVarCode[ii++] = m_activeUpsInfo->record.upsVarCode[i];
      break;
      }
    }
  for (int i=ii; i< knc::NumberOfVars; i++) m_activeUpsInfo->record.upsVarCode[i]=0;// doplnime zbytek nulami to znamena zadna promena

  for (int i=0; i< knc::NumberOfVars; i++) {
    if (m_activeUpsInfo->record.upsVarCode[i] != 0) {
      analogMemberData=m_analogRecords->getData (m_activeUpsInfo->record.upsVarCode[i]);

      m_analogPanels->scaleEnd[i]=analogMemberData.end;
      m_analogPanels->scaleStart[i]=analogMemberData.start;
      TQColor analogFingerColor, analogScaleColor, analogFontColor;
      if (m_settingData->customOAnalogColor) {
        analogFingerColor = m_settingData->analogFingerColor;
        analogScaleColor = m_settingData->analogScaleColor;
        analogFontColor = m_settingData->analogFontColor;
        }
      else {
        analogFingerColor = DEFAULT_FINGER_COLOR;
        analogScaleColor = DEFAULT_SCALE_COLOR;
        analogFontColor = DEFAULT_FONT_COLOR;
        }

      if (m_settingData->customFont)
        // doesn't make background
        m_analogPanels->upsAnalogs[i] = new KNutAnalog( m_analogArea,0L,analogMemberData.start,analogMemberData.end,analogMemberData.typeAnalog,analogMemberData.numberItem,analogMemberData.numberInItem,analogFingerColor,analogScaleColor,analogFontColor,&(m_settingData->aPanelFont),m_settingData->typeDigitalProcessing);
      else
        m_analogPanels->upsAnalogs[i] = new KNutAnalog( m_analogArea,0L,analogMemberData.start,analogMemberData.end,analogMemberData.typeAnalog,analogMemberData.numberItem,analogMemberData.numberInItem,analogFingerColor,analogScaleColor,analogFontColor,&(m_settingData->systemFont),m_settingData->typeDigitalProcessing);
      //nastavime barvu mezikruzi


      if (m_settingData->customOAnalogColor) {
        m_analogPanels->upsAnalogs[i]->setArcColor(1,m_settingData->analogOKColor); // doesn't make background
        m_analogPanels->upsAnalogs[i]->setArcColor(2,m_settingData->analogWarnningColor); // doesn't make background
        m_analogPanels->upsAnalogs[i]->setArcColor(3,m_settingData->analogErrorColor); // doesn't make background
        }
      // po vygenerovani panelu jsou standartni barvy nastaveny automaticky
      //nastavime mezikruzi
      for (int j = 0; j < 5; j++ ) {
        if (!((analogMemberData.scaleStruct[j].start == 0) && (analogMemberData.scaleStruct[j].end ==0 ))) {
          m_analogPanels->upsAnalogs[i]->addArc (analogMemberData.scaleStruct[j].start,analogMemberData.scaleStruct[j].end,analogMemberData.scaleStruct[j].scaleColor, false); // doesn't make background
        }
      }
      m_analogPanels->upsAnalogs[i]->setText(analogMemberData.nameAnalog,analogMemberData.nameUnit);
      m_analogPanels->upsAnalogs[i]->setPalette(m_aPanelPalette);
      m_analogPanels->upsAnalogs[i]->makeBackground(false); // makes background of analog panel

      }
    }

//tqDebug ( "KNutPanelMeter::activateAnalogs 1" );
  m_analogArea->repaint(); //repaint all analog panels, background was made already
//tqDebug ("KNutPanelMeter::activateAnalogs - end");
//  analogSV->resizeContents(sizeHint().width(),sizeHint().height());
  }



void KNutPanelMeter::setSize (bool showPanels) {
    int row =0;
    int col=0;
    int maxCols =0;
    int maxRows =0;

    if (!m_activeUpsInfo->netError) {
      for (int i=0; i< knc::NumberOfVars; i++) {
        if (m_activeUpsInfo->record.upsVarCode[i] != 0) {
          if (maxCols < m_settingData->countCols) maxCols++;
          maxRows = row+1;
          // jestlize upsAnalogs =0 nejsou aktivovany
          if (m_analogPanels->upsAnalogs[i]) {
            m_analogPanels->upsAnalogs[i]->move (SpacePanels + (SpacePanels)+(col*(KNutAnalog::AnalogWidth+SpacePanels)),SpacePanels+(row*(KNutAnalog::AnalogWidth+SpacePanels)));
            if (showPanels) m_analogPanels->upsAnalogs[i]->show();
            }
          col++;
          if (col > (m_settingData->countCols-1) ) {col=0; row++;}; // prechod na dalsi radku
          }
        }
      }
    // musime nastavit velikost
    m_widthArea = (KNutAnalog::AnalogWidth + SpacePanels)*maxCols +2*SpacePanels; // sirka
    m_heightArea = (KNutAnalog::AnalogWidth + SpacePanels)*(maxRows) + SpacePanels; // minimalni velikost podle mericich panelu

    m_analogArea->setMinimumSize (m_widthArea,m_heightArea);
    adjustSize();
    resizeContents(m_widthArea,m_heightArea);
    repaint();
  }

void KNutPanelMeter::repaintScaleAnalogPanel (int panelNumber, float value) {

  if (m_analogPanels->upsAnalogs[panelNumber] != 0L){
    switch (m_activeUpsInfo->record.upsVarCode[panelNumber]) {
      case knc::VarCurrent : // output.current
        if (m_analogPanels->scaleEnd[panelNumber] < MaxCurrent) {
          if (m_analogPanels->scaleEnd[panelNumber] < value) {
            m_analogPanels->scaleEnd[panelNumber]=(static_cast<int>(floor((value+1)/5)))*5 +5;
            if (m_analogPanels->scaleEnd[panelNumber] > MaxCurrent) m_analogPanels->scaleEnd[panelNumber]=MaxCurrent;
              m_analogPanels->upsAnalogs[panelNumber]->setRange(m_analogPanels->scaleStart[panelNumber],m_analogPanels->scaleEnd[panelNumber],true);
            }
          }
        break;
      case knc::VarBattVolt : // battery.voltage
        if (m_analogPanels->scaleEnd[panelNumber] < MaxBattVolt) {
          if (m_analogPanels->scaleEnd[panelNumber] < value) {
            m_analogPanels->scaleEnd[panelNumber]=(static_cast<int>(floor((value+1)/10)))*10 +10;
            if (m_analogPanels->scaleEnd[panelNumber] > MaxBattVolt) m_analogPanels->scaleEnd[panelNumber]=MaxBattVolt;
              m_analogPanels->upsAnalogs[panelNumber]->setRange(m_analogPanels->scaleStart[panelNumber],m_analogPanels->scaleEnd[panelNumber],true);
            }
          }
        break;
      case knc::VarBattCurrent : // battery.current
        if (m_analogPanels->scaleEnd[panelNumber] < MaxBattCurrent) {
          if ((m_analogPanels->scaleEnd[panelNumber] < value) || (m_analogPanels->scaleStart[panelNumber] > value)) {
            if ((value >10) || (value <- 15)) {
              if ((value >20) || (value < -30)) {
                m_analogPanels->scaleEnd[panelNumber]=30;
                m_analogPanels->scaleStart[panelNumber]=-45;
                 }
              else {
                m_analogPanels->scaleEnd[panelNumber]=20;
                m_analogPanels->scaleStart[panelNumber]=-30;
                }
              m_analogPanels->upsAnalogs[panelNumber]->setPointer(value); // jistota pokud by nam to nekde propadlo
              m_analogPanels->upsAnalogs[panelNumber]->hide();// schovame analogovy panel   hides analog panel
              m_analogPanels->upsAnalogs[panelNumber]->setRange (m_analogPanels->scaleStart[panelNumber],m_analogPanels->scaleEnd[panelNumber]);
              m_analogPanels->upsAnalogs[panelNumber]->repaint(); // prekreslime , repaints panel
              m_analogPanels->upsAnalogs[panelNumber]->show(); //zobrazime merak  shows analog panel
              }
            }
         }
       break;
      } // end switch
    }
  }



void KNutPanelMeter::repaintAnalogPointer (int panelNumber, float value, bool run) {
  if (m_analogPanels->upsAnalogs[panelNumber] != 0L)
     m_analogPanels->upsAnalogs[panelNumber]->setPointer (value,run); // nastavi hodnotu rucicky
  }



void KNutPanelMeter::setAnalogBG(TQPalette aPanelPalette) {

  m_aPanelPalette = aPanelPalette;
  for (int i=0; i< knc::NumberOfVars; i++) {
    if ((m_activeUpsInfo->record.upsVarCode[i]) && (m_analogPanels->upsAnalogs[i]))
      m_analogPanels->upsAnalogs[i]->setPalette(m_aPanelPalette);
    }
 }


void KNutPanelMeter::changeAnalogPanelsDigProcessing (void) {

  if (m_analogPanels == 0) return;

  for (int i=0; i< knc::NumberOfVars; i++) {
    if (m_analogPanels->upsAnalogs[i] != 0L) m_analogPanels->upsAnalogs[i]->setDigitalProcesing(m_settingData->typeDigitalProcessing,true);
    }

  }


void KNutPanelMeter::repaintAnalogPanels (bool repaintFrequencyPanels, bool repaintVoltagePanels, bool repaintAllPanels) {

KNutVarData::VarStrucDef analogMemberData;

  if (m_analogPanels == 0) return;

  // pregenerovani panelu slouzi pro settingMain a setting Analog
  for (int i=0; i< knc::NumberOfVars; i++) {
    if ((m_activeUpsInfo->record.upsVarCode[i]) && (m_analogPanels->upsAnalogs[i])) {  
           //if upsAnalogs[x] is set to zero, this upsAnalog is not used
           // record.upsVarCode contain list of code of analog meter 
           // 0 is code for none analog meter, 1 for Input Voltage, 2 for Battery Charge,
      if (((m_activeUpsInfo->record.upsVarCode[i] == knc::VarAcfreq) && (repaintFrequencyPanels)) ||
           ((m_activeUpsInfo->record.upsVarCode[i] == knc::VarOutFreq) && (repaintFrequencyPanels)) ||
           (((m_activeUpsInfo->record.upsVarCode[i] == knc::VarUtility) ||
             (m_activeUpsInfo->record.upsVarCode[i] == knc::VarOutVolt)) && (repaintVoltagePanels))) {

        analogMemberData=m_analogRecords->getData (m_activeUpsInfo->record.upsVarCode[i]); // nacteme data

        m_analogPanels->upsAnalogs[i]->hide();// schovame analogovy panel
        m_analogPanels->upsAnalogs[i]->delArc(); //zrusime segmenty
        m_analogPanels->upsAnalogs[i]->setRange (analogMemberData.start,analogMemberData.end);
        for (int j = 0; j < 5; j++ ) {
          if (!((analogMemberData.scaleStruct[j].start == 0) && (analogMemberData.scaleStruct[j].end ==0 ))) {
            m_analogPanels->upsAnalogs[i]->addArc (analogMemberData.scaleStruct[j].start,analogMemberData.scaleStruct[j].end,analogMemberData.scaleStruct[j].scaleColor, false);
            } // end if (!
          }// end for (int i=0

        m_analogPanels->upsAnalogs[i]->makeBackground(false); // repaints analog meter
        m_analogPanels->upsAnalogs[i]->repaintPointer(false); // repaints analog meter
        m_analogPanels->upsAnalogs[i]->repaint(); // repaints analog meter
        m_analogPanels->upsAnalogs[i]->show(); // shows analog meter
        } // end if (((activeUpsInfo
      if (repaintAllPanels) {
        if (m_settingData->customOAnalogColor) {
          m_analogPanels->upsAnalogs[i]->setPointerColor(m_settingData->analogFingerColor);
          m_analogPanels->upsAnalogs[i]->setArcColor(1,m_settingData->analogOKColor);
          m_analogPanels->upsAnalogs[i]->setArcColor(2,m_settingData->analogWarnningColor);
          m_analogPanels->upsAnalogs[i]->setArcColor(3,m_settingData->analogErrorColor);
          m_analogPanels->upsAnalogs[i]->setScaleColor(m_settingData->analogScaleColor);
          m_analogPanels->upsAnalogs[i]->setFontColor(m_settingData->analogFontColor);
          }
        else {
          m_analogPanels->upsAnalogs[i]->setPointerColor (DEFAULT_FINGER_COLOR);
          m_analogPanels->upsAnalogs[i]->setDefaultArcColor();
          m_analogPanels->upsAnalogs[i]->setScaleColor (DEFAULT_SCALE_COLOR);
          m_analogPanels->upsAnalogs[i]->setFontColor (DEFAULT_FONT_COLOR);
          }
        m_analogPanels->upsAnalogs[i]->repaintAll();
        }
      }
    } // end for
  }

void KNutPanelMeter::zeroingPanels (void) {
  if (m_analogPanels) {
    for (int i=0; i< knc::NumberOfVars; i++) {
      if ((m_analogPanels->upsAnalogs[i] != 0L) && (m_activeUpsInfo->record.upsVarCode[i] != 0)) // jistota pokud by nam to nekde propadlo
        m_analogPanels->upsAnalogs[i]->setPointer (0); // nastavi hodnotu rucicky
      }
    }
  }



TQSize KNutPanelMeter::sizeHint (void){

  return TQSize(m_widthArea,m_heightArea);
  }


void KNutPanelMeter::slotSetPanelsFont(TQFont newFont) {

  for (int i=0; i< knc::NumberOfVars; i++) {
    if ((m_activeUpsInfo->record.upsVarCode[i]) && (m_analogPanels->upsAnalogs[i])) {
      m_analogPanels->upsAnalogs[i]->slotSetAllFont(newFont);
      // je nutno prekresli i rucicku
      }
    }
  }

#include "knutpanelmeter.moc"
