// KDat - a tar-based DAT archiver
// Copyright (C) 1998-2000  Sean Vyain, svyain@mail.tds.net
// Copyright (C) 2001-2002  Lawrence Widman, kdat@cardiothink.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

#ifndef _ImageCache_h_
#define _ImageCache_h_

class TQPixmap;

/**
 * @short A container for commonly used icons.
 */
class ImageCache {
    static ImageCache* _instance;

    TQPixmap* _archive;
    TQPixmap* _backup;
    TQPixmap* _file;
    TQPixmap* _folderClosed;
    TQPixmap* _folderOpen;
    TQPixmap* _restore;
    TQPixmap* _selectAll;
    TQPixmap* _selectNone;
    TQPixmap* _selectSome;
    TQPixmap* _tape;
    TQPixmap* _tapeMounted;
    TQPixmap* _tapeUnmounted;
    TQPixmap* _verify;

    ImageCache();
public:
    /**
     * Destroy the image cache and free the icons.
     */
    ~ImageCache();

    /**
     * This method is an accessor for the single instance of the image cache.
     *
     * @return A pointer to the single instance of the image cache.
     */
    static ImageCache* instance();

    /**
     * Get the tree-node icon used for archives.
     *
     * @return A pointer to the icon.
     */
    const TQPixmap* getArchive();

    /**
     * Get the toolbar icon used for the backup action.
     *
     * @return A pointer to the icon.
     */
    const TQPixmap* getBackup();

    /**
     * Get the tree-node icon used for files.
     *
     * @return A pointer to the icon.
     */
    const TQPixmap* getFile();

    /**
     * Get the tree-node icon used for a closed folder.
     *
     * @return A pointer to the icon.
     */
    const TQPixmap* getFolderClosed();

    /**
     * Get the tree-node icon used for an open folder.
     *
     * @return A pointer to the icon.
     */
    const TQPixmap* getFolderOpen();

    /**
     * Get the toolbar icon used for the restore action.
     *
     * @return A pointer to the icon.
     */
    const TQPixmap* getRestore();

    /**
     * Get the tree-node icon used when all subnodes are selected.
     *
     * @return A pointer to the icon.
     */
    const TQPixmap* getSelectAll();

    /**
     * Get the tree-node icon used when no subnodes are selected.
     *
     * @return A pointer to the icon.
     */
    const TQPixmap* getSelectNone();
    
    /**
     * Get the tree-node icon used when some subnodes are selected.
     *
     * @return A pointer to the icon.
     */
    const TQPixmap* getSelectSome();

    /**
     * Get the tree-node icon used for tape indexes.
     *
     * @return A pointer to the icon.
     */
    const TQPixmap* getTape();

    /**
     * Get the tree-node/toolbar icon used for a mounted tape drive.
     *
     * @return A pointer to the icon.
     */
    const TQPixmap* getTapeMounted();

    /**
     * Get the tree-node/toolbar icon used for an unmounted tape drive.
     *
     * @return A pointer to the icon.
     */
    const TQPixmap* getTapeUnmounted();

    /**
     * Get the toolbar icon used for the verify action.
     *
     * @return A pointer to the icon.
     */
    const TQPixmap* getVerify();
};

#endif
