/*
   TDevelop Autotools Support
   Copyright (c) 2005 by Matt Rogers <mattr@kde.org>

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************
*/
#include "autotoolsaction.h"

#include <tqtoolbutton.h>
#include <tqtooltip.h>
#include <tqwhatsthis.h>
#include <tdeapplication.h>
#include <kdebug.h>
#include <kiconloader.h>

AutoToolsAction::~AutoToolsAction()
{
}

AutoToolsAction::AutoToolsAction( const TQString& text, const TDEShortcut& cut,
                                  const TQObject* receiver, const char* slot,
                                  TDEActionCollection* parent, const char* name )
: TDEAction( text, cut, receiver, slot, parent, name )
{
}

AutoToolsAction::AutoToolsAction( const TQString& text, const TQIconSet& pix, const TDEShortcut& cut,
                                  const TQObject* receiver, const char* slot,
                                  TDEActionCollection* parent, const char* name )
: TDEAction( text, pix, cut, receiver, slot, parent, name )
{
}

AutoToolsAction::AutoToolsAction( const TQString& text, const TQString& pix, const TDEShortcut& cut,
                                  const TQObject* receiver, const char* slot,
                                  TDEActionCollection* parent, const char* name )
: TDEAction( text, pix, cut, receiver, slot, parent, name )
{
}

AutoToolsAction::AutoToolsAction( const KGuiItem& item, const TDEShortcut & cut,
                                  const TQObject* receiver, const char* slot,
                                  TDEActionCollection* parent, const char* name )
: TDEAction( item, cut, receiver, slot, parent, name )
{
}

AutoToolsAction::AutoToolsAction( const TQString& text, const TDEShortcut& cut,
                                  TQObject* parent, const char* name )
: TDEAction( text, cut, parent, name )
{
}

AutoToolsAction::AutoToolsAction( const TQString& text, const TDEShortcut& cut,
                                  const TQObject* receiver, const char* slot,
                                  TQObject* parent, const char* name )
: TDEAction( text, cut, receiver, slot, parent, name )
{
}

AutoToolsAction::AutoToolsAction( const TQString& text, const TQIconSet& pix,
                                  const TDEShortcut& cut, TQObject* parent, const char* name )
: TDEAction( text, pix, cut, parent, name )
{
}

AutoToolsAction::AutoToolsAction( const TQString& text, const TQString& pix,
                                  const TDEShortcut& cut, TQObject* parent, const char* name )
: TDEAction( text, pix, cut, parent, name )
{
}

AutoToolsAction::AutoToolsAction( const TQString& text, const TQIconSet& pix,
                                  const TDEShortcut& cut, const TQObject* receiver,
                                  const char* slot, TQObject* parent, const char * name )
: TDEAction( text, pix, cut, receiver, slot, parent, name )
{
}

AutoToolsAction::AutoToolsAction( const TQString& text, const TQString& pix,
                                  const TDEShortcut & cut, const TQObject* receiver,
                                  const char* slot, TQObject* parent, const char * name )
: TDEAction( text, pix, cut, receiver, slot, parent, name )
{
}

AutoToolsAction::AutoToolsAction( TQObject * parent, const char * name )
: TDEAction( parent, name )
{
}

int AutoToolsAction::plug( TQWidget* w, int index )
{
	if ( !w ) {
		kdWarning(129) << "TDEAction::plug called with 0 argument\n";
		return -1;
	}
	
	// Check if action is permitted
	if (kapp && !kapp->authorizeTDEAction(name()))
		return -1;
	
	if ( ::tqt_cast<TQToolButton*>( w ) )
	{
		TQToolButton* tb = static_cast<TQToolButton*>( w );
		connect( tb, TQ_SIGNAL( clicked() ), this, TQ_SLOT( activate() ) );
		int id = getToolButtonID();
		
		if ( !icon().isEmpty() )
			tb->setPixmap( SmallIcon( icon() ) );
		else
			tb->setText( text() );
		
		if ( !isEnabled() )
			tb->setEnabled( false );
		
		if ( !whatsThis().isEmpty() )
		{
			TQWhatsThis::remove( tb );
			TQWhatsThis::add( tb, whatsThisWithIcon() );
		}
		
		if ( !toolTip().isEmpty() )
		{
			TQToolTip::remove( tb );
			TQToolTip::add( tb, toolTip() );
		}
		
		addContainer( tb, id );
		
		return containerCount() - 1;
	}
	
	return TDEAction::plug( w, index );
}

void AutoToolsAction::updateEnabled( int i )
{
	TQWidget* w = container( i );
	
	if ( ::tqt_cast<TQToolButton*>( w ) )
		static_cast<TQToolButton*>( w )->setEnabled( isEnabled() );
	else
		TDEAction::updateEnabled( i ) ;
}
