#ifndef __PLUGINCONTROLLER_H__
#define __PLUGINCONTROLLER_H__

#include <tqdict.h>
#include <tqvaluelist.h>

#include <kservice.h>

#include <kdevplugincontroller.h>

#include <profileengine.h>

class KXMLGUIClient;
class KService;
class KDevPlugin;
class KDialogBase;
class ProjectInfo;

/**
Plugin controller implementation.
Loads and unloads plugins.
*/
class PluginController : public KDevPluginController
{
  TQ_OBJECT
  

public:

  ~PluginController();

  static PluginController *getInstance();
  static TQStringList argumentsFromService( const KService::Ptr &service );


  virtual KDevPlugin * loadPlugin( const TQString & serviceType, const TQString & constraint );
  virtual void unloadPlugin( const TQString & plugin );

  TQString currentProfile() const { return m_profile; }

  void loadInitialPlugins();

  void loadProjectPlugins( const TQStringList & ignorePlugins );
  void unloadProjectPlugins();

  void loadGlobalPlugins( const TQStringList & ignorePlugins = TQStringList() );

  //  KDevPlugin * getPlugin( const KService::Ptr &service );

  virtual KDevPlugin *extension(const TQString &serviceType, const TQString &constraint = "");

  void unloadPlugins( TQStringList const & );

  void integratePart(KXMLGUIClient *part);
  void integrateAndRememberPart(const TQString &name, KDevPlugin *part);
  void removePart(KXMLGUIClient* part);
  void removeAndForgetPart(const TQString &name, KDevPlugin* part);

  const TQValueList<KDevPlugin*> loadedPlugins();

  ProfileEngine &engine() { return m_engine; }

  virtual KURL::List profileResources(const TQString &nameFilter);
  virtual KURL::List profileResourcesRecursive(const TQString &nameFilter);

  //returns the name of an old profile that was unloaded
  TQString changeProfile(const TQString &newProfile);

public slots:
  void selectPlugins();

signals:
  void loadingPlugin(const TQString &plugin);

protected:
  PluginController();

private slots:
//  void slotConfigWidget( KDialogBase* );
  void loadCorePlugins();
  void loadPlugins( TDETrader::OfferList offers, const TQStringList & ignorePlugins = TQStringList() );
  void unloadPlugins();

private:
	static KDevPlugin *loadPlugin( const KService::Ptr &service );


  TQDict<KDevPlugin> m_parts;
  TQString m_profile;

  static PluginController *s_instance;

  ProfileEngine m_engine;

};

#endif
