# Copyright 2002-2025 Gentoo Authors
# Copyright 2025 The Trinity Desktop Project
# Distributed under the terms of the GNU General Public License v2

EAPI=8

inherit autotools ffmpeg-compat

DESCRIPTION="Utilities for transcoding video and audio codecs in different containers"
HOMEPAGE="https://web.archive.org/web/20110424210638/http://www.transcoding.org/cgi-bin/transcode"
SRC_URI="
	https://mirror.ppa.trinitydesktop.org/trinity/deb/trinity-r14.1.x/pool/deps/t/transcode/${PN}_${PV}.orig.tar.bz2 -> ${P}.tar.bz2
	https://github.com/Fat-Zer/${PN}-gentoo-trinity-patches/archive/refs/tags/p1.tar.gz -> ${P}-patches-p1.tar.gz
"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="~alpha amd64 ~arm64 ppc ppc64 ~riscv sparc x86"
IUSE="cpu_flags_ppc_altivec cpu_flags_x86_3dnow a52 aac alsa dv dvd +iconv imagemagick jpeg lzo mjpeg cpu_flags_x86_mmx mp3 mpeg nuv ogg oss pic postproc quicktime sdl cpu_flags_x86_sse cpu_flags_x86_sse2 theora truetype v4l vorbis X x264 xml xvid"

REQUIRED_USE="
	cpu_flags_x86_sse? ( cpu_flags_x86_mmx )
	cpu_flags_x86_sse2? ( cpu_flags_x86_mmx cpu_flags_x86_sse )
	cpu_flags_x86_3dnow? ( cpu_flags_x86_mmx )
	nuv? ( lzo )
"

RDEPEND="
	media-video/ffmpeg-compat:4=
	a52? ( media-libs/a52dec )
	aac? ( media-libs/faac )
	alsa? ( media-libs/alsa-lib )
	dv? ( media-libs/libdv )
	dvd? ( media-libs/libdvdread:0= )
	iconv? ( virtual/libiconv )
	imagemagick? ( media-gfx/imagemagick:= )
	jpeg? ( media-libs/libjpeg-turbo:= )
	lzo? ( >=dev-libs/lzo-2 )
	mjpeg? ( media-video/mjpegtools:= )
	mp3? ( media-sound/lame )
	mpeg? ( media-libs/libmpeg2 )
	ogg? ( media-libs/libogg )
	quicktime? ( >=media-libs/libquicktime-1 )
	sdl? ( >=media-libs/libsdl-1.2.5[X?] )
	theora? ( media-libs/libtheora )
	truetype? ( >=media-libs/freetype-2 )
	v4l? ( media-libs/libv4l )
	vorbis? ( media-libs/libvorbis )
	X? (
		x11-libs/libXaw
		x11-libs/libXpm
		x11-libs/libXv
	)
	x264? ( media-libs/x264:= )
	xml? ( dev-libs/libxml2 )
	xvid? ( media-libs/xvid )
"
DEPEND="${RDEPEND}"
BDEPEND="
	virtual/pkgconfig
	v4l? ( >=sys-kernel/linux-headers-2.6.11 )
"

PATCHDIR="${WORKDIR}/transcode-gentoo-trinity-patches-p1"

PATCHES=(
	"${PATCHDIR}"/${P}-ffmpeg-remove-mbqmin-mbqmax-from-ffmpeg-config.patch
	"${PATCHDIR}"/${P}-ffmpeg-rename-pp_mode_t-and-pp_context_t-types.patch
	"${PATCHDIR}"/${P}-ffmpeg-Fix-build-with-ffmpeg-0.11.patch
	"${PATCHDIR}"/${P}-lavc-fix-invalid-free-when-preset-file-not-found.patch
	"${PATCHDIR}"/${P}-ffmpeg-fix-build-against-libav-9.patch
	"${PATCHDIR}"/${P}-ffmpeg-fix-building-with-libav-10.patch
	"${PATCHDIR}"/${P}-ffmpeg-lavc-Do-not-force-using-a-preset.patch
	"${PATCHDIR}"/${P}-ffmpeg-fix-build-with-ffmpeg-2.0.patch
	"${PATCHDIR}"/${P}-subtitler-Fix-freetype-includes.patch
	"${PATCHDIR}"/${P}-ffmpeg-fix-build-with-ffmpeg-2.4.patch
	"${PATCHDIR}"/${P}-resample-build-against-libswresample-instead-of-liba.patch # bug 722296
	"${PATCHDIR}"/${P}-acc-mp3-pass-prevent-symbol-names-clash.patch
	"${PATCHDIR}"/${P}-v4l-use-strerror-instead-of-sys_errlist.patch
	"${PATCHDIR}"/${P}-avc-ffmpeg-fix-build-with-ffmpeg-2.8.patch
	"${PATCHDIR}"/${P}-im-fix-build-with-ImageMagick-7.patch
	"${PATCHDIR}"/${P}-ffmpeg-fix-build-with-ffmpeg-4.patch
	"${PATCHDIR}"/${P}-Avoid-filtering-pkg-config-flags.patch # gentoo-bug 914628
	"${PATCHDIR}"/${P}-libtc-use-stpncpy-instead-of-strlcpy.patch
	"${PATCHDIR}"/${P}-ffmpeg-fix-build-of-ffmpeg-audio-encoding-with-ffmpe.patch
	"${PATCHDIR}"/${P}-resample-support-build-against-ffmpeg-4.0.patch
	"${PATCHDIR}"/${P}-mp3-make-lame-stuff-hip.patch
	"${PATCHDIR}"/${P}-im-imlist-some-more-fixes-for-imagemagick-7.patch
	"${PATCHDIR}"/${P}-libtc-fix-enforce-of-max-values-for-TCCONF_FLAG_RANG.patch
	"${PATCHDIR}"/${P}-ffmpeg-set-default-for-rc_strategy-to-0.patch
	"${PATCHDIR}"/${P}-ffmpeg-fix-ffmpeg-import.patch
	"${PATCHDIR}"/${P}-export_ffmpeg-more-fixes-for-ffmpeg-3.1-port-fixes.patch
)

src_prepare() {
	default

	eautoreconf
}

src_configure() {
	local myconf
	use x86 && myconf="$(use_enable !pic x86-textrels)" # bug 271476

	ffmpeg_compat_setup 4

	local myeconfargs=(
		$(use_enable cpu_flags_ppc_altivec altivec)
		$(use_enable cpu_flags_x86_mmx mmx)
		$(use_enable cpu_flags_x86_3dnow 3dnow)
		$(use_enable cpu_flags_x86_sse sse)
		$(use_enable cpu_flags_x86_sse2 sse2)
		$(use_enable v4l libv4l2)
		$(use_enable v4l libv4lconvert)
		$(use_enable mpeg libmpeg2)
		$(use_enable mpeg libmpeg2convert)
		--enable-experimental
		--enable-deprecated
		$(use_enable v4l)
		$(use_enable oss)
		$(use_enable alsa)
		$(use_enable postproc libpostproc)
		$(use_enable truetype freetype2)
		$(use_enable mp3 lame)
		$(use_enable xvid)
		$(use_enable x264)
		$(use_enable ogg)
		$(use_enable vorbis)
		$(use_enable theora)
		$(use_enable dvd libdvdread)
		$(use_enable dv libdv)
		$(use_enable quicktime libquicktime)
		$(use_enable lzo)
		$(use_enable a52)
		$(use_enable aac faac)
		$(use_enable xml libxml2)
		$(use_enable mjpeg mjpegtools)
		$(use_enable sdl)
		$(use_enable imagemagick)
		$(use_enable jpeg libjpeg)
		$(use_enable iconv)
		$(use_enable nuv)
		$(use_with X x)
		--with-mod-path=/usr/$(get_libdir)/transcode
		${myconf}
	)
	econf "${myeconfargs[@]}"
}

src_install() {
	emake DESTDIR="${D}" docsdir=/usr/share/doc/${PF} install
	dodoc AUTHORS ChangeLog README STYLE TODO
	find "${ED}" \( -name "*.a" -o -name "*.la" \) -delete || die
}
