# Copyright 2023-2025 The Trinity Desktop Project
# Distributed under the terms of the GNU General Public License v2

EAPI="8"

TRINITY_EXTRAGEAR_PACKAGING="yes"
TRINITY_HANDBOOK="never"

TRINITY_LANGS="da de el es fr it"

TRINITY_MODULE_TYPE="applications/utilities"
inherit trinity-base-2

DESCRIPTION="Full-Screen Task Manager for TDE"
HOMEPAGE="https://trinitydesktop.org/"

LICENSE="|| ( GPL-2 GPL-3 )"
SLOT="14"
if [[ ${PV} != *9999* ]] ; then
	KEYWORDS="~amd64 ~arm64 ~x86"
fi
IUSE="xcomposite"

DEPEND="media-libs/imlib2
	xcomposite? ( x11-libs/libXcomposite
			x11-libs/libXdamage )
"
RDEPEND="${DEPEND}"

src_configure() {
	local mycmakeargs=(
		-DBUILD_TRANSLATIONS=ON
		-DWITH_XCOMPOSITE="$(usex xcomposite)"
	)
	trinity-base-2_src_configure
}
