/* UNIX(R) Regular Expression Tools

   Copyright (C) 2001 Caldera International, Inc.
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to:
       Free Software Foundation, Inc.
       59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
# include "stdio.h"
# include "stdlib.h"
# define U(x) ((unsigned char)(x))
# define NLSTATE yyprevious=YYNEWLINE
# define BEGIN yybgin = yysvec + 1 +
# define INITIAL 0
# define YYLERR yysvec
# define YYSTATE (yyestate-yysvec-1)
# define YYOPTIM 1
# ifndef YYLMAX
# define YYLMAX 200
# endif
# define output(c) (void)putc(c,yyout)
#if defined(__cplusplus)
extern "C" {
#endif
#if defined(__cplusplus) || defined(__STDC__)
	int yyback(int *, int);
	int yyinput(void);
	int yylook(void);
	void yyoutput(int);
	int yyracc(int);
	int yyreject(void);
	void yyunput(int);
	int yylex(void);

#ifdef __STDC__
#ifndef yyless
	void yyless(int);
#endif
#ifndef yywrap
	int yywrap(void);
#endif
#endif

#endif
#if defined(__cplusplus)
}
#endif
# define input() (((yytchar=yysptr>yysbuf?U(*--yysptr):getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)
# define unput(c) {yytchar= (c);if(yytchar=='\n')yylineno--;*yysptr++=yytchar;}
# define yymore() (yymorfg=1)
# define ECHO (void)fprintf(yyout, "%s",yytext)
# define REJECT { nstr = yyreject(); goto yyfussy;}
int yyleng; extern char yytext[];
int yymorfg;
extern char *yysptr, yysbuf[];
int yytchar;
FILE *yyin, *yyout;
extern int yylineno;
struct yysvf { 
	struct yywork *yystoff;
	struct yysvf *yyother;
	int *yystops;};
struct yysvf *yyestate;
extern struct yysvf yysvec[], *yybgin;

# line 3 "awk.lx.l"
/*		copyright	"%c%"	*/
#ident	"@(#)unixsrc:usr/src/common/cmd/awk/awk.lx.l /main/uw7_nj/1"
#ident  "$Header: awk.lx.l 1.2 91/06/25 $"
# define A 2
# define str 4
# define sc 6
# define reg 8
# define comment 10

#include	"awk.h"
#include	"y.tab.h"
#include	<pfmt.h>

#undef	input	/* defeat lex */
#undef	unput

extern YYSTYPE	yylval;
extern int	infunc;

int	lineno	= 1;
int	bracecnt = 0;
int	brackcnt  = 0;
int	parencnt = 0;
#define DEBUG
#ifdef	DEBUG
#	define	RET(x)	{if(dbg)printf("lex %s [%s]\n", tokname(x), yytext); return(x); }
#else
#	define	RET(x)	return(x)
#endif

#define	CADD	cbuf[clen++] = yytext[0]; \
		if (clen >= CBUFLEN-1) { \
			vyyerror(":90:String/reg expr %.10s ... too long", cbuf); \
			BEGIN A; \
		}

static const char extra[] = ":91:Extra %c";
extern const char nlstring[];

uchar	cbuf[CBUFLEN];
uchar	*s;
int	clen, cflag;
# define YYNEWLINE 10
yylex(){
int nstr; extern int yyprevious;

# line 57 "awk.lx.l"
switch (yybgin-yysvec-1) {	/* witchcraft */
	case 0:
		BEGIN A;
		break;
	case sc:
		BEGIN A;
		RET('}');
	}
while((nstr = yylook()) >= 0)
yyfussy: switch(nstr){
case 0:
if(yywrap()) return(0); break;
case 1:

# line 66 "awk.lx.l"
	{ lineno++; RET(NL); }
break;
case 2:

# line 67 "awk.lx.l"
	{ ; }
break;
case 3:

# line 68 "awk.lx.l"
{ ; }
break;
case 4:

# line 69 "awk.lx.l"
	{ RET(';'); }
break;
case 5:

# line 71 "awk.lx.l"
{ lineno++; }
break;
case 6:

# line 72 "awk.lx.l"
{ RET(XBEGIN); }
break;
case 7:

# line 73 "awk.lx.l"
	{ RET(XEND); }
break;
case 8:

# line 74 "awk.lx.l"
{ if (infunc) vyyerror(":92:Illegal nested function"); RET(FUNC); }
break;
case 9:

# line 75 "awk.lx.l"
{ if (!infunc) vyyerror(":93:Return not in function"); RET(RETURN); }
break;
case 10:

# line 76 "awk.lx.l"
	{ RET(AND); }
break;
case 11:

# line 77 "awk.lx.l"
	{ RET(BOR); }
break;
case 12:

# line 78 "awk.lx.l"
	{ RET(NOT); }
break;
case 13:

# line 79 "awk.lx.l"
	{ yylval.i = NE; RET(NE); }
break;
case 14:

# line 80 "awk.lx.l"
	{ yylval.i = MATCH; RET(MATCHOP); }
break;
case 15:

# line 81 "awk.lx.l"
	{ yylval.i = NOTMATCH; RET(MATCHOP); }
break;
case 16:

# line 82 "awk.lx.l"
	{ yylval.i = LT; RET(LT); }
break;
case 17:

# line 83 "awk.lx.l"
	{ yylval.i = LE; RET(LE); }
break;
case 18:

# line 84 "awk.lx.l"
	{ yylval.i = EQ; RET(EQ); }
break;
case 19:

# line 85 "awk.lx.l"
	{ yylval.i = GE; RET(GE); }
break;
case 20:

# line 86 "awk.lx.l"
	{ yylval.i = GT; RET(GT); }
break;
case 21:

# line 87 "awk.lx.l"
	{ yylval.i = APPEND; RET(APPEND); }
break;
case 22:

# line 88 "awk.lx.l"
	{ yylval.i = INCR; RET(INCR); }
break;
case 23:

# line 89 "awk.lx.l"
	{ yylval.i = DECR; RET(DECR); }
break;
case 24:

# line 90 "awk.lx.l"
	{ yylval.i = ADDEQ; RET(ASGNOP); }
break;
case 25:

# line 91 "awk.lx.l"
	{ yylval.i = SUBEQ; RET(ASGNOP); }
break;
case 26:

# line 92 "awk.lx.l"
	{ yylval.i = MULTEQ; RET(ASGNOP); }
break;
case 27:

# line 93 "awk.lx.l"
	{ yylval.i = DIVEQ; RET(ASGNOP); }
break;
case 28:

# line 94 "awk.lx.l"
	{ yylval.i = MODEQ; RET(ASGNOP); }
break;
case 29:

# line 95 "awk.lx.l"
	{ yylval.i = POWEQ; RET(ASGNOP); }
break;
case 30:

# line 96 "awk.lx.l"
{ yylval.i = POWEQ; RET(ASGNOP); }
break;
case 31:

# line 97 "awk.lx.l"
	{ yylval.i = ASSIGN; RET(ASGNOP); }
break;
case 32:

# line 98 "awk.lx.l"
	{ RET(POWER); }
break;
case 33:

# line 99 "awk.lx.l"
	{ RET(POWER); }
break;
case 34:

# line 101 "awk.lx.l"
{ yylval.cp = fieldadr(atoi(yytext+1)); RET(FIELD); }
break;
case 35:

# line 102 "awk.lx.l"
{ unputstr("(NF)"); return(INDIRECT); }
break;
case 36:

# line 103 "awk.lx.l"
{ int c, n;
		  c = input(); unput(c);
		  if (c == '(' || c == '[' || infunc && (n=isarg(yytext+1)) >= 0) {
			unputstr(yytext+1);
			return(INDIRECT);
		  } else {
			yylval.cp = setsymtab(yytext+1,"",0.0,STR|NUM,symtab);
			RET(IVAR);
		  }
		}
break;
case 37:

# line 113 "awk.lx.l"
	{ RET(INDIRECT); }
break;
case 38:

# line 114 "awk.lx.l"
	{ yylval.cp = setsymtab(yytext, "", 0.0, NUM, symtab); RET(VARNF); }
break;
case 39:

# line 116 "awk.lx.l"
{
		  yylval.cp = setsymtab(yytext, tostring(yytext), atof(yytext), CON|NUM, symtab);
		  RET(NUMBER); }
break;
case 40:

# line 120 "awk.lx.l"
{ RET(WHILE); }
break;
case 41:

# line 121 "awk.lx.l"
	{ RET(FOR); }
break;
case 42:

# line 122 "awk.lx.l"
	{ RET(DO); }
break;
case 43:

# line 123 "awk.lx.l"
	{ RET(IF); }
break;
case 44:

# line 124 "awk.lx.l"
	{ RET(ELSE); }
break;
case 45:

# line 125 "awk.lx.l"
	{ RET(NEXT); }
break;
case 46:

# line 126 "awk.lx.l"
	{ RET(EXIT); }
break;
case 47:

# line 127 "awk.lx.l"
{ RET(BREAK); }
break;
case 48:

# line 128 "awk.lx.l"
{ RET(CONTINUE); }
break;
case 49:

# line 129 "awk.lx.l"
{ yylval.i = PRINT; RET(PRINT); }
break;
case 50:

# line 130 "awk.lx.l"
{ yylval.i = PRINTF; RET(PRINTF); }
break;
case 51:

# line 131 "awk.lx.l"
{ yylval.i = SPRINTF; RET(SPRINTF); }
break;
case 52:

# line 132 "awk.lx.l"
{ yylval.i = SPLIT; RET(SPLIT); }
break;
case 53:

# line 133 "awk.lx.l"
{ RET(SUBSTR); }
break;
case 54:

# line 134 "awk.lx.l"
	{ yylval.i = SUB; RET(SUB); }
break;
case 55:

# line 135 "awk.lx.l"
	{ yylval.i = GSUB; RET(GSUB); }
break;
case 56:

# line 136 "awk.lx.l"
{ RET(INDEX); }
break;
case 57:

# line 137 "awk.lx.l"
{ RET(MATCHFCN); }
break;
case 58:

# line 138 "awk.lx.l"
	{ RET(IN); }
break;
case 59:

# line 139 "awk.lx.l"
{ RET(GETLINE); }
break;
case 60:

# line 140 "awk.lx.l"
{ RET(DELETE); }
break;
case 61:

# line 141 "awk.lx.l"
{ yylval.i = FLENGTH; RET(BLTIN); }
break;
case 62:

# line 142 "awk.lx.l"
	{ yylval.i = FLOG; RET(BLTIN); }
break;
case 63:

# line 143 "awk.lx.l"
	{ yylval.i = FINT; RET(BLTIN); }
break;
case 64:

# line 144 "awk.lx.l"
	{ yylval.i = FEXP; RET(BLTIN); }
break;
case 65:

# line 145 "awk.lx.l"
	{ yylval.i = FSQRT; RET(BLTIN); }
break;
case 66:

# line 146 "awk.lx.l"
	{ yylval.i = FSIN; RET(BLTIN); }
break;
case 67:

# line 147 "awk.lx.l"
	{ yylval.i = FCOS; RET(BLTIN); }
break;
case 68:

# line 148 "awk.lx.l"
{ yylval.i = FATAN; RET(BLTIN); }
break;
case 69:

# line 149 "awk.lx.l"
{ yylval.i = FSYSTEM; RET(BLTIN); }
break;
case 70:

# line 150 "awk.lx.l"
	{ yylval.i = FRAND; RET(BLTIN); }
break;
case 71:

# line 151 "awk.lx.l"
{ yylval.i = FSRAND; RET(BLTIN); }
break;
case 72:

# line 152 "awk.lx.l"
{ yylval.i = FTOUPPER; RET(BLTIN); }
break;
case 73:

# line 153 "awk.lx.l"
{ yylval.i = FTOLOWER; RET(BLTIN); }
break;
case 74:

# line 154 "awk.lx.l"
{ yylval.i = FCLOSE; RET(BLTIN); }
break;
case 75:

# line 156 "awk.lx.l"
{ int n, c;
		  c = input(); unput(c);	/* look for '(' */
		  if (c != '(' && infunc && (n=isarg(yytext)) >= 0) {
			yylval.i = n;
			RET(ARG);
		  } else {
			yylval.cp = setsymtab(yytext,"",0.0,STR|NUM,symtab);
			if (c == '(') {
				RET(CALL);
			} else {
				RET(VAR);
			}
		  }
		}
break;
case 76:

# line 170 "awk.lx.l"
	{ BEGIN str; clen = 0; }
break;
case 77:

# line 172 "awk.lx.l"
	{ if (--bracecnt < 0) vyyerror(extra, '}'); BEGIN sc; RET(';'); }
break;
case 78:

# line 173 "awk.lx.l"
	{ if (--brackcnt < 0) vyyerror(extra, ']'); RET(']'); }
break;
case 79:

# line 174 "awk.lx.l"
	{ if (--parencnt < 0) vyyerror(extra, ')'); RET(')'); }
break;
case 80:

# line 176 "awk.lx.l"
	{ if (yytext[0] == '{') bracecnt++;
		  else if (yytext[0] == '[') brackcnt++;
		  else if (yytext[0] == '(') parencnt++;
		  RET(yylval.i = yytext[0]); /* everything else */ }
break;
case 81:

# line 181 "awk.lx.l"
{ cbuf[clen++] = '\\'; cbuf[clen++] = yytext[1]; }
break;
case 82:

# line 182 "awk.lx.l"
	{ vyyerror(":94:Newline in regular expression %.10s ...", cbuf); lineno++; BEGIN A; }
break;
case 83:

# line 183 "awk.lx.l"
{ BEGIN A;
		  cbuf[clen] = 0;
		  yylval.s = tostring(cbuf);
		  unput('/');
		  RET(REGEXPR); }
break;
case 84:

# line 188 "awk.lx.l"
	{ CADD; }
break;
case 85:

# line 190 "awk.lx.l"
	{ BEGIN A;
		  cbuf[clen] = 0; s = tostring(cbuf);
		  cbuf[clen] = ' '; cbuf[++clen] = 0;
		  yylval.cp = setsymtab(cbuf, s, 0.0, CON|STR, symtab);
		  RET(STRING); }
break;
case 86:

# line 195 "awk.lx.l"
	{ vyyerror(nlstring, cbuf); lineno++; BEGIN A; }
break;
case 87:

# line 196 "awk.lx.l"
{ cbuf[clen++] = '"'; }
break;
case 88:

# line 197 "awk.lx.l"
{ cbuf[clen++] = '\n'; }
break;
case 89:

# line 198 "awk.lx.l"
{ cbuf[clen++] = '\t'; }
break;
case 90:

# line 199 "awk.lx.l"
{ cbuf[clen++] = '\f'; }
break;
case 91:

# line 200 "awk.lx.l"
{ cbuf[clen++] = '\r'; }
break;
case 92:

# line 201 "awk.lx.l"
{ cbuf[clen++] = '\b'; }
break;
case 93:

# line 202 "awk.lx.l"
{ cbuf[clen++] = '\v'; }
break;
case 94:

# line 203 "awk.lx.l"
{ cbuf[clen++] = '\007'; }
break;
case 95:

# line 204 "awk.lx.l"
{ cbuf[clen++] = '\\'; }
break;
case 96:

# line 205 "awk.lx.l"
{ int n;
		  sscanf(yytext+1, "%o", &n); cbuf[clen++] = n; }
break;
case 97:

# line 207 "awk.lx.l"
{ int n;	/* ANSI permits any number! */
		  sscanf(yytext+2, "%x", &n); cbuf[clen++] = n; }
break;
case 98:

# line 209 "awk.lx.l"
{ cbuf[clen++] = yytext[1]; }
break;
case 99:

# line 210 "awk.lx.l"
	{ CADD; }
break;
case -1:
break;
default:
(void)fprintf(yyout,"bad switch yylook %d",nstr);
} return(0); }
/* end of yylex */

startreg()
{
	BEGIN reg;
	clen = 0;
}

/* input() and unput() are transcriptions of the standard lex
   macros for input and output with additions for error message
   printing.  God help us all if someone changes how lex works.
*/

uchar	ebuf[300];
uchar	*ep = ebuf;

input()
{
	register int c;
	extern uchar *lexprog;

	if (yysptr > yysbuf)
		c = U(*--yysptr);
	else if (lexprog != NULL) {	/* awk '...' */
		if (c = *lexprog)
			lexprog++;
	} else				/* awk -f ... */
		c = pgetc();
	if (c == '\n')
		yylineno++;
	else if (c == EOF)
		c = 0;
	if (ep >= ebuf + sizeof ebuf)
		ep = ebuf;
	return *ep++ = c;
}

unput(c)
{
	yytchar = c;
	if (yytchar == '\n')
		yylineno--;
	*yysptr++ = yytchar;
	if (--ep < ebuf)
		ep = ebuf + sizeof(ebuf) - 1;
}


unputstr(s)
	char *s;
{
	int i;

	for (i = strlen(s)-1; i >= 0; i--)
		unput(s[i]);
}

int yyvstop[] = {
0,

80,
0,

3,
80,
0,

1,
0,

12,
80,
0,

76,
80,
0,

2,
80,
0,

37,
80,
0,

80,
0,

80,
0,

79,
80,
0,

80,
0,

80,
0,

80,
0,

80,
0,

80,
0,

39,
80,
0,

4,
80,
0,

16,
80,
0,

31,
80,
0,

20,
80,
0,

75,
80,
0,

75,
80,
0,

75,
80,
0,

75,
80,
0,

80,
0,

78,
80,
0,

33,
80,
0,

75,
80,
0,

75,
80,
0,

75,
80,
0,

75,
80,
0,

75,
80,
0,

75,
80,
0,

75,
80,
0,

75,
80,
0,

75,
80,
0,

75,
80,
0,

75,
80,
0,

75,
80,
0,

75,
80,
0,

75,
80,
0,

75,
80,
0,

75,
80,
0,

80,
0,

77,
80,
0,

14,
80,
0,

99,
0,

86,
0,

85,
99,
0,

99,
0,

84,
0,

82,
0,

83,
84,
0,

84,
0,

3,
0,

13,
0,

15,
0,

2,
0,

34,
0,

36,
0,

36,
0,

28,
0,

10,
0,

32,
0,

26,
0,

22,
0,

24,
0,

23,
0,

25,
0,

39,
0,

27,
0,

39,
0,

39,
0,

17,
0,

18,
0,

19,
0,

21,
0,

75,
0,

75,
0,

75,
0,

38,
75,
0,

5,
0,

29,
0,

75,
0,

75,
0,

75,
0,

75,
0,

75,
0,

42,
75,
0,

75,
0,

75,
0,

75,
0,

75,
0,

75,
0,

75,
0,

43,
75,
0,

58,
75,
0,

75,
0,

75,
0,

75,
0,

75,
0,

75,
0,

75,
0,

75,
0,

75,
0,

75,
0,

75,
0,

75,
0,

75,
0,

75,
0,

75,
0,

75,
0,

11,
0,

98,
0,

87,
98,
0,

96,
98,
0,

95,
98,
0,

94,
98,
0,

92,
98,
0,

90,
98,
0,

88,
98,
0,

91,
98,
0,

89,
98,
0,

93,
98,
0,

98,
0,

81,
0,

35,
36,
0,

30,
0,

39,
0,

75,
0,

7,
75,
0,

75,
0,

75,
0,

75,
0,

75,
0,

67,
75,
0,

75,
0,

75,
0,

75,
0,

64,
75,
0,

41,
75,
0,

75,
0,

75,
0,

75,
0,

75,
0,

63,
75,
0,

75,
0,

62,
75,
0,

75,
0,

75,
0,

75,
0,

75,
0,

75,
0,

66,
75,
0,

75,
0,

75,
0,

75,
0,

75,
0,

54,
75,
0,

75,
0,

75,
0,

75,
0,

75,
0,

96,
0,

97,
0,

75,
0,

75,
0,

75,
0,

75,
0,

75,
0,

75,
0,

44,
75,
0,

46,
75,
0,

8,
75,
0,

75,
0,

55,
75,
0,

75,
0,

75,
0,

75,
0,

45,
75,
0,

75,
0,

70,
75,
0,

75,
0,

75,
0,

75,
0,

65,
75,
0,

75,
0,

75,
0,

75,
0,

75,
0,

75,
0,

75,
0,

96,
0,

6,
75,
0,

68,
75,
0,

47,
75,
0,

74,
75,
0,

75,
0,

75,
0,

75,
0,

75,
0,

56,
75,
0,

75,
0,

57,
75,
0,

49,
75,
0,

75,
0,

52,
75,
0,

75,
0,

71,
75,
0,

75,
0,

75,
0,

75,
0,

75,
0,

40,
75,
0,

75,
0,

60,
75,
0,

75,
0,

75,
0,

61,
75,
0,

50,
75,
0,

9,
75,
0,

75,
0,

53,
75,
0,

69,
75,
0,

75,
0,

75,
0,

75,
0,

75,
0,

59,
75,
0,

51,
75,
0,

73,
75,
0,

72,
75,
0,

48,
75,
0,

8,
75,
0,
0};
# define YYTYPE unsigned char
struct yywork { YYTYPE verify, advance; } yycrank[] = {
0,0,	0,0,	3,13,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	3,14,	3,15,	
0,0,	0,0,	0,0,	0,0,	
0,0,	14,67,	0,0,	0,0,	
0,0,	5,59,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	5,59,	5,60,	0,0,	
0,0,	0,0,	3,16,	3,17,	
3,18,	3,19,	3,20,	3,21,	
14,67,	37,95,	3,22,	3,23,	
3,24,	70,0,	3,25,	3,26,	
3,27,	3,28,	6,61,	0,0,	
0,0,	0,0,	5,61,	0,0,	
0,0,	3,28,	0,0,	0,0,	
3,29,	3,30,	3,31,	3,32,	
0,0,	21,75,	3,33,	3,34,	
5,59,	10,65,	3,35,	23,76,	
3,33,	0,0,	16,68,	0,0,	
5,59,	0,0,	0,0,	3,36,	
0,0,	0,0,	0,0,	0,0,	
0,0,	5,59,	0,0,	24,78,	
9,63,	20,74,	23,77,	5,59,	
27,83,	3,37,	3,38,	3,39,	
9,63,	9,64,	3,40,	3,41,	
3,42,	3,43,	3,44,	3,45,	
3,46,	24,79,	3,47,	25,80,	
6,62,	3,48,	3,49,	3,50,	
5,62,	3,51,	10,66,	3,52,	
3,53,	3,54,	30,87,	31,88,	
3,55,	32,89,	32,90,	25,81,	
34,92,	3,56,	3,57,	3,58,	
4,16,	4,17,	4,18,	4,19,	
4,20,	4,21,	9,65,	9,63,	
4,22,	4,23,	4,24,	16,69,	
4,25,	4,26,	4,27,	9,63,	
35,93,	36,94,	39,96,	40,97,	
41,98,	43,101,	42,99,	44,103,	
9,63,	42,100,	4,29,	4,30,	
4,31,	4,32,	9,63,	43,102,	
45,105,	4,34,	47,109,	44,104,	
4,35,	48,111,	45,106,	46,107,	
18,70,	49,113,	47,110,	50,114,	
51,115,	4,36,	52,116,	48,112,	
18,70,	18,0,	52,117,	9,66,	
54,124,	46,108,	55,125,	56,126,	
76,141,	92,144,	82,86,	4,37,	
4,38,	4,39,	93,145,	97,146,	
4,40,	4,41,	4,42,	4,43,	
4,44,	4,45,	4,46,	98,147,	
4,47,	99,148,	101,151,	4,48,	
4,49,	4,50,	103,152,	4,51,	
100,149,	4,52,	4,53,	4,54,	
105,155,	100,150,	4,55,	18,70,	
106,156,	53,118,	82,86,	4,56,	
4,57,	4,58,	107,157,	18,70,	
53,119,	53,120,	53,121,	104,153,	
108,158,	53,122,	111,161,	112,162,	
18,70,	53,123,	104,154,	110,159,	
113,163,	114,164,	18,70,	19,71,	
19,71,	19,71,	19,71,	19,71,	
19,71,	19,71,	19,71,	19,71,	
19,71,	115,165,	116,166,	110,160,	
117,167,	118,168,	120,171,	121,172,	
19,72,	19,72,	19,72,	19,72,	
19,72,	19,72,	19,72,	19,72,	
19,72,	19,72,	19,72,	19,72,	
19,72,	19,73,	19,72,	19,72,	
19,72,	19,72,	19,72,	19,72,	
19,72,	19,72,	19,72,	19,72,	
19,72,	19,72,	122,173,	123,174,	
125,177,	144,180,	19,72,	146,181,	
19,72,	19,72,	19,72,	19,72,	
19,72,	19,72,	19,72,	19,72,	
19,72,	19,72,	19,72,	19,72,	
19,72,	19,72,	19,72,	19,72,	
19,72,	19,72,	19,72,	19,72,	
19,72,	19,72,	19,72,	19,72,	
19,72,	19,72,	26,82,	26,82,	
26,82,	26,82,	26,82,	26,82,	
26,82,	26,82,	26,82,	26,82,	
28,84,	147,182,	28,85,	28,85,	
28,85,	28,85,	28,85,	28,85,	
28,85,	28,85,	28,85,	28,85,	
33,91,	33,91,	33,91,	33,91,	
33,91,	33,91,	33,91,	33,91,	
33,91,	33,91,	119,169,	28,86,	
148,183,	149,184,	151,185,	152,186,	
119,170,	33,91,	33,91,	33,91,	
33,91,	33,91,	33,91,	33,91,	
33,91,	33,91,	33,91,	33,91,	
33,91,	33,91,	33,91,	33,91,	
33,91,	33,91,	33,91,	33,91,	
33,91,	33,91,	33,91,	33,91,	
33,91,	33,91,	33,91,	28,86,	
153,187,	156,188,	157,189,	33,91,	
158,190,	33,91,	33,91,	33,91,	
33,91,	33,91,	33,91,	33,91,	
33,91,	33,91,	33,91,	33,91,	
33,91,	33,91,	33,91,	33,91,	
33,91,	33,91,	33,91,	33,91,	
33,91,	33,91,	33,91,	33,91,	
33,91,	33,91,	33,91,	62,127,	
159,191,	66,139,	161,192,	163,193,	
164,194,	165,195,	166,196,	62,127,	
62,0,	66,139,	66,0,	71,71,	
71,71,	71,71,	71,71,	71,71,	
71,71,	71,71,	71,71,	71,71,	
71,71,	72,72,	72,72,	72,72,	
72,72,	72,72,	72,72,	72,72,	
72,72,	72,72,	72,72,	167,197,	
62,128,	169,198,	170,199,	171,200,	
73,72,	73,72,	73,72,	73,72,	
73,72,	73,72,	73,72,	73,72,	
73,72,	73,72,	62,129,	172,201,	
66,139,	173,202,	124,175,	72,72,	
174,203,	175,204,	62,127,	176,205,	
66,139,	177,206,	73,140,	124,176,	
180,208,	181,209,	182,210,	62,127,	
183,211,	66,139,	73,72,	184,212,	
185,213,	62,127,	188,214,	66,139,	
84,84,	84,84,	84,84,	84,84,	
84,84,	84,84,	84,84,	84,84,	
84,84,	84,84,	129,178,	129,178,	
129,178,	129,178,	129,178,	129,178,	
129,178,	129,178,	62,130,	189,215,	
191,216,	84,86,	192,217,	62,131,	
62,132,	193,218,	195,219,	197,220,	
62,133,	198,221,	199,222,	201,223,	
202,224,	203,225,	204,226,	205,227,	
62,134,	206,228,	212,229,	213,230,	
62,135,	214,231,	62,136,	215,232,	
62,137,	217,233,	62,138,	219,234,	
220,235,	86,142,	222,236,	86,142,	
224,237,	84,86,	86,143,	86,143,	
86,143,	86,143,	86,143,	86,143,	
86,143,	86,143,	86,143,	86,143,	
138,179,	138,179,	138,179,	138,179,	
138,179,	138,179,	138,179,	138,179,	
138,179,	138,179,	225,238,	226,239,	
227,240,	229,241,	231,242,	232,243,	
236,244,	138,179,	138,179,	138,179,	
138,179,	138,179,	138,179,	239,245,	
240,246,	140,72,	140,72,	140,72,	
140,72,	140,72,	140,72,	140,72,	
140,72,	140,72,	140,72,	142,143,	
142,143,	142,143,	142,143,	142,143,	
142,143,	142,143,	142,143,	142,143,	
142,143,	241,247,	242,248,	0,0,	
0,0,	138,179,	138,179,	138,179,	
138,179,	138,179,	138,179,	140,72,	
178,207,	178,207,	178,207,	178,207,	
178,207,	178,207,	178,207,	178,207,	
0,0};
struct yysvf yysvec[] = {
0,	0,	0,
yycrank+0,	0,		0,	
yycrank+0,	0,		0,	
yycrank+-1,	0,		0,	
yycrank+-95,	yysvec+3,	0,	
yycrank+-20,	0,		0,	
yycrank+-16,	yysvec+5,	0,	
yycrank+0,	0,		0,	
yycrank+0,	0,		0,	
yycrank+-87,	0,		0,	
yycrank+-22,	yysvec+9,	0,	
yycrank+0,	0,		0,	
yycrank+0,	0,		0,	
yycrank+0,	0,		yyvstop+1,
yycrank+8,	0,		yyvstop+3,
yycrank+0,	0,		yyvstop+6,
yycrank+13,	0,		yyvstop+8,
yycrank+0,	0,		yyvstop+11,
yycrank+-167,	0,		yyvstop+14,
yycrank+191,	0,		yyvstop+17,
yycrank+28,	0,		yyvstop+20,
yycrank+27,	0,		yyvstop+22,
yycrank+0,	0,		yyvstop+24,
yycrank+29,	0,		yyvstop+27,
yycrank+44,	0,		yyvstop+29,
yycrank+62,	0,		yyvstop+31,
yycrank+266,	0,		yyvstop+33,
yycrank+31,	0,		yyvstop+35,
yycrank+278,	0,		yyvstop+37,
yycrank+0,	0,		yyvstop+40,
yycrank+57,	0,		yyvstop+43,
yycrank+58,	0,		yyvstop+46,
yycrank+60,	0,		yyvstop+49,
yycrank+288,	0,		yyvstop+52,
yycrank+55,	yysvec+33,	yyvstop+55,
yycrank+66,	yysvec+33,	yyvstop+58,
yycrank+75,	yysvec+33,	yyvstop+61,
yycrank+31,	0,		yyvstop+64,
yycrank+0,	0,		yyvstop+66,
yycrank+85,	0,		yyvstop+69,
yycrank+31,	yysvec+33,	yyvstop+72,
yycrank+34,	yysvec+33,	yyvstop+75,
yycrank+42,	yysvec+33,	yyvstop+78,
yycrank+48,	yysvec+33,	yyvstop+81,
yycrank+43,	yysvec+33,	yyvstop+84,
yycrank+49,	yysvec+33,	yyvstop+87,
yycrank+66,	yysvec+33,	yyvstop+90,
yycrank+60,	yysvec+33,	yyvstop+93,
yycrank+64,	yysvec+33,	yyvstop+96,
yycrank+72,	yysvec+33,	yyvstop+99,
yycrank+70,	yysvec+33,	yyvstop+102,
yycrank+58,	yysvec+33,	yyvstop+105,
yycrank+77,	yysvec+33,	yyvstop+108,
yycrank+112,	yysvec+33,	yyvstop+111,
yycrank+69,	yysvec+33,	yyvstop+114,
yycrank+78,	yysvec+33,	yyvstop+117,
yycrank+59,	0,		yyvstop+120,
yycrank+0,	0,		yyvstop+122,
yycrank+0,	0,		yyvstop+125,
yycrank+0,	0,		yyvstop+128,
yycrank+0,	0,		yyvstop+130,
yycrank+0,	0,		yyvstop+132,
yycrank+-410,	0,		yyvstop+135,
yycrank+0,	0,		yyvstop+137,
yycrank+0,	0,		yyvstop+139,
yycrank+0,	0,		yyvstop+141,
yycrank+-412,	0,		yyvstop+144,
yycrank+0,	yysvec+14,	yyvstop+146,
yycrank+0,	0,		yyvstop+148,
yycrank+0,	0,		yyvstop+150,
yycrank+-35,	yysvec+18,	yyvstop+152,
yycrank+375,	0,		yyvstop+154,
yycrank+385,	yysvec+19,	yyvstop+156,
yycrank+400,	yysvec+19,	yyvstop+158,
yycrank+0,	0,		yyvstop+160,
yycrank+0,	0,		yyvstop+162,
yycrank+123,	0,		yyvstop+164,
yycrank+0,	0,		yyvstop+166,
yycrank+0,	0,		yyvstop+168,
yycrank+0,	0,		yyvstop+170,
yycrank+0,	0,		yyvstop+172,
yycrank+0,	0,		yyvstop+174,
yycrank+117,	yysvec+26,	yyvstop+176,
yycrank+0,	0,		yyvstop+178,
yycrank+436,	0,		yyvstop+180,
yycrank+0,	yysvec+28,	yyvstop+182,
yycrank+490,	0,		0,	
yycrank+0,	0,		yyvstop+184,
yycrank+0,	0,		yyvstop+186,
yycrank+0,	0,		yyvstop+188,
yycrank+0,	0,		yyvstop+190,
yycrank+0,	yysvec+33,	yyvstop+192,
yycrank+114,	yysvec+33,	yyvstop+194,
yycrank+122,	yysvec+33,	yyvstop+196,
yycrank+0,	yysvec+33,	yyvstop+198,
yycrank+0,	0,		yyvstop+201,
yycrank+0,	0,		yyvstop+203,
yycrank+94,	yysvec+33,	yyvstop+205,
yycrank+98,	yysvec+33,	yyvstop+207,
yycrank+90,	yysvec+33,	yyvstop+209,
yycrank+98,	yysvec+33,	yyvstop+211,
yycrank+94,	yysvec+33,	yyvstop+213,
yycrank+0,	yysvec+33,	yyvstop+215,
yycrank+91,	yysvec+33,	yyvstop+218,
yycrank+122,	yysvec+33,	yyvstop+220,
yycrank+98,	yysvec+33,	yyvstop+222,
yycrank+106,	yysvec+33,	yyvstop+224,
yycrank+106,	yysvec+33,	yyvstop+226,
yycrank+111,	yysvec+33,	yyvstop+228,
yycrank+0,	yysvec+33,	yyvstop+230,
yycrank+135,	yysvec+33,	yyvstop+233,
yycrank+120,	yysvec+33,	yyvstop+236,
yycrank+128,	yysvec+33,	yyvstop+238,
yycrank+120,	yysvec+33,	yyvstop+240,
yycrank+117,	yysvec+33,	yyvstop+242,
yycrank+144,	yysvec+33,	yyvstop+244,
yycrank+140,	yysvec+33,	yyvstop+246,
yycrank+136,	yysvec+33,	yyvstop+248,
yycrank+143,	yysvec+33,	yyvstop+250,
yycrank+238,	yysvec+33,	yyvstop+252,
yycrank+140,	yysvec+33,	yyvstop+254,
yycrank+158,	yysvec+33,	yyvstop+256,
yycrank+184,	yysvec+33,	yyvstop+258,
yycrank+168,	yysvec+33,	yyvstop+260,
yycrank+354,	yysvec+33,	yyvstop+262,
yycrank+179,	yysvec+33,	yyvstop+264,
yycrank+0,	0,		yyvstop+266,
yycrank+0,	0,		yyvstop+268,
yycrank+0,	0,		yyvstop+270,
yycrank+446,	0,		yyvstop+273,
yycrank+0,	0,		yyvstop+276,
yycrank+0,	0,		yyvstop+279,
yycrank+0,	0,		yyvstop+282,
yycrank+0,	0,		yyvstop+285,
yycrank+0,	0,		yyvstop+288,
yycrank+0,	0,		yyvstop+291,
yycrank+0,	0,		yyvstop+294,
yycrank+0,	0,		yyvstop+297,
yycrank+500,	0,		yyvstop+300,
yycrank+0,	0,		yyvstop+302,
yycrank+525,	yysvec+19,	yyvstop+304,
yycrank+0,	0,		yyvstop+307,
yycrank+535,	0,		0,	
yycrank+0,	yysvec+142,	yyvstop+309,
yycrank+212,	yysvec+33,	yyvstop+311,
yycrank+0,	yysvec+33,	yyvstop+313,
yycrank+177,	yysvec+33,	yyvstop+316,
yycrank+228,	yysvec+33,	yyvstop+318,
yycrank+233,	yysvec+33,	yyvstop+320,
yycrank+233,	yysvec+33,	yyvstop+322,
yycrank+0,	yysvec+33,	yyvstop+324,
yycrank+249,	yysvec+33,	yyvstop+327,
yycrank+250,	yysvec+33,	yyvstop+329,
yycrank+264,	yysvec+33,	yyvstop+331,
yycrank+0,	yysvec+33,	yyvstop+333,
yycrank+0,	yysvec+33,	yyvstop+336,
yycrank+282,	yysvec+33,	yyvstop+339,
yycrank+274,	yysvec+33,	yyvstop+341,
yycrank+286,	yysvec+33,	yyvstop+343,
yycrank+311,	yysvec+33,	yyvstop+345,
yycrank+0,	yysvec+33,	yyvstop+347,
yycrank+311,	yysvec+33,	yyvstop+350,
yycrank+0,	yysvec+33,	yyvstop+352,
yycrank+316,	yysvec+33,	yyvstop+355,
yycrank+300,	yysvec+33,	yyvstop+357,
yycrank+307,	yysvec+33,	yyvstop+359,
yycrank+318,	yysvec+33,	yyvstop+361,
yycrank+326,	yysvec+33,	yyvstop+363,
yycrank+0,	yysvec+33,	yyvstop+365,
yycrank+340,	yysvec+33,	yyvstop+368,
yycrank+341,	yysvec+33,	yyvstop+370,
yycrank+331,	yysvec+33,	yyvstop+372,
yycrank+349,	yysvec+33,	yyvstop+374,
yycrank+346,	yysvec+33,	yyvstop+376,
yycrank+348,	yysvec+33,	yyvstop+379,
yycrank+354,	yysvec+33,	yyvstop+381,
yycrank+355,	yysvec+33,	yyvstop+383,
yycrank+361,	yysvec+33,	yyvstop+385,
yycrank+556,	0,		yyvstop+387,
yycrank+0,	yysvec+138,	yyvstop+389,
yycrank+394,	yysvec+33,	yyvstop+391,
yycrank+423,	yysvec+33,	yyvstop+393,
yycrank+367,	yysvec+33,	yyvstop+395,
yycrank+375,	yysvec+33,	yyvstop+397,
yycrank+374,	yysvec+33,	yyvstop+399,
yycrank+364,	yysvec+33,	yyvstop+401,
yycrank+0,	yysvec+33,	yyvstop+403,
yycrank+0,	yysvec+33,	yyvstop+406,
yycrank+366,	yysvec+33,	yyvstop+409,
yycrank+398,	yysvec+33,	yyvstop+412,
yycrank+0,	yysvec+33,	yyvstop+414,
yycrank+384,	yysvec+33,	yyvstop+417,
yycrank+390,	yysvec+33,	yyvstop+419,
yycrank+405,	yysvec+33,	yyvstop+421,
yycrank+0,	yysvec+33,	yyvstop+423,
yycrank+394,	yysvec+33,	yyvstop+426,
yycrank+0,	yysvec+33,	yyvstop+428,
yycrank+397,	yysvec+33,	yyvstop+431,
yycrank+397,	yysvec+33,	yyvstop+433,
yycrank+404,	yysvec+33,	yyvstop+435,
yycrank+0,	yysvec+33,	yyvstop+437,
yycrank+415,	yysvec+33,	yyvstop+440,
yycrank+400,	yysvec+33,	yyvstop+442,
yycrank+416,	yysvec+33,	yyvstop+444,
yycrank+399,	yysvec+33,	yyvstop+446,
yycrank+407,	yysvec+33,	yyvstop+448,
yycrank+420,	yysvec+33,	yyvstop+450,
yycrank+0,	0,		yyvstop+452,
yycrank+0,	yysvec+33,	yyvstop+454,
yycrank+0,	yysvec+33,	yyvstop+457,
yycrank+0,	yysvec+33,	yyvstop+460,
yycrank+0,	yysvec+33,	yyvstop+463,
yycrank+412,	yysvec+33,	yyvstop+466,
yycrank+422,	yysvec+33,	yyvstop+468,
yycrank+420,	yysvec+33,	yyvstop+470,
yycrank+417,	yysvec+33,	yyvstop+472,
yycrank+0,	yysvec+33,	yyvstop+474,
yycrank+425,	yysvec+33,	yyvstop+477,
yycrank+0,	yysvec+33,	yyvstop+479,
yycrank+429,	yysvec+33,	yyvstop+482,
yycrank+422,	yysvec+33,	yyvstop+485,
yycrank+0,	yysvec+33,	yyvstop+487,
yycrank+418,	yysvec+33,	yyvstop+490,
yycrank+0,	yysvec+33,	yyvstop+492,
yycrank+422,	yysvec+33,	yyvstop+495,
yycrank+449,	yysvec+33,	yyvstop+497,
yycrank+458,	yysvec+33,	yyvstop+499,
yycrank+459,	yysvec+33,	yyvstop+501,
yycrank+0,	yysvec+33,	yyvstop+503,
yycrank+444,	yysvec+33,	yyvstop+506,
yycrank+0,	yysvec+33,	yyvstop+508,
yycrank+451,	yysvec+33,	yyvstop+511,
yycrank+462,	yysvec+33,	yyvstop+513,
yycrank+0,	yysvec+33,	yyvstop+515,
yycrank+0,	yysvec+33,	yyvstop+518,
yycrank+0,	yysvec+33,	yyvstop+521,
yycrank+462,	yysvec+33,	yyvstop+524,
yycrank+0,	yysvec+33,	yyvstop+526,
yycrank+0,	yysvec+33,	yyvstop+529,
yycrank+457,	yysvec+33,	yyvstop+532,
yycrank+458,	yysvec+33,	yyvstop+534,
yycrank+492,	yysvec+33,	yyvstop+536,
yycrank+484,	yysvec+33,	yyvstop+538,
yycrank+0,	yysvec+33,	yyvstop+540,
yycrank+0,	yysvec+33,	yyvstop+543,
yycrank+0,	yysvec+33,	yyvstop+546,
yycrank+0,	yysvec+33,	yyvstop+549,
yycrank+0,	yysvec+33,	yyvstop+552,
yycrank+0,	yysvec+33,	yyvstop+555,
0,	0,	0};
struct yywork *yytop = yycrank+611;
struct yysvf *yybgin = yysvec+1;
unsigned char yymatch[] = {
00  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,011 ,012 ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
011 ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,
'8' ,'8' ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'G' ,
'G' ,'G' ,'G' ,'G' ,'G' ,'G' ,'G' ,'G' ,
'G' ,'G' ,'G' ,'G' ,'G' ,'G' ,'G' ,'G' ,
'G' ,'G' ,'G' ,01  ,01  ,01  ,01  ,'G' ,
01  ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'G' ,
'G' ,'G' ,'G' ,'G' ,'G' ,'G' ,'G' ,'G' ,
'G' ,'G' ,'G' ,'G' ,'G' ,'G' ,'G' ,'G' ,
'G' ,'G' ,'G' ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
0};
char yyextra[] = {
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0};
#ident	"@(#)libl:lib/ncform	1.7"
int yylineno =1;
# define YYU(x) x
# define NLSTATE yyprevious=YYNEWLINE
char yytext[YYLMAX];
struct yysvf *yylstate [YYLMAX], **yylsp, **yyolsp;
char yysbuf[YYLMAX];
char *yysptr = yysbuf;
int *yyfnd;
extern struct yysvf *yyestate;
int yyprevious = YYNEWLINE;
#if defined(__cplusplus) || defined(__STDC__)
int yylook(void)
#else
yylook()
#endif
{
	register struct yysvf *yystate, **lsp;
	register struct yywork *yyt;
	struct yysvf *yyz;
	int yych, yyfirst;
	struct yywork *yyr;
# ifdef LEXDEBUG
	int debug;
# endif
	char *yylastch;
	/* start off machines */
# ifdef LEXDEBUG
	debug = 0;
# endif
	yyfirst=1;
	if (!yymorfg)
		yylastch = yytext;
	else {
		yymorfg=0;
		yylastch = yytext+yyleng;
		}
	for(;;){
		lsp = yylstate;
		yyestate = yystate = yybgin;
		if (yyprevious==YYNEWLINE) yystate++;
		for (;;){
# ifdef LEXDEBUG
			if(debug)fprintf(yyout,"state %d\n",yystate-yysvec-1);
# endif
			yyt = yystate->yystoff;
			if(yyt == yycrank && !yyfirst){  /* may not be any transitions */
				yyz = yystate->yyother;
				if(yyz == 0)break;
				if(yyz->yystoff == yycrank)break;
				}
			*yylastch++ = yych = input();
			if(yylastch > &yytext[YYLMAX]) {
				fprintf(yyout,"Input string too long, limit %d\n",YYLMAX);
				exit(1);
			}
			yyfirst=0;
		tryagain:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"char ");
				allprint(yych);
				putchar('\n');
				}
# endif
			yyr = yyt;
			if ( (int)yyt > (int)yycrank){
				yyt = yyr + yych;
				if (yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					if(lsp > &yylstate[YYLMAX]) {
						fprintf(yyout,"Input string too long, limit %d\n",YYLMAX);
						exit(1);
					}
					goto contin;
					}
				}
# ifdef YYOPTIM
			else if((int)yyt < (int)yycrank) {		/* r < yycrank */
				yyt = yyr = yycrank+(yycrank-yyt);
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"compressed state\n");
# endif
				yyt = yyt + yych;
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					if(lsp > &yylstate[YYLMAX]) {
						fprintf(yyout,"Input string too long, limit %d\n",YYLMAX);
						exit(1);
					}
					goto contin;
					}
				yyt = yyr + YYU(yymatch[yych]);
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"try fall back character ");
					allprint(YYU(yymatch[yych]));
					putchar('\n');
					}
# endif
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transition */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					if(lsp > &yylstate[YYLMAX]) {
						fprintf(yyout,"Input string too long, limit %d\n",YYLMAX);
						exit(1);
					}
					goto contin;
					}
				}
			if ((yystate = yystate->yyother) && (yyt= yystate->yystoff) != yycrank){
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"fall back to state %d\n",yystate-yysvec-1);
# endif
				goto tryagain;
				}
# endif
			else
				{unput(*--yylastch);break;}
		contin:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"state %d char ",yystate-yysvec-1);
				allprint(yych);
				putchar('\n');
				}
# endif
			;
			}
# ifdef LEXDEBUG
		if(debug){
			fprintf(yyout,"stopped at %d with ",*(lsp-1)-yysvec-1);
			allprint(yych);
			putchar('\n');
			}
# endif
		while (lsp-- > yylstate){
			*yylastch-- = 0;
			if (*lsp != 0 && (yyfnd= (*lsp)->yystops) && *yyfnd > 0){
				yyolsp = lsp;
				if(yyextra[*yyfnd]){		/* must backup */
					while(yyback((*lsp)->yystops,-*yyfnd) != 1 && lsp > yylstate){
						lsp--;
						unput(*yylastch--);
						}
					}
				yyprevious = YYU(*yylastch);
				yylsp = lsp;
				yyleng = yylastch-yytext+1;
				yytext[yyleng] = 0;
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"\nmatch ");
					sprint(yytext);
					fprintf(yyout," action %d\n",*yyfnd);
					}
# endif
				return(*yyfnd++);
				}
			unput(*yylastch);
			}
		if (yytext[0] == 0  /* && feof(yyin) */)
			{
			yysptr=yysbuf;
			return(0);
			}
		yyprevious = yytext[0] = input();
		if (yyprevious>0)
			output(yyprevious);
		yylastch=yytext;
# ifdef LEXDEBUG
		if(debug)putchar('\n');
# endif
		}
	}
#if defined(__cplusplus) || defined(__STDC__)
int yyback(int *p, int m)
#else
yyback(p, m)
	int *p;
#endif
{
	if (p==0) return(0);
	while (*p) {
		if (*p++ == m)
			return(1);
	}
	return(0);
}
	/* the following are only used in the lex library */
#if defined(__cplusplus) || defined(__STDC__)
int yyinput(void)
#else
yyinput()
#endif
{
	return(input());
	}
#if defined(__cplusplus) || defined(__STDC__)
void yyoutput(int c)
#else
yyoutput(c)
  int c; 
#endif
{
	output(c);
	}
#if defined(__cplusplus) || defined(__STDC__)
void yyunput(int c)
#else
yyunput(c)
   int c; 
#endif
{
	unput(c);
	}
