.bp
.sh 1 "Additional features"
.pp
This section describes some additional commands of use for
reading your mail, setting options, and handling lists of messages.
.sh 2 "Message lists"
.pp
Several
.i Mail
commands accept a list of messages as an argument.
Along with
.b type
and
.b delete ,
described in section 2,
there is the
.b from
command, which prints the message headers associated with the
message list passed to it.
The
.b from
command is particularly useful in conjunction with some of the
message list features described below.
.pp
A
.i "message list"
consists of a list of message numbers, ranges, and names,
separated by spaces or tabs.  Message numbers may be either
decimal numbers, which directly specify messages, or one of the
special characters
.q \(ua
.q "."
or
.q "$"
to specify the first relevant, current, or last
relevant message, respectively.
.i Relevant
here means, for most commands
.q "not deleted"
and
.q "deleted"
for the
.b undelete
command.
.pp
A range of messages consists of two message numbers (of the form
described in the previous paragraph) separated by a dash.
Thus, to print the first four messages, use
.(l
type 1\-4
.)l
and to print all the messages from the current message to the last
message, use
.(l
type .\-$
.)l
.pp
A
.i name
is a user name.  The user names given in the message list are
collected together and each message selected by other means
is checked to make sure it was sent by one of the named users.
If the message consists entirely of user names, then every
message sent by one those users that is
.i relevant
(in the sense described earlier)
is selected.  Thus, to print every message sent to you by
.q root,
do
.(l
type root
.)l
.pp
As a shorthand notation, you can specify simply
.q *
to get every
.i relevant
(same sense)
message.  Thus,
.(l
type *
.)l
prints all undeleted messages,
.(l
delete *
.)l
deletes all undeleted messages, and
.(l
undelete *
.)l
undeletes all deleted messages.
.pp
You can search for the presence of a word in subject lines with
.b / .
For example, to print the headers of all messages that contain the
word
.q PASCAL,
do:
.(l
from /pascal
.)l
Note that subject searching ignores upper/lower case differences.
.sh 2 "List of commands"
.pp
This section describes all the
.i Mail
commands available when
receiving mail.
.ip \fB!\fP
Used to preface a command to be executed by the shell.
.ip \fB\-\fP
The
.rb \-
command goes to the previous message and prints it.  The
.rb \-
command may be given a decimal number
.i n
as an argument, in which case the
.i n th
previous message is gone to and printed.
.ip \fBReply\fP
Note the capital R in the name.
Frame a reply to a one or more messages.
The reply (or replies if you are using this on multiple messages)
will be sent ONLY to the person who sent you the message
(respectively, the set of people who sent the messages you are
replying to).
You can
add people using the
.b ~t
and
.b ~c
tilde escapes.  The subject in your reply is formed by prefacing the
subject in the original message with
.q "Re:"
unless it already began thus.
If the original message included a
.q "reply-to"
header field, the reply will go
.i only
to the recipient named by
.q "reply-to."
You type in your message using the same conventions available to you
through the
.b mail
command.
The
.b Reply
command is especially useful for replying to messages that were sent
to enormous distribution groups when you really just want to
send a message to the originator.  Use it often.
.ip \fBalias\fP
Define a name to stand for a set of other names.
This is used when you want to send messages to a certain
group of people and want to avoid retyping their names.
For example
.(l
alias project john sue willie kathryn
.)l
creates an alias
.i project
which expands to the four people John, Sue, Willie, and Kathryn.
.ip \fBalternates\fP
If you have accounts on several machines, you may find it convenient
to use the /usr/lib/aliases on all the machines except one to direct
your mail to a single account.
The
.b alternates
command is used to inform
.i Mail
that each of these other addresses is really
.i you .
.i Alternates
takes a list of user names and remembers that they are all actually you.
When you
.b reply
to messages that were sent to one of these alternate names,
.i Mail
will not bother to send a copy of the message to this other address (which
would simply be directed back to you by the alias mechanism).
If
.i alternates
is given no argument, it lists the current set of alternate names.
.b Alternates
is usually used in the .mailrc file.
.ip \fBchdir\fP
The
.b chdir
command allows you to change your current directory.
.b Chdir
takes a single argument, which is taken to be the pathname of
the directory to change to.  If no argument is given,
.b chdir
changes to your home directory.
.ip \fBcopy\fP
The
.b copy
command does the same thing that
.b save
does, except that it does not mark the messages it is used on
for deletion when you quit.
.ip \fBdelete\fP
Deletes a list of messages.  Deleted messages can be reclaimed
with the
.b undelete
command.
.ip \fBdt\fP
The
.b dt
command deletes the current message and prints the next message.
It is useful for quickly reading and disposing of mail.
.ip \fBedit\fP
To edit individual messages using the text editor, the
.b edit
command is provided.  The
.b edit
command takes a list of messages as described under the
.b type
command and processes each by writing it into the file
Message\c
.i x
where
.i x
is the message number being edited and executing the text editor on it.
When you have edited the message to your satisfaction, write the message
out and quit, upon which
.i Mail
will read the message back and remove the file.
.b Edit
may be abbreviated to
.b e .
.ip \fBelse\fP
Marks the end of the then-part of an
.b if
statement and the beginning of the
part to take effect if the condition of the
.b if
statement is false.
.ip \fBendif\fP
Marks the end of an
.b if
statement.
.ip \fBexit\fP
Leave
.i Mail
without updating the system mailbox or the file your were reading.
Thus, if you accidentally delete several messages, you can use
.b exit
to avoid scrambling your mailbox.
.ip \fBfile\fP
The same as
.b folder .
.ip \fBfolders\fP
List the names of the folders in your folder directory.
.ip \fBfolder\fP
The
.b folder
command switches to a new mail file or folder.  With no arguments, it
tells you which file you are currently reading.  If you give
it an argument, it will write out changes (such as deletions)
you have made in the current file and read the new file.
Some special conventions are recognized for the name:
.(b
.TS
center;
c c
l a.
Name	Meaning
_
#	Previous file read
%	Your system mailbox
%name	\fIName\fP's system mailbox
&	Your ~/mbox file
+folder	A file in your folder directory
.TE
.)b
.ip \fBfrom\fP
The
.b from
command takes a list of messages and prints out the header lines for each one;
hence
.(l
from joe
.)l
is the easy way to display all the message headers from \*(lqjoe.\*(rq
.ip \fBheaders\fP
When you start up
.i Mail
to read your mail, it lists the message headers that you have.
These headers tell you who each message is from, when they were
sent, how many lines and characters each message is, and the
.q "Subject:"
header field of each message, if present.  In addition,
.i Mail
tags the message header of each message that has been the object
of the
.b preserve
command with a
.q P.
Messages that have been
.b saved
or
.b written
are flagged with a
.q *.
Finally,
.b deleted
messages are not printed at all.  If you wish to reprint the current
list of message headers, you can do so with the
.b headers
command.  The
.b headers
command (and thus the initial header listing)
only lists the first so many message headers.
The number of headers listed depends on the speed of your
terminal.
This can be overridden by specifying the number of headers you
want with the
.i window
option.
.i Mail
maintains a notion of the current
.q window
into your messages for the purposes of printing headers.
Use the
.b z
command to move forward and back a window.
You can move
.i Mail's
notion of the current window directly to a particular message by
using, for example,
.(l
headers 40
.)l
to move
.i Mail's
attention to the messages around message 40.  The
.b headers
command can be abbreviated to
.b h .
.ip \fBhelp\fP
Print a brief and usually out of date help message about the commands
in
.i Mail .
Refer to this manual instead.
.ip \fBhold\fP
Arrange to hold a list of messages in the system mailbox, instead
of moving them to the file
.i mbox
in your home directory.  If you set the binary option
.i hold ,
this will happen by default.
.ip \fBif\fP
Commands in your
.q .mailrc
file can be executed conditionally depending on whether you are
sending or receiving mail with the
.b if
command.  For example, you can do:
.(l
if receive
	\fIcommands\fP...
endif
.)l
An
.b else
form is also available:
.(l
if send
	\fIcommands\fP...
else
	\fIcommands\fP...
endif
.)l
Note that the only allowed conditions are
.b receive
and
.b send .
.ip \fBignore\fP
Ignore a list of headers.
If you use
.b p
to print messages,
these headers
will not
be printed.
If you use
.b P ,
the headers
will be printed.
.ip \fBmail\fP
Send mail to one or more people.  If you have the
.i ask
option set,
.i Mail
will prompt you for a subject to your message.  Then you
can type in your message, using tilde escapes as described in
section 4 to edit, print, or modify your message.  To signal your
satisfaction with the message and send it, type control-d at the
beginning of a line, or a . alone on a line if you set the option
.i dot .
To abort the message, type two interrupt characters (\s-2RUBOUT\s0
by default) in a row or use the
.b ~q
escape.
.ip \fBmbox\fP
Indicate that a list of messages be sent to
.i mbox
in your home directory when you quit.  This is the default
action for messages if you do
.i not
have the
.i hold
option set.
.ip \fBnext\fP
The
.b next
command goes to the next message and types it.  If given a message list,
.b next
goes to the first such message and types it.  Thus,
.(l
next root
.)l
goes to the next message sent by
.q root
and types it.  The
.b next
command can be abbreviated to simply a newline, which means that one
can go to and type a message by simply giving its message number or
one of the magic characters
.q "\(ua"
.q "."
or
.q "$".
Thus,
.(l
\&.
.)l
prints the current message and
.(l
4
.)l
prints message 4, as described previously.
.ip \fBpreserve\fP
Same as
.b hold .
Cause a list of messages to be held in your system mailbox when you quit.
.ip \fBquit\fP
Leave
.i Mail
and update the file, folder, or system mailbox your were reading.
Messages that you have examined are marked as
.q read
and messages that existed when you started are marked as
.q old.
If you were editing your system mailbox and
if you have set the binary option
.i hold ,
all messages which have not been deleted, saved, or mboxed
will be retained in your system mailbox.
If you were editing your system mailbox and
you did
.i not
have
.i hold
set, all messages which have not been deleted, saved, or preserved
will be moved to the file
.i mbox
in your home directory.
.ip \fBreply\fP
Frame a reply to a single message.
The reply will be sent to the
person who sent you the message to which you are replying, plus all
the people who received the original message, except you.  You can
add people using the
.b ~t
and
.b ~c
tilde escapes.  The subject in your reply is formed by prefacing the
subject in the original message with
.q "Re:"
unless it already began thus.
If the original message included a
.q "reply-to"
header field, the reply will go
.i only
to the recipient named by
.q "reply-to."
You type in your message using the same conventions available to you
through the
.b mail
command.
.ip \fBsave\fP
It is often useful to be able to save messages on related topics
in a file.  The
.b save
command gives you ability to do this.  The
.b save
command takes as argument a lit of message numbers, followed by
the name of the file on which to save the messages.  The messages
are appended to the named file, thus allowing one to keep several
messages in the file, stored in the order they were put there.
The
.b save
command can be abbreviated to
.b s .
An example of the
.b save
command relative to our running example is:
.(l
s 1 2 tuitionmail
.)l
.b Saved
messages are not automatically saved in
.i mbox
at quit time, nor are they selected by the
.b next
command described above, unless explicitly specified.
.ip \fBset\fP
Set an option or give an option a value.  Used to customize
.i Mail .
Section 5.3 contains a list of the options.  Options can be
.i binary ,
in which case they are
.i on
or
.i off ,
or
.i valued .
To set a binary option
.i option
.i on ,
do
.(l
set option
.)l
To give the valued option
.i option
the value
.i value ,
do
.(l
set option=value
.)l
Several options can be specified in a single
.b set
command.
.ip \fBshell\fP
The
.b shell
command allows you to
escape to the shell.
.b Shell
invokes an interactive shell and allows you to type commands to it.
When you leave the shell, you will return to
.i Mail .
The shell used is a default assumed by
.i Mail ;
you can override this default by setting the valued option
.q SHELL,
eg:
.(l
set SHELL=/bin/csh
.)l
.ip \fBsource\fP
The
.b source
command reads
.i Mail
commands from a file.  It is useful when you are trying to fix your
.q .mailrc
file and you need to re-read it.
.ip \fBtop\fP
The
.b top
command takes a message list and prints the first five lines
of each addressed message.  It may be abbreviated to
.b to .
If you wish, you can change the number of lines that
.b top
prints out by setting the valued option
.q "toplines."
On a CRT terminal,
.(l
set toplines=10
.)l
might be preferred.
.ip \fBtype\fP
Print a list of messages on your terminal.  If you have set the
option
.i crt
to a number and the total number of lines in the messages you are
printing exceed that specified by
.i crt ,
the messages will be printed by a terminal paging program such as
.i more .
.ip \fBundelete\fP
The
.b undelete
command causes a message that had been deleted previously to regain
its initial status.  Only messages that have been deleted may be
undeleted.  This command may be abbreviated to
.b u .
.ip \fBunset\fP
Reverse the action of setting a binary or valued option.
.ip \fBvisual\fP
It is often useful to be able to invoke one of two editors,
based on the type of terminal one is using.  To invoke
a display oriented editor, you can use the
.b visual
command.  The operation of the
.b visual
command is otherwise identical to that of the
.b edit
command.
.ne 2v+\n(psu
.sp \n(psu
Both the
.b edit
and
.b visual
commands assume some default text editors.  These default editors
can be overridden by the valued options
.q EDITOR
and
.q VISUAL
for the standard and screen editors.  You might want to do:
.(l
set EDITOR=/usr/ucb/ex VISUAL=/usr/ucb/vi
.)l
.ip \fBwrite\fP
The
.b save
command always writes the entire message, including the headers,
into the file.  If you want to write just the message itself, you
can use the
.b write
command.  The
.b write
command has the same syntax as the
.b save
command, and can be abbreviated to simply
.b w .
Thus, we could write the second message by doing:
.(l
w 2 file.c
.)l
As suggested by this example, the
.b write
command is useful for such tasks as sending and receiving
source program text over the message system.
.ip \fBz\fP
.i Mail
presents message headers in windowfuls as described under
the
.b headers
command.
You can move
.i Mail's
attention forward to the next window by giving the
.(l
z+
.)l
command.  Analogously, you can move to the previous window with:
.(l
z\-
.)l
.sh 2 "Custom options"
.pp
Throughout this manual, we have seen examples of binary and valued options.
This section describes each of the options in alphabetical order, including
some that you have not seen yet.
To avoid confusion, please note that the options are either
all lower case letters or all upper case letters.  When I start a sentence
such as:
.q "Ask"
causes
.i Mail
to prompt you for a subject header,
I am only capitalizing
.q ask
as a courtesy to English.
.ip \fBEDITOR\fP
The valued option
.q EDITOR
defines the pathname of the text editor to be used in the
.b edit
command and ~e.  If not defined, a standard editor is used.
.ip \fBSHELL\fP
The valued option
.q SHELL
gives the path name of your shell.  This shell is used for the
.b !
command and ~! escape.  In addition, this shell expands
file names with shell metacharacters like * and ? in them.
.ip \fBVISUAL\fP
The valued option
.q VISUAL
defines the pathname of your screen editor for use in the
.b visual
command
and ~v escape.  A standard screen editor is used if you do not define one.
.ip \fBappend\fP
The
.q append
option is binary and
causes messages saved in
.i mbox
to be appended to the end rather than prepended.
Normally,
.i Mail will put messages in
.i mbox
in the same order that the system puts messages in your system mailbox.
By setting
.q append,
you are requesting that
.i mbox
be appended to regardless.  It is in any event quicker to append.
.ip \fBask\fP
.q "Ask"
is a binary option which
causes
.i Mail
to prompt you for the subject of each message you send.
If you respond with simply a newline, no subject field will be sent.
.ip \fBaskcc\fP
.q Askcc
is a binary option which
causes you to be prompted for additional carbon copy recipients at the
end of each message.  Responding with a newline shows your
satisfaction with the current list.
.ip \fBautoprint\fP
.q Autoprint
is a binary option which
causes the
.b delete
command to behave like
.b dp
\*- thus, after deleting a message, the next one will be typed
automatically.  This is useful to quickly scanning and deleting
messages in your mailbox.
.ip \fBdot\fP
.q Dot
is a binary option which, if set, causes
.i Mail
to interpret a period alone on a line as the terminator
of a message you are sending.
.ip \fBescape\fP
To allow you to change the escape character used when sending
mail, you can set the valued option
.q escape.
Only the first character of the
.q escape
option is used, and it must be doubled if it is to appear as
the first character of a line of your message.  If you change your escape
character, then ~ loses all its special meaning, and need no longer be doubled
at the beginning of a line.
.ip \fBfolder\fP
The name of the directory to use for storing folders of messages.
If this name begins with a `/'
.i Mail
considers it to be an absolute pathname; otherwise, the folder directory
is found relative to your home directory.
.ip \fBignore\fP
The binary option
.q ignore
causes \s-2RUBOUT\s0 characters from your terminal to be ignored and echoed
as @'s while you are sending mail.  \s-2RUBOUT\s0 characters retain their
original meaning in
.i Mail
command mode.
Setting the
.q ignore
option is equivalent to supplying the
.b \-i
flag on the command line as described in section 2.
.ip \fBignoreeof\fP
An option related to
.q dot
is
.q ignoreeof
which makes
.i Mail
refuse to accept a control\-d as the end of a message.
.q Ignoreeof
also applies to
.i Mail
command mode.
.ip \fBkeep\fP
The
.q keep
option causes
.i Mail
to truncate your system mailbox instead of deleting it when it
is empty.  This is useful if you elect to protect your mailbox, which
you would do with the shell command:
.(l
chmod 600 /usr/spool/mail/yourname
.)l
where
.i yourname
is your login name.  If you do not do this, anyone can probably read
your mail, although people usually don't.
.ip \fBkeepsave\fP
When you
.b save
a message,
.i Mail
usually discards it when you
.b quit .
To retain all saved messages, set the
.q keepsave
option.
.ip \fBmetoo\fP
When sending mail to an alias,
.i Mail
makes sure that if you are included in the alias, that mail will not
be sent to you.  This is useful if a single alias is being used by
all members of the group.  If however, you wish to receive a copy of
all the messages you send to the alias, you can set the binary option
.q metoo.
.ip \fBnosave\fP
Normally,
when you abort a message with two \s-2RUBOUTs\s0,
.i Mail
copies the partial letter to the file
.q dead.letter
in your home directory.  Setting the binary option
.q nosave
prevents this.
.ip \fBquiet\fP
The binary option
.q quiet
suppresses the printing of the version when
.i Mail
is first invoked,
as well as printing the for example
.q "Message 4:"
from the
.b type
command.
.ip \fBrecord\fP
If you love to keep records, then the
valued option
.q record
can be set to the name of a file to save your outgoing mail.
Each new message you send is appended to the end of the file.
.ip \fBscreen\fP
When
.i Mail
initially prints the message headers, it determines the number to
print by looking at the speed of your terminal.  The faster your
terminal, the more it prints.
The valued option
.q screen
overrides this calculation and
specifies how many message headers you want printed.
This number is also used for scrolling with the
.b z
command.
.ip \fBsendmail\fP
To alternate delivery system, set the
.q sendmail
option to the full pathname of the program to use.  Note:  this is not
for everyone!  Most people should use the default delivery system.
.ip \fBtoplines\fP
The valued option
.q toplines
defines the number of lines that the
.q top
command will print out instead of the default five lines.
