typedef union {
	long words[2];
	unsigned char bytes[8];
} block;

extern unsigned short ip_L0[],ip_L2[],ip_L4[],ip_L6[] ;
extern unsigned short ip_L8[],ip_La[],ip_Lc[],ip_Le[];
extern unsigned long ip_L1[],ip_L3[],ip_L5[],ip_L7[] ;
extern unsigned long ip_L9[],ip_Lb[],ip_Ld[],ip_Lf[];
extern unsigned short ip_H0[],ip_H2[],ip_H4[],ip_H6[] ;
extern unsigned short ip_H8[],ip_Ha[],ip_Hc[],ip_He[];
extern unsigned long ip_H1[],ip_H3[],ip_H5[],ip_H7[] ;
extern unsigned long ip_H9[],ip_Hb[],ip_Hd[],ip_Hf[];
extern unsigned long ipi_L0[],ipi_L2[],ipi_L4[],ipi_L6[] ;
extern unsigned long ipi_L8[],ipi_La[],ipi_Lc[],ipi_Le[];
extern unsigned long ipi_H1[],ipi_H3[],ipi_H5[],ipi_H7[] ;
extern unsigned long ipi_H9[],ipi_Hb[],ipi_Hd[],ipi_Hf[];
extern long SP0[],SP1[],SP2[],SP3[],SP4[],SP5[],SP6[],SP7[];
extern unsigned long E_L0[], E_L5[], E_L6[], E_L7[];
extern unsigned short E_L2[], E_L3[], E_L4[];
extern unsigned long E_H0[], E_H1[], E_H2[], E_H7[];
int shift[] = {1, 1, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 1};
long keys_L[16], keys_H[16];

des(in, out)
long in[2], out[2];
{
	register unsigned long low, high;
	register unsigned long temp;
	register i;
	register unsigned long right, left;

	temp = in[0];
	low  = ip_L0[temp & 0xf];
	high = ip_H0[temp & 0xf];
	temp >>= 4;
	low  |= ip_L1[temp & 0xf];
	high |= ip_H1[temp & 0xf];
	temp >>= 4;
	low  |= ip_L2[temp & 0xf];
	high |= ip_H2[temp & 0xf];
	temp >>= 4;
	low  |= ip_L3[temp & 0xf];
	high |= ip_H3[temp & 0xf];
	temp >>= 4;
	low  |= ip_L4[temp & 0xf];
	high |= ip_H4[temp & 0xf];
	temp >>= 4;
	low  |= ip_L5[temp & 0xf];
	high |= ip_H5[temp & 0xf];
	temp >>= 4;
	low  |= ip_L6[temp & 0xf];
	high |= ip_H6[temp & 0xf];
	temp >>= 4;
	low  |= ip_L7[temp & 0xf];
	high |= ip_H7[temp & 0xf];
	temp = in[1];
	low  |= ip_L8[temp & 0xf];
	high |= ip_H8[temp & 0xf];
	temp >>= 4;
	low  |= ip_L9[temp & 0xf];
	high |= ip_H9[temp & 0xf];
	temp >>= 4;
	low  |= ip_La[temp & 0xf];
	high |= ip_Ha[temp & 0xf];
	temp >>= 4;
	low  |= ip_Lb[temp & 0xf];
	high |= ip_Hb[temp & 0xf];
	temp >>= 4;
	low  |= ip_Lc[temp & 0xf];
	high |= ip_Hc[temp & 0xf];
	temp >>= 4;
	low  |= ip_Ld[temp & 0xf];
	high |= ip_Hd[temp & 0xf];
	temp >>= 4;
	low  |= ip_Le[temp & 0xf];
	high |= ip_He[temp & 0xf];
	temp >>= 4;
	low  |= ip_Lf[temp & 0xf];
	high |= ip_Hf[temp & 0xf];
	left = low;
	right = high;
	for (i = 0; i < 15; i++) {
		temp = right;
		low  = E_L0[temp & 0xf];
		high = E_H0[temp & 0xf];
		temp >>= 4;
		high |= E_H1[temp & 0xf];
		temp >>= 4;
		low  |= E_L2[temp & 0xf];
		high |= E_H2[temp & 0xf];
		temp >>= 4;
		low  |= E_L3[temp & 0xf];
		temp >>= 4;
		low  |= E_L4[temp & 0xf];
		temp >>= 4;
		low  |= E_L5[temp & 0xf];
		temp >>= 4;
		low  |= E_L6[temp & 0xf];
		temp >>= 4;
		low  |= E_L7[temp & 0xf];
		high |= E_H7[temp & 0xf];
		low ^= keys_L[i];
		high ^= keys_H[i];
		temp = SP0[(high >> 16) & 077];
		temp |= SP1[(high >> 22) & 077];
		temp |= SP2[((low & 03) << 4) | ((high >> 28) & 017)];
		temp |= SP3[(low >> 2) & 077];
		temp |= SP4[(low >> 8) & 077];
		temp |= SP5[(low >> 14) & 077];
		temp |= SP6[(low >> 20) & 077];
		temp |= SP7[(low >> 26) & 077];
		high = left;
		left = right;
		right = high ^ temp;
	}
	temp = right;
	low  = E_L0[temp & 0xf];
	high = E_H0[temp & 0xf];
	temp >>= 4;
	high |= E_H1[temp & 0xf];
	temp >>= 4;
	low  |= E_L2[temp & 0xf];
	high |= E_H2[temp & 0xf];
	temp >>= 4;
	low  |= E_L3[temp & 0xf];
	temp >>= 4;
	low  |= E_L4[temp & 0xf];
	temp >>= 4;
	low  |= E_L5[temp & 0xf];
	temp >>= 4;
	low  |= E_L6[temp & 0xf];
	temp >>= 4;
	low  |= E_L7[temp & 0xf];
	high |= E_H7[temp & 0xf];
	low ^= keys_L[i];
	high ^= keys_H[i];
	temp = SP0[(high >> 16) & 077];
	temp |= SP1[(high >> 22) & 077];
	temp |= SP2[((low & 03) << 4) | ((high >> 28) & 017)];
	temp |= SP3[(low >> 2) & 077];
	temp |= SP4[(low >> 8) & 077];
	temp |= SP5[(low >> 14) & 077];
	temp |= SP6[(low >> 20) & 077];
	temp |= SP7[(low >> 26) & 077];
	left ^= temp;
	temp = left;
	low  = ipi_L0[temp & 0xf];
	temp >>= 4;
	high = ipi_H1[temp & 0xf];
	temp >>= 4;
	low  |= ipi_L2[temp & 0xf];
	temp >>= 4;
	high |= ipi_H3[temp & 0xf];
	temp >>= 4;
	low  |= ipi_L4[temp & 0xf];
	temp >>= 4;
	high |= ipi_H5[temp & 0xf];
	temp >>= 4;
	low  |= ipi_L6[temp & 0xf];
	temp >>= 4;
	high |= ipi_H7[temp & 0xf];
	temp = right;
	low  |= ipi_L8[temp & 0xf];
	temp >>= 4;
	high |= ipi_H9[temp & 0xf];
	temp >>= 4;
	low  |= ipi_La[temp & 0xf];
	temp >>= 4;
	high |= ipi_Hb[temp & 0xf];
	temp >>= 4;
	low  |= ipi_Lc[temp & 0xf];
	temp >>= 4;
	high |= ipi_Hd[temp & 0xf];
	temp >>= 4;
	low  |= ipi_Le[temp & 0xf];
	temp >>= 4;
	high |= ipi_Hf[temp & 0xf];
	out[0] = low;
	out[1] = high;
}
