
# line 24 "gram.y"
#include "cfront.h"
#include "size.h"
#include "template.h"
#include <string.h>
// include tqueue.h after YYSTYPE is defined ...


struct parstate {
	Ptype intypedef;
	int   defercheck;
	Pname intag;
} pstate[BLMAX];
static int px;
static void
SAVE_STATE()
{
//error('d',"save_state: in_typedef%t in_tag%n defer_check %d",in_typedef,in_tag,defer_check);
	if ( px >= BLMAX ) error('i',"maximum scope depth exceeded");
	pstate[px].intypedef = in_typedef;
	in_typedef = 0;
	pstate[px].defercheck = defer_check;
	defer_check = 0;
	pstate[px].intag = in_tag;
	in_tag = 0;
	++px;
}
static void
RESTORE_STATE()
{
//error('d',"restore_state: in_typedef%t in_tag%n defer_check %d",in_typedef,in_tag,defer_check);
	if ( --px < 0 ) error('i',"scope stack underflow");
	in_typedef = pstate[px].intypedef;
	defer_check = pstate[px].defercheck;
	in_tag = pstate[px].intag;
//error('d',"            -> in_typedef%t in_tag%n defer_check %d",in_typedef,in_tag,defer_check);
}

#define copy_if_need_be(s)  ((templp->in_progress || templp->parameters_in_progress) ? strdup(s) : s) 
#define YYMAXDEPTH 600

#ifdef DBG
#ifndef YYDEBUG
#define YYDEBUG 1
#endif
#endif

static init_seen = 0;
static cdi = 0;
static Pnlist cd = 0, cd_vec[BLMAX];
static char stmt_seen = 0, stmt_vec[BLMAX];

//local class
static Plist tn_vec[BLMAX], lcl_tn_vec[BLMAX], lcl_blk_vec[BLMAX];
extern void local_restore();
extern void local_name();

//nested class
static Plist nested_tn_vec[BLMAX], nested_type_vec[BLMAX];
extern void nested_restore();

static Pname err_name = 0;

// fcts put into norm2.c just to get them out of gram.y
void sig_name(Pname);	
Ptype tok_to_type(TOK);
void memptrdcl(Pname, Pname, Ptype, Pname);

static Pptr doptr(TOK p, TOK t)
{
	Pptr r = new ptr(p,0);
	switch (t) {
	case CONST:
		r->b_const = 1;
               // if (p == RPTR) error('w',"redundant `const' after &");
		break;
	case VOLATILE:
		error('w',"\"volatile\" not implemented (ignored)");
		break;
	default:
		error("syntax error: *%k",t);
	}
	return r;
}

static Pbcl dobase(TOK pr, Pname n, TOK v = 0)
{
	Pbcl b = new basecl(0,0);

	if (pr == PROTECTED) {
		pr = PUBLIC;
		error("protectedBC");
	}
	b->ppp = pr;	// save protection indicator

	if (n) {
		if (n->base != TNAME) {
			error("BN%n not aTN",n);
			return 0;
		}

		Pbase bt = Pbase(n->tp);
		while (bt->base == TYPE) bt = Pbase(bt->b_name->tp);

		if (bt->base != COBJ) {
			error("BN%n not aCN",n);
			return 0;
		}

		if (v) {
			if (v != VIRTUAL) error("syntax error:%k inBCD",v);
			b->base = VIRTUAL;
		}
		else
			b->base = NAME;

		b->bclass = Pclass(bt->b_name->tp);
	}

	return b;
}


#define Ndata(a,b)	b->normalize(Pbase(a),0,0)
#define Ncast(a,b)	b->normalize(Pbase(a),0,1)
#define Nfct(a,b,c)	b->normalize(Pbase(a),Pblock(c),0)
#define Ncopy(n)	(n->base==TNAME)?new name(n->string):n

#define Finit(p)	Pfct(p)->f_init
#define Fargdcl(p,q,r)	Pfct(p)->argdcl(q,r)
#define Freturns(p)	Pfct(p)->returns
#define Vtype(v)	Pvec(v)->typ
#define Ptyp(p)		Pptr(p)->typ

		/* avoid redefinitions */
#undef EOFTOK
#undef ASM
#undef BREAK
#undef CASE
#undef CONTINUE
#undef DEFAULT
#undef DELETE
#undef DO
#undef ELSE
#undef ENUM
#undef FOR
#undef FORTRAN
#undef FRIEND
#undef GOTO
#undef IF
#undef NEW
#undef OPERATOR
#undef RETURN
#undef SIZEOF
#undef SWITCH
#undef THIS
#undef WHILE
#undef LP
#undef RP
#undef LB
#undef RB
#undef REF
#undef DOT
#undef NOT
#undef COMPL
#undef MUL
#undef AND
#undef PLUS
#undef MINUS
#undef ER
#undef OR
#undef ANDAND
#undef OROR
#undef QUEST
#undef COLON
#undef ASSIGN
#undef CM
#undef SM
#undef LC
#undef RC
#undef ID
#undef STRING
#undef ICON
#undef FCON
#undef CCON
#undef ZERO
#undef ASOP
#undef RELOP
#undef EQUOP
#undef DIVOP
#undef SHIFTOP
#undef ICOP
#undef TYPE
#undef TNAME
#undef EMPTY
#undef NO_ID
#undef NO_EXPR
#undef FDEF
#undef ELLIPSIS
#undef AGGR
#undef MEM
#undef MEMPTR
#undef PR
#undef TSCOPE
#undef DECL_MARKER
#undef REFMUL
#undef LDOUBLE
#undef LINKAGE
#undef LOCAL
#undef TEMPLATE

#undef XVIRT
#undef XNLIST
#undef XILINE
#undef XIA
#undef STATEMENT
#undef EXPRESSION
#undef SM_PARAM
#undef TEMPLATE_TEST
#undef PTNAME
#undef NEW_INIT_KLUDGE

# line 246 "gram.y"
typedef union  {
	char*	s;
	TOK	t;
	int	i;
	loc	l;
	Pname	pn;
	Ptype	pt;
	Pexpr	pe;
	Pstmt	ps;
	Pbase	pb;
	Pnlist	nl;
	Pslist	sl;
	Pelist	el;
	Pbcl	pbc;
	Pptr	pp;
	PP	p;	// fudge: pointer to all class node objects
	Plist	pl;
	toknode* q;	// token queue
} YYSTYPE;

# line 266 "gram.y"
#include "tqueue.h"
extern YYSTYPE yylval, yyval;
extern int yyparse();

// in_typedef should allow for nested in_typedef
extern int	declTag;	 // !1: inline, virtual mod permitted
int		in_sizeof = 0;
Ptype 		in_typedef = 0;  // catch redefinition of TNAME
Pname		in_tag = 0;      // handle complex typedefs: int (*)()
extern int	defer_check;	 // redefinition typedef check delay
Pname		curr_scope;

extern int 	must_be_id;	 // !0, TNAME => ID, i.e., int X
int	DECL_TYPE = 0; 	 // lalex() wants this set for global x(*fp)()
int	in_arg_list=0; 	 // !0 when parsing argument list
static int in_binit_list=0;
int	in_class_decl=0; // !0 when processing class definition
int	parsing_class_members=0; // !0 when parsing class def but not member function body
int	in_mem_fct=0;    // !0 when parsing member function definition

#define yylex lalex
#define NEXTTOK() ( (yychar==-1) ? (yychar=yylex(),yychar) : yychar )
#define EXPECT_ID() must_be_id = 1
#define NOT_EXPECT_ID() must_be_id = 0

Pname syn()
{
ll:
	switch (yyparse()) {
	case 0:		return 0;	// EOF
	case 1:		goto ll;	// no action needed
	default:	return yyval.pn;
	}
}

# define EOFTOK 0
# define ASM 1
# define AUTO 2
# define BREAK 3
# define CASE 4
# define CONTINUE 7
# define DEFAULT 8
# define DELETE 9
# define DO 10
# define ELSE 12
# define ENUM 13
# define FOR 16
# define FORTRAN 17
# define FRIEND 18
# define GOTO 19
# define IF 20
# define NEW 23
# define OPERATOR 24
# define RETURN 28
# define SIZEOF 30
# define SWITCH 33
# define THIS 34
# define WHILE 39
# define LP 40
# define RP 41
# define LB 42
# define RB 43
# define REF 44
# define DOT 45
# define NOT 46
# define COMPL 47
# define MUL 50
# define AND 52
# define PLUS 54
# define MINUS 55
# define LT 58
# define GT 60
# define ER 64
# define OR 65
# define ANDAND 66
# define OROR 67
# define QUEST 68
# define COLON 69
# define ASSIGN 70
# define CM 71
# define SM 72
# define LC 73
# define RC 74
# define ID 80
# define STRING 81
# define ICON 82
# define FCON 83
# define CCON 84
# define NAME 85
# define ZERO 86
# define ASOP 90
# define RELOP 91
# define EQUOP 92
# define DIVOP 93
# define SHIFTOP 94
# define ICOP 95
# define TYPE 97
# define TNAME 123
# define EMPTY 124
# define NO_ID 125
# define NO_EXPR 126
# define FDEF 127
# define ELLIPSIS 155
# define AGGR 156
# define MEM 160
# define MEMPTR 173
# define PR 175
# define TSCOPE 178
# define DECL_MARKER 179
# define REFMUL 180
# define LDOUBLE 181
# define LINKAGE 182
# define LOCAL 183
# define TEMPLATE 185
# define XVIRT 200
# define XNLIST 201
# define XILINE 202
# define XIA 203
# define STATEMENT 205
# define EXPRESSION 206
# define SM_PARAM 207
# define TEMPLATE_TEST 208
# define PTNAME 209
# define NEW_INIT_KLUDGE 210
# define XDELETED_NODE 211
# define DUMMY_LAST_NODE 212
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern short yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256

# line 2251 "gram.y"


static void
check_tag()
/*
        Allow the case of inline/virtual/overload as 
        modifiers of return type of form struct/class/union x foo() 
        SM, COLON, LC ==> real class declaration, not return type
*/
{
	switch ( NEXTTOK() ) {
	case SM: case COLON: case LC:
    		declTag = 1;
    		break;
	default:
    		declTag = 0;
    		break;
        }
}

static void
end_al( Plist mtn, int rst )
// unhide type names hidden by arg names
// mtn == saved modified_tn
{
	if ( rst == 0 ) {
		// not really an arg list, or we are entering a function def
		// merge modified_tn and don't restore
		if ( modified_tn == 0 ) modified_tn = mtn;
		else {
			for ( Plist l = modified_tn; l->l; l = l->l ) ;
			l->l = mtn;
		}
	} else {
		restore();
		modified_tn = mtn;
	}
}
static void
arg_redec( Pname fn )
{
	if ( fn==0 || fn->tp->base != FCT )
		error('i',"bad inline rewrite!");
	Pname al = Pfct(fn->tp)->argtype;
	Pname n = 0;
	for ( ;  al;  al = al->n_list ) {
		DB( if(Ydebug>=1)error('d',"arg_redec:  %n  %d",al,al->lex_level); );
		// nested function args should have lex_level >= 1
		if ( al->lex_level==1 && (n=ktbl->look(al->string,0)) )
			n->hide();
		else if ( al->lex_level>1 && (n=ktbl->look(al->string,LOCAL)) )
			n->hide();
		DB( if(Ydebug>=1)error('d',"   %n",n); );
	}
}


short yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
-1, 26,
	40, 58,
	42, 58,
	46, 58,
	-2, 63,
-1, 54,
	71, 46,
	72, 46,
	-2, 45,
-1, 72,
	155, 360,
	-2, 295,
-1, 77,
	13, 355,
	97, 355,
	123, 355,
	155, 355,
	156, 355,
	160, 355,
	178, 355,
	179, 355,
	182, 355,
	-2, 295,
-1, 131,
	73, 109,
	-2, 103,
-1, 328,
	40, 59,
	42, 59,
	46, 59,
	-2, 65,
-1, 359,
	60, 20,
	71, 20,
	-2, 120,
-1, 360,
	60, 19,
	71, 19,
	-2, 119,
-1, 415,
	1, 210,
	3, 210,
	4, 210,
	7, 210,
	8, 210,
	9, 210,
	10, 210,
	13, 210,
	16, 210,
	19, 210,
	20, 210,
	23, 210,
	24, 210,
	28, 210,
	30, 210,
	33, 210,
	34, 210,
	39, 210,
	40, 210,
	46, 210,
	47, 210,
	50, 210,
	52, 210,
	54, 210,
	55, 210,
	72, 210,
	73, 210,
	80, 210,
	81, 210,
	82, 210,
	83, 210,
	84, 210,
	85, 210,
	86, 210,
	95, 210,
	97, 210,
	123, 210,
	156, 210,
	160, 210,
	178, 210,
	179, 210,
	182, 210,
	185, 210,
	209, 210,
	-2, 0,
	};
# define YYNPROD 375
# define YYLAST 3383
short yyact[]={

 181, 532, 154, 558,  49, 525, 469,  69, 212,  16,
  70, 343, 184,   9, 190,  11, 156,  73, 344, 167,
 405, 362, 531,  10, 306, 240, 194, 210, 331, 234,
  76, 193, 311, 516, 541,  28,  17,  78, 318, 209,
 131, 165,  94, 208, 466, 328,  95, 233,  34,  83,
  35, 128,  60,  54, 218, 127, 127,  32, 128, 517,
  86,  89, 145, 314, 183,  12,  64, 151, 479,  76,
  93, 418, 407, 220, 129, 199,  78,  34, 185,  35,
  31, 196,  34, 138,  35, 309,  44, 126, 196,  50,
 125, 211, 201, 211, 180,  88, 302, 585,  76, 624,
 142, 570, 235, 500,  43,  78, 351, 363,  27, 444,
 413, 407, 415,  85, 256, 570, 341, 236, 309, 568,
 569,  34, 593,  35,  88,  59,  33,  20, 351,  88,
 506, 350,  39, 147, 148,  45, 213, 557, 450,  16,
 367, 368, 211, 224, 576, 211, 226, 315,  46,  82,
  84, 211, 243, 225, 185, 271,  83, 262, 576, 285,
 286, 287, 288, 289, 290, 291, 292, 293, 295,  44,
 515,  37, 282, 307, 308, 284, 296, 435,  34,  82,
  35, 294, 355, 283, 250, 237, 338,  43, 246, 337,
  82,  84, 304,  44, 252, 330, 227, 305, 365, 352,
  37, 501, 436, 286, 356,  37, 329,  45, 204, 329,
 247,  43,  81,  30, 249, 357, 333, 316,  45, 300,
 566,  60, 250, 301, 564, 216, 467, 329, 563,  80,
 553, 552,  60, 211, 309, 325,  45, 339, 231,  91,
 326,  45,  45, 144,  37, 143, 358, 361,  60,  92,
 206,  39, 370, 149, 372, 373, 374, 375, 376, 377,
 378, 379, 380, 381, 382, 383, 384, 385, 386, 387,
 388, 389, 366, 390, 334, 369, 349, 391, 396,  60,
  45, 256, 399, 354, 353, 254, 255,  80,  44, 215,
 638,  32, 393, 296,  59, 395, 402, 285, 371, 403,
  74,  37,  82, 394,  75,  59,  43, 550, 414, 520,
  71, 211,  74, 494,  31,  82,  75, 411, 412, 298,
 397,  59, 400, 196, 262,  82, 498,  74, 134, 424,
 211,  75,  60, 347, 327, 360, 423,  45,  30, 559,
 410, 408, 299, 422, 464, 409, 420, 205, 463, 432,
 438,  32,  59, 443, 417, 458,  82, 340, 457, 427,
 428, 433, 429, 419, 437, 439, 243,  38, 451, 431,
 324, 312, 238, 448,  31, 297,  39,  34,  39,  35,
 447, 442,  38, 446, 214,  38, 449,  74, 189, 587,
 561,  75,  34, 454,  35, 441,  66, 503,  38, 302,
 303,  65,  26, 232, 296,  59,  47,  62, 637, 275,
 455, 590,  30,  44, 474,  44, 629,  51,  83, 460,
  74,  83, 319, 459,  75, 275, 604, 461, 462, 565,
  90,  43, 602,  43, 133, 471, 601, 599, 424, 424,
 476, 477, 555, 132, 140, 423, 423, 554, 480, 141,
  39, 432, 473, 491, 489,  44, 492, 481,  44, 482,
 448, 485,  45, 472,  45, 586, 465, 447, 484, 150,
 274, 187, 434,  43,  26, 495,  43,  81, 497, 459,
 459, 187, 490, 336, 275, 502, 496,  44, 248, 251,
 416, 505,  26, 281,  26, 277, 510, 278, 280, 508,
  37, 504, 507, 445,  45,  43, 296,  45, 519, 513,
 239, 511, 523, 524, 497,  37, 514, 145, 521,  48,
 471, 549, 512,   8, 551,  60, 509,  16,   7, 556,
 522, 530,  26,  38, 342,  74,  45, 230, 560,  75,
 562, 478, 242,  26, 313, 187,  26, 187, 276, 483,
 588,  45,  26, 191, 486, 549, 549, 187, 591, 595,
 597,  16,  77, 425,  74, 530, 603, 195,  75,  26,
 549, 549, 549, 549, 549, 549, 549, 549, 549, 549,
 549, 549, 549, 549, 549, 549, 549, 549, 592, 122,
 625, 310, 596, 626, 598,  71, 600,  74,  59, 166,
 192,  75, 605, 606, 607, 608, 609, 610, 611, 612,
 613, 614, 615, 616, 617, 618, 619, 620, 621, 622,
 623, 526, 347, 518, 499, 146,  55,  30, 640, 222,
  53,  36, 642, 631,  26, 632, 633, 130, 635, 549,
  40, 645, 646, 359,  51, 175,  22,  36, 137, 650,
 649,  18, 347,   1,  36,  36, 468,  30,  38, 475,
  74,  52,  63, 641,  75,  39, 470,  32, 643,  63,
  63, 644,   2,   0,   0,  79,  24, 187,  52,   0,
 398,   0, 401,   0,   0, 652,  26,  52,  52,   0,
  31,   0,  24,  72,   0,  39,   0,   0,   0,  24,
  24, 140,  44,  23,   0,   0, 347,   0,   0, 178,
  19,  30,  26,   0,   0, 188, 187, 440, 198,   0,
  43,   0, 426,  85,   0, 188,  58,   0,  42, 298,
  72,  26,  44,  87,  19,  38, 198,  71, 198,  74,
   0,   0, 124,  75,   0,  34,   0,  35,   0,  39,
  43,  45, 299,  36,  32, 179,   0,   0,   0, 187,
   0,  36,  72,   0,   0,  72,  83,  67,  52,  68,
  38,   0,  42,   0,   0, 319, 229,  31,  36,   0,
  34,  45,  35,   0,   0, 297,  44, 198,   0, 188,
 198, 188,  88,  63,   0,   0, 198,  26,   0,  38,
   0, 188,   0,  44,  43,   0,  24,   0,   0,  34,
  21,  35,  25, 198,   0,  30,  36,   0,  39,   0,
 570,  43,  52,  24, 568, 569, 219,  36,  83,   0,
   0,  63, 217,   0,  36,  45,   0,   0,  39, 319,
  19,   0,  52,  36,  30,   0,   0,  26,   0,  63,
 335,   0,  45,  39,   0,  44,  57,  19,  52,   0,
 187,  24,  42, 576, 574,  44,   0,   0,  37,   0,
   0,  41, 321,  43,  36,  44,   0,  52, 198,  24,
   0,   0,  39,  43,  81,   0, 124,  52,  52,  52,
  44, 135,   0,  43,  29,  58, 187, 186,   0, 187,
 320,   0,   0,  37,  45,   0, 317,   0,  43,  51,
  51,   0,   0,  19,  45,  41, 332,   0,   0,  44,
  26, 188, 317, 219,  45,   0,  72,  36,   0,   0,
 198, 281,  37, 277,  39, 278, 280,  43,  61,  45,
   0, 348,  52, 176,  52,  52,  25, 364,   0,   0,
   0,  36, 335, 317,  26,   0, 198,   0,   0,   0,
 188,   0,   0, 335,   0,   0,  52, 136,  45,   0,
   0,  44,  39, 152, 135, 198,  71, 430,  74,  71,
 207,  74,  75, 134,   0,  75, 276, 155, 176,  43,
 135,  52,  52,   0, 164, 335, 321, 321, 173, 174,
 406,   0,  72, 188, 179,  41, 317,   0, 124,  44,
 161, 162,   0,   0, 157,   0, 158,  39, 160, 159,
  45,   0,   0,   0, 320, 320,   0,  43,  29,   0,
   0, 186,   0,  39, 347,   0, 332, 335, 335,  30,
   0, 198,  39,   0, 174, 171, 169, 170, 172,  30,
 168, 346,   0,   0,  44, 348, 348,   0,  45, 163,
   0, 177,  52,   0,   0,   0,   0,   0, 364,   0,
  44, 279,  43, 139,   0,   0,  36,  39,   0,  44,
   0,   0,  52,   0,  52,   0,  52,  39,  43, 133,
 570,  22,   0,   0, 568, 569,   0,  43, 579,   0,
 578, 256,   0,  45, 188, 254, 255,   0, 256,   0,
 406, 406, 254, 255,  44,   0, 264,   0, 265,  45,
  36,  24,   0,   0, 153,   0, 348,   0,  45, 345,
   0, 577,  43, 576, 574,  63,   0,   0,   0,   0,
 188,   0,  43, 188, 262, 260, 348,  52, 348, 263,
 348, 262, 260,  52,  52,  19,   0,   0,   0,   0,
   0,   0,   0,  45, 198,  24,  72,   0, 546,   0,
 542, 539,   0,  45, 543, 540, 547, 545,   0,   0,
  42,   0,   0, 535, 570,  72, 544, 533, 568, 569,
 155, 176, 579,   0, 578, 528,   0, 164, 198,  58,
 536, 173,   0,   0,   0,   0, 534, 179,   0,   0,
   0, 348,   0, 161, 162,   0,   0, 157,   0, 158,
   0, 160, 159,   0,   0, 577, 575, 576, 574,   0,
 118,   0,   0,   0,   0,   0,   0,   0,   0, 527,
 415,   0,   0,   0, 117,   0,   0, 537, 171, 169,
 170, 172,  30, 168,   0,   0,   0,   0,   0,   0,
   0, 110, 163, 111, 529, 119,   0, 112, 113,   0,
   0,  98,   0,  99,   0,  96,  97,   0,   0, 106,
   0, 107,   0,   0,   0, 101, 100, 108, 109,   0,
 538, 116, 120, 570,   0, 571,   0, 568, 569,  42,
   0, 579,   0, 578,   0,   0,  30, 573, 572, 580,
   0, 115, 105, 103, 104, 102, 114,   0, 123,   0,
   0,   0,   0,  41,   0,   0,   0, 548,   0,   0,
   0,   0,   0,   0, 577, 575, 576, 574,   0,   0,
   0,   0,   0,   0,  39,  43,  29, 152,   0, 186,
   0,  42,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 155, 176,  42,   0,   0,   0,   0, 164,   0,
   0,   0, 173,   0,   0,   0,  45,   0, 179,   0,
   0,  44,   0,  25, 161, 162,   0,   0, 157,   0,
 158,   0, 160, 159,   0,   0,   0,   0,   0,  43,
   0, 121,   0,   0,   0,   0,   0,   0,   0,  39,
   0, 182,   0, 152,   0,   0,   0,  42, 174, 171,
 169, 170, 172,  30, 168,   0,   0, 155, 176,   0,
  45,   0,   0, 163, 164, 197,   0,   0, 173,   0,
   0,   0, 241,   0, 179,   0,  44,  25,   0,   0,
 161, 162,   0,   0, 157,   0, 158,   0, 160, 159,
   0,  39,   0,   0,  43,  29,   0,   0, 186,   0,
 570,   0, 571,  39, 568, 569,   0,   0, 579,   0,
 578,   0,   0,   0, 174, 171, 169, 170, 172,  30,
 168, 244, 245,   0,  41,  45,   0,   0, 153, 163,
   0, 197,   0,   0,   0, 421,  41,   0,   0,   0,
  44, 577, 575, 576, 574,   0,  43,  29,   0,   0,
 186,   0,   0,   0, 152,   0,   0,  39,  43,  29,
   0,   0, 186,   0,   0,   0, 256,   0, 155, 176,
 254, 255,   0,   0, 264, 164, 265,  45,   0, 173,
   0,   0,   0,   0,   0, 179,   0,   0,   0,  45,
  41, 161, 162,   0, 153, 157,   0, 158,   0, 160,
 159,   0,   0,   0,   0,   0,   0, 263, 261, 262,
 260,   0,  43,  29,   0,   0, 186,   0, 182,   0,
 547,   0,   0,   0,   0, 174, 171, 169, 170, 172,
  30, 168,   0,   0, 155, 176,   0,   0,   0,   0,
 163, 164, 177,  45,   0, 173,   0,   0,   0,   0,
   0, 179,   0, 155, 176,   0,   0, 161, 162,   0,
 164, 157,   0, 158, 173, 160, 159,   0,  39,   0,
 179,   0, 627,   0,   0,   0, 161, 162,   0,   0,
 157,   0, 158,   0, 160, 159,   0,   0,   0,   0,
   0, 174, 171, 169, 170, 172,  30, 168,   0,   0,
   0,   0,   0,   0,   0, 153, 163,   0, 177,   0,
 174, 171, 169, 170, 172,  30, 168,   0,   0, 155,
 176,   0,   0,  43,   0, 163, 164, 177,   0,   0,
 173,   0,   0,   0,  39,   0, 179,   0, 589,   0,
   0,   0, 161, 162,   0,   0, 157,   0, 158,   0,
 160, 159,   0,  39,  45,   0,   0,   0, 256,   0,
 257,   0, 254, 255,   0,   0, 264,   0, 265,   0,
   0, 548, 259, 258, 266,   0, 174, 171, 169, 170,
 172,  30, 168,   0,   0,   0,   0,   0,   0,  43,
 273, 163,   0, 177,   0,   0,   0,   0,   0, 263,
 261, 262, 260,   0, 155, 176,   0,   0,  43,   0,
   0, 164,   0,   0,   0, 173,   0,   0,   0,  39,
  45, 179,   0, 392,   0,   0,   0, 161, 162,   0,
   0, 157,   0, 158,   0, 160, 159,   0,   0,  45,
 570,   0, 571,   0, 568, 569,   0,   0, 579,   0,
 578,   0,   0,   0, 573, 572, 273,   0,   0,   0,
   0, 174, 171, 169, 170, 172,  30, 168, 155, 176,
   0,   0,   0,   0,  43, 164, 163,   0, 177, 173,
   0, 577, 575, 576, 574, 179,   0, 272,   0,   0,
   0, 161, 162,   0,   0, 157,   0, 158,   0, 160,
 159,   0,   0,   0,  39,  45,   0,   0,   0, 256,
   0, 257,   0, 254, 255,   0,   0, 264,   0, 265,
   0,   0,   0, 259, 258, 174, 171, 169, 170, 172,
  30, 168,   0,   0,   0,   0,   0,   0, 155, 176,
 163, 273, 177,   0,   0, 164,   0,   0,   0, 173,
 263, 261, 262, 260,   0, 179,   0,   0,   0,  43,
   0, 161, 162,   0,   0, 157,   0, 158,  39, 160,
 159,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  45,   0,   0,   0,   0, 174, 171, 169, 170, 172,
  30, 168, 155, 176,   0, 273,   0,   0,   0, 164,
 163,   0, 177, 173,   0,   0,  42,   0,   0, 179,
   0,   0,   0,  43,   0, 161, 162,   0,   0, 157,
   0, 158,   0, 160, 159,   0,   0,   0,  39,   0,
   0,   0,   0, 407,   0,   0,   0,   0,   0,   0,
   0,   0,   0,  34,  45,  35,   0,   0, 152, 323,
 171, 169, 170, 172,  30, 168,   0,   0,   4,  13,
   0,   0, 155, 176, 163, 273, 177,   0,   0, 164,
   0,  42,   0, 173,   0,   0,   0,   0,  30, 179,
 202,   0,  32,  43,   0, 161, 162,   0,   0, 200,
  57, 158,  39, 160, 159,   0,   0,   0,  38,   0,
   0,   0,   0,   0,   0,  31,   0,   0,  34,   0,
  35,   0, 182,   0,  45,   0,  39,   0,   0, 174,
 171, 169, 170, 172,  30, 168,   0,   0,   0, 273,
   3,   0,   6,   0, 163, 155, 176,   0,  21,   0,
   0,   0, 164,  30,   0,   0, 173,  43,   0,  41,
  42,   0, 179,  44,   0,  25,   0,   0, 161, 162,
   0,  32,   0,   0,   0,   0,  37,   0,   0,   0,
   0,  43,  61,   0,   0,   0,   0,  38,  45,   0,
   0,  39,   0,   0,  31,   0,   0,  34,   0,  35,
   0,   0, 174, 171, 169, 170, 172,  30, 168,   0,
   0,   0,  45,   0,   0,   0,   0, 163,   0, 177,
   0, 221, 203,   0,  41,  42,   0,  21,  44,   0,
   0,   0,  30,   0,   0,   0,  32,   0,   0,   0,
   0,  37,   0,   0,  25,  39,  43,  29,   0,  42,
   5,   0,  38,  14,   0,   0,   0,   0,  45,  31,
   0,   0,  34,   0,  35,   0,   0,   0,   0,   0,
  39,   0,   0,   0,   0,   0,  15,  45,   0,   0,
   0,   0, 273,   0,   0,   0,  34,   0,  35,   0,
   0,   0,  21,   0,   0,   0,   0,  30,   0,   0,
  43,   0,   0,  41,   0,   0,   0,  44,   0,  25,
   0,   0,   0,   0,   0,   0, 363,   0,   0,   0,
  37,  30, 228,   0,   0,  43,  29,   0,  42, 186,
   0,  45, 223,  57,   0,  39,  42,   0,   0,  32,
   0,   0,   0,   0,  42,   0,   0,  32,   0,   0,
   0,   0,   0,   0,   0,  38,  45,   0,   0,  39,
   0,   0,  31,  38,   0,  34,   0,  35,  41,   0,
  31,   0,  44,  34,   0,  35,   0,   0,   0,   0,
   0,  34,   0,  35,  66,  37,   0,  56,   0,   0,
  43,  29,  41,   0, 186,  62,  44,   0,   0,   0,
  30,   0,   0,  21,   0,   0,   0,  32,  30,  37,
   0,   0,  57,   0,  43,  61,  30, 487, 488,   0,
  57,  45,   0,  38,   0,   0,   0,   0,  57,   0,
  31,   0,   0,  34,   0,  35,   0,   0,  39,   0,
   0,   0,   0,   0,   0,  45,  39,   0,   0,   0,
   0,   0,   0,   0,  39,   0, 570,   0, 571,   0,
 568, 569,   0,  21, 579,   0, 578,   0,  30,   0,
 573,  41,   0,   0,   0,  44,   0,   0,   0,  41,
  88,   0,   0,  44,   0,   0,   0,  41,  37,   0,
   0,  44,   0,  43,  61,   0,  37, 577, 575, 576,
 574,  43,  61,   0,  37,   0,  39,   0,   0,  43,
  61,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0, 651,   0,  45,   0,   0,   0,   0,   0,
   0, 256,  45, 257,   0, 254, 255,   0,   0, 264,
  45, 265,   0,  44,   0, 259, 258, 266, 267, 270,
   0, 253, 269,   0,   0,   0,  37,   0,   0,   0,
   0,  43,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 268, 263, 261, 262, 260,   0,   0,   0, 256,
   0, 257,   0, 254, 255,   0,   0, 264,   0, 265,
   0,   0,  45, 259, 258, 266, 267, 270,   0, 253,
 269, 648,   0,   0,   0, 256,   0, 257,   0, 254,
 255,   0,   0, 264,   0, 265,   0, 647,   0, 268,
 263, 261, 262, 260, 256,   0, 257,   0, 254, 255,
   0,   0, 264,   0, 265,   0,   0,   0, 259, 258,
 266, 267, 270,   0, 253, 269, 263, 261, 262, 260,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0, 639,   0, 268, 263, 261, 262, 260, 256,
   0, 257,   0, 254, 255,   0,   0, 264,   0, 265,
   0,   0,   0, 259, 258, 266, 267, 270,   0, 253,
 269,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0, 268,
 263, 261, 262, 260, 570,   0, 571,   0, 568, 569,
   0,   0, 579,   0, 578,   0,   0,   0, 573, 572,
 580, 581, 584, 636, 567, 583,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0, 582, 577, 575, 576, 574, 256,
   0, 257,   0, 254, 255,   0,   0, 264,   0, 265,
   0,   0,   0, 259, 258, 266, 267, 270, 634, 253,
 269,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0, 630,   0,   0,   0, 268,
 263, 261, 262, 260, 256,   0, 257,   0, 254, 255,
   0,   0, 264,   0, 265,   0,   0,   0, 259, 258,
 266, 267, 270,   0, 253, 269,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0, 268, 263, 261, 262, 260, 570,
   0, 571,   0, 568, 569,   0,   0, 579,   0, 578,
   0,   0,   0, 573, 572, 580, 581, 584,   0, 567,
 583, 628,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0, 582,
 577, 575, 576, 574, 256,   0, 257,   0, 254, 255,
   0,   0, 264,   0, 265,   0,   0,   0, 259, 258,
 266, 267, 270,   0, 253, 269, 594,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0, 493,   0, 268, 263, 261, 262, 260, 256,
   0, 257,   0, 254, 255,   0,   0, 264,   0, 265,
   0,   0,   0, 259, 258, 266, 267, 270,   0, 253,
 269,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0, 456,   0, 268,
 263, 261, 262, 260, 256,   0, 257,   0, 254, 255,
   0,   0, 264,   0, 265,   0,   0,   0, 259, 258,
 266, 267, 270,   0, 253, 269,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0, 453,   0, 268, 263, 261, 262, 260, 256,
   0, 257,   0, 254, 255,   0,   0, 264,   0, 265,
   0,   0,   0, 259, 258, 266, 267, 270,   0, 253,
 269,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0, 268,
 263, 261, 262, 260, 256,   0, 257,   0, 254, 255,
   0,   0, 264,   0, 265,   0,   0,   0, 259, 258,
 266, 267, 270, 452, 253, 269,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 404,   0,   0,   0, 268, 263, 261, 262, 260, 256,
   0, 257,   0, 254, 255,   0,   0, 264,   0, 265,
   0,   0,   0, 259, 258, 266, 267, 270,   0, 253,
 269,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0, 322,   0, 268,
 263, 261, 262, 260, 256,   0, 257,   0, 254, 255,
   0,   0, 264,   0, 265,   0,   0,   0, 259, 258,
 266, 267, 270,   0, 253, 269,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0, 268, 263, 261, 262, 260, 570,
   0, 571,   0, 568, 569,   0,   0, 579,   0, 578,
   0,   0,   0, 573, 572, 580, 581, 584,   0, 567,
 583,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0, 582,
 577, 575, 576, 574, 570,   0, 571,   0, 568, 569,
   0,   0, 579,   0, 578,   0,   0,   0, 573, 572,
 580, 581, 584, 256, 567, 257,   0, 254, 255,   0,
   0, 264,   0, 265,   0,   0,   0, 259, 258, 266,
 267, 270,   0, 253, 582, 577, 575, 576, 574,   0,
   0,   0,   0,   0, 256,   0, 257,   0, 254, 255,
   0,   0, 264, 268, 263, 261, 262, 260, 259, 258,
 266, 267, 270, 570, 253, 571,   0, 568, 569,   0,
   0, 579,   0, 578,   0,   0,   0, 573, 572, 580,
 581, 584,   0,   0, 268, 263, 261, 262, 260, 256,
   0, 257,   0, 254, 255,   0,   0, 264,   0, 265,
   0,   0,   0, 259, 577, 575, 576, 574, 256,   0,
 257,   0, 254, 255,   0,   0, 264,   0, 265,   0,
   0,   0, 259, 258, 266, 267, 270,   0,   0,   0,
 263, 261, 262, 260,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0, 263,
 261, 262, 260 };
short yypact[]={

2038,-1000,-1000,-1000,-1000,  75,-1000,-1000,-1000,-1000,
-1000,-1000,-1000, 366,-1000,   9,2285, 697,-1000, 522,
-1000, 242,  33,2353, 730,-1000, 181,-1000,-1000,-1000,
 191, -53,1221,-1000,  -7, -10,-122, -23,-1000,-1000,
-1000, 910, 894,-1000,-1000, 181,-1000,  19, 187, 185,
-1000,-1000, -74,-123, 555,  62,-1000,-1000, 522,-1000,
-1000,-1000, 184, 643,-1000, 181, 964,1515,-1000, 849,
-1000, 347,1338,-1000, 964,-1000,-1000,2019,-1000, 849,
 267,-1000,-1000,-1000,-1000, 205, 270, 522,-1000, 939,
1404,-1000,1404,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
 343, 246,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000, 128,-1000,-1000,-1000,-1000,-1000, -24,-1000,
2117, 169, 181,-1000,-1000,-1000,  22,  44,-1000,-1000,
-1000,1404, 331,1286,1404, 849,-1000, 327,-1000,-1000,
1404,3193,1815, 461, 891, 715,1885,1885,1885,1885,
1885,1885,1885,1885,1885,-1000,-1000,1404,-1000,-1000,
-1000,-1000,-1000,-1000,-1000, 295,1221, 359, 360,-1000,
 120,3193,1515,  49,-1000,2285,-1000, 181, 298,-1000,
 330,  -8, 146,-1000,-1000,-1000, 759, 359, 705,3084,
1949, 329,-1000, 730,-1000,-1000, 267,-1000, 135,-1000,
-1000,3224,2301, 156,-1000,-1000,-1000,-1000,-1000,  -2,
-1000,-1000,-1000,-1000,-1000, 117, 114,-1000, 168,  33,
  43, 954,1404,  57,-1000, 129,  22, 135, 110, 144,
-1000, 255,   9,2206,-1000,-1000, 138,  16,1515,-1000,
 555, 964, 135, 964, 964, 964, 964, 964, 964, 964,
 964, 964, 964, 964, 964, 964, 964, 964, 964, 964,
 964, 891, 964, 386,1751, 715,-1000, 964, 919,1885,
 919,1515,-1000,-1000,1338, 453, 891, 891, 891, 891,
 453, 453, 453, 453,2092,3039,1973,-1000,1221, 811,
-1000,-1000,1515,1515,-1000,  36,  39,-1000,-1000,-1000,
1404, -26,-1000, 322,1350,-1000,1515,-1000, 493,-1000,
 695, 342,-1000, 321,-1000, -26, 936,-1000,-1000,1404,
-1000, 258,  -2,-1000,-1000,-115,-1000,-1000,-1000,-1000,
 105,-1000, 131,-1000,-1000, 253, 542,-1000,-1000, 135,
-1000,  22, 964,  35,-1000,-1000,-1000,1286,-1000, 181,
-1000,-1000, 345,-1000,  27,  66,  39,-1000,-1000,-1000,
3193,-1000,3193,  64,  64,-1000,1486,3269,2525, 231,
1058,-1000,1051,1051,1051,1829,1678,3193,3193,2994,
2949, 891, 964,-1000,-1000,1338,2904,-1000,-1000, 453,
-1000,-1000, 317, 314,-1000, 378,  32,  71,-1000,-1000,
-1000, 307, 303,-1000,-1000, -30, 626, 135,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000, 345, 618, 358,
 358,-1000,-1000, 258, -59,-1000, 954,-1000, 572,-1000,
 572,-1000,-1000,3193,-1000,2182,-1000,-1000,-1000, 345,
-1000,-1000, 964,1885,2859, 272,-1000,-1000, 715,-1000,
-1000, 258, 285,-1000,-1000,-1000,-1000,  29, 130,-1000,
1515, 357,-1000, -26,1515,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,  58,-1000,-1000,2293,
 270,3288, 891,1885, 715,-1000,-1000, 849, 345, -15,
-1000, 626, 268,1515,-1000, 165,-1000,   9,   9, 270,
 891,-1000,-1000,-1000,-1000,-1000,-1000,-1000,1167,-1000,
-1000, 266,  39, 162, 161,-1000,-1000,-1000, 964,  56,
-1000,-1000,-1000, 299, 299, 350, 299, 159, 155,-1000,
 151,3129,-1000,-1000,  17,-1000, 349,1666, 402, 891,
-1000,-1000,1167,1581,-1000,  50,2814,  39,-1000, 964,
-1000,-1000,-1000,-1000,-1000, 964,-1000,1581,1581,1581,
1581,1581,1581,1581,1581,1581,1581,1581,1581,1581,
1581,1581,1581,1581,1581,-1000,-1000,  18, 891, 964,
1600,-1000,2769,-1000,-1000,-1000, 404,2724,-1000,-1000,
-1000,-1000,-1000,2679,-1000,3174,  51,  51,-1000,1134,
2376,1420,  65,1040,-1000, 770, 770, 770,1760,1243,
3174,3174,2634, 369, 249,2589, 891, 964,-1000,-1000,
-1000, 964,-1000,-1000,-1000,-1000,1581, 299,-1000,1885,
2544,-1000,2499,-1000,3243,-1000, 891,1885, 964, 891,
2451,-1000,-1000 };
short yypgo[]={

   0, 672,  65,  15,  22,   7,  24, 656,   6,  12,
 653,  17, 703,   8, 651,  35,  47,  29,  40,  18,
 648, 640, 108, 637, 629,  66, 626, 127,  36,  26,
 624,  33, 623,   1,   5, 621, 600,  14,   0,  34,
   2,  41, 599,  20,  16,  54,  46, 589,  38,  21,
  31, 567,  10, 553,  28,  27,   3, 126, 645, 401,
 709, 630, 549,  42, 544, 542, 541,   4, 537, 534,
  11,  32, 675,  39,  43, 528, 523, 519, 510, 503,
 502, 499,  64, 491, 490, 489, 488, 403,  45,  25,
 483, 472, 466, 465, 447, 442, 437, 436, 432, 429,
 426,  19, 414 };
short yyr1[]={

   0,  10,  10,  10,  10,  10,  10,  10,  76,  77,
  79,  75,  62,  62,  62,  80,  62,  81,  62,  67,
  67,   1,   1,   1,   1,   1,   2,   2,   4,   4,
   4,   3,   3,   3,  83,  66,  82,  84,   6,   6,
   7,   7,   8,   8,   5,   5,  25,  85,  25,  25,
  86,  25,  26,  26,   9,   9,  87,  88,  60,  60,
  60,  14,  14,  14,  14,  14,  14,  14,  14,  13,
  13,  13,  13,  13,  13,  74,  74,  73,  73,  20,
  20,  15,  15,  15,  16,  16,  78,  78,  78,  65,
  65,  89,  89,  89,  49,  49,  49,  49,  17,  17,
  17,  90,  22,  22,  22,  22,  91,  91,  68,  68,
  69,  69,  70,  70,  70,  70,  70,  21,  21,  18,
  18,  19,  19,  23,  23,  23,  24,  24,  24,  24,
  24,  24,  24,  24,  27,  27,  27,  27,  63,  63,
  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,
  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,
  63,  63,  63,  63,  58,  58,  59,  59,  71,  71,
  28,  28,  28,  28,  28,  28,  28,  28,  28,  28,
  28,  28,  28,  28,  28,  28,  28,  48,  48,  48,
  48,  48,  48,  48,  54,  54,  54,  43,  43,  43,
  43,  43,  45,  45,  30,  30,  30,  31,  32,  56,
  92,  33,  33,  33,  35,  35,  35,  35,  93,  35,
  35,  95,  94,  34,  34,  34,  34,  34,  34,  34,
  34,  34,  34,  96,  34,  34,  97,  34,  98,  34,
  99,  34, 100,  34,  37,  36,  36,  29,  29,  39,
  39,  39,  39,  39,  39,  39,  39,  39,  39,  39,
  39,  39,  39,  39,  39,  39,  39,  39,  39,  39,
  39,  39,  38,  38,  38,  38,  38,  38,  38,  38,
  38,  38,  38,  38,  38,  38,  38,  38,  38,  38,
  38,  38,  38,  38,  38,  38,  40,  40,  40,  40,
  40,  40,  40,  40,  40,  40,  40,  40,  40,  40,
  40,  40,  40,  40,  40,  40,  40,  40,  40,  40,
  40,  40,  40,  40,  40,  40,  42,  42,  42,  42,
  42,  42,  42,  61,  57,  57,  57,  41,  41,  41,
  41,  41,  41,  41,  44, 101,  47,  47,  47,  47,
  46,  55,  51, 102,  51,  72,  52,  53,  53,  50,
  50,  64,  64,  64,  12,  12,  12,  12,  12,  12,
  12,  12,  12,  11,  11 };
short yyr2[]={

   0,   1,   1,   1,   2,   1,   1,   1,   6,   0,
   0,   7,   1,   1,   2,   0,   5,   0,   6,   1,
   1,   1,   1,   1,   1,   5,   4,   2,   6,   5,
   5,   5,   4,   4,   0,   4,   0,   0,   3,   0,
   1,   3,   3,   4,   2,   0,   1,   0,   4,   2,
   0,   4,   1,   3,   3,   2,   1,   1,   1,   4,
   4,   1,   1,   1,   2,   4,   1,   1,   1,   1,
   2,   2,   2,   2,   2,   3,   1,   1,   1,   1,
   1,   4,   5,   2,   1,   3,   3,   1,   0,   1,
   1,   2,   2,   2,   1,   2,   2,   2,   1,   3,
   0,   0,   5,   2,   5,   2,   0,   2,   2,   0,
   1,   3,   1,   2,   2,   3,   3,   2,   4,   1,
   1,   1,   1,   2,   0,   2,   1,   2,   2,   1,
   1,   1,   2,   3,   1,   2,   2,   2,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   2,   2,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   2,   2,   1,   0,   2,
   2,   4,   2,   4,   6,   4,   4,   6,   1,   3,
   2,   4,   2,   2,   2,   2,   3,   1,   2,   0,
   2,   2,   2,   3,   0,   2,   2,   0,   2,   2,
   4,   4,   0,   2,   0,   2,   2,   2,   0,   3,
   0,   4,   2,   3,   1,   1,   1,   2,   0,   5,
   4,   0,   2,   2,   1,   3,   3,   1,   1,   1,
   3,   5,   3,   0,   9,   3,   0,   4,   0,   4,
   0,   5,   0,   4,   1,   1,   3,   1,   3,   3,
   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
   3,   3,   3,   3,   3,   3,   5,   2,   5,   3,
   6,   1,   3,   3,   3,   3,   3,   3,   3,   3,
   3,   3,   3,   3,   3,   3,   3,   3,   3,   5,
   2,   5,   3,   6,   1,   0,   2,   2,   3,   3,
   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
   2,   4,   3,   3,   3,   3,   3,   1,   1,   3,
   1,   1,   1,   1,   1,   1,   4,   4,   5,   5,
   6,   6,   4,   4,   1,   1,   2,   1,   2,   2,
   3,   2,   3,   3,   4,   1,   1,   1,   2,   2,
   2,   2,   2,   0,   5,   1,   5,   3,   1,   1,
   0,   0,   1,   2,   1,   1,   2,   2,   2,   2,
   1,   3,   2,   3,   1 };
short yychk[]={

-1000, -10,  -1,  72,   0, 182,  74, -75, -76,  -9,
  -4,  -3,  -2,   1, 185, 208, -13, -28, -14, -60,
 -27,  80, -58, -12, -72,  97, -59, -22, -15, 179,
  85,  47,  24, -57,  50,  52, -61, 173,  40, 123,
 -21, 156,  13, 178, 160, 209,  73,  40, -77, -67,
  80, -59, -58, -61, -28, -26,  72,  97, -60, -22,
 -15, 179,  80, -58, -25, -59,  69,  70,  72,  -5,
 -52,  40, -72, -11,  42,  46, -52,  40, -11, -72,
  45, 179, -57, 123, -27,  80, -28, -60,  97, -28,
 -87,  58,  58, 123, -63, -46,  54,  55,  50,  52,
  65,  64,  94,  92,  93,  91,  58,  60,  66,  67,
  40,  42,  46,  47,  95,  90,  70,  23,   9,  44,
  71, 180, -47,  97, -60,  97,  97, 178, 173,  97,
 -23, -18, -59, 179,  73,  80,  73, -20, -18, 179,
 -59, -87,  81,  58,  58,  -5,  70,  71,  72,  69,
 -87, -38,   9, 160, -40,  23, -44,  50,  52,  55,
  54,  46,  47,  95,  30, -41, -42,-101,  86,  82,
  83,  81,  84,  34,  80, -58,  24,  97, -60,  40,
 -29, -38,  73, -82,  -9, -13, 182, -59, -58,  41,
 -37, -53, -36, -50, -29, -51, -13,  97, -58, -38,
  50, -37,  41, 173, -27,  80,  45,  41, -74, -73,
 -55, -38, -13, -74,  41,  43,  97, -60, -45, -12,
  97,  74, -24, 185,  -9,  -4,  -3,  -2, 175, -58,
 -68,  69, -87, -16, -17,  80,  73, -74,  41, -78,
 -89, 156, -65, -13, 205, 206, -74, -82, -86, -25,
 -28, -85, -74,  70,  54,  55,  50,  52,  65,  64,
  94,  92,  93,  91,  58,  60,  66,  67,  90,  71,
  68, -40,  42, 160,   9,  23,  95,  42,  44, 180,
  45,  40, -44, -55,-101, -40, -40, -40, -40, -40,
 -40, -40, -40, -40, -44, -38, -13,  80,  24,  47,
 -63, -46,  40,  40,  72, -37,  -6, 124, 125,  69,
 -87, -71,  41, -64,  71, 155,  71, -60, -48,  80,
 -12, -72,  43,  80,  41, -71, -28, -27, -88,  71,
  60, -54, -12,  60, -45, -61, -90,  72,  72,  69,
 -27,  73, -69, -70, -19, 175,  97,  80, -60, -74,
  74,  71,  70, -16, -88,  72,  60,  71, -67, -59,
  80, -67, -49,  80, -12,  60,  -6, 124, 125, -29,
 -38, -88, -38, -38, -38, -38, -38, -38, -38, -38,
 -38, -38, -38, -38, -38, -38, -38, -38, -38, -38,
 -38, -40,  42, -44, -55,-101, -38, -41, -59, -40,
 -41, -59, -37, -37,  41, -43, -12,  40, -63, -46,
 -18, -37, -37,  74, -33,  73, -84, -74,  97,  41,
 -50, 155, -29, -11, -52,  70, -59, -48, -48,  41,
  41, -73, -11, -54, -91,  72,  71, -19,  97, -19,
 175, -88, -17, -38,  74, -79, -89, -11, -52, -49,
  72, -33,  69,  43, -38, -37,  43,  41,  41, -11,
  41, -43, -43,  41,  41, -92,  74, 256,  -7,  -8,
  40, -19, -88, -71,-102,  41, -52, -52, -66, 127,
 -70, -19, -19, -62,  -4,  -3, -22, 205, 206, -13,
 -28, -38, -40,  43,  41, -44, -55,-101,  41, -30,
  74,  71, -37,  40, -29, -83,  72, -80, -81, -28,
 -40, -44, -55, -52, -11, 185, -31,  74, -32,  -8,
  41, -37,  -6, -67, -67, -34, -35,  72,  28,  97,
  -9,  -4, -33,  20,  39,  16,  33,  80, 123,   4,
   8, -39,   3,   7,  19,  10,   1,   9, 160, -40,
  41, -33,  69,  69, -94, -95, -38,  81, -56,  40,
 -56,  40, -56,  69,  69, -99,  69,  70,  54,  55,
  50,  52,  65,  64,  94,  92,  93,  91,  60,  58,
  66,  67,  90,  71,  68,  80, -93,  40, -40,  42,
   9, -34, -39,  72,  72, -33, -31, -38, -31, -96,
 -31, -97, -98, -38,-100, -39, -39, -39, -39, -39,
 -39, -39, -39, -39, -39, -39, -39, -39, -39, -39,
 -39, -39, -39, -31,  81, -38, -40,  42,  72,  12,
  41, -31, -31, -31,  69, -31,  69,  39,  41,  43,
 -38, -31, -38, -31, -39, -56, -40,  43,  72, -40,
 -38,  41, -31 };
short yydef[]={

   0,  -2,   1,   2,   3,  62,   5,   6,   7,  21,
  22,  23,  24,   0,   9,   0,   0,  45,  69,   0,
 178, 134,   0,   0,   0,  61,  -2,  66,  67,  68,
   0,   0,   0, 164, 364, 365,   0, 370, 355, 167,
 124,   0,   0, 334, 335,   0,   4,   0,   0,   0,
  19,  20,   0,   0,  -2,   0,  55,  70,  71,  72,
  73,  74, 134,   0,  52,  58, 295, 295,  27,  36,
 170, 355,  -2, 185, 295, 374, 172,  -2, 184, 360,
   0,  64, 165, 166, 180, 134, 182, 183, 367,   0,
 295,  56, 295, 135, 136, 137, 138, 139, 140, 141,
 142, 143, 144, 145, 146, 147, 148, 149, 150, 151,
   0,   0, 154, 155, 156, 157, 158, 159, 160, 161,
 162, 163, 202, 346, 347, 366, 368, 336, 369, 372,
   0,  -2, 120, 105, 117, 119, 100,  83,  79,  80,
 120, 295,   0,  88, 295,  36,  50,   0,  54,  47,
 295,  49,   0, 335, 294,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0, 317, 318, 295, 320, 321,
 322, 323, 324, 325, 337,   0,   0,   0,   0, 345,
   0, 247, 295,  39,  44,   0,  62,  63,   0, 168,
   0, 361, 244, 358, 245, 359, 189,  61,   0,   0,
   0,   0, 168,   0, 179, 134,   0, 186,   0,  76,
  77,  78, 194,   0, 152, 153, 348, 349, 350, 202,
 371, 101, 123, 125, 126, 130, 129, 131,   0,   0,
   0,   0, 295,   0,  84,  98, 100,   0,   0,   0,
  87,   0,   0,   0,  89,  90,   0,  39, 295,  53,
  46, 295,   0, 295, 295, 295, 295, 295, 295, 295,
 295, 295, 295, 295, 295, 295, 295, 295, 295, 295,
 295, 290, 295, 335,   0,   0, 300, 295,   0,   0,
   0, 295, 296, 297, 295, 301, 302, 303, 304, 305,
 306, 307, 308, 309, 310,   0, 197, 338,   0,   0,
 339, 341, 295, 295,  26,   0,   0,  32,  33,  37,
 295, 171, 173,   0, 360, 362, 295,  71, 352, 187,
 189, 189, 373, 337, 175, 176,   0, 181,  -2, 295,
  57, 351, 194,  60, 203,   0, 106, 127, 128, 132,
 180, 118, 108, 110, 112,   0,   0, 121, 122,   0,
  81, 100, 295,   0, 333,  25,  10,   0,  91,  -2,
  -2,  92,  93,  94,   0,   0,   0,  29,  30,  51,
  48,  59, 272, 273, 274, 275, 276, 277, 278, 279,
 280, 281, 282, 283, 284, 285, 286, 287, 288,   0,
   0, 292, 295, 298, 299, 295,   0, 312, 314, 313,
 315, 316,   0,   0, 319,   0, 197, 197, 340, 342,
 343,   0,   0, 248,  31,  -2,   0,   0, 169, 168,
 357, 363, 246, 191, 192, 353, 188, 190,   0,   0,
   0,  75, 196, 195, 102, 133,   0, 113,   0, 114,
   0, 104,  85,  99,  82,   0,  86,  96,  97,  95,
   8,  28, 295,   0,   0,   0, 311, 332,   0, 199,
 344, 198,   0, 326, 327, 204, 212,   0,  38,  40,
 295,   0,  65, 356, 295, 193, 174, 177, 107,  34,
 111, 115, 116,  11,  12,  13,  66,  15,  17,   0,
  45, 289, 291,   0,   0, 328, 329,   0,   0, 208,
 213,   0,   0, 295, 354,  39,  14,   0,   0,  45,
 293, 330, 331, 200, 201, 205, 206, 211,   0,  41,
  42,   0,   0,   0,   0, 207, 221, 224, 295,  61,
 227, 228, 229,   0,   0,   0,   0, 337, 167, 240,
   0, 214, 215, 216,   0, 218,   0,   0, 335, 271,
  43,  35,   0,   0, 223,   0,   0,   0, 208, 295,
 208, 233, 208, 236, 238, 295, 242,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0, 217, 208,   0, 267, 295,
   0,  16,   0, 222, 225, 226, 230,   0, 232, 208,
 235, 208, 208,   0, 208, 249, 250, 251, 252, 253,
 254, 255, 256, 257, 258, 259, 260, 261, 262, 263,
 264, 265,   0,   0,   0,   0, 269, 295,  18, 208,
 209, 295, 237, 239, 208, 243,   0,   0, 220,   0,
   0, 231,   0, 241, 266, 219, 268,   0, 295, 270,
   0, 208, 234 };
# ifdef YYDEBUG
# include "y.debug"
# endif

# define YYFLAG -1000
# define YYERROR goto yyerrlab
# define YYACCEPT return(0)
# define YYABORT return(1)

/*	parser for yacc output	*/

#ifdef YYDEBUG
int yydebug = 0; /* 1 for debugging */
#endif
YYSTYPE yyv[YYMAXDEPTH]; /* where the values are stored */
int yychar = -1; /* current input token number */
int yynerrs = 0;  /* number of errors */
short yyerrflag = 0;  /* error recovery flag */

yyparse()
{	short yys[YYMAXDEPTH];
	int yyj, yym;
	register YYSTYPE *yypvt;
	register int yystate, yyn;
	register short *yyps;
	register YYSTYPE *yypv;
	register short *yyxi;

	yystate = 0;
	yychar = -1;
	yynerrs = 0;
	yyerrflag = 0;
	yyps= &yys[-1];
	yypv= &yyv[-1];

yystack:    /* put a state and value onto the stack */
#ifdef YYDEBUG
	if(yydebug >= 3)
		if(yychar < 0 || yytoknames[yychar] == 0)
			printf("char %d in %s", yychar, yystates[yystate]);
		else
			printf("%s in %s", yytoknames[yychar], yystates[yystate]);
#endif
	if( ++yyps >= &yys[YYMAXDEPTH] ) { 
		yyerror( "yacc stack overflow" ); 
		return(1); 
	}
	*yyps = yystate;
	++yypv;
	*yypv = yyval;
yynewstate:
	yyn = yypact[yystate];
	if(yyn <= YYFLAG) goto yydefault; /* simple state */
	if(yychar<0) {
		yychar = yylex();
#ifdef YYDEBUG
		if(yydebug >= 2) {
			if(yychar <= 0)
				printf("lex EOF\n");
			else if(yytoknames[yychar])
				printf("lex %s\n", yytoknames[yychar]);
			else
				printf("lex (%c)\n", yychar);
		}
#endif
		if(yychar < 0)
			yychar = 0;
	}
	if((yyn += yychar) < 0 || yyn >= YYLAST)
		goto yydefault;
	if( yychk[ yyn=yyact[ yyn ] ] == yychar ){ /* valid shift */
		yychar = -1;
		yyval = yylval;
		yystate = yyn;
		if( yyerrflag > 0 ) --yyerrflag;
		goto yystack;
	}
yydefault:
	/* default state action */
	if( (yyn=yydef[yystate]) == -2 ) {
		if(yychar < 0) {
			yychar = yylex();
#ifdef YYDEBUG
			if(yydebug >= 2)
				if(yychar < 0)
					printf("lex EOF\n");
				else
					printf("lex %s\n", yytoknames[yychar]);
#endif
			if(yychar < 0)
				yychar = 0;
		}
		/* look through exception table */
		for(yyxi=yyexca; (*yyxi!= (-1)) || (yyxi[1]!=yystate);
			yyxi += 2 ) ; /* VOID */
		while( *(yyxi+=2) >= 0 ){
			if( *yyxi == yychar ) break;
		}
		if( (yyn = yyxi[1]) < 0 ) return(0);   /* accept */
	}
	if( yyn == 0 ){ /* error */
		/* error ... attempt to resume parsing */
		switch( yyerrflag ){
		case 0:   /* brand new error */
#ifdef YYDEBUG
			yyerror("syntax error\n%s", yystates[yystate]);
			if(yytoknames[yychar])
				yyerror("saw %s\n", yytoknames[yychar]);
			else if(yychar >= ' ' && yychar < '\177')
				yyerror("saw `%c'\n", yychar);
			else if(yychar == 0)
				yyerror("saw EOF\n");
			else
				yyerror("saw char 0%o\n", yychar);
#else
			yyerror( "syntax error" );
#endif
yyerrlab:
			++yynerrs;
		case 1:
		case 2: /* incompletely recovered error ... try again */
			yyerrflag = 3;
			/* find a state where "error" is a legal shift action */
			while ( yyps >= yys ) {
				yyn = yypact[*yyps] + YYERRCODE;
				if( yyn>= 0 && yyn < YYLAST && yychk[yyact[yyn]] == YYERRCODE ){
					yystate = yyact[yyn];  /* simulate a shift of "error" */
					goto yystack;
				}
				yyn = yypact[*yyps];
				/* the current yyps has no shift onn "error", pop stack */
#ifdef YYDEBUG
				if( yydebug ) printf( "error recovery pops state %d, uncovers %d\n", *yyps, yyps[-1] );
#endif
				--yyps;
				--yypv;
			}
			/* there is no state on the stack with an error shift ... abort */
yyabort:
			return(1);
		case 3:  /* no shift yet; clobber input char */
#ifdef YYDEBUG
			if( yydebug ) {
				printf("error recovery discards ");
				if(yytoknames[yychar])
					printf("%s\n", yytoknames[yychar]);
				else if(yychar >= ' ' && yychar < '\177')
					printf("`%c'\n", yychar);
				else if(yychar == 0)
					printf("EOF\n");
				else
					printf("char 0%o\n", yychar);
			}
#endif
			if( yychar == 0 ) goto yyabort; /* don't discard EOF, quit */
			yychar = -1;
			goto yynewstate;   /* try again in the same state */
		}
	}
	/* reduction by production yyn */
#ifdef YYDEBUG
	if(yydebug) {	char *s;
		printf("reduce %d in:\n\t", yyn);
		for(s = yystates[yystate]; *s; s++) {
			putchar(*s);
			if(*s == '\n' && *(s+1))
				putchar('\t');
		}
	}
#endif
	yyps -= yyr2[yyn];
	yypvt = yypv;
	yypv -= yyr2[yyn];
	yyval = yypv[1];
	yym=yyn;
	/* consult goto table to find next state */
	yyn = yyr1[yyn];
	yyj = yypgo[yyn] + *yyps + 1;
	if( yyj>=YYLAST || yychk[ yystate = yyact[yyj] ] != -yyn ) yystate = yyact[yypgo[yyn]];
	switch(yym){
		
case 1:
# line 480 "gram.y"
{	return 2; } break;
case 2:
# line 481 "gram.y"
{	return 1; } break;
case 3:
# line 482 "gram.y"
{	return 0; } break;
case 4:
# line 484 "gram.y"
{
				set_linkage(yypvt[-1].s);
				bl_level--;
				return 1;
			} break;
case 5:
# line 490 "gram.y"
{
				set_linkage(0);
				bl_level++;
				return 1;
			} break;
case 6:
# line 495 "gram.y"
{  return 1; } break;
case 7:
# line 496 "gram.y"
{  return 1 ;} break;
case 8:
# line 501 "gram.y"
{ Ptreet t = tree_template::get(yypvt[-4].pn->string) ;
                    Pexpr  e = 0 ;
	            if (t)
		      e = t->expand(expr_unlist(yypvt[-2].el)) ;
	            else error ("%s wasn't an expression template",
		                	yypvt[-4].pn->string)  ;
	           } break;
case 9:
# line 510 "gram.y"
{ templp->start() ; } break;
case 10:
# line 512 "gram.y"
{templp->enter_parameters() ; } break;
case 11:
# line 514 "gram.y"
{templp->end(yypvt[-0].pn);
                  templp->in_progress = false ;
                  goto mod;} break;
case 12:
# line 520 "gram.y"
{ goto mod; } break;
case 13:
# line 522 "gram.y"
{ goto mod; } break;
case 14:
# line 524 "gram.y"
{ Pname pn = yypvt[-1].pb->aggr();
                    /* basetype:aggr() does not return the name for a forward */
		    /* declaration, so extract it directly */
                    yyval.p = (pn ? pn : yypvt[-1].pb->b_name) ;
                    DECL_TYPE = 0;  } break;
case 15:
# line 531 "gram.y"
{templp->curr_tree_template = yypvt[-0].t ; } break;
case 16:
# line 533 "gram.y"
{yypvt[-2].pn->n_initializer = yypvt[-0].pe ; /* actually a stmt */
                    yyval.pn = yypvt[-2].pn; } break;
case 17:
# line 536 "gram.y"
{templp->curr_tree_template = yypvt[-0].t ; } break;
case 18:
# line 538 "gram.y"
{yypvt[-3].pn->n_initializer = yypvt[-1].pe ; /* actually a stmt */
                    yyval.pn = yypvt[-3].pn ; } break;
case 20:
# line 544 "gram.y"
{ yyval.pn = Ncopy(yypvt[-0].pn) ;} break;
case 21:
# line 548 "gram.y"
{	
			/* if function declartion with arguments
			 * need to make sure modified_tn is traversed */
			if ( yypvt[-0].pn != 0 
				&& yypvt[-0].pn->tp->base == FCT 
				&& Pfct(yypvt[-0].pn->tp)->nargs !=0 ) 
					goto mod;
			else {
				modified_tn = 0;
				curr_scope = 0;
				if (yypvt[-0].pn==0) yyval.i = 1; 
			     }
			} break;
case 22:
# line 562 "gram.y"
{	goto mod; } break;
case 23:
# line 564 "gram.y"
{	goto mod; } break;
case 24:
# line 566 "gram.y"
{ mod:	if (modified_tn) {
					restore();
					modified_tn = 0;
				}
				local_blk = 0;
				curr_scope = 0;
				if (local_tn) {
					local_restore();
					local_tn = 0;
				}
				
				if (nested_tn) { // x::f(){}
					nested_restore();
					nested_tn = 0;
					nested_type = 0;
				}
			} break;
case 25:
# line 584 "gram.y"
{	Pname n = new name(make_name('A'));
				n->tp = new basetype(ASM,0);
				Pbase(n->tp)->b_name = Pname(yypvt[-2].s);
				yyval.p = n;
			} break;
case 26:
# line 592 "gram.y"
{
				err_name = yypvt[-3].pn;
				if(err_name) err_name->n_initializer = yypvt[-1].pe;
				goto fix;
			} break;
case 27:
# line 598 "gram.y"
{
				Ptype t;
				err_name = yypvt[-1].pn;
			fix:
				if (err_name == 0) {
					error("syntax error:TX");
					yyval.p = Ndata(defa_type,err_name);
				}
				else if ((t=err_name->tp) == 0) {
					error("TX for%n",err_name);
					yyval.p = Ndata(defa_type,err_name);
				}
				else if (t->base==FCT) {
					if (Pfct(t)->returns==0)
						yyval.p = Nfct(defa_type,err_name,0);
					else
						yyval.p = Ndata(0,err_name);
				}
				else {
					error("syntax error:TX for%k%n",t->base,err_name);
					yyval.p = Ndata(defa_type,err_name);
				}
			} break;
case 28:
# line 624 "gram.y"
{	Pname n = Nfct(yypvt[-5].p,yypvt[-4].pn,yypvt[-0].p);
				Fargdcl(n->tp,name_unlist(yypvt[-3].nl),n);
				Finit(n->tp) = yypvt[-1].pn;
				yyval.p = n;
				NOT_EXPECT_ID();
                        //???POP_SCOPE(); // undef arg names
			} break;
case 29:
# line 632 "gram.y"
{
				Pname n = Nfct(yypvt[-4].p,yypvt[-3].pn,dummy);
				Fargdcl(n->tp,name_unlist(yypvt[-2].nl),n);
				yypvt[-0].q->retval.pn = n;
				yyval.p = n;
				NOT_EXPECT_ID();
			} break;
case 30:
# line 640 "gram.y"
{
				error(&yypvt[-3].pn->where,"syntax error -- did you forget a ';'?");
				Pname n = Nfct(yypvt[-4].p,yypvt[-3].pn,0);
				yyval.p = n;
				NOT_EXPECT_ID();
                   	//???POP_SCOPE(); // undef arg names
			} break;
case 31:
# line 650 "gram.y"
{	Pname n = Nfct(defa_type,yypvt[-4].pn,yypvt[-0].p);
				Fargdcl(n->tp,name_unlist(yypvt[-3].nl),n);
				if ( yypvt[-1].pn && yypvt[-1].pn->n_list && 
     					ccl && ccl->csu == UNION )  
						error( "multiple initializers in unionK %s::%n", yypvt[-4].pn->string, yypvt[-4].pn );
				Finit(n->tp) = yypvt[-1].pn;
				yyval.p = n;
				NOT_EXPECT_ID();
                        //???POP_SCOPE(); // undef arg names 
			} break;
case 32:
# line 661 "gram.y"
{
				Pname n = Nfct(defa_type,yypvt[-3].pn,dummy);
				Fargdcl(n->tp,name_unlist(yypvt[-2].nl),n);
				yypvt[-0].q->retval.pn = n;
				yyval.p = n;
				NOT_EXPECT_ID();
			} break;
case 33:
# line 669 "gram.y"
{
				error(&yypvt[-3].pn->where,"badD of%n -- did you forget a ';'?",yypvt[-3].pn);
				Pname n = Nfct(defa_type,yypvt[-3].pn,0);
				yyval.p = n;
				NOT_EXPECT_ID();
                         //???POP_SCOPE(); // undef arg names
			} break;
case 34:
# line 679 "gram.y"
{//PUSH_ARG_SCOPE
                        	arg_redec(yypvt[-0].pn);
                   	} break;
case 35:
# line 683 "gram.y"
{
				Finit(yypvt[-3].pn->tp) = yypvt[-1].pn;
				Pfct(yypvt[-3].pn->tp)->body = Pblock(yypvt[-0].p);
				yyval.pn = yypvt[-3].pn;
				NOT_EXPECT_ID();
                        //???POP_SCOPE(); // undef arg names
			} break;
case 36:
# line 694 "gram.y"
{
			// if parsing implicit inline def, save body
			//   of function for parsing after class def
			switch ( NEXTTOK() ) {
			case LC: case COLON:
				if ( in_class_decl ) {
					// mem or friend inline def
					// save text of mem_init & ftn
					la_backup(yychar,yylval);
					// yylval used as dummy...
					la_backup(FDEF, yylval);
					if ( yylval.q = save_text() )
						yychar = EMPTY;
					else { // syntax error
						// just parse in place
						yylex(); // FDEF
						yychar = yylex();
					}
				} // if in_class_decl
				break;
			default:
				la_backup(yychar,yylval);
				yychar = NO_ID; // 'graceful' recovery
				break;
			}
		   } break;
case 37:
# line 722 "gram.y"
{ ++in_binit_list; } break;
case 38:
# line 723 "gram.y"
{	
				yyval.p = yypvt[-0].p; 
				in_arg_list = 0;
				--in_binit_list;
			} break;
case 39:
# line 729 "gram.y"
{	yyval.p = 0; } break;
case 40:
# line 733 "gram.y"
{ yyval.p = yypvt[-0].p; } break;
case 41:
# line 735 "gram.y"
{ yyval.pn = yypvt[-0].pn;  yyval.pn->n_list = yypvt[-2].pn; } break;
case 42:
# line 739 "gram.y"
{
				yyval.pn = new name;
				yyval.pn->n_initializer = yypvt[-1].pe;
			} break;
case 43:
# line 744 "gram.y"
{
				Pname n = Ncopy(yypvt[-3].pn);
				n->base = yypvt[-3].pn->base;
				n->tp = yypvt[-3].pn->tp;
				n->n_initializer = yypvt[-1].pe;
				yyval.pn = n;
			} break;
case 44:
# line 768 "gram.y"
{	if (yypvt[-0].pn == 0)
					error("badAD");
				else if (yypvt[-0].pn->tp->base == FCT)
					error("FD inAL (%n)",yypvt[-0].pn);
				else if (yypvt[-1].p)
                                        yypvt[-1].nl->add_list(yypvt[-0].pn);
				else
					yyval.nl = new nlist(yypvt[-0].pn);
			} break;
case 45:
# line 778 "gram.y"
{
                                yyval.p = 0; 
			} break;
case 47:
# line 785 "gram.y"
{
                                if ( in_typedef ) {
                                        error("Tdef field");
                                        in_typedef = 0;
                                }
                        //      ENTER_NAME(yypvt[-1].pn);
                        } break;
case 48:
# line 793 "gram.y"
{	yyval.p = yypvt[-3].pn;
				yyval.pn->tp = new basetype(FIELD,yypvt[-0].pn);
		 	} break;
case 49:
# line 797 "gram.y"
{	yyval.p = new name;
				yyval.pn->tp = new basetype(FIELD,yypvt[-0].pn);
                                if ( in_typedef ) {
                                        error("Tdef field");
                                        in_typedef = 0;
                                }
			} break;
case 50:
# line 805 "gram.y"
{
                        //      ENTER_NAME(yypvt[-1].pn);
                        } break;
case 51:
# line 809 "gram.y"
{       Pexpr e = yypvt[-0].pe;
                                if (e == dummy) error("emptyIr");
                                yypvt[-3].pn->n_initializer = e;
                                init_seen = 0;
                        } break;
case 52:
# line 817 "gram.y"
{	
				if (yypvt[-0].p) yyval.nl = new nlist(yypvt[-0].pn); 
				if ( NEXTTOK() == CM && la_look() == TNAME ) 
					EXPECT_ID();
			} break;
case 53:
# line 823 "gram.y"
{	if (yypvt[-2].p)
					if (yypvt[-0].p)
						yypvt[-2].nl->add(yypvt[-0].pn);
					else
						error("DL syntax");
				else {
					if (yypvt[-0].p) yyval.nl = new nlist(yypvt[-0].pn);
					error("DL syntax");
				}
				if ( NEXTTOK() == CM && la_look() == TNAME ) 
					EXPECT_ID();
			} break;
case 54:
# line 838 "gram.y"
{ 
				extern int co_hack;
				co_hack = 1;
				/*$$ = Ndata($1,name_unlist($<nl>2));*/
				Pname n = Ndata(yypvt[-2].p,name_unlist(yypvt[-1].nl)); 
//error('d',"data_dcl:type decl_list sm: %n%t in_typedef%t in_tag%n",n,n->tp,in_typedef,in_tag);
				if ( in_typedef && in_tag ) { 
					if ( n->tp->check( in_tag->tp, 0 ))
    						error("%nredefined: previous: %t now: %t", in_tag, in_tag->tp, n->tp );
				}
				in_typedef = 0;
				in_tag = 0;
				co_hack = 0;
				DECL_TYPE = 0; 
				yyval.p = n;
			} break;
case 55:
# line 855 "gram.y"
{
				yyval.p = yypvt[-1].pb->aggr(); 
				in_typedef = 0;
				in_tag = 0;
				DECL_TYPE = 0; 
			} break;
case 56:
# line 866 "gram.y"
{ templp->parameters_in_progress++; } break;
case 57:
# line 867 "gram.y"
{ templp->parameters_in_progress--; } break;
case 58:
# line 869 "gram.y"
{ yyval.pn = templp->check_tname(yypvt[-0].pn) ; } break;
case 59:
# line 871 "gram.y"
{ 
		    yyval.pn = parametrized_typename(yypvt[-3].pn,
						  (expr_unlist(yypvt[-1].el))) ; 
		  } break;
case 60:
# line 876 "gram.y"
{ extern Pbase any_type;
		    error("%n was not a parametrized type.", yyval.pn) ;
                    yyval.pn= yypvt[-3].pn->tdef() ;
                    yyval.pn->tp = any_type ; } break;
case 61:
# line 884 "gram.y"
{ 
				yyval.p = new basetype(yypvt[-0].t,0); 
				if ( yypvt[-0].t == TYPEDEF ) in_typedef = yyval.pt;
				if (DECL_TYPE == -1) DECL_TYPE = 0;
			} break;
case 62:
# line 890 "gram.y"
{	yyval.p = new basetype(EXTERN,0);
				yyval.pb->b_linkage = yypvt[-0].s;
				if (DECL_TYPE == -1) DECL_TYPE = 0;
			} break;
case 63:
# line 895 "gram.y"
{ 
				templp->check_tname(yypvt[-0].pn);
				yyval.p = new basetype(TYPE,yypvt[-0].pn); 
				if (DECL_TYPE == -1) DECL_TYPE = 0;
			} break;
case 64:
# line 901 "gram.y"
{ // modified tn_list TNAME
				yyval.p = new basetype(TYPE,yypvt[-0].pn);
				//xxx qualifier currently ignored...
				if (DECL_TYPE == -1) DECL_TYPE = 0;
			} break;
case 65:
# line 907 "gram.y"
{
				yyval.pb = parametrized_basetype(yypvt[-3].pn,(expr_unlist(yypvt[-1].el)));
			} break;
case 68:
# line 913 "gram.y"
{ 
				if (DECL_TYPE == TNAME)
					yyval.p = new basetype(TYPE,yypvt[-0].pn); 
		//	else if (DECL_TYPE == TSCOPE)
		//	yyval.p = 0;
				else
				if (DECL_TYPE == 0 &&
					yypvt[-0].p->base == TNAME)
						yyval.p = new basetype(TYPE,yypvt[-0].pn); 
				else
					yyval.p = new basetype(yypvt[-0].t,0); 
				DECL_TYPE = -1;
			} break;
case 70:
# line 930 "gram.y"
{ 
				if ( DECL_TYPE != -1 ) {
					switch (yypvt[-1].pb->base) { Pbase bt;
					case COBJ: case EOBJ:
						bt = new basetype(0,0);
						*bt = *yypvt[-1].pb;
						DEL(yypvt[-1].pb);
						yypvt[-1].pb = bt;
					}
					yyval.p = yypvt[-1].pb->type_adj(yypvt[-0].t); 
				}
				DECL_TYPE = 0;
			} break;
case 71:
# line 944 "gram.y"
{
//error('d',"decl_type: %d  $1: %t  $2: %n",DECL_TYPE,yypvt[-1].pb,yypvt[-0].pn);
				if ( DECL_TYPE != -1 ) 
			 		yyval.p = yypvt[-1].pb->name_adj(yypvt[-0].pn);
			/*XXX*/	else if(yypvt[-1].pb==0) yyval.p=new basetype(TYPE,yypvt[-0].pn);
				DECL_TYPE = 0;
			} break;
case 72:
# line 951 "gram.y"
{ yyval.p = yypvt[-1].pb->base_adj(yypvt[-0].pb); } break;
case 73:
# line 952 "gram.y"
{ yyval.p = yypvt[-1].pb->base_adj(yypvt[-0].pb); } break;
case 74:
# line 954 "gram.y"
{ 
				if (DECL_TYPE == TYPE) {
					switch (yypvt[-1].pb->base) { Pbase bt;
					case COBJ: case EOBJ:
						bt = new basetype(0,0);
						*bt = *yypvt[-1].pb;
						DEL(yypvt[-1].pb);
						yypvt[-1].pb = bt;
					}
					yyval.p = yypvt[-1].pb->type_adj(yypvt[-0].t);  
				}
			/*XXX*/	else if (DECL_TYPE == TSCOPE) {
			/*XXX*/		error('i',"type decl_marker(tscope)");
			/*XXX*/	//	yyval.p = yypvt[-1].p;//ignore(?)
			/*XXX*/	}
				else
					yyval.p = yypvt[-1].pb->name_adj(yypvt[-0].pn); 
				DECL_TYPE = -1;
			} break;
case 75:
# line 976 "gram.y"
{yypvt[-2].el->add(new expr(ELIST,yypvt[-0].pe,NULL)) ; } break;
case 76:
# line 977 "gram.y"
{ yyval.el =
				     new elist(new expr(ELIST,yypvt[-0].pe,NULL)); } break;
case 77:
# line 981 "gram.y"
{yypvt[-0].pn->n_template_arg = template_actual_arg_dummy ;
		   yyval.pe = yypvt[-0].pn; /* keep yacc happy */ } break;
case 78:
# line 984 "gram.y"
{ yyval.pe = yypvt[-0].pe ; } break;
case 79:
# line 989 "gram.y"
{ enumcheck:
			Ptype tx = yypvt[-0].pn->tp;
			yyval.p = yypvt[-0].p;
			if ( tx->base == TYPE ) {
				yyval.p = Pbase(tx)->b_name;
				tx = yyval.pn->tp;
				if ( tx->base != EOBJ
				||   strcmp(yyval.pn->string,yypvt[-0].pn->string)
				)
					error("%n of type%t redeclared as enum.",yypvt[-0].pn,tx);
			} else if ( tx->base != EOBJ )
				error("%n of type%t redeclared as enum",yypvt[-0].pn,tx);
		} break;
case 80:
# line 1002 "gram.y"
{ goto enumcheck; } break;
case 81:
# line 1005 "gram.y"
{ yyval.p = end_enum(0,yypvt[-1].nl); } break;
case 82:
# line 1006 "gram.y"
{ yyval.p = end_enum(yypvt[-3].pn,yypvt[-1].nl); } break;
case 83:
# line 1007 "gram.y"
{ yyval.pb = (Pbase)yypvt[-0].pn->tp; } break;
case 84:
# line 1011 "gram.y"
{	if (yypvt[-0].p) yyval.nl = new nlist(yypvt[-0].pn); } break;
case 85:
# line 1013 "gram.y"
{	if( yypvt[-0].p)
					if (yypvt[-2].p)
						yypvt[-2].nl->add(yypvt[-0].pn);
					else
						yyval.nl = new nlist(yypvt[-0].pn);
			} break;
case 88:
# line 1023 "gram.y"
{ yyval.pn = NULL ;} break;
case 91:
# line 1031 "gram.y"
{ templp->collect(yypvt[-1].t, yypvt[-0].pn) ; } break;
case 92:
# line 1033 "gram.y"
{ templp->collect(yypvt[-1].t, yypvt[-0].pn) ; } break;
case 93:
# line 1035 "gram.y"
{templp->collect(Ndata(yypvt[-1].p,yypvt[-0].pn)); } break;
case 94:
# line 1041 "gram.y"
{	yyval.p = yypvt[-0].pn; } break;
case 95:
# line 1043 "gram.y"
{	Ptyp(yypvt[-1].p) = yypvt[-0].pn->tp;
				yypvt[-0].pn->tp = (Ptype)yypvt[-1].p;
				yyval.p = yypvt[-0].p;
			} break;
case 96:
# line 1048 "gram.y"
{	Vtype(yypvt[-0].p) = yypvt[-1].pn->tp;
				yypvt[-1].pn->tp = (Ptype)yypvt[-0].p;
			} break;
case 97:
# line 1052 "gram.y"
{	Freturns(yypvt[-0].p) = yypvt[-1].pn->tp;
				yypvt[-1].pn->tp = (Ptype)yypvt[-0].p;
			} break;
case 98:
# line 1058 "gram.y"
{	yyval.p = yypvt[-0].pn; yyval.pn->tp = moe_type; } break;
case 99:
# line 1060 "gram.y"
{	yyval.p = yypvt[-2].pn;
				yyval.pn->tp = moe_type;
				yyval.pn->n_initializer = yypvt[-0].pe;
			} break;
case 100:
# line 1065 "gram.y"
{	yyval.p = 0; } break;
case 101:
# line 1069 "gram.y"
{	parsing_class_members = 0;
				RESTORE_STATE();
				switch ( NEXTTOK() ) {
				case TYPE: case AGGR: case ENUM: case EOFTOK:
					error("`;' or declaratorX afterCD");
					la_backup(yychar,yylval);
					yychar = SM;
					break;
				}
				la_backup(yychar,yylval);
				yychar = -1;
				restore_text();
				++bl_level; // scope weirdness!
				++in_mem_fct;
			} break;
case 102:
# line 1085 "gram.y"
{
				--in_mem_fct;
				--bl_level; // scope weirdness!
				if ( yychar == ID ) {
					// (yuk!) adjust lex level
					--yylval.pn->lex_level;
				}
				ccl->mem_list = name_unlist(yypvt[-3].nl);
				if ( --in_class_decl )  // nested class
					// continue to parse enclosing class
					parsing_class_members = 1;
				ccl->nest_list = nested_type;
				if ( nested_tn ) nested_restore();
				nested_type = nested_type_vec[in_class_decl];
				nested_tn = nested_tn_vec[in_class_decl];
				end_cl();
				declTag = 1;
                        //POP_SCOPE();
			} break;
case 103:
# line 1105 "gram.y"
{ aggrcheck:
				yyval.pb = (Pbase)yypvt[-0].pn->tp; 
				if ( yyval.p->base == TYPE ) {
					Pname nx = yyval.pb->b_name;
					yyval.pb = (Pbase)nx->tp;
					if ( yyval.p->base != COBJ
					||   strcmp(nx->string,yypvt[-0].pn->string)
					)
						error("%n of type%t redeclared as%k.",yypvt[-0].pn,yyval.pb,yypvt[-1].t);
				} else if ( yyval.p->base != COBJ )
					error("%n of type%t redeclared as%k",yypvt[-0].pn,yyval.pb,yypvt[-1].t);
				check_tag();
			} break;
case 104:
# line 1119 "gram.y"
{ 
		    Pname p = parametrized_typename(yypvt[-3].pn, (expr_unlist(yypvt[-1].el))) ;
                    yyval.pb = (Pbase)p->tp; 
                    check_tag(); 
		  } break;
case 105:
# line 1125 "gram.y"
{
				goto aggrcheck;
			} break;
case 108:
# line 1135 "gram.y"
{ yyval.pbc = yypvt[-0].pbc; } break;
case 109:
# line 1136 "gram.y"
{ yyval.pbc = 0; } break;
case 111:
# line 1141 "gram.y"
{	if (yypvt[-0].pbc) { yyval.pbc = yypvt[-0].pbc; yyval.pbc->next = yypvt[-2].pbc; } } break;
case 112:
# line 1144 "gram.y"
{ yyval.pbc = dobase(0,yypvt[-0].pn); } break;
case 113:
# line 1145 "gram.y"
{ yyval.pbc = dobase(yypvt[-1].t,yypvt[-0].pn); } break;
case 114:
# line 1146 "gram.y"
{ yyval.pbc = dobase(0,yypvt[-0].pn,yypvt[-1].t); } break;
case 115:
# line 1147 "gram.y"
{ yyval.pbc = dobase(yypvt[-2].t,yypvt[-0].pn,yypvt[-1].t); } break;
case 116:
# line 1148 "gram.y"
{ yyval.pbc = dobase(yypvt[-1].t,yypvt[-0].pn,yypvt[-2].t); } break;
case 117:
# line 1152 "gram.y"
{//PUSH_CLASS_SCOPE(0);
				parsing_class_members = 1;
				yyval.p = start_cl(yypvt[-1].t,0,0); 
				nested_tn_vec[in_class_decl] = nested_tn;
				nested_type_vec[in_class_decl++] = nested_type;
				nested_tn = nested_type = 0;
				SAVE_STATE();
			} break;
case 118:
# line 1162 "gram.y"
{ //PUSH_CLASS_SCOPE(yypvt[-2].pn->string);
				parsing_class_members = 1;
				yyval.p = start_cl(yypvt[-3].t,yypvt[-2].pn,yypvt[-1].pbc);
				nested_tn_vec[in_class_decl] = nested_tn;
				nested_type_vec[in_class_decl++] = nested_type;
				nested_tn = nested_type = 0;
				SAVE_STATE();
			} break;
case 119:
# line 1172 "gram.y"
{ yyval.p = yypvt[-0].pn; } break;
case 120:
# line 1173 "gram.y"
{ yyval.p=yypvt[-0].p; } break;
case 121:
# line 1176 "gram.y"
{ yyval.p = yypvt[-0].pn; } break;
case 122:
# line 1177 "gram.y"
{ yyval.p=yypvt[-0].p; } break;
case 123:
# line 1181 "gram.y"
{
				if (yypvt[-0].p) {
					if (yypvt[-1].p)
						yypvt[-1].nl->add_list(yypvt[-0].pn);
					else
						yyval.nl = new nlist(yypvt[-0].pn);
				}
			} break;
case 124:
# line 1189 "gram.y"
{ yyval.p = 0; } break;
case 125:
# line 1191 "gram.y"
{
				error( "ZizedTD must be atG, notC scope" );
				error('i', "cannot recover from previous error" );
			} break;
case 132:
# line 1204 "gram.y"
{	yyval.p = new name;
				yyval.pn->base = yypvt[-1].t;
			} break;
case 133:
# line 1214 "gram.y"
{	Pname n = Ncopy(yypvt[-1].pn);
				if (n->n_oper == TYPE) {
					error('s',"visibilityD for conversion operator");
					// n->tp = Ptype(n->n_initializer);
					n->tp = Ptype(n->cond);
					n->cond = 0;
					// n->n_initializer = 0;
					n->n_oper = 0;
					sig_name(n);
				}
				n->n_qualifier = yypvt[-2].pn;
				n->base = PR;
				yyval.p = n;
			} break;
case 134:
# line 1243 "gram.y"
{	yyval.p = yypvt[-0].pn; } break;
case 135:
# line 1245 "gram.y"
{	yyval.p = Ncopy(yypvt[-0].pn);
				yyval.pn->n_oper = DTOR;
			} break;
case 136:
# line 1249 "gram.y"
{	yyval.p = new name(oper_name(yypvt[-0].t));
				yyval.pn->n_oper = yypvt[-0].t;
			} break;
case 137:
# line 1253 "gram.y"
{	Pname n = yypvt[-0].pn;
				n->string = "_type";
				n->n_oper = TYPE;
				n->cond = Pexpr(n->tp);
				// n->n_initializer = Pexpr(n->tp);
				n->tp = 0;
				yyval.p = n;
			} break;
case 152:
# line 1277 "gram.y"
{	yyval.t = CALL; } break;
case 153:
# line 1278 "gram.y"
{	yyval.t = DEREF; } break;
case 159:
# line 1284 "gram.y"
{	yyval.t = NEW; } break;
case 160:
# line 1285 "gram.y"
{	yyval.t = DELETE; } break;
case 161:
# line 1286 "gram.y"
{	yyval.t = REF; } break;
case 162:
# line 1287 "gram.y"
{	yyval.t = CM; } break;
case 163:
# line 1288 "gram.y"
{	yyval.t = REFMUL;
					if (yypvt[-0].t == DOT) error(".* cannot be overloaded");
				} break;
case 164:
# line 1294 "gram.y"
{   if ( yypvt[-0].pn != sta_name ) {
// error('d',"tn_list: tscope: pn1: %s", yypvt[-0].pn->string);
				Ptype t = yypvt[-0].pn->tp;
				while ( t->base == TYPE )
					t = Pbase(t)->b_name->tp;
				Pname n = Pbase(t)->b_name;
				if (NEXTTOK() == TNAME
				&& strcmp(n->string,yylval.pn->string)==0){
					// ctor -- change to ID to avoid
					//    parsing as type spec
					yychar = ID;
					yylval.pn = Ncopy(yylval.pn);
					yylval.pn->n_oper = TNAME;
				}
			    }
			    yyval.pn = yypvt[-0].pn;
			} break;
case 165:
# line 1312 "gram.y"
{ error('s', "CNs do not nest, use typedef x::y y_in_x"); } break;
case 166:
# line 1317 "gram.y"
{	yyval.pn = yypvt[-0].pn;
				//xxx qualifier currently ignored...
				// yyval.pn = Ncopy( yypvt[-0].pn );
				// yyval.pn->n_oper = TNAME;
				// yyval.pn->n_qualifier = yypvt[-1].pn;
			} break;
case 167:
# line 1324 "gram.y"
{	yyval.pn = yypvt[-0].pn;
			//	yyval.pn = Ncopy( yypvt[-0].pn );
			//	yyval.pn->n_oper = TNAME;
			} break;
case 168:
# line 1331 "gram.y"
{ yyval.i = 0; } break;
case 169:
# line 1333 "gram.y"
{ /* const/volatile function */
				switch ( yypvt[-0].t ) {
				case VOLATILE:
					error('s',"volatile functions");
					break;
				case CONST:
					yyval.i = (yypvt[-1].i | 1);
					break;
				default:
					if ( NEXTTOK() != SM
					&&   yychar != COLON
					&&   yychar != LC ) {
						la_backup(yychar,yylval);
						yylval.t = yypvt[-0].t;
						la_backup(TYPE,yylval);
						yylval.t = SM;
						yychar = SM;
						error("syntax error: unexpected%k (did you forget a `;'?)",yypvt[-0].t);
					} else error("FD syntax: unexpected%k",yypvt[-0].t);
					break;
				}
 			} break;
case 170:
# line 1358 "gram.y"
{	Freturns(yypvt[-0].p) = yypvt[-1].pn->tp;
				yypvt[-1].pn->tp = yypvt[-0].pt;
			} break;
case 171:
# line 1362 "gram.y"
{ /* function with no argument */
 				yypvt[-3].pn->tp = new fct(yypvt[-3].pn->tp,0,1);
 				Pfct(yypvt[-3].pn->tp)->f_const = (yypvt[-0].i & 1);
 			} break;
case 172:
# line 1367 "gram.y"
{	Pname n = yypvt[-1].pn;
				yyval.p = Ncopy(n);
                                //??? what if tname is qualified ???
				if (ccl && strcmp(n->string,ccl->string)) n->hide();
				yyval.pn->n_oper = TNAME;
				Freturns(yypvt[-0].p) = yyval.pn->tp;
				yyval.pn->tp = yypvt[-0].pt;
			} break;
case 173:
# line 1380 "gram.y"
{	
				yypvt[-3].pn->tp = new fct(yypvt[-3].pn->tp,yypvt[-1].pn,1); 
 				in_arg_list = 0;
 				end_al(yypvt[-2].pl,0);
				//RESTORE_STATE();
                        //POP_SCOPE(); // similar to end_al()
			} break;
case 174:
# line 1388 "gram.y"
{
				Pptr p = new ptr( PTR, 0 );
				Ptyp(p) = new basetype(TYPE,yypvt[-5].pn);
				Freturns( yypvt[-0].p ) = Ptype(p);
				yypvt[-2].pn->tp = yypvt[-0].pt;
				yyval.p = yypvt[-2].pn;
				if (DECL_TYPE == -1) DECL_TYPE = 0;
			} break;
case 175:
# line 1397 "gram.y"
{	yyval.p = Ncopy(yypvt[-3].pn);
				yyval.pn->n_oper = TNAME;
				yyval.pn->tp = new fct(0,yypvt[-1].pn,1);
			} break;
case 176:
# line 1402 "gram.y"
{ /* function with no argument */
				yyval.p = Ncopy(yypvt[-3].pn);
 				yyval.pn->n_oper = TNAME;
 				yyval.pn->tp = new fct(0,0,1);
 				Pfct(yypvt[-3].pn->tp)->f_const = (yypvt[-0].i & 1);
			} break;
case 177:
# line 1409 "gram.y"
{	memptrdcl(yypvt[-3].pn,yypvt[-5].pn,yypvt[-0].pt,yypvt[-2].pn);
				yyval.p = yypvt[-2].p;
			} break;
case 179:
# line 1414 "gram.y"
{	yyval.p = Ncopy(yypvt[-0].pn);
				yyval.pn->n_qualifier = yypvt[-2].pn;
				error(strict_opt?0:'w',"`.' used for qualification; please use `::' (anachronism)");
			} break;
case 180:
# line 1419 "gram.y"
{	yyval.p = yypvt[-0].p;
				if ( yypvt[-1].pn != sta_name ) {
    					set_scope(yypvt[-1].pn); 
    					yyval.pn->n_qualifier = yypvt[-1].pn;
				}
			} break;
case 181:
# line 1426 "gram.y"
{	yyval.p = Ncopy(yypvt[-0].pn);
				yyval.pn->n_qualifier = yypvt[-2].pn;
				error(ansi_opt?0:'w',"anachronism `.' used for qualification; please use `::'");
				if ( yypvt[-3].pn != sta_name ) {
    					set_scope(yypvt[-3].pn); 
    					yypvt[-2].pn->n_qualifier = yypvt[-3].pn;
				}
			} break;
case 182:
# line 1444 "gram.y"
{	Ptyp(yypvt[-1].p) = yypvt[-0].pn->tp;
				yypvt[-0].pn->tp = yypvt[-1].pt;
				yyval.p = yypvt[-0].p;
			} break;
case 183:
# line 1449 "gram.y"
{	yyval.p = Ncopy(yypvt[-0].pn);
				yyval.pn->n_oper = TNAME;
				// cannot evaluate at this point: defer until data_dcl
				if ( in_typedef ) {
					defer_check = 1;
					in_tag = yypvt[-0].pn;
				}
				yypvt[-0].pn->hide();
				defer_check = 0;
				yyval.pn->tp = yypvt[-1].pt;
			} break;
case 184:
# line 1461 "gram.y"
{	yyval.p = Ncopy(yypvt[-1].pn);
				yyval.pn->n_oper = TNAME;
				if ( in_typedef ) {
					defer_check = 1;
					in_tag = yypvt[-1].pn;
				}
				yypvt[-1].pn->hide();
				defer_check = 0;
				yyval.pn->tp = yypvt[-0].pt;
			} break;
case 185:
# line 1472 "gram.y"
{	Vtype(yypvt[-0].p) = yypvt[-1].pn->tp;
				yypvt[-1].pn->tp = yypvt[-0].pt;
			} break;
case 186:
# line 1489 "gram.y"
{
				yyval.p = yypvt[-1].p; 
				in_arg_list = 0;
				end_al(yypvt[-2].pl,0);
				//RESTORE_STATE();
                        //POP_SCOPE(); // similar to end_al()
			} break;
case 187:
# line 1499 "gram.y"
{	yyval.p = yypvt[-0].pn; } break;
case 188:
# line 1501 "gram.y"
{	yyval.p = Ncopy(yypvt[-0].pn);
				yyval.pn->n_oper = TNAME;
				yypvt[-0].pn->hide();
				yyval.pn->tp = yypvt[-1].pt;
			} break;
case 189:
# line 1507 "gram.y"
{	
				yyval.p = new name; 
				NOT_EXPECT_ID();
			} break;
case 190:
# line 1512 "gram.y"
{	Ptyp(yypvt[-1].p) = yypvt[-0].pn->tp;
				yypvt[-0].pn->tp = (Ptype)yypvt[-1].p;
				yyval.p = yypvt[-0].p;
			} break;
case 191:
# line 1517 "gram.y"
{	Vtype(yypvt[-0].p) = yypvt[-1].pn->tp;
				yypvt[-1].pn->tp = (Ptype)yypvt[-0].p;
			} break;
case 192:
# line 1521 "gram.y"
{	Freturns(yypvt[-0].p) = yypvt[-1].pn->tp;
				yypvt[-1].pn->tp = (Ptype)yypvt[-0].p;
			} break;
case 193:
# line 1537 "gram.y"
{ 
// error('d', "arg_lp arg_decl rp in_arg_list: %d", in_arg_list );
				yyval.p = yypvt[-1].p; 
				in_arg_list = 0;
				end_al(yypvt[-2].pl,0);
				//RESTORE_STATE();
                        //POP_SCOPE(); // similar to end_al()
			} break;
case 194:
# line 1548 "gram.y"
{	yyval.p = new name; } break;
case 195:
# line 1550 "gram.y"
{	Ptyp(yypvt[-1].p) = yypvt[-0].pn->tp;
				yypvt[-0].pn->tp = (Ptype)yypvt[-1].p;
				yyval.p = yypvt[-0].p;
                                NOT_EXPECT_ID();
			} break;
case 196:
# line 1556 "gram.y"
{	Vtype(yypvt[-0].p) = yypvt[-1].pn->tp;
				yypvt[-1].pn->tp = (Ptype)yypvt[-0].p;
			} break;
case 197:
# line 1561 "gram.y"
{ yyval.p = new name; } break;
case 198:
# line 1563 "gram.y"
{	Ptyp(yypvt[-1].p) = yypvt[-0].pn->tp;
				yypvt[-0].pn->tp = (Ptype)yypvt[-1].p;
				yyval.p = yypvt[-0].p;
				NOT_EXPECT_ID();
			} break;
case 199:
# line 1569 "gram.y"
{	Vtype(yypvt[-0].p) = yypvt[-1].pn->tp;
				yypvt[-1].pn->tp = (Ptype)yypvt[-0].p;
			} break;
case 200:
# line 1573 "gram.y"
{	Freturns(yypvt[-0].p) = yypvt[-2].pn->tp;
				yypvt[-2].pn->tp = yypvt[-0].pt;
				yyval.p = yypvt[-2].p;
			} break;
case 201:
# line 1578 "gram.y"
{	Vtype(yypvt[-0].p) = yypvt[-2].pn->tp;
				yypvt[-2].pn->tp = yypvt[-0].pt;
				yyval.p = yypvt[-2].p;
			} break;
case 202:
# line 1585 "gram.y"
{	yyval.p = new name; } break;
case 203:
# line 1587 "gram.y"
{	Ptyp(yypvt[-1].p) = yypvt[-0].pn->tp;
				yypvt[-0].pn->tp = (Ptype)yypvt[-1].p;
				yyval.p = yypvt[-0].p;
			} break;
case 204:
# line 1597 "gram.y"
{
				yyval.p = 0; 
			} break;
case 205:
# line 1601 "gram.y"
{
				error( "ZizedTD must be atG, not local scope" );
				error('i', "cannot recover from previous error" );
			} break;
case 206:
# line 1606 "gram.y"
{	
				if (yypvt[-0].p)
					if (yypvt[-1].p)
						yypvt[-1].sl->add(yypvt[-0].ps);
					else {
						yyval.sl =  new slist(yypvt[-0].ps);
						stmt_seen = 1;
					}
			} break;
case 207:
# line 1617 "gram.y"
{
				yyval.p = yypvt[-0].p;
				if (yypvt[-0].p)	stmt_seen = 1;
			} break;
case 208:
# line 1624 "gram.y"
{
				yyval.p = 0;
				check_decl();
			} break;
case 209:
# line 1631 "gram.y"
{	yyval.p = yypvt[-1].p;
			/*	if ($<pe>$ == dummy) error("empty condition");*/
				stmt_seen = 1;
			} break;
case 210:
# line 1638 "gram.y"
{//PUSH_BLOCK_SCOPE	
				cd_vec[cdi] = cd;
				stmt_vec[cdi] = stmt_seen;
				tn_vec[cdi] = modified_tn;
				lcl_blk_vec[cdi++] = local_blk;
				lcl_tn_vec[cdi] = local_tn;
				local_blk = 0;
				local_tn = 0;
				cd = 0;
				stmt_seen = 0;
				modified_tn = 0;
			} break;
case 211:
# line 1651 "gram.y"
{	Pname n = name_unlist(cd);
				Pstmt ss = stmt_unlist(yypvt[-1].sl);
				yyval.p = new block(yypvt[-3].l,n,ss,yypvt[-0].l);
				if ( local_tn ) local_restore();
				if ( local_blk ) local_name();
				if (modified_tn) restore();
				cd = cd_vec[--cdi];
				stmt_seen = stmt_vec[cdi];
				modified_tn = tn_vec[cdi];
				local_tn = lcl_tn_vec[cdi];
				local_blk = lcl_blk_vec[cdi];
				if (cdi < 0) error('i',"block level(%d)",cdi);
				NOT_EXPECT_ID();
                        //POP_SCOPE(); // similar to end_al()
			} break;
case 212:
# line 1667 "gram.y"
{	yyval.p = new block(yypvt[-1].l,0,0,yypvt[-0].l); NOT_EXPECT_ID();} break;
case 213:
# line 1669 "gram.y"
{	yyval.p = new block(yypvt[-2].l,0,0,yypvt[-0].l); NOT_EXPECT_ID();} break;
case 214:
# line 1673 "gram.y"
{	yyval.p = new estmt(SM,curloc,yypvt[-0].pe,0);	} break;
case 215:
# line 1675 "gram.y"
{	yyval.p = new stmt(BREAK,yypvt[-0].l,0); } break;
case 216:
# line 1677 "gram.y"
{	yyval.p = new stmt(CONTINUE,yypvt[-0].l,0); } break;
case 217:
# line 1679 "gram.y"
{	yyval.p = new lstmt(GOTO,yypvt[-1].l,yypvt[-0].pn,0); } break;
case 218:
# line 1680 "gram.y"
{ stmt_seen=1; } break;
case 219:
# line 1681 "gram.y"
{	yyval.p = new estmt(DO,yypvt[-4].l,yypvt[-0].pe,yypvt[-2].ps); } break;
case 220:
# line 1683 "gram.y"
{	
				if (stmt_seen)
					yyval.p = new estmt(ASM,curloc,(Pexpr)yypvt[-1].s,0);
				else {
					Pname n = new name(make_name('A'));
					n->tp = new basetype(ASM,(Pname)yypvt[-1].s);
					if (cd)
						cd->add_list(n);
					else
						cd = new nlist(n);
					yyval.p = 0;
				}
			} break;
case 221:
# line 1698 "gram.y"
{
			if ( NEXTTOK() != SM ) {
				error("`;' missing afterS");
				la_backup(yychar,yylval);
				yychar = SM;
			}
		  } break;
case 224:
# line 1709 "gram.y"
{	yyval.p = new estmt(SM,yypvt[-0].l,dummy,0); } break;
case 225:
# line 1711 "gram.y"
{	yyval.p = new estmt(RETURN,yypvt[-2].l,yypvt[-1].pe,0); } break;
case 226:
# line 1713 "gram.y"
{
				error("local linkage specification");
				yyval.p = yypvt[-0].pn;
			} break;
case 227:
# line 1718 "gram.y"
{	Pname n = yypvt[-0].pn;
				if (n) {
//error('d',"adding local dcl of%n%t ll %d in_typedef%t",n,n->tp,n->lex_level,in_typedef);
					if (stmt_seen) {
						yyval.p = new block(n->where,n,0);
						yyval.ps->base = DCL;
					}
					else {
						if (cd)
							cd->add_list(n);
						else
							cd = new nlist(n);
						yyval.p = 0;
					}
				} // if n
			} break;
case 228:
# line 1735 "gram.y"
{
				Pname n = yypvt[-0].pn;
				error(&n->where,"%n's definition is nested (did you forget a ``}''?)",n);
				if (cd)
					cd->add_list(n);
				else
					cd = new nlist(n);
				yyval.p = 0;
			} break;
case 230:
# line 1746 "gram.y"
{	yyval.p = new ifstmt(yypvt[-2].l,yypvt[-1].pe,yypvt[-0].ps,0); } break;
case 231:
# line 1748 "gram.y"
{	yyval.p = new ifstmt(yypvt[-4].l,yypvt[-3].pe,yypvt[-2].ps,yypvt[-0].ps); } break;
case 232:
# line 1750 "gram.y"
{	yyval.p = new estmt(WHILE,yypvt[-2].l,yypvt[-1].pe,yypvt[-0].ps); } break;
case 233:
# line 1751 "gram.y"
{ stmt_seen=1; } break;
case 234:
# line 1752 "gram.y"
{	yyval.p = new forstmt(yypvt[-8].l,yypvt[-5].ps,yypvt[-4].pe,yypvt[-2].pe,yypvt[-0].ps); } break;
case 235:
# line 1754 "gram.y"
{	yyval.p = new estmt(SWITCH,yypvt[-2].l,yypvt[-1].pe,yypvt[-0].ps); } break;
case 236:
# line 1755 "gram.y"
{ yyval.p = yypvt[-1].pn; stmt_seen=1; } break;
case 237:
# line 1756 "gram.y"
{	Pname n = yypvt[-1].pn;
				yyval.p = new lstmt(LABEL,n->where,n,yypvt[-0].ps);
			} break;
case 238:
# line 1759 "gram.y"
{ yyval.p = new name(yypvt[-1].pn->string); stmt_seen=1; } break;
case 239:
# line 1760 "gram.y"
{	Pname n = yypvt[-1].pn;
				yyval.p = new lstmt(LABEL,n->where,n,yypvt[-0].ps);
			} break;
case 240:
# line 1763 "gram.y"
{ stmt_seen=1; } break;
case 241:
# line 1764 "gram.y"
{	if (yypvt[-2].pe == dummy) error("empty case label");
				yyval.p = new estmt(CASE,yypvt[-4].l,yypvt[-2].pe,yypvt[-0].ps);
			} break;
case 242:
# line 1767 "gram.y"
{ stmt_seen=1; } break;
case 243:
# line 1768 "gram.y"
{	yyval.p = new stmt(DEFAULT,yypvt[-3].l,yypvt[-0].ps); } break;
case 244:
# line 1775 "gram.y"
{	Pexpr e = expr_unlist(yypvt[-0].el);
				while (e && e->e1==dummy) {
					register Pexpr ee2 = e->e2;
					if (ee2) error("EX inEL");
					delete e;
					e = ee2;
				}
				yyval.p = e;
			} break;
case 245:
# line 1787 "gram.y"
{	yyval.el = new elist(new expr(ELIST,yypvt[-0].pe,0)); } break;
case 246:
# line 1789 "gram.y"
{	yypvt[-2].el->add(new expr(ELIST,yypvt[-0].pe,0)); } break;
case 248:
# line 1794 "gram.y"
{
  			  	if ( in_arg_list ) 
       			  		error( "syntax error: IrL not permitted in AL" );
				else if ( in_binit_list )
					error( "syntax error: IrL not permitted inMIr" );
  			  	else 
					init_seen = 1;
				Pexpr e;
				if (yypvt[-1].p)
					e = yypvt[-1].pe;
				else
					e = new expr(ELIST,dummy,0);
				yyval.p = new expr(ILIST,e,0);
			} break;
case 249:
# line 1811 "gram.y"
{	bbinop:	yyval.p = new expr(yypvt[-1].t,yypvt[-2].pe,yypvt[-0].pe); } break;
case 250:
# line 1812 "gram.y"
{	goto bbinop; } break;
case 251:
# line 1813 "gram.y"
{	goto bbinop; } break;
case 252:
# line 1814 "gram.y"
{	goto bbinop; } break;
case 253:
# line 1815 "gram.y"
{	goto bbinop; } break;
case 254:
# line 1816 "gram.y"
{	goto bbinop; } break;
case 255:
# line 1817 "gram.y"
{	goto bbinop; } break;
case 256:
# line 1818 "gram.y"
{ 	goto bbinop; } break;
case 257:
# line 1819 "gram.y"
{	goto bbinop; } break;
case 258:
# line 1820 "gram.y"
{	goto bbinop; } break;
case 259:
# line 1821 "gram.y"
{	goto bbinop; } break;
case 260:
# line 1822 "gram.y"
{	goto bbinop; } break;
case 261:
# line 1823 "gram.y"
{	goto bbinop; } break;
case 262:
# line 1824 "gram.y"
{	goto bbinop; } break;
case 263:
# line 1825 "gram.y"
{	goto bbinop; } break;
case 264:
# line 1826 "gram.y"
{	goto bbinop; } break;
case 265:
# line 1827 "gram.y"
{	goto bbinop; } break;
case 266:
# line 1829 "gram.y"
{	yyval.p = new qexpr(yypvt[-4].pe,yypvt[-2].pe,yypvt[-0].pe); } break;
case 267:
# line 1831 "gram.y"
{ yyval.p = new expr(DELETE,yypvt[-0].pe,0); } break;
case 268:
# line 1833 "gram.y"
{
				if(yypvt[-2].pe != dummy) {
					if ( warning_opt || strict_opt )
						error(strict_opt?0:'w',"v in `delete[v]' is redundant; use `delete[] instead (anachronism)");
				}
				yyval.p = new expr(DELETE,yypvt[-0].pe,yypvt[-2].pe);
			} break;
case 269:
# line 1841 "gram.y"
{	yyval.p = new expr(GDELETE,yypvt[-0].pe,0); } break;
case 270:
# line 1843 "gram.y"
{
				if(yypvt[-2].pe != dummy) { 
					if ( warning_opt || strict_opt )
						error(strict_opt?0:'w',"v in `::delete[v]' is redundant; use `::delete[] instead (anachronism)");
				}
				yyval.p = new expr(DELETE,yypvt[-0].pe,yypvt[-2].pe);
			} break;
case 272:
# line 1854 "gram.y"
{	binop:	yyval.p = new expr(yypvt[-1].t,yypvt[-2].pe,yypvt[-0].pe); } break;
case 273:
# line 1855 "gram.y"
{	goto binop; } break;
case 274:
# line 1856 "gram.y"
{	goto binop; } break;
case 275:
# line 1857 "gram.y"
{	goto binop; } break;
case 276:
# line 1858 "gram.y"
{	goto binop; } break;
case 277:
# line 1859 "gram.y"
{	goto binop; } break;
case 278:
# line 1860 "gram.y"
{	goto binop; } break;
case 279:
# line 1861 "gram.y"
{ 	goto binop; } break;
case 280:
# line 1862 "gram.y"
{	goto binop; } break;
case 281:
# line 1863 "gram.y"
{	goto binop; } break;
case 282:
# line 1864 "gram.y"
{	goto binop; } break;
case 283:
# line 1865 "gram.y"
{	goto binop; } break;
case 284:
# line 1866 "gram.y"
{	goto binop; } break;
case 285:
# line 1867 "gram.y"
{	goto binop; } break;
case 286:
# line 1868 "gram.y"
{	goto binop; } break;
case 287:
# line 1869 "gram.y"
{	goto binop; } break;
case 288:
# line 1870 "gram.y"
{	goto binop; } break;
case 289:
# line 1872 "gram.y"
{	yyval.p = new qexpr(yypvt[-4].pe,yypvt[-2].pe,yypvt[-0].pe); } break;
case 290:
# line 1874 "gram.y"
{	yyval.p = new expr(DELETE,yypvt[-0].pe,0); } break;
case 291:
# line 1876 "gram.y"
{
				if(yypvt[-2].pe != dummy) {
					if ( warning_opt || strict_opt )
						error(strict_opt?0:'w',"v in `delete[v]' is redundant; use `delete[] instead (anachronism)");
				}
				yyval.p = new expr(DELETE,yypvt[-0].pe,yypvt[-2].pe);
			} break;
case 292:
# line 1884 "gram.y"
{	yyval.p = new expr(GDELETE,yypvt[-0].pe,0); } break;
case 293:
# line 1886 "gram.y"
{
				if(yypvt[-2].pe != dummy) {
					if ( warning_opt || strict_opt )
						error(strict_opt?0:'w',"v in `::delete[v]' is redundant; use `::delete[] instead (anachronism)");
				}
				yyval.p = new expr(DELETE,yypvt[-0].pe,yypvt[-2].pe);
			} break;
case 294:
# line 1893 "gram.y"
{ 
			init_seen = 0; 
			} break;
case 295:
# line 1897 "gram.y"
{	yyval.p = dummy; } break;
case 296:
# line 1900 "gram.y"
{ goto new1; } break;
case 297:
# line 1902 "gram.y"
{	new1:
				Ptype t = yypvt[-0].pn->tp;
				yyval.p = new texpr(NEW,t,0);
			} break;
case 298:
# line 1906 "gram.y"
{ goto new3; } break;
case 299:
# line 1908 "gram.y"
{	new3:
				Ptype t = yypvt[-0].pn->tp;
 				yyval.p = new texpr(GNEW,t,0);
 			} break;
case 300:
# line 1913 "gram.y"
{	yyval.p = new expr(yypvt[-0].t,yypvt[-1].pe,0); } break;
case 301:
# line 1915 "gram.y"
{	yyval.p = new texpr(CAST,yypvt[-1].pn->tp,yypvt[-0].pe); } break;
case 302:
# line 1917 "gram.y"
{	yyval.p = new expr(DEREF,yypvt[-0].pe,0); } break;
case 303:
# line 1919 "gram.y"
{	yyval.p = new expr(ADDROF,0,yypvt[-0].pe); } break;
case 304:
# line 1921 "gram.y"
{	yyval.p = new expr(UMINUS,0,yypvt[-0].pe); } break;
case 305:
# line 1923 "gram.y"
{	yyval.p = new expr(UPLUS,0,yypvt[-0].pe); } break;
case 306:
# line 1925 "gram.y"
{	yyval.p = new expr(NOT,0,yypvt[-0].pe); } break;
case 307:
# line 1927 "gram.y"
{	yyval.p = new expr(COMPL,0,yypvt[-0].pe); } break;
case 308:
# line 1929 "gram.y"
{	yyval.p = new expr(yypvt[-1].t,0,yypvt[-0].pe); } break;
case 309:
# line 1931 "gram.y"
{	
				yyval.p = new texpr(SIZEOF,0,yypvt[-0].pe); 
				in_sizeof = 0;
			} break;
case 310:
# line 1936 "gram.y"
{	
				yyval.p = new texpr(SIZEOF,yypvt[-0].pn->tp,0); 
				in_sizeof = 0;
			} break;
case 311:
# line 1941 "gram.y"
{	yyval.p = new expr(DEREF,yypvt[-3].pe,yypvt[-1].pe); } break;
case 312:
# line 1943 "gram.y"
{	yyval.p = new ref(REF,yypvt[-2].pe,yypvt[-0].pn); } break;
case 313:
# line 1945 "gram.y"
{	yyval.p = new expr(yypvt[-1].t,yypvt[-2].pe,yypvt[-0].pe); } break;
case 314:
# line 1947 "gram.y"
{	yyval.p = new ref(REF,yypvt[-2].pe,Ncopy(yypvt[-0].pn)); } break;
case 315:
# line 1949 "gram.y"
{	yyval.p = new ref(DOT,yypvt[-2].pe,yypvt[-0].pn); } break;
case 316:
# line 1951 "gram.y"
{	yyval.p = new ref(DOT,yypvt[-2].pe,Ncopy(yypvt[-0].pn)); } break;
case 318:
# line 1954 "gram.y"
{
			if ( init_seen )
     				error( "syntax error:IrL illegal within ()");
			} break;
case 319:
# line 1960 "gram.y"
{
				if ( yypvt[-1].p == dummy )
					error("syntax error: nullE");
				yyval.p = yypvt[-1].p;
			} break;
case 320:
# line 1966 "gram.y"
{	yyval.p = zero; } break;
case 321:
# line 1968 "gram.y"
{	yyval.p = new expr(ICON,0,0);
				yyval.pe->string = copy_if_need_be(yypvt[-0].s);
			} break;
case 322:
# line 1972 "gram.y"
{	yyval.p = new expr(FCON,0,0);
				yyval.pe->string = copy_if_need_be(yypvt[-0].s);
			} break;
case 323:
# line 1976 "gram.y"
{	yyval.p = new expr(STRING,0,0);
				yyval.pe->string = copy_if_need_be(yypvt[-0].s);
			} break;
case 324:
# line 1980 "gram.y"
{	yyval.p = new expr(CCON,0,0);
				yyval.pe->string = copy_if_need_be(yypvt[-0].s);
			} break;
case 325:
# line 1984 "gram.y"
{	yyval.p = new expr(THIS,0,0); } break;
case 326:
# line 1988 "gram.y"
{ 	yyval.p = new texpr(VALUE,tok_to_type(yypvt[-3].t),yypvt[-1].pe); } break;
case 327:
# line 1993 "gram.y"
{	yyval.p = new texpr(VALUE,yypvt[-3].pn->tp,yypvt[-1].pe); } break;
case 328:
# line 1994 "gram.y"
{ goto new2; } break;
case 329:
# line 1996 "gram.y"
{	new2:
				Ptype t = yypvt[-0].pn->tp;
				yyval.p=new texpr(NEW,t,0);
				yyval.pe->e2 = yypvt[-2].pe;
			} break;
case 330:
# line 2001 "gram.y"
{ goto new4; } break;
case 331:
# line 2003 "gram.y"
{	new4:
				Ptype t = yypvt[-0].pn->tp;
				yyval.p = new texpr(GNEW,t,0);
				yyval.pe->e2 = yypvt[-2].pe;
			} break;
case 332:
# line 2009 "gram.y"
{	
				Pexpr ee = yypvt[-1].pe;
				Pexpr e = yypvt[-3].pe;
				if (e->base==NEW || e->base==GNEW)
					e->e1 = ee;
				else
					yyval.p = new call(e,ee);
			} break;
case 333:
# line 2021 "gram.y"
{
		    yyval.pn =parametrized_typename(yypvt[-3].pn,(expr_unlist(yypvt[-1].el))); 
	 	 } break;
case 334:
# line 2027 "gram.y"
{       
				yyval.pn = yypvt[-0].pn; 
				curr_scope = yypvt[-0].pn;
			} break;
case 335:
# line 2031 "gram.y"
{ yyval.pn = sta_name; } break;
case 336:
# line 2032 "gram.y"
{ yyval.pn = yypvt[-1].pn; } break;
case 337:
# line 2037 "gram.y"
{	yyval.p = yypvt[-0].pn; } break;
case 338:
# line 2039 "gram.y"
{	yyval.p = Ncopy(yypvt[-0].pn);
				yyval.pn->n_qualifier = yypvt[-1].pn;
			} break;
case 339:
# line 2043 "gram.y"
{	yyval.p = new name(oper_name(yypvt[-0].t));
				yyval.pn->n_oper = yypvt[-0].t;
			} break;
case 340:
# line 2047 "gram.y"
{	yyval.p = new name(oper_name(yypvt[-0].t));
				yyval.pn->n_oper = yypvt[-0].t;
				yyval.pn->n_qualifier = yypvt[-2].pn;
			} break;
case 341:
# line 2052 "gram.y"
{	yyval.p = yypvt[-0].p;
				sig_name(yyval.pn);
			} break;
case 342:
# line 2056 "gram.y"
{	yyval.p = yypvt[-0].p;
				sig_name(yyval.pn);
				yyval.pn->n_qualifier = yypvt[-2].pn;
			} break;
case 343:
# line 2061 "gram.y"
{	
				if (strcmp(yypvt[-2].pn->string,yypvt[-0].pn->string)) error("syntax error: inconsistent destructor notation");
				yyval.p = new name(oper_name(DTOR));
				yyval.pn->n_oper = DTOR;
				yyval.pn->n_qualifier = yypvt[-2].pn;
			} break;
case 344:
# line 2073 "gram.y"
{ yyval.p = Ncast(yypvt[-2].p,yypvt[-1].pn); } break;
case 345:
# line 2076 "gram.y"
{ check_cast(); } break;
case 346:
# line 2080 "gram.y"
{
				TOK t = yypvt[-0].t;

				switch (t) {
				case FRIEND:
				case OVERLOAD:
				case REGISTER:
				case STATIC:
				case EXTERN:
				case AUTO:
				case VIRTUAL:
					error("%k in operatorT",t);
					t = INT;
					
				}

				yyval.p = new basetype(t,0);

			} break;
case 347:
# line 2099 "gram.y"
{ yyval.p = new basetype(TYPE,yypvt[-0].pn); } break;
case 348:
# line 2101 "gram.y"
{ 
				if ( DECL_TYPE != -1 ) {
					switch (yypvt[-1].pb->base) { Pbase bt;
					case COBJ: case EOBJ:
						bt = new basetype(0,0);
						*bt = *yypvt[-1].pb;
						DEL(yypvt[-1].pb);
						yypvt[-1].pb = bt;
					}
					yyval.p = yypvt[-1].pb->type_adj(yypvt[-0].t); 
				}
				DECL_TYPE = 0;
			} break;
case 349:
# line 2115 "gram.y"
{ 
				if ( DECL_TYPE != -1 ) 
			 		yyval.p = yypvt[-1].pb->name_adj(yypvt[-0].pn);
				DECL_TYPE = 0;
			} break;
case 350:
# line 2122 "gram.y"
{ yyval.p = Ncast(yypvt[-1].p,yypvt[-0].pn); } break;
case 351:
# line 2125 "gram.y"
{ yyval.p = Ncast(yypvt[-1].p,yypvt[-0].pn); } break;
case 352:
# line 2128 "gram.y"
{	
                         //      ENTER_NAME(yypvt[-0].pn);
				yyval.p = Ndata(yypvt[-1].p,yypvt[-0].pn); 
			} break;
case 353:
# line 2133 "gram.y"
{
                        //      ENTER_NAME(yypvt[-1].pn);
                        } break;
case 354:
# line 2137 "gram.y"
{       yyval.p = Ndata(yypvt[-4].p,yypvt[-3].pn);
                                yyval.pn->n_initializer = yypvt[-0].pe;
                        } break;
case 355:
# line 2143 "gram.y"
{//PUSH_ARG_SCOPE 
				//SAVE_STATE();
				check_decl(); 
				in_arg_list=1; 
				yyval.pl = modified_tn;
				modified_tn = 0;
			} break;
case 356:
# line 2153 "gram.y"
{
			yyval.p = new fct(0,name_unlist(yypvt[-3].nl),yypvt[-2].t); 
			if ( NEXTTOK() != COLON ) in_arg_list=0;
			//in_arg_list=0;
			Pfct(yyval.pt)->f_const = (yypvt[-0].i & 1);
			if ( parsing_class_members
			||   (NEXTTOK()!=LC && yychar!=COLON)) {
				end_al(yypvt[-4].pl,1);
                        //POP_SCOPE(); // similar to end_al()
			} else
				end_al(yypvt[-4].pl,0);
			//RESTORE_STATE();
		    } break;
case 357:
# line 2169 "gram.y"
{
				if (yypvt[-0].p)
					if (yypvt[-2].p)
						yypvt[-2].nl->add(yypvt[-0].pn);
					else {
						error("AD syntax");
						yyval.nl = new nlist(yypvt[-0].pn); 
					}
				else
					error("AD syntax");
			} break;
case 358:
# line 2181 "gram.y"
{
				if (yypvt[-0].p) yyval.nl = new nlist(yypvt[-0].pn); 
			} break;
case 360:
# line 2187 "gram.y"
{	yyval.p = 0; } break;
case 361:
# line 2191 "gram.y"
{	yyval.t = 1; } break;
case 362:
# line 2193 "gram.y"
{	yyval.t = ELLIPSIS; } break;
case 363:
# line 2195 "gram.y"
{	yyval.t = ELLIPSIS; } break;
case 364:
# line 2199 "gram.y"
{
			yyval.p = new ptr(PTR,0); 
			EXPECT_ID();
			} break;
case 365:
# line 2204 "gram.y"
{
			yyval.p = new ptr(RPTR,0); 
			EXPECT_ID();
			} break;
case 366:
# line 2209 "gram.y"
{	yyval.p = doptr(PTR,yypvt[-0].t); } break;
case 367:
# line 2211 "gram.y"
{	
				switch ( yypvt[-0].t ) {
				case CONST:
                                     yypvt[-1].pp->b_const = 1; break;
				case VOLATILE:
				     error('w',"\"volatile\" not implemented (ignored)");
				     break;
				default:
				    error( "syntax error: *%k", yypvt[-0].t );
				}
				yyval.p = yypvt[-1].pp; 
			} break;
case 368:
# line 2224 "gram.y"
{	yyval.p = doptr(RPTR,yypvt[-0].t); } break;
case 369:
# line 2226 "gram.y"
{	goto memptr1;  } break;
case 370:
# line 2228 "gram.y"
{
			memptr1:
			yyval.p = new ptr(PTR,0);
			yyval.pp->memof = Pclass(Pbase(yypvt[-0].pn->tp)->b_name->tp);
			EXPECT_ID();
			} break;
case 371:
# line 2235 "gram.y"
{	
				yypvt[-1].t = yypvt[-0].t;
				goto memptr2;  
			} break;
case 372:
# line 2240 "gram.y"
{	
				memptr2:
				yyval.p = doptr(PTR,yypvt[-0].t);
				yyval.pp->memof = Pclass(Pbase(yypvt[-1].pn->tp)->b_name->tp);
			} break;
case 373:
# line 2247 "gram.y"
{ yyval.p = new vec(0,yypvt[-1].pe!=dummy?yypvt[-1].pe:0 ); } break;
case 374:
# line 2248 "gram.y"
{ yyval.p = new vec(0,0); } break;
	}
	goto yystack;  /* stack new state and value */
}
