/*
	Program to list symbols from a a.out format file
*/

#include <stdio.h>

#define MAXFILE 80

struct hdr {
	unsigned fmagic;
	unsigned tsize;
	unsigned dsize;
	unsigned bsize;
	unsigned ssize;
	unsigned entry;
	unsigned pad;
	unsigned relflg;
} hdr;

int fd;

main(argc,argv)
int argc;
char **argv;
{
	unsigned n;

	struct symbol {
		char sname[8];
		char stype;
		char spad;
		unsigned svalue;
	} symbol;

	while(--argc) {
		if(**++argv != '-') {
			++argc;
			break;
		}
		switch(tolower(argv[0][1])) {
		default:
			fprintf(stderr,"symdump: unknown flag: %s\n",argv);
			break;
		}
	}

	if(argc != 2) {
		fprintf(stderr,"usage: symdump file\n");
		fprintf(stderr,"argc: %d\n",argc);
		exit(2);
	}

	if((fd = open(*argv,0)) < 0) {
		fprintf(stderr,"symdump: can't open %s for read.\n",*argv);
-		exit(2);
	}
	if(read(fd,&hdr,sizeof hdr) != sizeof hdr) {
		fprintf(stderr,"symdump: error or EOF reading header.\n");
		quit(2);
	}
	
	if(hdr.ssize == 0) {
		fprintf(stderr,"symdump: No symbol table to dump...\n");
		quit(2);
	}

	if(lseek(fd,
	  (long)hdr.tsize*(2-hdr.relflg)+
	  (long)hdr.dsize*(2-hdr.relflg)+0x10,0) < 0) {
		fprintf(stderr,"symdump: error during lseek...\n");
		quit(2);
	}

	for(n=0; n < hdr.ssize; n += sizeof(symbol)) {
		if(read(fd,&symbol,sizeof symbol) != sizeof symbol) {
			fprintf(stderr,"symdump: error reading symbol.\n");
			quit(2);
		}
		printf("%-8.8s %6.6o %4.4x\n",symbol.sname,symbol.svalue,
			symbol.svalue);
	}
}


/*
	Routine to quit and close file
*/
void quit(cc)
int cc;
{
	close(fd);
	exit(cc);
}
