// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package filter

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceAllFilterBackendOKCode is the HTTP code returned for type ReplaceAllFilterBackendOK
const ReplaceAllFilterBackendOKCode int = 200

/*
ReplaceAllFilterBackendOK All Filter lines replaced

swagger:response replaceAllFilterBackendOK
*/
type ReplaceAllFilterBackendOK struct {

	/*
	  In: Body
	*/
	Payload models.Filters `json:"body,omitempty"`
}

// NewReplaceAllFilterBackendOK creates ReplaceAllFilterBackendOK with default headers values
func NewReplaceAllFilterBackendOK() *ReplaceAllFilterBackendOK {

	return &ReplaceAllFilterBackendOK{}
}

// WithPayload adds the payload to the replace all filter backend o k response
func (o *ReplaceAllFilterBackendOK) WithPayload(payload models.Filters) *ReplaceAllFilterBackendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all filter backend o k response
func (o *ReplaceAllFilterBackendOK) SetPayload(payload models.Filters) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllFilterBackendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.Filters{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// ReplaceAllFilterBackendAcceptedCode is the HTTP code returned for type ReplaceAllFilterBackendAccepted
const ReplaceAllFilterBackendAcceptedCode int = 202

/*
ReplaceAllFilterBackendAccepted Configuration change accepted and reload requested

swagger:response replaceAllFilterBackendAccepted
*/
type ReplaceAllFilterBackendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload models.Filters `json:"body,omitempty"`
}

// NewReplaceAllFilterBackendAccepted creates ReplaceAllFilterBackendAccepted with default headers values
func NewReplaceAllFilterBackendAccepted() *ReplaceAllFilterBackendAccepted {

	return &ReplaceAllFilterBackendAccepted{}
}

// WithReloadID adds the reloadId to the replace all filter backend accepted response
func (o *ReplaceAllFilterBackendAccepted) WithReloadID(reloadID string) *ReplaceAllFilterBackendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace all filter backend accepted response
func (o *ReplaceAllFilterBackendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace all filter backend accepted response
func (o *ReplaceAllFilterBackendAccepted) WithPayload(payload models.Filters) *ReplaceAllFilterBackendAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all filter backend accepted response
func (o *ReplaceAllFilterBackendAccepted) SetPayload(payload models.Filters) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllFilterBackendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.Filters{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// ReplaceAllFilterBackendBadRequestCode is the HTTP code returned for type ReplaceAllFilterBackendBadRequest
const ReplaceAllFilterBackendBadRequestCode int = 400

/*
ReplaceAllFilterBackendBadRequest Bad request

swagger:response replaceAllFilterBackendBadRequest
*/
type ReplaceAllFilterBackendBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceAllFilterBackendBadRequest creates ReplaceAllFilterBackendBadRequest with default headers values
func NewReplaceAllFilterBackendBadRequest() *ReplaceAllFilterBackendBadRequest {

	return &ReplaceAllFilterBackendBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace all filter backend bad request response
func (o *ReplaceAllFilterBackendBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceAllFilterBackendBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace all filter backend bad request response
func (o *ReplaceAllFilterBackendBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace all filter backend bad request response
func (o *ReplaceAllFilterBackendBadRequest) WithPayload(payload *models.Error) *ReplaceAllFilterBackendBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all filter backend bad request response
func (o *ReplaceAllFilterBackendBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllFilterBackendBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceAllFilterBackendDefault General Error

swagger:response replaceAllFilterBackendDefault
*/
type ReplaceAllFilterBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceAllFilterBackendDefault creates ReplaceAllFilterBackendDefault with default headers values
func NewReplaceAllFilterBackendDefault(code int) *ReplaceAllFilterBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceAllFilterBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace all filter backend default response
func (o *ReplaceAllFilterBackendDefault) WithStatusCode(code int) *ReplaceAllFilterBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace all filter backend default response
func (o *ReplaceAllFilterBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace all filter backend default response
func (o *ReplaceAllFilterBackendDefault) WithConfigurationVersion(configurationVersion string) *ReplaceAllFilterBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace all filter backend default response
func (o *ReplaceAllFilterBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace all filter backend default response
func (o *ReplaceAllFilterBackendDefault) WithPayload(payload *models.Error) *ReplaceAllFilterBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all filter backend default response
func (o *ReplaceAllFilterBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllFilterBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
