/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.scan;

public enum Severity {
    Normal("Scanned - No Issues", 0),
    Pending("Pending Scan", 1),
    Unknown("Unknown", 2),
    Information("Information", 3),
    Low("Low", 4),
    Medium("Medium", 5),
    High("High", 6),
    Minor("Low", 4),
    Major("Medium", 5),
    Critical("High", 6);

    public static final Severity[] NEW_SEVERITIES;
    private String severityName;
    private int ordinal;

    private Severity(String severityName, int ordinal) {
        this.severityName = severityName;
        this.ordinal = ordinal;
    }

    public String getSeverityName() {
        return this.severityName;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public boolean isHigherThan(Severity other) {
        return this.ordinal > other.getOrdinal();
    }

    public static Severity fromString(String inputSeverity) {
        for (Severity severity : NEW_SEVERITIES) {
            if (!severity.getSeverityName().equals(inputSeverity)) continue;
            return severity;
        }
        switch (inputSeverity) {
            case "Critical": {
                return High;
            }
            case "Major": {
                return Medium;
            }
            case "Minor": {
                return Low;
            }
            case "Normal": {
                return Normal;
            }
        }
        throw new IllegalArgumentException("Severity " + inputSeverity + " doesn't exist");
    }

    static {
        NEW_SEVERITIES = new Severity[]{Normal, Pending, Unknown, Information, Low, Medium, High};
    }
}

