/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.framework.application;

import com.jgoodies.application.Application;
import com.jgoodies.application.ResourceMap;
import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.SystemUtils;
import com.jgoodies.common.promise.Promise;
import com.jgoodies.common.swing.focus.JGLayoutFocusTraversalPolicy;
import com.jgoodies.components.JGComponentFactory;
import com.jgoodies.components.util.TextComponentUtils;
import com.jgoodies.framework.application.GlassPaneBlocker;
import com.jgoodies.framework.osx.OSXUtils;
import com.jgoodies.layout.FormsSetup;
import com.jgoodies.looks.LookUtils;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.EventObject;
import java.util.logging.FileHandler;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.UIManager;

public abstract class JGApplication
extends Application {
    private static final String WINDOWS_APPDATA = "APPDATA";
    private static final String MAC_LIBRARY_APP_SUPPORT = "Library/Application Support";
    private String[] args;
    private File applicationDataDirectory;

    @Override
    protected void startup(String[] args) {
        this.args = args;
        this.preConfiguration();
        this.configureSystemProperties();
        this.configureLogging();
        this.configureUI();
        this.configureHelp();
        this.preCreateAndShowGUI();
        this.createAndShowGUI();
        this.postCreateAndShowGUI();
    }

    @Override
    protected void shutdown() {
        JGApplication.disposeFramesAndWindows();
    }

    protected void preConfiguration() {
    }

    protected void configureSystemProperties() {
        String[] keys;
        ResourceMap resourceMap = JGApplication.getResourceMap();
        for (String key : keys = new String[]{"application.name", "application.fullVersion", "application.vendor", "application.vendor.url", "application.vendor.mail"}) {
            System.setProperty(key, resourceMap.getString(key, new Object[0]));
        }
    }

    protected void configureLogging() {
        String logType = System.getProperty("logging.type", "default");
        String configurationFileName = "resources/logging." + logType + ".properties";
        this.configureLoggingFromProperties(this.getClass().getResource(configurationFileName));
        this.addLogFileHandler(this.getApplicationDataDirectory(), "console%u.log");
    }

    protected void configureHelp() {
    }

    protected void configureUI() {
        OSXUtils.setUseScreenMenuBar(true);
        UIManager.put("ClassLoader", LookUtils.class.getClassLoader());
    }

    protected void preCreateAndShowGUI() {
        FormsSetup.setComponentFactoryDefault(JGComponentFactory.getCurrent());
        JGLayoutFocusTraversalPolicy.installAsDefault();
        this.setDefaultInputBlocker(new GlassPaneBlocker());
    }

    protected void postCreateAndShowGUI() {
    }

    protected final String[] getArgs() {
        return this.args;
    }

    protected static final void disposeFramesAndWindows() {
        Frame[] frames;
        for (Frame frame : frames = Frame.getFrames()) {
            if (frame instanceof JFrame) {
                Window[] ownedWindows;
                JFrame jframe = (JFrame)frame;
                for (Window element : ownedWindows = jframe.getOwnedWindows()) {
                    element.dispose();
                }
            }
            frame.dispose();
        }
    }

    protected abstract void createAndShowGUI();

    @Override
    public Promise<Boolean> exit(EventObject event) {
        TextComponentUtils.commitImmediately();
        return super.exit(event);
    }

    public final File getApplicationDataDirectory() {
        if (this.applicationDataDirectory == null) {
            this.applicationDataDirectory = this.lookupApplicationDataDirectory();
        }
        return this.applicationDataDirectory;
    }

    protected File lookupApplicationDataDirectory() {
        String appPath;
        String vendorPath;
        File baseDir = this.lookupApplicationDataBaseDirectory();
        String vendorId = JGApplication.getResourceMap().getString("application.vendor.id", new Object[0]);
        String appId = JGApplication.getResourceMap().getString("application.id", new Object[0]);
        if (SystemUtils.IS_OS_WINDOWS || SystemUtils.IS_OS_MAC) {
            vendorPath = vendorId;
            appPath = appId;
        } else {
            vendorPath = "." + vendorId.replaceAll("\\s", "").toLowerCase();
            appPath = appId.replaceAll("\\s", "").toLowerCase();
        }
        return new File(new File(baseDir, vendorPath), appPath);
    }

    protected File lookupApplicationDataBaseDirectory() {
        File userHome = new File(System.getProperty("user.home"));
        if (SystemUtils.IS_OS_MAC) {
            return new File(userHome, MAC_LIBRARY_APP_SUPPORT);
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            try {
                String appDataValue = System.getenv(WINDOWS_APPDATA);
                if (appDataValue != null) {
                    return new File(appDataValue);
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return userHome;
    }

    protected void configureLoggingFromProperties(URL configurationURL) {
        Preconditions.checkNotNull(configurationURL, "The %s must not be null.", "configuration URL");
        String errorMessage = "Failed to open the logging configuration URL: " + configurationURL;
        try (InputStream in = configurationURL.openStream();){
            LogManager.getLogManager().readConfiguration(in);
        }
        catch (IOException | SecurityException e) {
            System.err.println(errorMessage);
            e.printStackTrace();
        }
    }

    protected void addLogFileHandler(File logDirectory, String logFilePattern) {
        if (!logDirectory.exists() && !logDirectory.mkdirs()) {
            System.err.println("Failed to create the logfile directory: " + logDirectory);
            return;
        }
        try {
            String pattern = logDirectory.getAbsolutePath() + "/" + logFilePattern;
            FileHandler handler = new FileHandler(pattern);
            Logger.getLogger("").addHandler(handler);
        }
        catch (IOException e) {
            System.err.println("Failed to configure the logging: " + e.getLocalizedMessage());
        }
    }
}

