/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.jdiskreport.gui.application;

import com.jgoodies.app.gui.pages.preferences.PreferencesPage;
import com.jgoodies.application.Action;
import com.jgoodies.application.Application;
import com.jgoodies.application.ResourceMap;
import com.jgoodies.application.TaskBuilder;
import com.jgoodies.common.base.Strings;
import com.jgoodies.common.base.SystemUtils;
import com.jgoodies.common.jsdl.action.ActionBean;
import com.jgoodies.common.swing.internal.AncestorSupport;
import com.jgoodies.dialogs.basics.MessagePaneBuilder;
import com.jgoodies.dialogs.basics.ReturnValue;
import com.jgoodies.dialogs.basics.StandardPaneBuilder;
import com.jgoodies.dialogs.core.PreferredWidth;
import com.jgoodies.dialogs.core.pane.task.TaskPaneBuilder;
import com.jgoodies.dialogs.core.pane.task.TaskPaneWorker;
import com.jgoodies.dialogs.core.util.JSDLUtils;
import com.jgoodies.framework.osx.OSXApplicationMenu;
import com.jgoodies.framework.setup.BasicApplicationPreferences;
import com.jgoodies.jdiskreport.JDiskReport;
import com.jgoodies.jdiskreport.domain.PersistencyManager;
import com.jgoodies.jdiskreport.domain.ScanConfiguration;
import com.jgoodies.jdiskreport.domain.ScanResult;
import com.jgoodies.jdiskreport.domain.scan.ConsoleScanLog;
import com.jgoodies.jdiskreport.domain.scan.Scanner;
import com.jgoodies.jdiskreport.gui.application.JDResources;
import com.jgoodies.jdiskreport.gui.application.JDResultModel;
import com.jgoodies.jdiskreport.gui.application.JDResultPage;
import com.jgoodies.jdiskreport.gui.node.DirectoryNode;
import com.jgoodies.jdiskreport.gui.node.FileNode;
import com.jgoodies.jdiskreport.gui.node.RootNode;
import com.jgoodies.jdiskreport.gui.settings.GUISettings;
import com.jgoodies.jdiskreport.gui.shared.format.JDFormats;
import com.jgoodies.navigation.Page;
import com.jgoodies.navigation.PageFrame;
import com.jgoodies.navigation.PageModel;
import java.awt.Color;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.EventObject;
import java.util.List;
import javax.swing.JFrame;

public final class JDApplicationModel
extends ActionBean {
    static final String ACTION_REFRESH = "Refresh";
    static final String ACTION_SCAN = "Scan";
    static final String ACTION_OPEN_SCAN = "OpenScan";
    static final String ACTION_SAVE_SCAN = "SaveScan";
    static final String ACTION_PREFERENCES = "Preferences";
    static final String ACTION_ABOUT = "About";
    private static JDResources resources = JDResources.getInstance();
    private final GUISettings guiSettings = new GUISettings();
    private BasicApplicationPreferences appPrefs;
    private final PageModel rootPageModel = new PageModel();
    private PreferencesPage prefsPage;
    private JDResultModel resultModel;
    private static final String SCAN_FILENAME_SUFFIX = ".jdr2";

    GUISettings getGuiSettings() {
        return this.guiSettings;
    }

    BasicApplicationPreferences getApplicationPreferences() {
        if (this.appPrefs == null) {
            this.appPrefs = BasicApplicationPreferences.fromUserPreferences();
        }
        return this.appPrefs;
    }

    JDResultModel getResultModel() {
        return this.resultModel;
    }

    Page getPreferencesPage() {
        if (this.prefsPage == null) {
            this.prefsPage = new PreferencesPage.Builder().prefs(this.getApplicationPreferences()).backButtonVisible(true).build();
            ResourceMap rMap = Application.getResourceMap(JDApplicationModel.class);
            URL licenseURL = rMap.getURL("Preferences.license.path");
            try (java.util.Scanner scanner = new java.util.Scanner(licenseURL.openStream(), StandardCharsets.UTF_8.toString());){
                scanner.useDelimiter("\\a");
                String licenseText = scanner.hasNext() ? scanner.next() : "";
                this.prefsPage.setLicenseText(licenseText);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return this.prefsPage;
    }

    void onReady(JFrame frame) {
        this.resultModel = new JDResultModel(RootNode.empty());
        OSXApplicationMenu.register(this::onAboutPerformed, this::onPreferencesPerformed);
        PageFrame content = new PageFrame(this.rootPageModel);
        content.setBackground(Color.WHITE);
        content.setOpaque(true);
        frame.setContentPane(content);
        if (JDiskReport.scanResult != null) {
            this.onScanResult(frame);
            return;
        }
        if (JDiskReport.scanConfiguration != null) {
            this.onScanConfiguration(frame, JDiskReport.scanConfiguration);
            return;
        }
        this.onChoosePath(frame);
    }

    private void onChoosePath(JFrame frame) {
        ReturnValue<File> result;
        while ((result = ((StandardPaneBuilder)new StandardPaneBuilder().owner(frame)).showDirectoryChooser(JDResources.getInstance().chooseDirectoryToScan)).getProceed() && result.getValue() == null) {
        }
        if (result.isCancelled()) {
            Application.getInstance().exit(null);
            return;
        }
        Path scanTarget = JDiskReport.toValidPath(result.getValue().getAbsolutePath());
        this.onScanConfiguration(frame, new ScanConfiguration(scanTarget));
    }

    private void onScanConfiguration(JFrame frame, ScanConfiguration configuration) {
        this.scan(frame, new JDResultPage(this).getPanel(), configuration);
    }

    private void onScanResult(JFrame frame) {
        this.executeCreateAndSetRoot(frame, new JDResultPage(this).getPanel(), JDiskReport.scanResult);
    }

    @Action
    public void onRefreshPerformed(ActionEvent evt) {
        ScanConfiguration configuration = new ScanConfiguration(this.getResultModel().getRootPath());
        this.scan((JFrame)AncestorSupport.getWindowFor(evt), null, configuration);
    }

    @Action
    public void onScanPerformed(ActionEvent evt) {
        ReturnValue<File> result;
        while ((result = ((StandardPaneBuilder)new StandardPaneBuilder().owner(evt)).showDirectoryChooser(JDResources.getInstance().chooseDirectoryToScan)).getProceed() && result.getValue() == null) {
        }
        if (result.isCancelled()) {
            return;
        }
        File directory = result.getValue();
        System.out.println("chosen directory =" + directory.getAbsolutePath());
        this.scan((JFrame)AncestorSupport.getWindowFor(evt), null, new ScanConfiguration(directory.toPath()));
    }

    public static void onOpenFileInFileView(EventObject evt, FileNode node) {
        JDApplicationModel.openPathInFileView(evt, node.getParent().getPathName());
    }

    static void openPathInFileView(EventObject evt, String fileName) {
        if (!SystemUtils.IS_OS_WINDOWS) {
            ((StandardPaneBuilder)new StandardPaneBuilder().owner(evt)).showNotYetAvailable("Open File View (Non-Windows)");
            return;
        }
        String command = "explorer.exe";
        String parameters = String.format("/e,\"%s\"", fileName);
        String fullCommand = command + ' ' + parameters;
        try {
            Runtime.getRuntime().exec(fullCommand);
        }
        catch (IOException ex) {
            System.err.println("Execution error for " + fullCommand);
        }
    }

    static void deleteFolder(EventObject evt, DirectoryNode selection) {
        boolean proceed = ((StandardPaneBuilder)new StandardPaneBuilder().owner(evt)).showRiskyDeleteConfirmation(JDApplicationModel.resources.confirmDeleteFolderFormat, selection.getName(), JDFormats.formatCount(selection.getFileCount()), JDFormats.formatCount(selection.getDirectoryCount()), JDFormats.formatSize(selection.getSize()).replace(' ', '\u202f'));
        if (!proceed) {
            return;
        }
        ((StandardPaneBuilder)new StandardPaneBuilder().owner(evt)).showNotYetImplemented("Delete Folder", null);
    }

    @Action
    public void onOpenScanPerformed(ActionEvent evt) {
        FileDialog fileDialog = new FileDialog((Frame)JSDLUtils.getWindowFor(evt), JDApplicationModel.resources.chooseFileToOpen, 0);
        fileDialog.setFilenameFilter(new ScanFilter());
        fileDialog.setVisible(true);
        String directory = fileDialog.getDirectory();
        if (null == directory) {
            return;
        }
        String filename = fileDialog.getFile();
        if (null == filename) {
            return;
        }
        File inputFile = new File(directory, filename);
        this.executeOpen(evt, inputFile);
    }

    @Action
    public static void onSaveScanPerformed(ActionEvent evt) {
        FileDialog fileDialog = new FileDialog((Frame)JSDLUtils.getWindowFor(evt), JDApplicationModel.resources.chooseFileToSave, 1);
        fileDialog.setFilenameFilter(new ScanFilter());
        fileDialog.setVisible(true);
        String directory = fileDialog.getDirectory();
        if (null == directory) {
            return;
        }
        String filename = fileDialog.getFile();
        if (null == filename) {
            return;
        }
        if (!filename.endsWith(SCAN_FILENAME_SUFFIX)) {
            filename = filename + SCAN_FILENAME_SUFFIX;
        }
        File outputFile = new File(directory, filename);
        JDApplicationModel.executeSave(evt, outputFile, JDiskReport.scanResult);
    }

    @Action
    public void onPreferencesPerformed(ActionEvent evt) {
        this.rootPageModel.navigate(evt, this.getPreferencesPage(), (Object)0);
    }

    @Action
    public void onAboutPerformed(ActionEvent evt) {
        this.rootPageModel.navigate(evt, this.getPreferencesPage(), (Object)2);
    }

    private static void printMemoryUsage() {
        System.gc();
        long free = Runtime.getRuntime().freeMemory();
        long total = Runtime.getRuntime().totalMemory();
        long used = total - free;
        System.out.println("Total memory=" + total / 1024L + "KB");
        System.out.println("Used memory =" + used / 1024L + "KB");
        System.out.flush();
    }

    private void setScanResult(ScanResult result, JFrame frame, Container content) {
        JDiskReport.scanResult = result;
        this.executeCreateAndSetRoot(frame, content, result);
    }

    void scan(JFrame frame, Container content, ScanConfiguration configuration) {
        Scanner scanner = JDiskReport.createScanner();
        ((TaskPaneBuilder)((TaskPaneBuilder)((TaskPaneBuilder)new TaskPaneBuilder().owner(frame)).title("JDiskReport", new Object[0])).mainInstructionText(JDApplicationModel.resources.scanInProgress, new Object[0]).contentText("\u2026", new Object[0]).progressVisible(true).progressIndeterminate(true).preferredWidth(PreferredWidth.MEDIUM)).showDialogAndExecute(new ScanTask(frame, content, scanner, configuration));
    }

    static RootNode createRootFrom(ScanResult result) {
        RootNode root = RootNode.createFrom(result.getSnapshot());
        JDApplicationModel.printMemoryUsage();
        System.out.print("Computing statistics\u2026");
        LocalDateTime t0 = LocalDateTime.now();
        root.computeAndSetStatistics();
        LocalDateTime t1 = LocalDateTime.now();
        System.out.format(" done in %d s\n", Duration.between(t0, t1).toMillis() / 1000L);
        JDApplicationModel.printMemoryUsage();
        System.out.println("Clearing cached files");
        root.clearCachedFiles();
        JDApplicationModel.printMemoryUsage();
        return root;
    }

    private void executeOpen(EventObject evt, File inputFile) {
        new TaskBuilder().inBackgroundDo(() -> PersistencyManager.readScanResult(inputFile)).onSucceeded((context, result) -> {
            if (result == null) {
                context.fail(null);
                return;
            }
            this.setScanResult((ScanResult)result, null, null);
        }).onFailed(cause -> ((MessagePaneBuilder)new MessagePaneBuilder().owner(evt)).mainInstructionText("The scan file could not be opened", new Object[0]).showError()).execute(evt);
    }

    private static void executeSave(EventObject evt, File outputFile, ScanResult scanResult) {
        new TaskBuilder().inBackgroundDo(() -> {
            PersistencyManager.writeScanResult(outputFile, scanResult);
            return null;
        }).onFailed(cause -> ((MessagePaneBuilder)new MessagePaneBuilder().owner(evt)).mainInstructionText("The scan result could not be saved", new Object[0]).showError()).execute(evt);
    }

    void executeCreateAndSetRoot(JFrame frame, Container content, ScanResult scanResult) {
        new TaskBuilder().inBackgroundDo(() -> JDApplicationModel.createRootFrom(scanResult)).onSucceeded(root -> {
            this.rootPageModel.initialPage(new JDResultPage(this));
            this.getResultModel().setRootNode((RootNode)root);
        }).execute(null);
    }

    private static final class ScanFilter
    implements FilenameFilter {
        private ScanFilter() {
        }

        @Override
        public boolean accept(File file, String filename) {
            return filename.endsWith(JDApplicationModel.SCAN_FILENAME_SUFFIX);
        }
    }

    private final class ScanTask
    extends TaskPaneWorker<ScanResult, String> {
        private final JFrame frame;
        private final Container content;
        private final Scanner scanner;
        private final ScanConfiguration configuration;
        private final Scanner.ScanLog scanLog;

        public ScanTask(JFrame frame, Container content, Scanner scanner, ScanConfiguration configuration) {
            this.frame = frame;
            this.content = content;
            this.scanner = scanner;
            this.configuration = configuration;
            this.scanLog = new WorkerScanLog(this);
        }

        void publishDirectory(String name) {
            this.publish(name);
        }

        @Override
        protected void process(List<String> chunks) {
            String last = chunks.get(chunks.size() - 1);
            this.getTaskPane().setContentText(last);
        }

        @Override
        protected ScanResult doInBackground() throws Exception {
            return this.scanner.scan(this.configuration, this.scanLog);
        }

        @Override
        protected void done() {
            try {
                JDApplicationModel.this.setScanResult((ScanResult)this.get(), this.frame, this.content);
            }
            catch (Exception exception) {
            }
            finally {
                this.getTaskPane().close();
            }
        }
    }

    private static final class WorkerScanLog
    extends ConsoleScanLog {
        private static final long LOG_INTERVAL_MILLIS = 500L;
        private final ScanTask worker;
        private long lastLogTime;

        WorkerScanLog(ScanTask worker) {
            this.worker = worker;
            this.lastLogTime = System.currentTimeMillis();
        }

        @Override
        public void logDirectory(File directory, int level) {
            long now = System.currentTimeMillis();
            if (now - this.lastLogTime < 500L) {
                return;
            }
            this.lastLogTime = now;
            this.worker.publishDirectory(Strings.abbreviateCenter(directory.getAbsolutePath(), 60));
        }
    }
}

