/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.jdiskreport.gui.statistic;

import com.jgoodies.application.Application;
import com.jgoodies.application.ResourceMap;
import com.jgoodies.common.base.Preconditions;
import com.jgoodies.jdiskreport.gui.node.FileNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public final class TypeDistribution {
    private static final ResourceMap RESOURCES = Application.getResourceMap(TypeDistribution.class);
    private Map<String, FileType> map = new HashMap<String, FileType>();
    private FileType[] typesBySize;
    private FileType[] typesByCount;
    private long sizeTotal;
    private long countTotal;
    private TableModel tableModelBySize;
    private TableModel tableModelByCount;
    private static final Comparator<FileType> SIZE_COMPARATOR = new SizeComparator();
    private static final Comparator<FileType> COUNT_COMPARATOR = new CountComparator();

    protected TypeDistribution() {
    }

    public TableModel getTableModelBySize() {
        if (this.tableModelBySize == null) {
            this.tableModelBySize = new ArrayDistributionTableModel(this, this.typesBySize);
        }
        return this.tableModelBySize;
    }

    public TableModel getTableModelByCount() {
        if (this.tableModelByCount == null) {
            this.tableModelByCount = new ArrayDistributionTableModel(this, this.typesByCount);
        }
        return this.tableModelByCount;
    }

    long getSizeTotal() {
        return this.sizeTotal;
    }

    long getCountTotal() {
        return this.countTotal;
    }

    String getKeyPrefix() {
        return this.getClass().getSimpleName();
    }

    void add(FileNode fileNode) {
        String suffix = fileNode.getSuffix();
        FileType type = this.map.get(suffix);
        long size = fileNode.getSize();
        long count = fileNode.getFileCount();
        if (type == null) {
            type = new FileType(suffix, size, count);
            this.map.put(suffix, type);
        } else {
            type.add(size);
        }
        this.sizeTotal += size;
        this.countTotal += count;
    }

    void add(TypeDistribution distribution) {
        for (Map.Entry<String, FileType> entry : distribution.map.entrySet()) {
            String entrySuffix = entry.getKey();
            FileType entryType = entry.getValue();
            FileType type = this.map.get(entrySuffix);
            if (type == null) {
                this.map.put(entrySuffix, entryType);
            } else {
                type.add(entryType.size, entryType.count);
            }
            this.sizeTotal += entryType.size;
            this.countTotal += entryType.count;
        }
    }

    public void replaceMapByArrays() {
        int size = this.map.size();
        ArrayList<FileType> types = new ArrayList<FileType>(size);
        types.addAll(this.map.values());
        Collections.sort(types, SIZE_COMPARATOR);
        this.typesBySize = types.toArray(new FileType[types.size()]);
        Collections.sort(types, COUNT_COMPARATOR);
        this.typesByCount = types.toArray(new FileType[types.size()]);
        this.map = null;
    }

    public String toString() {
        TableModel model = this.getTableModelBySize();
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        for (int row = 0; row < model.getRowCount(); ++row) {
            builder.append("\n");
            builder.append(model.getValueAt(row, 0));
            builder.append(": size=");
            builder.append(model.getValueAt(row, 1));
            builder.append("; count=");
            builder.append(model.getValueAt(row, 3));
        }
        builder.append("\nTotal: size=" + this.getSizeTotal());
        builder.append("; count=" + this.getCountTotal());
        return builder.toString();
    }

    static final class ArrayDistributionTableModel
    implements TableModel {
        private static final String[] COLUMN_NAME_KEY_SUFFIXES = new String[]{"title", "size", "sizePercent", "count", "countPercent"};
        private static final Class<?>[] COLUMN_CLASSES = new Class[]{String.class, Long.class, Float.class, Long.class, Float.class};
        private final TypeDistribution distribution;
        private final FileType[] types;
        private final String noExtension;

        ArrayDistributionTableModel(TypeDistribution distribution, FileType[] types) {
            this.distribution = distribution;
            this.types = Preconditions.checkNotNull(types, "The types array must not be null.");
            this.noExtension = RESOURCES.getString("TypeDistribution.noExtension", new Object[0]);
        }

        @Override
        public int getColumnCount() {
            return COLUMN_NAME_KEY_SUFFIXES.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            String key = this.distribution.getKeyPrefix() + ".columnName." + COLUMN_NAME_KEY_SUFFIXES[columnIndex];
            return RESOURCES.getString(key, new Object[0]);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return COLUMN_CLASSES[columnIndex];
        }

        @Override
        public int getRowCount() {
            return this.types.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    String suffix = this.types[rowIndex].suffix;
                    return suffix == null ? this.noExtension : suffix;
                }
                case 1: {
                    return this.types[rowIndex].size;
                }
                case 2: {
                    float size = this.types[rowIndex].size;
                    long sizeTotal = this.distribution.sizeTotal;
                    return Float.valueOf(sizeTotal == 0L ? 1.0f : size / (float)sizeTotal);
                }
                case 3: {
                    return this.types[rowIndex].count;
                }
                case 4: {
                    float count = this.types[rowIndex].count;
                    long countTotal = this.distribution.countTotal;
                    return Float.valueOf(countTotal == 0L ? 1.0f : count / (float)countTotal);
                }
            }
            throw new IllegalStateException("Unknown column index: " + columnIndex);
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            throw new UnsupportedOperationException("Distribution table models are not editable.");
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
        }
    }

    private static final class CountComparator
    implements Comparator<FileType> {
        private CountComparator() {
        }

        @Override
        public int compare(FileType t1, FileType t2) {
            long value1 = t1.count;
            long value2 = t2.count;
            return value1 < value2 ? 1 : (value1 > value2 ? -1 : 0);
        }
    }

    private static final class FileType {
        final String suffix;
        long size;
        long count;

        FileType(String suffix, long size, long count) {
            this.suffix = suffix;
            this.size = size;
            this.count = count;
        }

        void add(long newSize) {
            this.size += newSize;
            ++this.count;
        }

        void add(long newSize, long newCount) {
            this.size += newSize;
            this.count += newCount;
        }
    }

    private static final class SizeComparator
    implements Comparator<FileType> {
        private SizeComparator() {
        }

        @Override
        public int compare(FileType t1, FileType t2) {
            long value1 = t1.size;
            long value2 = t2.size;
            return value1 < value2 ? 1 : (value1 > value2 ? -1 : 0);
        }
    }
}

