/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.domain.taint;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import proguard.analysis.cpa.bam.BamCpa;
import proguard.analysis.cpa.bam.BamTransferRelation;
import proguard.analysis.cpa.bam.BlockAbstraction;
import proguard.analysis.cpa.defaults.NeverAbortOperator;
import proguard.analysis.cpa.defaults.SimpleCpa;
import proguard.analysis.cpa.domain.arg.ArgBamCpaRun;
import proguard.analysis.cpa.domain.arg.ArgProgramLocationDependentAbstractState;
import proguard.analysis.cpa.domain.taint.TaintAbstractState;
import proguard.analysis.cpa.domain.taint.TaintSource;
import proguard.analysis.cpa.interfaces.AbortOperator;
import proguard.analysis.cpa.interfaces.CallEdge;
import proguard.analysis.cpa.interfaces.ReachedSet;
import proguard.analysis.cpa.jvm.cfa.JvmCfa;
import proguard.analysis.cpa.jvm.domain.memory.JvmMemoryLocationAbstractState;
import proguard.analysis.cpa.jvm.domain.memory.JvmMemoryLocationBamCpaRun;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintBamCpaRun;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintSink;
import proguard.analysis.cpa.jvm.state.JvmAbstractState;
import proguard.analysis.cpa.jvm.state.heap.HeapModel;
import proguard.analysis.cpa.jvm.witness.JvmMemoryLocation;
import proguard.classfile.MethodSignature;

public class JvmTaintMemoryLocationBamCpaRun
extends JvmMemoryLocationBamCpaRun<SimpleCpa, TaintAbstractState> {
    private final Collection<? extends JvmTaintSink> taintSinks;
    private Set<JvmMemoryLocation> endPoints;

    public JvmTaintMemoryLocationBamCpaRun(JvmTaintBamCpaRun jvmTaintCpaRun, TaintAbstractState threshold, Collection<? extends JvmTaintSink> taintSinks) {
        super(jvmTaintCpaRun, threshold);
        this.taintSinks = taintSinks;
    }

    public JvmTaintMemoryLocationBamCpaRun(JvmCfa cfa, Set<? extends TaintSource> taintSources, MethodSignature mainSignature, int maxCallStackDepth, HeapModel heapModel, TaintAbstractState threshold, Collection<? extends JvmTaintSink> taintSinks, AbortOperator abortOperator) {
        this(new JvmTaintBamCpaRun(cfa, taintSources, mainSignature, maxCallStackDepth, heapModel, abortOperator), threshold, taintSinks);
    }

    public JvmTaintMemoryLocationBamCpaRun(JvmCfa cfa, Set<? extends TaintSource> taintSources, MethodSignature mainSignature, int maxCallStackDepth, HeapModel heapModel, TaintAbstractState threshold, Collection<? extends JvmTaintSink> taintSinks) {
        this(new JvmTaintBamCpaRun(cfa, taintSources, mainSignature, maxCallStackDepth, heapModel, NeverAbortOperator.INSTANCE), threshold, taintSinks);
    }

    public JvmTaintMemoryLocationBamCpaRun(JvmCfa cfa, Set<? extends TaintSource> taintSources, MethodSignature mainSignature, int maxCallStackDepth, TaintAbstractState threshold, Collection<? extends JvmTaintSink> taintSinks) {
        this(new JvmTaintBamCpaRun(cfa, taintSources, mainSignature, maxCallStackDepth), threshold, taintSinks);
    }

    @Override
    public List<JvmMemoryLocationAbstractState> getInitialStates() {
        return this.getEndPoints().stream().map(JvmMemoryLocationAbstractState::new).collect(Collectors.toList());
    }

    public Set<JvmMemoryLocation> getEndPoints() {
        HashSet<JvmMemoryLocation> memoryLocations = new HashSet<JvmMemoryLocation>();
        Map<String, Set<JvmMemoryLocation>> fqnToLocations = JvmTaintSink.convertSinksToMemoryLocations(this.taintSinks);
        if (this.endPoints != null) {
            return this.endPoints;
        }
        if (this.inputReachedSet == null) {
            this.execute();
            return this.endPoints;
        }
        Stream.concat(((BamTransferRelation)((BamCpa)((ArgBamCpaRun)this.inputCpaRun).getCpa()).getTransferRelation()).getCache().values().stream().map(BlockAbstraction::getReachedSet), Stream.of(this.inputReachedSet)).map(ReachedSet::asCollection).flatMap(Collection::stream).map(s -> (ArgProgramLocationDependentAbstractState)s).forEach(arg -> ((JvmAbstractState)arg.getWrappedState().getStateByName("Jvm")).getProgramLocation().getLeavingEdges().stream().filter(e -> e instanceof CallEdge).map(e -> ((CallEdge)((Object)e)).getCall().getTarget().getFqn()).forEach(fqn -> fqnToLocations.getOrDefault(fqn, Collections.emptySet()).stream().filter(l -> !l.extractValueOrDefault((JvmAbstractState)arg.getWrappedState().getStateByName("Jvm"), TaintAbstractState.bottom).isEmpty()).map(JvmMemoryLocation::copy).peek(l -> l.setArgNode(arg)).forEach(l -> memoryLocations.add((JvmMemoryLocation)l))));
        this.endPoints = memoryLocations;
        return this.endPoints;
    }
}

