/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.constant.visitor;

import proguard.classfile.Clazz;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.DoubleConstant;
import proguard.classfile.constant.DynamicConstant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.FloatConstant;
import proguard.classfile.constant.IntegerConstant;
import proguard.classfile.constant.InterfaceMethodrefConstant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.LongConstant;
import proguard.classfile.constant.MethodHandleConstant;
import proguard.classfile.constant.MethodTypeConstant;
import proguard.classfile.constant.MethodrefConstant;
import proguard.classfile.constant.ModuleConstant;
import proguard.classfile.constant.NameAndTypeConstant;
import proguard.classfile.constant.PackageConstant;
import proguard.classfile.constant.PrimitiveArrayConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;

public class ConstantStringBuilder
implements ConstantVisitor {
    private final StringBuilder stringBuilder;

    public ConstantStringBuilder(StringBuilder stringBuilder) {
        this.stringBuilder = stringBuilder;
    }

    @Override
    public void visitAnyConstant(Clazz clazz, Constant constant) {
        this.stringBuilder.append("Unknown");
    }

    @Override
    public void visitIntegerConstant(Clazz clazz, IntegerConstant integerConstant) {
        this.stringBuilder.append("Integer(" + integerConstant.u4value + ")");
    }

    @Override
    public void visitLongConstant(Clazz clazz, LongConstant longConstant) {
        this.stringBuilder.append("Long(" + longConstant.u8value + ")");
    }

    @Override
    public void visitFloatConstant(Clazz clazz, FloatConstant floatConstant) {
        this.stringBuilder.append("Float(" + floatConstant.f4value + ")");
    }

    @Override
    public void visitDoubleConstant(Clazz clazz, DoubleConstant doubleConstant) {
        this.stringBuilder.append("Double(" + doubleConstant.f8value + ")");
    }

    @Override
    public void visitPrimitiveArrayConstant(Clazz clazz, PrimitiveArrayConstant primitiveArrayConstant) {
        this.stringBuilder.append("PrimitiveArray(" + primitiveArrayConstant.getPrimitiveType() + "[" + primitiveArrayConstant.getLength() + "])");
    }

    @Override
    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        this.stringBuilder.append("String(\"" + stringConstant.getString(clazz) + "\")");
    }

    @Override
    public void visitUtf8Constant(Clazz clazz, Utf8Constant utf8Constant) {
        this.stringBuilder.append("Utf8(\"" + utf8Constant.getString() + "\")");
    }

    @Override
    public void visitDynamicConstant(Clazz clazz, DynamicConstant dynamicConstant) {
        this.stringBuilder.append("Dynamic(");
        clazz.constantPoolEntryAccept(dynamicConstant.u2nameAndTypeIndex, this);
        this.stringBuilder.append(", #" + dynamicConstant.u2bootstrapMethodAttributeIndex + ")");
    }

    @Override
    public void visitInvokeDynamicConstant(Clazz clazz, InvokeDynamicConstant invokeDynamicConstant) {
        this.stringBuilder.append("InvokeDynamic(");
        clazz.constantPoolEntryAccept(invokeDynamicConstant.u2nameAndTypeIndex, this);
        this.stringBuilder.append(", #" + invokeDynamicConstant.u2bootstrapMethodAttributeIndex + ")");
    }

    @Override
    public void visitMethodHandleConstant(Clazz clazz, MethodHandleConstant methodHandleConstant) {
        this.stringBuilder.append("MethodHandle(" + methodHandleConstant.u1referenceKind + ", ");
        clazz.constantPoolEntryAccept(methodHandleConstant.u2referenceIndex, this);
        this.stringBuilder.append(")");
    }

    @Override
    public void visitModuleConstant(Clazz clazz, ModuleConstant moduleConstant) {
        this.stringBuilder.append("Module(" + moduleConstant.getName(clazz) + ")");
    }

    @Override
    public void visitPackageConstant(Clazz clazz, PackageConstant packageConstant) {
        this.stringBuilder.append("Package(" + packageConstant.getName(clazz) + ")");
    }

    @Override
    public void visitFieldrefConstant(Clazz clazz, FieldrefConstant fieldrefConstant) {
        this.stringBuilder.append("Fieldref(" + fieldrefConstant.getClassName(clazz) + "." + fieldrefConstant.getName(clazz) + " " + fieldrefConstant.getType(clazz) + ")");
    }

    @Override
    public void visitInterfaceMethodrefConstant(Clazz clazz, InterfaceMethodrefConstant interfaceMethodrefConstant) {
        this.stringBuilder.append("InterfaceMethodref(" + interfaceMethodrefConstant.getClassName(clazz) + "." + interfaceMethodrefConstant.getName(clazz) + interfaceMethodrefConstant.getType(clazz) + ")");
    }

    @Override
    public void visitMethodrefConstant(Clazz clazz, MethodrefConstant methodrefConstant) {
        this.stringBuilder.append("Methodref(" + methodrefConstant.getClassName(clazz) + "." + methodrefConstant.getName(clazz) + methodrefConstant.getType(clazz) + ")");
    }

    @Override
    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        this.stringBuilder.append("Class(" + classConstant.getName(clazz) + ")");
    }

    @Override
    public void visitMethodTypeConstant(Clazz clazz, MethodTypeConstant methodTypeConstant) {
        this.stringBuilder.append("MethodType(" + methodTypeConstant.getType(clazz) + ")");
    }

    @Override
    public void visitNameAndTypeConstant(Clazz clazz, NameAndTypeConstant nameAndTypeConstant) {
        this.stringBuilder.append("NameAndType(" + nameAndTypeConstant.getName(clazz) + ", " + nameAndTypeConstant.getType(clazz) + ")");
    }
}

