/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.command;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandInvocation;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.InvocableCommand;
import com.velocitypowered.api.command.RawCommand;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.proxy.command.VelocityRawCommandInvocation;
import com.velocitypowered.proxy.command.VelocitySimpleCommandInvocation;
import com.velocitypowered.proxy.util.BrigadierUtils;

@FunctionalInterface
public interface CommandNodeFactory<T extends Command> {
    public static final InvocableCommandNodeFactory<SimpleCommand.Invocation> SIMPLE = new InvocableCommandNodeFactory<SimpleCommand.Invocation>(){

        @Override
        protected SimpleCommand.Invocation createInvocation(CommandContext<CommandSource> context) {
            return VelocitySimpleCommandInvocation.FACTORY.create((CommandContext)context);
        }
    };
    public static final InvocableCommandNodeFactory<RawCommand.Invocation> RAW = new InvocableCommandNodeFactory<RawCommand.Invocation>(){

        @Override
        protected RawCommand.Invocation createInvocation(CommandContext<CommandSource> context) {
            return VelocityRawCommandInvocation.FACTORY.create((CommandContext)context);
        }
    };
    public static final CommandNodeFactory<Command> FALLBACK = (alias, command) -> BrigadierUtils.buildRawArgumentsLiteral(alias, context -> {
        String[] args;
        CommandSource source = (CommandSource)context.getSource();
        if (!command.hasPermission(source, args = BrigadierUtils.getSplitArguments(context))) {
            return -165120983;
        }
        command.execute(source, args);
        return 1;
    }, (context, builder) -> {
        String[] args = BrigadierUtils.getSplitArguments(context);
        if (!command.hasPermission((CommandSource)context.getSource(), args)) {
            return builder.buildFuture();
        }
        return command.suggestAsync((CommandSource)context.getSource(), args).thenApply(values -> {
            for (String value : values) {
                builder.suggest(value);
            }
            return builder.build();
        });
    });

    public LiteralCommandNode<CommandSource> create(String var1, T var2);

    public static abstract class InvocableCommandNodeFactory<I extends CommandInvocation<?>>
    implements CommandNodeFactory<InvocableCommand<I>> {
        @Override
        public LiteralCommandNode<CommandSource> create(String alias, InvocableCommand<I> command) {
            return BrigadierUtils.buildRawArgumentsLiteral(alias, context -> {
                I invocation = this.createInvocation(context);
                if (!command.hasPermission(invocation)) {
                    return -165120983;
                }
                command.execute(invocation);
                return 1;
            }, (context, builder) -> {
                I invocation = this.createInvocation(context);
                if (!command.hasPermission(invocation)) {
                    return builder.buildFuture();
                }
                return command.suggestAsync(invocation).thenApply(values -> {
                    for (String value : values) {
                        builder.suggest(value);
                    }
                    return builder.build();
                });
            });
        }

        protected abstract I createInvocation(CommandContext<CommandSource> var1);
    }
}

