/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.plugin.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.velocitypowered.api.plugin.PluginDescription;
import com.velocitypowered.api.plugin.meta.PluginDependency;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PluginDependencyUtils {
    private PluginDependencyUtils() {
        throw new AssertionError();
    }

    public static List<PluginDescription> sortCandidates(List<PluginDescription> candidates) {
        ArrayList<PluginDescription> sortedCandidates = new ArrayList<PluginDescription>(candidates);
        sortedCandidates.sort(Comparator.comparing(PluginDescription::getId));
        MutableGraph<PluginDescription> graph = GraphBuilder.directed().allowsSelfLoops(false).expectedNodeCount(sortedCandidates.size()).build();
        ImmutableMap candidateMap = Maps.uniqueIndex(sortedCandidates, PluginDescription::getId);
        for (PluginDescription description : sortedCandidates) {
            graph.addNode(description);
            for (PluginDependency dependency : description.getDependencies()) {
                PluginDescription in = (PluginDescription)candidateMap.get(dependency.getId());
                if (in == null) continue;
                graph.putEdge(description, in);
            }
        }
        ArrayList<PluginDescription> sorted = new ArrayList<PluginDescription>();
        HashMap<PluginDescription, Mark> marks = new HashMap<PluginDescription, Mark>();
        for (PluginDescription node : graph.nodes()) {
            PluginDependencyUtils.visitNode(graph, node, marks, sorted, new ArrayDeque<PluginDescription>());
        }
        return sorted;
    }

    private static void visitNode(Graph<PluginDescription> dependencyGraph, PluginDescription node, Map<PluginDescription, Mark> marks, List<PluginDescription> sorted, Deque<PluginDescription> currentIteration) {
        Mark mark = marks.getOrDefault(node, Mark.NOT_VISITED);
        if (mark == Mark.PERMANENT) {
            return;
        }
        if (mark == Mark.TEMPORARY) {
            currentIteration.addLast(node);
            StringBuilder loopGraph = new StringBuilder();
            for (PluginDescription description : currentIteration) {
                loopGraph.append(description.getId());
                loopGraph.append(" -> ");
            }
            loopGraph.setLength(loopGraph.length() - 4);
            throw new IllegalStateException("Circular dependency detected: " + loopGraph.toString());
        }
        currentIteration.addLast(node);
        marks.put(node, Mark.TEMPORARY);
        for (PluginDescription edge : dependencyGraph.successors((Object)node)) {
            PluginDependencyUtils.visitNode(dependencyGraph, edge, marks, sorted, currentIteration);
        }
        marks.put(node, Mark.PERMANENT);
        currentIteration.removeLast();
        sorted.add(node);
    }

    private static enum Mark {
        NOT_VISITED,
        TEMPORARY,
        PERMANENT;

    }
}

