/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet.brigadier;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.packet.brigadier.ArgumentPropertySerializer;
import com.velocitypowered.proxy.protocol.packet.brigadier.ByteArgumentPropertySerializer;
import com.velocitypowered.proxy.protocol.packet.brigadier.DoubleArgumentPropertySerializer;
import com.velocitypowered.proxy.protocol.packet.brigadier.EmptyArgumentPropertySerializer;
import com.velocitypowered.proxy.protocol.packet.brigadier.FloatArgumentPropertySerializer;
import com.velocitypowered.proxy.protocol.packet.brigadier.GenericArgumentPropertySerializer;
import com.velocitypowered.proxy.protocol.packet.brigadier.IntegerArgumentPropertySerializer;
import com.velocitypowered.proxy.protocol.packet.brigadier.LongArgumentPropertySerializer;
import com.velocitypowered.proxy.protocol.packet.brigadier.ModArgumentProperty;
import com.velocitypowered.proxy.protocol.packet.brigadier.ModArgumentPropertySerializer;
import com.velocitypowered.proxy.protocol.packet.brigadier.PassthroughProperty;
import com.velocitypowered.proxy.protocol.packet.brigadier.StringArgumentPropertySerializer;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;

public class ArgumentPropertyRegistry {
    private static final Map<String, ArgumentPropertySerializer<?>> byId = new HashMap();
    private static final Map<Class<? extends ArgumentType>, ArgumentPropertySerializer<?>> byClass = new HashMap();
    private static final Map<Class<? extends ArgumentType>, String> classToId = new HashMap<Class<? extends ArgumentType>, String>();

    private ArgumentPropertyRegistry() {
        throw new AssertionError();
    }

    private static <T extends ArgumentType<?>> void register(String identifier, Class<T> klazz, ArgumentPropertySerializer<T> serializer) {
        byId.put(identifier, serializer);
        byClass.put(klazz, serializer);
        classToId.put(klazz, identifier);
    }

    private static <T> void empty(String identifier) {
        ArgumentPropertyRegistry.empty(identifier, EmptyArgumentPropertySerializer.EMPTY);
    }

    private static <T> void empty(String identifier, ArgumentPropertySerializer<T> serializer) {
        byId.put(identifier, serializer);
    }

    public static ArgumentType<?> deserialize(ByteBuf buf) {
        String identifier = ProtocolUtils.readString(buf);
        ArgumentPropertySerializer<?> serializer = byId.get(identifier);
        if (serializer == null) {
            throw new IllegalArgumentException("Argument type identifier " + identifier + " unknown.");
        }
        Object result = serializer.deserialize(buf);
        if (result instanceof ArgumentType) {
            return (ArgumentType)result;
        }
        return new PassthroughProperty(identifier, serializer, result);
    }

    public static void serialize(ByteBuf buf, ArgumentType<?> type) {
        if (type instanceof PassthroughProperty) {
            PassthroughProperty property = (PassthroughProperty)type;
            ProtocolUtils.writeString(buf, property.getIdentifier());
            if (property.getResult() != null) {
                property.getSerializer().serialize(property.getResult(), buf);
            }
        } else if (type instanceof ModArgumentProperty) {
            ModArgumentProperty property = (ModArgumentProperty)type;
            ProtocolUtils.writeString(buf, property.getIdentifier());
            buf.writeBytes(property.getData());
        } else {
            ArgumentPropertySerializer<?> serializer = byClass.get(type.getClass());
            String id = classToId.get(type.getClass());
            if (serializer == null || id == null) {
                throw new IllegalArgumentException("Don't know how to serialize " + type.getClass().getName());
            }
            ProtocolUtils.writeString(buf, id);
            serializer.serialize(type, buf);
        }
    }

    static {
        ArgumentPropertyRegistry.register("brigadier:string", StringArgumentType.class, StringArgumentPropertySerializer.STRING);
        ArgumentPropertyRegistry.register("brigadier:integer", IntegerArgumentType.class, IntegerArgumentPropertySerializer.INTEGER);
        ArgumentPropertyRegistry.register("brigadier:float", FloatArgumentType.class, FloatArgumentPropertySerializer.FLOAT);
        ArgumentPropertyRegistry.register("brigadier:double", DoubleArgumentType.class, DoubleArgumentPropertySerializer.DOUBLE);
        ArgumentPropertyRegistry.register("brigadier:bool", BoolArgumentType.class, GenericArgumentPropertySerializer.create(BoolArgumentType::bool));
        ArgumentPropertyRegistry.register("brigadier:long", LongArgumentType.class, LongArgumentPropertySerializer.LONG);
        ArgumentPropertyRegistry.register("crossstitch:mod_argument", ModArgumentProperty.class, ModArgumentPropertySerializer.MOD);
        ArgumentPropertyRegistry.empty("minecraft:entity", ByteArgumentPropertySerializer.BYTE);
        ArgumentPropertyRegistry.empty("minecraft:score_holder", ByteArgumentPropertySerializer.BYTE);
        ArgumentPropertyRegistry.empty("minecraft:game_profile");
        ArgumentPropertyRegistry.empty("minecraft:block_pos");
        ArgumentPropertyRegistry.empty("minecraft:column_pos");
        ArgumentPropertyRegistry.empty("minecraft:vec3");
        ArgumentPropertyRegistry.empty("minecraft:vec2");
        ArgumentPropertyRegistry.empty("minecraft:block_state");
        ArgumentPropertyRegistry.empty("minecraft:block_predicate");
        ArgumentPropertyRegistry.empty("minecraft:item_stack");
        ArgumentPropertyRegistry.empty("minecraft:item_predicate");
        ArgumentPropertyRegistry.empty("minecraft:color");
        ArgumentPropertyRegistry.empty("minecraft:component");
        ArgumentPropertyRegistry.empty("minecraft:message");
        ArgumentPropertyRegistry.empty("minecraft:nbt");
        ArgumentPropertyRegistry.empty("minecraft:nbt_compound_tag");
        ArgumentPropertyRegistry.empty("minecraft:nbt_tag");
        ArgumentPropertyRegistry.empty("minecraft:nbt_path");
        ArgumentPropertyRegistry.empty("minecraft:objective");
        ArgumentPropertyRegistry.empty("minecraft:objective_criteria");
        ArgumentPropertyRegistry.empty("minecraft:operation");
        ArgumentPropertyRegistry.empty("minecraft:particle");
        ArgumentPropertyRegistry.empty("minecraft:rotation");
        ArgumentPropertyRegistry.empty("minecraft:scoreboard_slot");
        ArgumentPropertyRegistry.empty("minecraft:swizzle");
        ArgumentPropertyRegistry.empty("minecraft:team");
        ArgumentPropertyRegistry.empty("minecraft:item_slot");
        ArgumentPropertyRegistry.empty("minecraft:resource_location");
        ArgumentPropertyRegistry.empty("minecraft:mob_effect");
        ArgumentPropertyRegistry.empty("minecraft:function");
        ArgumentPropertyRegistry.empty("minecraft:entity_anchor");
        ArgumentPropertyRegistry.empty("minecraft:item_enchantment");
        ArgumentPropertyRegistry.empty("minecraft:entity_summon");
        ArgumentPropertyRegistry.empty("minecraft:dimension");
        ArgumentPropertyRegistry.empty("minecraft:int_range");
        ArgumentPropertyRegistry.empty("minecraft:float_range");
        ArgumentPropertyRegistry.empty("minecraft:time");
        ArgumentPropertyRegistry.empty("minecraft:uuid");
        ArgumentPropertyRegistry.empty("minecraft:angle");
    }
}

