/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.tablist;

import com.google.common.base.Preconditions;
import com.velocitypowered.api.proxy.player.TabList;
import com.velocitypowered.api.proxy.player.TabListEntry;
import com.velocitypowered.api.util.GameProfile;
import com.velocitypowered.proxy.connection.MinecraftConnection;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.protocol.packet.HeaderAndFooter;
import com.velocitypowered.proxy.protocol.packet.PlayerListItem;
import com.velocitypowered.proxy.tablist.VelocityTabListEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.serializer.legacytext3.LegacyText3ComponentSerializer;
import net.kyori.text.Component;
import org.checkerframework.checker.nullness.qual.Nullable;

public class VelocityTabList
implements TabList {
    protected final ConnectedPlayer player;
    protected final MinecraftConnection connection;
    protected final Map<UUID, VelocityTabListEntry> entries = new ConcurrentHashMap<UUID, VelocityTabListEntry>();

    public VelocityTabList(ConnectedPlayer player) {
        this.player = player;
        this.connection = player.getConnection();
    }

    @Override
    @Deprecated
    public void setHeaderAndFooter(Component header, Component footer) {
        Preconditions.checkNotNull(header, "header");
        Preconditions.checkNotNull(footer, "footer");
        this.player.sendPlayerListHeaderAndFooter(LegacyText3ComponentSerializer.get().deserialize(header), LegacyText3ComponentSerializer.get().deserialize(footer));
    }

    @Override
    @Deprecated
    public void setHeaderAndFooter(net.kyori.adventure.text.Component header, net.kyori.adventure.text.Component footer) {
        Preconditions.checkNotNull(header, "header");
        Preconditions.checkNotNull(footer, "footer");
        this.player.sendPlayerListHeaderAndFooter(header, footer);
    }

    @Override
    public void clearHeaderAndFooter() {
        this.connection.write(HeaderAndFooter.reset());
    }

    @Override
    public void addEntry(TabListEntry entry) {
        Preconditions.checkNotNull(entry, "entry");
        Preconditions.checkArgument(entry.getTabList().equals(this), "The provided entry was not created by this tab list");
        Preconditions.checkArgument(!this.entries.containsKey(entry.getProfile().getId()), "this TabList already contains an entry with the same uuid");
        Preconditions.checkArgument(entry instanceof VelocityTabListEntry, "Not a Velocity tab list entry");
        PlayerListItem.Item packetItem = PlayerListItem.Item.from(entry);
        this.connection.write(new PlayerListItem(0, Collections.singletonList(packetItem)));
        this.entries.put(entry.getProfile().getId(), (VelocityTabListEntry)entry);
    }

    @Override
    public Optional<TabListEntry> removeEntry(UUID uuid) {
        Preconditions.checkNotNull(uuid, "uuid");
        TabListEntry entry = this.entries.remove(uuid);
        if (entry != null) {
            PlayerListItem.Item packetItem = PlayerListItem.Item.from(entry);
            this.connection.write(new PlayerListItem(4, Collections.singletonList(packetItem)));
        }
        return Optional.ofNullable(entry);
    }

    @Override
    public boolean containsEntry(UUID uuid) {
        Preconditions.checkNotNull(uuid, "uuid");
        return this.entries.containsKey(uuid);
    }

    public void clearAll() {
        Collection<VelocityTabListEntry> listEntries = this.entries.values();
        if (listEntries.isEmpty()) {
            return;
        }
        ArrayList<PlayerListItem.Item> items = new ArrayList<PlayerListItem.Item>(listEntries.size());
        for (TabListEntry tabListEntry : listEntries) {
            items.add(PlayerListItem.Item.from(tabListEntry));
        }
        this.entries.clear();
        this.connection.delayedWrite(new PlayerListItem(4, items));
    }

    @Override
    public Collection<TabListEntry> getEntries() {
        return Collections.unmodifiableCollection(this.entries.values());
    }

    @Override
    public TabListEntry buildEntry(GameProfile profile, @Nullable net.kyori.adventure.text.Component displayName, int latency, int gameMode) {
        return new VelocityTabListEntry(this, profile, displayName, latency, gameMode);
    }

    public void processBackendPacket(PlayerListItem packet) {
        for (PlayerListItem.Item item : packet.getItems()) {
            UUID uuid = item.getUuid();
            assert (uuid != null) : "1.7 tab list entry given to modern tab list handler!";
            if (packet.getAction() != 0 && !this.entries.containsKey(uuid)) continue;
            switch (packet.getAction()) {
                case 0: {
                    String name = item.getName();
                    List<GameProfile.Property> properties = item.getProperties();
                    if (name == null || properties == null) {
                        throw new IllegalStateException("Got null game profile for ADD_PLAYER");
                    }
                    this.entries.put(item.getUuid(), (VelocityTabListEntry)TabListEntry.builder().tabList(this).profile(new GameProfile(uuid, name, properties)).displayName(item.getDisplayName()).latency(item.getLatency()).gameMode(item.getGameMode()).build());
                    break;
                }
                case 4: {
                    this.entries.remove(uuid);
                    break;
                }
                case 3: {
                    VelocityTabListEntry entry = this.entries.get(uuid);
                    if (entry == null) break;
                    entry.setDisplayNameInternal(item.getDisplayName());
                    break;
                }
                case 2: {
                    VelocityTabListEntry entry = this.entries.get(uuid);
                    if (entry == null) break;
                    entry.setLatencyInternal(item.getLatency());
                    break;
                }
                case 1: {
                    VelocityTabListEntry entry = this.entries.get(uuid);
                    if (entry == null) break;
                    entry.setGameModeInternal(item.getGameMode());
                    break;
                }
            }
        }
    }

    void updateEntry(int action, TabListEntry entry) {
        if (this.entries.containsKey(entry.getProfile().getId())) {
            PlayerListItem.Item packetItem = PlayerListItem.Item.from(entry);
            this.connection.write(new PlayerListItem(action, Collections.singletonList(packetItem)));
        }
    }
}

