/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.util.bossbar;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.util.bossbar.BossBar;
import com.velocitypowered.api.util.bossbar.BossBarColor;
import com.velocitypowered.api.util.bossbar.BossBarFlag;
import com.velocitypowered.api.util.bossbar.BossBarOverlay;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.kyori.text.Component;
import net.kyori.text.serializer.gson.GsonComponentSerializer;

public class VelocityBossBar
implements BossBar {
    private final List<Player> players;
    private final Set<BossBarFlag> flags;
    private final UUID uuid;
    private boolean visible;
    private Component title;
    private float percent;
    private BossBarColor color;
    private BossBarOverlay overlay;

    public VelocityBossBar(Component title, BossBarColor color, BossBarOverlay overlay, float percent) {
        this.title = Preconditions.checkNotNull(title, "title");
        this.color = Preconditions.checkNotNull(color, "color");
        this.overlay = Preconditions.checkNotNull(overlay, "overlay");
        this.percent = percent;
        this.checkPercent(percent);
        this.uuid = UUID.randomUUID();
        this.visible = true;
        this.players = new ArrayList<Player>();
        this.flags = EnumSet.noneOf(BossBarFlag.class);
    }

    @Override
    public void addPlayers(Iterable<Player> players) {
        Preconditions.checkNotNull(players, "players");
        for (Player player : players) {
            this.addPlayer(player);
        }
    }

    @Override
    public void addPlayer(Player player) {
        Preconditions.checkNotNull(player, "player");
        if (!this.players.contains(player)) {
            this.players.add(player);
        }
        if (player.isActive() && this.visible) {
            this.sendPacket(player, this.addPacket());
        }
    }

    @Override
    public void removePlayer(Player player) {
        Preconditions.checkNotNull(player, "player");
        this.players.remove(player);
        if (player.isActive()) {
            this.sendPacket(player, this.removePacket());
        }
    }

    @Override
    public void removePlayers(Iterable<Player> players) {
        Preconditions.checkNotNull(players, "players");
        for (Player player : players) {
            this.removePlayer(player);
        }
    }

    @Override
    public void removeAllPlayers() {
        this.removePlayers(ImmutableList.copyOf(this.players));
    }

    @Override
    public Component getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(Component title) {
        this.title = Preconditions.checkNotNull(title, "title");
        if (this.visible) {
            com.velocitypowered.proxy.protocol.packet.BossBar bar = new com.velocitypowered.proxy.protocol.packet.BossBar();
            bar.setUuid(this.uuid);
            bar.setAction(3);
            bar.setName(GsonComponentSerializer.INSTANCE.serialize(title));
            this.sendToAffected(bar);
        }
    }

    @Override
    public float getPercent() {
        return this.percent;
    }

    @Override
    public void setPercent(float percent) {
        this.checkPercent(percent);
        this.percent = percent;
        if (this.visible) {
            com.velocitypowered.proxy.protocol.packet.BossBar bar = new com.velocitypowered.proxy.protocol.packet.BossBar();
            bar.setUuid(this.uuid);
            bar.setAction(2);
            bar.setPercent(percent);
            this.sendToAffected(bar);
        }
    }

    private void checkPercent(float percent) {
        if (percent < 0.0f || percent > 1.0f) {
            throw new IllegalArgumentException("Percent must be between 0 and 1");
        }
    }

    @Override
    public Collection<Player> getPlayers() {
        return ImmutableList.copyOf(this.players);
    }

    @Override
    public BossBarColor getColor() {
        return this.color;
    }

    @Override
    public void setColor(BossBarColor color) {
        this.color = Preconditions.checkNotNull(color, "color");
        if (this.visible) {
            this.sendDivisions(color, this.overlay);
        }
    }

    @Override
    public BossBarOverlay getOverlay() {
        return this.overlay;
    }

    @Override
    public void setOverlay(BossBarOverlay overlay) {
        this.overlay = Preconditions.checkNotNull(overlay, "overlay");
        if (this.visible) {
            this.sendDivisions(this.color, overlay);
        }
    }

    private void sendDivisions(BossBarColor color, BossBarOverlay overlay) {
        com.velocitypowered.proxy.protocol.packet.BossBar bar = new com.velocitypowered.proxy.protocol.packet.BossBar();
        bar.setUuid(this.uuid);
        bar.setAction(4);
        bar.setColor(color.ordinal());
        bar.setOverlay(overlay.ordinal());
        this.sendToAffected(bar);
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        boolean previous = this.visible;
        if (previous && !visible) {
            this.sendToAffected(this.removePacket());
        } else if (!previous && visible) {
            this.sendToAffected(this.addPacket());
        }
        this.visible = visible;
    }

    @Override
    public Collection<BossBarFlag> getFlags() {
        return ImmutableList.copyOf(this.flags);
    }

    @Override
    public void addFlags(BossBarFlag ... flags) {
        if (this.flags.addAll(Arrays.asList(flags)) && this.visible) {
            this.sendToAffected(this.updateFlags());
        }
    }

    @Override
    public void removeFlag(BossBarFlag flag) {
        Preconditions.checkNotNull(flag, "flag");
        if (this.flags.remove((Object)flag) && this.visible) {
            this.sendToAffected(this.updateFlags());
        }
    }

    @Override
    public void removeFlags(BossBarFlag ... flags) {
        if (this.flags.removeAll(Arrays.asList(flags)) && this.visible) {
            this.sendToAffected(this.updateFlags());
        }
    }

    private short serializeFlags() {
        short flagMask = 0;
        if (this.flags.contains((Object)BossBarFlag.DARKEN_SCREEN)) {
            flagMask = (short)(flagMask | 1);
        }
        if (this.flags.contains((Object)BossBarFlag.PLAY_BOSS_MUSIC)) {
            flagMask = (short)(flagMask | 2);
        }
        if (this.flags.contains((Object)BossBarFlag.CREATE_WORLD_FOG)) {
            flagMask = (short)(flagMask | 4);
        }
        return flagMask;
    }

    private com.velocitypowered.proxy.protocol.packet.BossBar addPacket() {
        com.velocitypowered.proxy.protocol.packet.BossBar bossBar = new com.velocitypowered.proxy.protocol.packet.BossBar();
        bossBar.setUuid(this.uuid);
        bossBar.setAction(0);
        bossBar.setName(GsonComponentSerializer.INSTANCE.serialize(this.title));
        bossBar.setColor(this.color.ordinal());
        bossBar.setOverlay(this.overlay.ordinal());
        bossBar.setPercent(this.percent);
        bossBar.setFlags(this.serializeFlags());
        return bossBar;
    }

    private com.velocitypowered.proxy.protocol.packet.BossBar removePacket() {
        com.velocitypowered.proxy.protocol.packet.BossBar bossBar = new com.velocitypowered.proxy.protocol.packet.BossBar();
        bossBar.setUuid(this.uuid);
        bossBar.setAction(1);
        return bossBar;
    }

    private com.velocitypowered.proxy.protocol.packet.BossBar updateFlags() {
        com.velocitypowered.proxy.protocol.packet.BossBar bossBar = new com.velocitypowered.proxy.protocol.packet.BossBar();
        bossBar.setUuid(this.uuid);
        bossBar.setAction(5);
        bossBar.setFlags(this.serializeFlags());
        return bossBar;
    }

    private void sendToAffected(MinecraftPacket packet) {
        for (Player player : this.players) {
            if (!player.isActive() || player.getProtocolVersion().getProtocol() < ProtocolVersion.MINECRAFT_1_9.getProtocol()) continue;
            this.sendPacket(player, packet);
        }
    }

    private void sendPacket(Player player, MinecraftPacket packet) {
        ConnectedPlayer connected = (ConnectedPlayer)player;
        connected.getConnection().write(packet);
    }
}

