// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/deployment_resource_pool_service.proto

#include "google/cloud/aiplatform/v1/deployment_resource_pool_connection.h"
#include "google/cloud/aiplatform/v1/deployment_resource_pool_options.h"
#include "google/cloud/aiplatform/v1/internal/deployment_resource_pool_connection_impl.h"
#include "google/cloud/aiplatform/v1/internal/deployment_resource_pool_option_defaults.h"
#include "google/cloud/aiplatform/v1/internal/deployment_resource_pool_stub_factory.h"
#include "google/cloud/aiplatform/v1/internal/deployment_resource_pool_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace aiplatform_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DeploymentResourcePoolServiceConnection::
    ~DeploymentResourcePoolServiceConnection() = default;

future<StatusOr<google::cloud::aiplatform::v1::DeploymentResourcePool>>
DeploymentResourcePoolServiceConnection::CreateDeploymentResourcePool(
    google::cloud::aiplatform::v1::CreateDeploymentResourcePoolRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::DeploymentResourcePool>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
DeploymentResourcePoolServiceConnection::CreateDeploymentResourcePool(
    NoAwaitTag,
    google::cloud::aiplatform::v1::CreateDeploymentResourcePoolRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::DeploymentResourcePool>>
DeploymentResourcePoolServiceConnection::CreateDeploymentResourcePool(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::DeploymentResourcePool>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::aiplatform::v1::DeploymentResourcePool>
DeploymentResourcePoolServiceConnection::GetDeploymentResourcePool(
    google::cloud::aiplatform::v1::GetDeploymentResourcePoolRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::aiplatform::v1::DeploymentResourcePool>
DeploymentResourcePoolServiceConnection::ListDeploymentResourcePools(
    google::cloud::aiplatform::v1::
        ListDeploymentResourcePoolsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::aiplatform::v1::DeploymentResourcePool>>();
}

future<StatusOr<google::cloud::aiplatform::v1::DeploymentResourcePool>>
DeploymentResourcePoolServiceConnection::UpdateDeploymentResourcePool(
    google::cloud::aiplatform::v1::UpdateDeploymentResourcePoolRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::DeploymentResourcePool>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
DeploymentResourcePoolServiceConnection::UpdateDeploymentResourcePool(
    NoAwaitTag,
    google::cloud::aiplatform::v1::UpdateDeploymentResourcePoolRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::DeploymentResourcePool>>
DeploymentResourcePoolServiceConnection::UpdateDeploymentResourcePool(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::DeploymentResourcePool>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
DeploymentResourcePoolServiceConnection::DeleteDeploymentResourcePool(
    google::cloud::aiplatform::v1::DeleteDeploymentResourcePoolRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
DeploymentResourcePoolServiceConnection::DeleteDeploymentResourcePool(
    NoAwaitTag,
    google::cloud::aiplatform::v1::DeleteDeploymentResourcePoolRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
DeploymentResourcePoolServiceConnection::DeleteDeploymentResourcePool(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

std::shared_ptr<DeploymentResourcePoolServiceConnection>
MakeDeploymentResourcePoolServiceConnection(std::string const& location,
                                            Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 DeploymentResourcePoolServicePolicyOptionList>(
      options, __func__);
  options = aiplatform_v1_internal::DeploymentResourcePoolServiceDefaultOptions(
      location, std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub =
      aiplatform_v1_internal::CreateDefaultDeploymentResourcePoolServiceStub(
          std::move(auth), options);
  return aiplatform_v1_internal::
      MakeDeploymentResourcePoolServiceTracingConnection(
          std::make_shared<aiplatform_v1_internal::
                               DeploymentResourcePoolServiceConnectionImpl>(
              std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1
}  // namespace cloud
}  // namespace google
