// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/cloudcontrolspartner/v1/core.proto

#include "google/cloud/cloudcontrolspartner/v1/cloud_controls_partner_core_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace cloudcontrolspartner_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

CloudControlsPartnerCoreConnectionIdempotencyPolicy::
    ~CloudControlsPartnerCoreConnectionIdempotencyPolicy() = default;

std::unique_ptr<CloudControlsPartnerCoreConnectionIdempotencyPolicy>
CloudControlsPartnerCoreConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<CloudControlsPartnerCoreConnectionIdempotencyPolicy>(
      *this);
}

Idempotency CloudControlsPartnerCoreConnectionIdempotencyPolicy::GetWorkload(
    google::cloud::cloudcontrolspartner::v1::GetWorkloadRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency CloudControlsPartnerCoreConnectionIdempotencyPolicy::ListWorkloads(
    google::cloud::cloudcontrolspartner::v1::ListWorkloadsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency CloudControlsPartnerCoreConnectionIdempotencyPolicy::GetCustomer(
    google::cloud::cloudcontrolspartner::v1::GetCustomerRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency CloudControlsPartnerCoreConnectionIdempotencyPolicy::ListCustomers(
    google::cloud::cloudcontrolspartner::v1::ListCustomersRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency
CloudControlsPartnerCoreConnectionIdempotencyPolicy::GetEkmConnections(
    google::cloud::cloudcontrolspartner::v1::GetEkmConnectionsRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency
CloudControlsPartnerCoreConnectionIdempotencyPolicy::GetPartnerPermissions(
    google::cloud::cloudcontrolspartner::v1::
        GetPartnerPermissionsRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency
CloudControlsPartnerCoreConnectionIdempotencyPolicy::ListAccessApprovalRequests(
    google::cloud::cloudcontrolspartner::v1::
        ListAccessApprovalRequestsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency CloudControlsPartnerCoreConnectionIdempotencyPolicy::GetPartner(
    google::cloud::cloudcontrolspartner::v1::GetPartnerRequest const&) {
  return Idempotency::kIdempotent;
}

std::unique_ptr<CloudControlsPartnerCoreConnectionIdempotencyPolicy>
MakeDefaultCloudControlsPartnerCoreConnectionIdempotencyPolicy() {
  return std::make_unique<
      CloudControlsPartnerCoreConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace cloudcontrolspartner_v1
}  // namespace cloud
}  // namespace google
