// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/cloudcontrolspartner/v1/monitoring.proto

#include "google/cloud/cloudcontrolspartner/v1/cloud_controls_partner_monitoring_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace cloudcontrolspartner_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

CloudControlsPartnerMonitoringClient::CloudControlsPartnerMonitoringClient(
    std::shared_ptr<CloudControlsPartnerMonitoringConnection> connection,
    Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
CloudControlsPartnerMonitoringClient::~CloudControlsPartnerMonitoringClient() =
    default;

StreamRange<google::cloud::cloudcontrolspartner::v1::Violation>
CloudControlsPartnerMonitoringClient::ListViolations(std::string const& parent,
                                                     Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cloudcontrolspartner::v1::ListViolationsRequest request;
  request.set_parent(parent);
  return connection_->ListViolations(request);
}

StreamRange<google::cloud::cloudcontrolspartner::v1::Violation>
CloudControlsPartnerMonitoringClient::ListViolations(
    google::cloud::cloudcontrolspartner::v1::ListViolationsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListViolations(std::move(request));
}

StatusOr<google::cloud::cloudcontrolspartner::v1::Violation>
CloudControlsPartnerMonitoringClient::GetViolation(std::string const& name,
                                                   Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cloudcontrolspartner::v1::GetViolationRequest request;
  request.set_name(name);
  return connection_->GetViolation(request);
}

StatusOr<google::cloud::cloudcontrolspartner::v1::Violation>
CloudControlsPartnerMonitoringClient::GetViolation(
    google::cloud::cloudcontrolspartner::v1::GetViolationRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetViolation(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace cloudcontrolspartner_v1
}  // namespace cloud
}  // namespace google
