// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/compute/global_forwarding_rules/v1/global_forwarding_rules.proto

#include "google/cloud/compute/global_forwarding_rules/v1/internal/global_forwarding_rules_option_defaults.h"
#include "google/cloud/compute/global_forwarding_rules/v1/global_forwarding_rules_connection.h"
#include "google/cloud/compute/global_forwarding_rules/v1/global_forwarding_rules_options.h"
#include "google/cloud/internal/populate_common_options.h"
#include "google/cloud/internal/populate_grpc_options.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_global_forwarding_rules_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

namespace {
auto constexpr kBackoffScaling = 2.0;
}  // namespace

Options GlobalForwardingRulesDefaultOptions(Options options) {
  options = internal::PopulateCommonOptions(
      std::move(options), "GOOGLE_CLOUD_CPP_GLOBAL_FORWARDING_RULES_ENDPOINT",
      "", "GOOGLE_CLOUD_CPP_GLOBAL_FORWARDING_RULES_AUTHORITY",
      "compute.googleapis.com");
  options = internal::PopulateGrpcOptions(std::move(options));
  if (!options.has<compute_global_forwarding_rules_v1::
                       GlobalForwardingRulesRetryPolicyOption>()) {
    options.set<compute_global_forwarding_rules_v1::
                    GlobalForwardingRulesRetryPolicyOption>(
        compute_global_forwarding_rules_v1::
            GlobalForwardingRulesLimitedTimeRetryPolicy(
                std::chrono::minutes(30))
                .clone());
  }
  if (!options.has<compute_global_forwarding_rules_v1::
                       GlobalForwardingRulesBackoffPolicyOption>()) {
    options.set<compute_global_forwarding_rules_v1::
                    GlobalForwardingRulesBackoffPolicyOption>(
        ExponentialBackoffPolicy(
            std::chrono::seconds(0), std::chrono::seconds(1),
            std::chrono::minutes(5), kBackoffScaling, kBackoffScaling)
            .clone());
  }
  if (!options.has<compute_global_forwarding_rules_v1::
                       GlobalForwardingRulesPollingPolicyOption>()) {
    options.set<compute_global_forwarding_rules_v1::
                    GlobalForwardingRulesPollingPolicyOption>(
        GenericPollingPolicy<
            compute_global_forwarding_rules_v1::
                GlobalForwardingRulesRetryPolicyOption::Type,
            compute_global_forwarding_rules_v1::
                GlobalForwardingRulesBackoffPolicyOption::Type>(
            options
                .get<compute_global_forwarding_rules_v1::
                         GlobalForwardingRulesRetryPolicyOption>()
                ->clone(),
            ExponentialBackoffPolicy(std::chrono::seconds(1),
                                     std::chrono::minutes(5), kBackoffScaling)
                .clone())
            .clone());
  }
  if (!options
           .has<compute_global_forwarding_rules_v1::
                    GlobalForwardingRulesConnectionIdempotencyPolicyOption>()) {
    options.set<compute_global_forwarding_rules_v1::
                    GlobalForwardingRulesConnectionIdempotencyPolicyOption>(
        compute_global_forwarding_rules_v1::
            MakeDefaultGlobalForwardingRulesConnectionIdempotencyPolicy());
  }

  return options;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_global_forwarding_rules_v1_internal
}  // namespace cloud
}  // namespace google
