// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/managedidentities/v1/managed_identities_service.proto

#include "google/cloud/managedidentities/v1/managed_identities_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace managedidentities_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

ManagedIdentitiesServiceConnectionIdempotencyPolicy::
    ~ManagedIdentitiesServiceConnectionIdempotencyPolicy() = default;

std::unique_ptr<ManagedIdentitiesServiceConnectionIdempotencyPolicy>
ManagedIdentitiesServiceConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<ManagedIdentitiesServiceConnectionIdempotencyPolicy>(
      *this);
}

Idempotency
ManagedIdentitiesServiceConnectionIdempotencyPolicy::CreateMicrosoftAdDomain(
    google::cloud::managedidentities::v1::
        CreateMicrosoftAdDomainRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
ManagedIdentitiesServiceConnectionIdempotencyPolicy::ResetAdminPassword(
    google::cloud::managedidentities::v1::ResetAdminPasswordRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ManagedIdentitiesServiceConnectionIdempotencyPolicy::ListDomains(
    google::cloud::managedidentities::v1::ListDomainsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency ManagedIdentitiesServiceConnectionIdempotencyPolicy::GetDomain(
    google::cloud::managedidentities::v1::GetDomainRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency ManagedIdentitiesServiceConnectionIdempotencyPolicy::UpdateDomain(
    google::cloud::managedidentities::v1::UpdateDomainRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ManagedIdentitiesServiceConnectionIdempotencyPolicy::DeleteDomain(
    google::cloud::managedidentities::v1::DeleteDomainRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ManagedIdentitiesServiceConnectionIdempotencyPolicy::AttachTrust(
    google::cloud::managedidentities::v1::AttachTrustRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
ManagedIdentitiesServiceConnectionIdempotencyPolicy::ReconfigureTrust(
    google::cloud::managedidentities::v1::ReconfigureTrustRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ManagedIdentitiesServiceConnectionIdempotencyPolicy::DetachTrust(
    google::cloud::managedidentities::v1::DetachTrustRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ManagedIdentitiesServiceConnectionIdempotencyPolicy::ValidateTrust(
    google::cloud::managedidentities::v1::ValidateTrustRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<ManagedIdentitiesServiceConnectionIdempotencyPolicy>
MakeDefaultManagedIdentitiesServiceConnectionIdempotencyPolicy() {
  return std::make_unique<
      ManagedIdentitiesServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace managedidentities_v1
}  // namespace cloud
}  // namespace google
