// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package acl

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetAllACLFrontendOKCode is the HTTP code returned for type GetAllACLFrontendOK
const GetAllACLFrontendOKCode int = 200

/*
GetAllACLFrontendOK Successful operation

swagger:response getAllAclFrontendOK
*/
type GetAllACLFrontendOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload models.Acls `json:"body,omitempty"`
}

// NewGetAllACLFrontendOK creates GetAllACLFrontendOK with default headers values
func NewGetAllACLFrontendOK() *GetAllACLFrontendOK {

	return &GetAllACLFrontendOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get all Acl frontend o k response
func (o *GetAllACLFrontendOK) WithConfigurationVersion(configurationVersion string) *GetAllACLFrontendOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all Acl frontend o k response
func (o *GetAllACLFrontendOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all Acl frontend o k response
func (o *GetAllACLFrontendOK) WithPayload(payload models.Acls) *GetAllACLFrontendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all Acl frontend o k response
func (o *GetAllACLFrontendOK) SetPayload(payload models.Acls) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllACLFrontendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.Acls{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

/*
GetAllACLFrontendDefault General Error

swagger:response getAllAclFrontendDefault
*/
type GetAllACLFrontendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetAllACLFrontendDefault creates GetAllACLFrontendDefault with default headers values
func NewGetAllACLFrontendDefault(code int) *GetAllACLFrontendDefault {
	if code <= 0 {
		code = 500
	}

	return &GetAllACLFrontendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get all Acl frontend default response
func (o *GetAllACLFrontendDefault) WithStatusCode(code int) *GetAllACLFrontendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get all Acl frontend default response
func (o *GetAllACLFrontendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get all Acl frontend default response
func (o *GetAllACLFrontendDefault) WithConfigurationVersion(configurationVersion string) *GetAllACLFrontendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all Acl frontend default response
func (o *GetAllACLFrontendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all Acl frontend default response
func (o *GetAllACLFrontendDefault) WithPayload(payload *models.Error) *GetAllACLFrontendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all Acl frontend default response
func (o *GetAllACLFrontendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllACLFrontendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
