// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package crt_load

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the generate command

import (
	"net/http"

	"github.com/go-openapi/runtime/middleware"
)

// CreateCrtLoadHandlerFunc turns a function with the right signature into a create crt load handler
type CreateCrtLoadHandlerFunc func(CreateCrtLoadParams, interface{}) middleware.Responder

// Handle executing the request and returning a response
func (fn CreateCrtLoadHandlerFunc) Handle(params CreateCrtLoadParams, principal interface{}) middleware.Responder {
	return fn(params, principal)
}

// CreateCrtLoadHandler interface for that can handle valid create crt load params
type CreateCrtLoadHandler interface {
	Handle(CreateCrtLoadParams, interface{}) middleware.Responder
}

// NewCreateCrtLoad creates a new http.Handler for the create crt load operation
func NewCreateCrtLoad(ctx *middleware.Context, handler CreateCrtLoadHandler) *CreateCrtLoad {
	return &CreateCrtLoad{Context: ctx, Handler: handler}
}

/*
	CreateCrtLoad swagger:route POST /services/haproxy/configuration/crt_loads CrtLoad createCrtLoad

# Add a new certificate to load

Adds a new load entry to the specified crt_store section in the configuration
*/
type CreateCrtLoad struct {
	Context *middleware.Context
	Handler CreateCrtLoadHandler
}

func (o *CreateCrtLoad) ServeHTTP(rw http.ResponseWriter, r *http.Request) {
	route, rCtx, _ := o.Context.RouteInfo(r)
	if rCtx != nil {
		*r = *rCtx
	}
	var Params = NewCreateCrtLoadParams()
	uprinc, aCtx, err := o.Context.Authorize(r, route)
	if err != nil {
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}
	if aCtx != nil {
		*r = *aCtx
	}
	var principal interface{}
	if uprinc != nil {
		principal = uprinc.(interface{}) // this is really a interface{}, I promise
	}

	if err := o.Context.BindValidRequest(r, route, &Params); err != nil { // bind params
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}

	res := o.Handler.Handle(Params, principal) // actually handle the request
	o.Context.Respond(rw, r, route.Produces, route, res)

}
