// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_request_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// CreateHTTPRequestRuleBackendCreatedCode is the HTTP code returned for type CreateHTTPRequestRuleBackendCreated
const CreateHTTPRequestRuleBackendCreatedCode int = 201

/*
CreateHTTPRequestRuleBackendCreated HTTP Request Rule created

swagger:response createHttpRequestRuleBackendCreated
*/
type CreateHTTPRequestRuleBackendCreated struct {

	/*
	  In: Body
	*/
	Payload *models.HTTPRequestRule `json:"body,omitempty"`
}

// NewCreateHTTPRequestRuleBackendCreated creates CreateHTTPRequestRuleBackendCreated with default headers values
func NewCreateHTTPRequestRuleBackendCreated() *CreateHTTPRequestRuleBackendCreated {

	return &CreateHTTPRequestRuleBackendCreated{}
}

// WithPayload adds the payload to the create Http request rule backend created response
func (o *CreateHTTPRequestRuleBackendCreated) WithPayload(payload *models.HTTPRequestRule) *CreateHTTPRequestRuleBackendCreated {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Http request rule backend created response
func (o *CreateHTTPRequestRuleBackendCreated) SetPayload(payload *models.HTTPRequestRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPRequestRuleBackendCreated) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(201)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateHTTPRequestRuleBackendAcceptedCode is the HTTP code returned for type CreateHTTPRequestRuleBackendAccepted
const CreateHTTPRequestRuleBackendAcceptedCode int = 202

/*
CreateHTTPRequestRuleBackendAccepted Configuration change accepted and reload requested

swagger:response createHttpRequestRuleBackendAccepted
*/
type CreateHTTPRequestRuleBackendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.HTTPRequestRule `json:"body,omitempty"`
}

// NewCreateHTTPRequestRuleBackendAccepted creates CreateHTTPRequestRuleBackendAccepted with default headers values
func NewCreateHTTPRequestRuleBackendAccepted() *CreateHTTPRequestRuleBackendAccepted {

	return &CreateHTTPRequestRuleBackendAccepted{}
}

// WithReloadID adds the reloadId to the create Http request rule backend accepted response
func (o *CreateHTTPRequestRuleBackendAccepted) WithReloadID(reloadID string) *CreateHTTPRequestRuleBackendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the create Http request rule backend accepted response
func (o *CreateHTTPRequestRuleBackendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the create Http request rule backend accepted response
func (o *CreateHTTPRequestRuleBackendAccepted) WithPayload(payload *models.HTTPRequestRule) *CreateHTTPRequestRuleBackendAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Http request rule backend accepted response
func (o *CreateHTTPRequestRuleBackendAccepted) SetPayload(payload *models.HTTPRequestRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPRequestRuleBackendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateHTTPRequestRuleBackendBadRequestCode is the HTTP code returned for type CreateHTTPRequestRuleBackendBadRequest
const CreateHTTPRequestRuleBackendBadRequestCode int = 400

/*
CreateHTTPRequestRuleBackendBadRequest Bad request

swagger:response createHttpRequestRuleBackendBadRequest
*/
type CreateHTTPRequestRuleBackendBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateHTTPRequestRuleBackendBadRequest creates CreateHTTPRequestRuleBackendBadRequest with default headers values
func NewCreateHTTPRequestRuleBackendBadRequest() *CreateHTTPRequestRuleBackendBadRequest {

	return &CreateHTTPRequestRuleBackendBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the create Http request rule backend bad request response
func (o *CreateHTTPRequestRuleBackendBadRequest) WithConfigurationVersion(configurationVersion string) *CreateHTTPRequestRuleBackendBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create Http request rule backend bad request response
func (o *CreateHTTPRequestRuleBackendBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create Http request rule backend bad request response
func (o *CreateHTTPRequestRuleBackendBadRequest) WithPayload(payload *models.Error) *CreateHTTPRequestRuleBackendBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Http request rule backend bad request response
func (o *CreateHTTPRequestRuleBackendBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPRequestRuleBackendBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateHTTPRequestRuleBackendConflictCode is the HTTP code returned for type CreateHTTPRequestRuleBackendConflict
const CreateHTTPRequestRuleBackendConflictCode int = 409

/*
CreateHTTPRequestRuleBackendConflict The specified resource already exists

swagger:response createHttpRequestRuleBackendConflict
*/
type CreateHTTPRequestRuleBackendConflict struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateHTTPRequestRuleBackendConflict creates CreateHTTPRequestRuleBackendConflict with default headers values
func NewCreateHTTPRequestRuleBackendConflict() *CreateHTTPRequestRuleBackendConflict {

	return &CreateHTTPRequestRuleBackendConflict{}
}

// WithConfigurationVersion adds the configurationVersion to the create Http request rule backend conflict response
func (o *CreateHTTPRequestRuleBackendConflict) WithConfigurationVersion(configurationVersion string) *CreateHTTPRequestRuleBackendConflict {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create Http request rule backend conflict response
func (o *CreateHTTPRequestRuleBackendConflict) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create Http request rule backend conflict response
func (o *CreateHTTPRequestRuleBackendConflict) WithPayload(payload *models.Error) *CreateHTTPRequestRuleBackendConflict {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Http request rule backend conflict response
func (o *CreateHTTPRequestRuleBackendConflict) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPRequestRuleBackendConflict) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(409)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
CreateHTTPRequestRuleBackendDefault General Error

swagger:response createHttpRequestRuleBackendDefault
*/
type CreateHTTPRequestRuleBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateHTTPRequestRuleBackendDefault creates CreateHTTPRequestRuleBackendDefault with default headers values
func NewCreateHTTPRequestRuleBackendDefault(code int) *CreateHTTPRequestRuleBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &CreateHTTPRequestRuleBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the create HTTP request rule backend default response
func (o *CreateHTTPRequestRuleBackendDefault) WithStatusCode(code int) *CreateHTTPRequestRuleBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the create HTTP request rule backend default response
func (o *CreateHTTPRequestRuleBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the create HTTP request rule backend default response
func (o *CreateHTTPRequestRuleBackendDefault) WithConfigurationVersion(configurationVersion string) *CreateHTTPRequestRuleBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create HTTP request rule backend default response
func (o *CreateHTTPRequestRuleBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create HTTP request rule backend default response
func (o *CreateHTTPRequestRuleBackendDefault) WithPayload(payload *models.Error) *CreateHTTPRequestRuleBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create HTTP request rule backend default response
func (o *CreateHTTPRequestRuleBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPRequestRuleBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
