// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package quic_initial_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetAllQUICInitialRuleFrontendOKCode is the HTTP code returned for type GetAllQUICInitialRuleFrontendOK
const GetAllQUICInitialRuleFrontendOKCode int = 200

/*
GetAllQUICInitialRuleFrontendOK Successful operation

swagger:response getAllQuicInitialRuleFrontendOK
*/
type GetAllQUICInitialRuleFrontendOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload models.QUICInitialRules `json:"body,omitempty"`
}

// NewGetAllQUICInitialRuleFrontendOK creates GetAllQUICInitialRuleFrontendOK with default headers values
func NewGetAllQUICInitialRuleFrontendOK() *GetAllQUICInitialRuleFrontendOK {

	return &GetAllQUICInitialRuleFrontendOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get all Quic initial rule frontend o k response
func (o *GetAllQUICInitialRuleFrontendOK) WithConfigurationVersion(configurationVersion string) *GetAllQUICInitialRuleFrontendOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all Quic initial rule frontend o k response
func (o *GetAllQUICInitialRuleFrontendOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all Quic initial rule frontend o k response
func (o *GetAllQUICInitialRuleFrontendOK) WithPayload(payload models.QUICInitialRules) *GetAllQUICInitialRuleFrontendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all Quic initial rule frontend o k response
func (o *GetAllQUICInitialRuleFrontendOK) SetPayload(payload models.QUICInitialRules) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllQUICInitialRuleFrontendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.QUICInitialRules{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

/*
GetAllQUICInitialRuleFrontendDefault General Error

swagger:response getAllQuicInitialRuleFrontendDefault
*/
type GetAllQUICInitialRuleFrontendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetAllQUICInitialRuleFrontendDefault creates GetAllQUICInitialRuleFrontendDefault with default headers values
func NewGetAllQUICInitialRuleFrontendDefault(code int) *GetAllQUICInitialRuleFrontendDefault {
	if code <= 0 {
		code = 500
	}

	return &GetAllQUICInitialRuleFrontendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get all QUIC initial rule frontend default response
func (o *GetAllQUICInitialRuleFrontendDefault) WithStatusCode(code int) *GetAllQUICInitialRuleFrontendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get all QUIC initial rule frontend default response
func (o *GetAllQUICInitialRuleFrontendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get all QUIC initial rule frontend default response
func (o *GetAllQUICInitialRuleFrontendDefault) WithConfigurationVersion(configurationVersion string) *GetAllQUICInitialRuleFrontendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all QUIC initial rule frontend default response
func (o *GetAllQUICInitialRuleFrontendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all QUIC initial rule frontend default response
func (o *GetAllQUICInitialRuleFrontendDefault) WithPayload(payload *models.Error) *GetAllQUICInitialRuleFrontendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all QUIC initial rule frontend default response
func (o *GetAllQUICInitialRuleFrontendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllQUICInitialRuleFrontendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
