/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.proxies;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.java.proxies.ConcreteJavaProxy;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.Inspector;
import org.jruby.util.RubyStringBuilder;
import org.jruby.util.TypeConverter;

public final class MapJavaProxy
extends ConcreteJavaProxy {
    private RubyHashMap wrappedMap;

    public MapJavaProxy(Ruby runtime2, RubyClass klazz) {
        super(runtime2, klazz);
    }

    public MapJavaProxy(Ruby runtime2, RubyClass klazz, Map map2) {
        super(runtime2, klazz, map2);
    }

    public static RubyClass createMapJavaProxy(Ruby runtime2) {
        RubyClass MapJavaProxy2 = runtime2.defineClass("MapJavaProxy", runtime2.getJavaSupport().getConcreteProxyClass(), MapJavaProxy::new);
        ConcreteJavaProxy.initialize(MapJavaProxy2);
        return MapJavaProxy2;
    }

    private RubyHashMap getOrCreateRubyHashMap(Ruby runtime2) {
        if (this.wrappedMap == null) {
            this.wrappedMap = new RubyHashMap(runtime2, this);
        }
        return this.wrappedMap;
    }

    @JRubyMethod(name={"default"})
    public IRubyObject default_value_get(ThreadContext context) {
        return this.getOrCreateRubyHashMap(context.runtime).default_value_get(context);
    }

    @JRubyMethod(name={"default"})
    public IRubyObject default_value_get(ThreadContext context, IRubyObject arg2) {
        return this.getOrCreateRubyHashMap(context.runtime).default_value_get(context, arg2);
    }

    @JRubyMethod(name={"default="}, required=1)
    public IRubyObject default_value_set(ThreadContext context, IRubyObject defaultValue) {
        return this.getOrCreateRubyHashMap(context.runtime).default_value_set(context, defaultValue);
    }

    @JRubyMethod(name={"default_proc"})
    public IRubyObject default_proc(ThreadContext context) {
        return this.getOrCreateRubyHashMap(context.runtime).default_proc(context);
    }

    @JRubyMethod(name={"default_proc="})
    public IRubyObject set_default_proc(ThreadContext context, IRubyObject proc2) {
        return this.getOrCreateRubyHashMap(context.runtime).set_default_proc(context, proc2);
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect(ThreadContext context) {
        return this.getOrCreateRubyHashMap(context.runtime).inspect(context);
    }

    @JRubyMethod(name={"size", "length"})
    public RubyFixnum rb_size(ThreadContext context) {
        return this.getOrCreateRubyHashMap(context.runtime).rb_size(context);
    }

    @JRubyMethod(name={"empty?"})
    public RubyBoolean empty_p(ThreadContext context) {
        return this.getOrCreateRubyHashMap(context.runtime).empty_p(context);
    }

    @Override
    @JRubyMethod(name={"to_a"})
    public RubyArray to_a(ThreadContext context) {
        return this.getOrCreateRubyHashMap(context.runtime).to_a(context);
    }

    @JRubyMethod(name={"to_proc"})
    public RubyProc to_proc(ThreadContext context) {
        IRubyObject newProc = this.getOrCreateRubyHashMap(context.runtime).callMethod("to_proc");
        TypeConverter.checkType(context, newProc, context.runtime.getProc());
        return (RubyProc)newProc;
    }

    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s(ThreadContext context) {
        return RubyString.newString(context.runtime, this.getMapObject().toString());
    }

    @JRubyMethod(name={"rehash"}, notImplemented=true)
    public RubyHash rehash(ThreadContext context) {
        return this.getOrCreateRubyHashMap(context.runtime).rehash(context);
    }

    @JRubyMethod(name={"to_hash", "to_h"})
    public RubyHash to_hash(ThreadContext context) {
        return this.getOrCreateRubyHashMap(context.runtime).to_hash(context);
    }

    @JRubyMethod(name={"[]=", "store"}, required=2)
    public IRubyObject op_aset(ThreadContext context, IRubyObject key2, IRubyObject value2) {
        return this.getOrCreateRubyHashMap(context.runtime).op_aset(context, key2, value2);
    }

    @Override
    @JRubyMethod(name={"=="})
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        return this.getOrCreateRubyHashMap(context.runtime).op_equal(context, other);
    }

    @JRubyMethod(name={"eql?"})
    public IRubyObject op_eql(ThreadContext context, IRubyObject other) {
        return this.getOrCreateRubyHashMap(context.runtime).op_eql(context, other);
    }

    @JRubyMethod(name={"[]"}, required=1)
    public IRubyObject op_aref(ThreadContext context, IRubyObject key2) {
        return this.getOrCreateRubyHashMap(context.runtime).op_aref(context, key2);
    }

    @JRubyMethod(name={"<"}, required=1)
    public IRubyObject op_lt(ThreadContext context, IRubyObject other) {
        return this.getOrCreateRubyHashMap(context.runtime).op_lt(context, other);
    }

    @JRubyMethod(name={"<="}, required=1)
    public IRubyObject op_le(ThreadContext context, IRubyObject other) {
        return this.getOrCreateRubyHashMap(context.runtime).op_le(context, other);
    }

    @JRubyMethod(name={">"}, required=1)
    public IRubyObject op_gt(ThreadContext context, IRubyObject other) {
        return this.getOrCreateRubyHashMap(context.runtime).op_gt(context, other);
    }

    @JRubyMethod(name={">="}, required=1)
    public IRubyObject op_ge(ThreadContext context, IRubyObject other) {
        return this.getOrCreateRubyHashMap(context.runtime).op_ge(context, other);
    }

    @JRubyMethod(name={"hash"})
    public RubyFixnum hash(ThreadContext context) {
        return this.getOrCreateRubyHashMap(context.runtime).hash();
    }

    @JRubyMethod
    public IRubyObject fetch(ThreadContext context, IRubyObject key2, Block block) {
        return this.getOrCreateRubyHashMap(context.runtime).fetch(context, key2, block);
    }

    @JRubyMethod
    public IRubyObject fetch(ThreadContext context, IRubyObject key2, IRubyObject _default, Block block) {
        return this.getOrCreateRubyHashMap(context.runtime).fetch(context, key2, _default, block);
    }

    @JRubyMethod(name={"has_key?", "key?", "include?", "member?"}, required=1)
    public RubyBoolean has_key_p(ThreadContext context, IRubyObject key2) {
        return this.getOrCreateRubyHashMap(context.runtime).has_key_p(context, key2);
    }

    @JRubyMethod(name={"has_value?", "value?"}, required=1)
    public RubyBoolean has_value_p(ThreadContext context, IRubyObject expected) {
        return this.getOrCreateRubyHashMap(context.runtime).has_value_p(context, expected);
    }

    @JRubyMethod(name={"each", "each_pair"})
    public IRubyObject each(ThreadContext context, Block block) {
        return this.getOrCreateRubyHashMap(context.runtime).each(context, block);
    }

    @JRubyMethod(name={"each_value"})
    public IRubyObject each_value(ThreadContext context, Block block) {
        return this.getOrCreateRubyHashMap(context.runtime).each_value(context, block);
    }

    @JRubyMethod(name={"each_key"})
    public IRubyObject each_key(ThreadContext context, Block block) {
        return this.getOrCreateRubyHashMap(context.runtime).each_key(context, block);
    }

    @JRubyMethod(name={"select!"})
    public IRubyObject select_bang(ThreadContext context, Block block) {
        return this.getOrCreateRubyHashMap(context.runtime).select_bang(context, block);
    }

    @JRubyMethod(name={"keep_if"})
    public IRubyObject keep_if(ThreadContext context, Block block) {
        return this.getOrCreateRubyHashMap(context.runtime).keep_if(context, block);
    }

    @JRubyMethod(name={"index"})
    public IRubyObject index(ThreadContext context, IRubyObject expected) {
        return this.getOrCreateRubyHashMap(context.runtime).key(context, expected);
    }

    @JRubyMethod(name={"key"})
    public IRubyObject key(ThreadContext context, IRubyObject expected) {
        return this.getOrCreateRubyHashMap(context.runtime).key(context, expected);
    }

    @JRubyMethod(name={"keys"})
    public RubyArray keys(ThreadContext context) {
        return this.getOrCreateRubyHashMap(context.runtime).keys(context);
    }

    @JRubyMethod(name={"values", "ruby_values"})
    public RubyArray rb_values(ThreadContext context) {
        return this.getOrCreateRubyHashMap(context.runtime).rb_values(context);
    }

    @JRubyMethod(name={"shift"}, notImplemented=true)
    public IRubyObject shift(ThreadContext context) {
        return this.getOrCreateRubyHashMap(context.runtime).shift(context);
    }

    @JRubyMethod(name={"delete"})
    public IRubyObject delete(ThreadContext context, IRubyObject key2, Block block) {
        return this.getOrCreateRubyHashMap(context.runtime).delete(context, key2, block);
    }

    @JRubyMethod(name={"select"})
    public IRubyObject select(ThreadContext context, Block block) {
        return this.getOrCreateRubyHashMap(context.runtime).select(context, block);
    }

    @JRubyMethod(name={"delete_if"})
    public IRubyObject delete_if(ThreadContext context, Block block) {
        return this.getOrCreateRubyHashMap(context.runtime).delete_if(context, block);
    }

    @JRubyMethod(name={"reject"})
    public IRubyObject reject(ThreadContext context, Block block) {
        return this.getOrCreateRubyHashMap(context.runtime).reject(context, block);
    }

    @JRubyMethod(name={"reject!"})
    public IRubyObject reject_bang(ThreadContext context, Block block) {
        return this.getOrCreateRubyHashMap(context.runtime).reject_bang(context, block);
    }

    @JRubyMethod(name={"clear", "ruby_clear"})
    public IRubyObject rb_clear(ThreadContext context) {
        return this.getOrCreateRubyHashMap(context.runtime).rb_clear(context);
    }

    @JRubyMethod(name={"invert"})
    public RubyHash invert(ThreadContext context) {
        return this.getOrCreateRubyHashMap(context.runtime).invert(context);
    }

    @Deprecated
    public RubyHash merge_bang(ThreadContext context, IRubyObject other, Block block) {
        return this.merge_bang(context, new IRubyObject[]{other}, block);
    }

    @JRubyMethod(name={"merge!", "update"}, rest=true)
    public RubyHash merge_bang(ThreadContext context, IRubyObject[] others, Block block) {
        return this.getOrCreateRubyHashMap(context.runtime).merge_bang(context, others, block);
    }

    @Deprecated
    public RubyHash merge(ThreadContext context, IRubyObject other, Block block) {
        return this.merge(context, new IRubyObject[]{other}, block);
    }

    @JRubyMethod(name={"merge", "ruby_merge"}, rest=true)
    public RubyHash merge(ThreadContext context, IRubyObject[] others, Block block) {
        return this.getOrCreateRubyHashMap(context.runtime).merge(context, others, block);
    }

    @JRubyMethod(name={"initialize_copy"}, visibility=Visibility.PRIVATE)
    public RubyHash initialize_copy(ThreadContext context, IRubyObject other) {
        return this.getOrCreateRubyHashMap(context.runtime).initialize_copy(context, other);
    }

    @JRubyMethod(name={"replace", "ruby_replace"}, required=1)
    public RubyHash replace(ThreadContext context, IRubyObject other) {
        return this.getOrCreateRubyHashMap(context.runtime).replace(context, other);
    }

    @JRubyMethod(name={"values_at"}, rest=true)
    public RubyArray values_at(ThreadContext context, IRubyObject[] args2) {
        return this.getOrCreateRubyHashMap(context.runtime).values_at(context, args2);
    }

    @JRubyMethod(name={"fetch_values"}, rest=true)
    public RubyArray fetch_values(ThreadContext context, IRubyObject[] args2, Block block) {
        return this.getOrCreateRubyHashMap(context.runtime).fetch_values(context, args2, block);
    }

    @JRubyMethod(name={"assoc"})
    public IRubyObject assoc(ThreadContext context, IRubyObject obj) {
        return this.getOrCreateRubyHashMap(context.runtime).assoc(context, obj);
    }

    @JRubyMethod(name={"rassoc"})
    public IRubyObject rassoc(ThreadContext context, IRubyObject obj) {
        return this.getOrCreateRubyHashMap(context.runtime).rassoc(context, obj);
    }

    @JRubyMethod(name={"flatten"})
    public IRubyObject flatten(ThreadContext context) {
        return this.getOrCreateRubyHashMap(context.runtime).flatten(context);
    }

    @JRubyMethod(name={"flatten"})
    public IRubyObject flatten(ThreadContext context, IRubyObject level2) {
        return this.getOrCreateRubyHashMap(context.runtime).flatten(context, level2);
    }

    @JRubyMethod(name={"compare_by_identity"})
    public IRubyObject compare_by_identity(ThreadContext context) {
        return this;
    }

    @JRubyMethod(name={"compare_by_identity?"})
    public IRubyObject compare_by_identity_p(ThreadContext context) {
        return this.getOrCreateRubyHashMap(context.runtime).compare_by_identity_p(context);
    }

    @Override
    public IRubyObject dup() {
        return this.dupImpl("dup");
    }

    @Override
    public IRubyObject rbClone() {
        return this.dupImpl("clone");
    }

    @JRubyMethod(name={"any?"}, optional=1, checkArity=false)
    public IRubyObject any_p(ThreadContext context, IRubyObject[] args2, Block block) {
        return this.getOrCreateRubyHashMap(context.runtime).any_p(context, args2, block);
    }

    @JRubyMethod(name={"dig"}, required=1, rest=true, checkArity=false)
    public IRubyObject dig(ThreadContext context, IRubyObject[] args2) {
        return this.getOrCreateRubyHashMap(context.runtime).dig(context, args2);
    }

    private MapJavaProxy dupImpl(String method2) {
        Map map2 = this.getMapObject();
        try {
            Map newMap = (Map)map2.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            newMap.putAll(map2);
            MapJavaProxy proxy2 = new MapJavaProxy(this.getRuntime(), this.metaClass);
            proxy2.setObject(newMap);
            return proxy2;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            RaiseException e = this.getRuntime().newNotImplementedError("can't " + method2 + " Map of type " + this.getObject().getClass().getName());
            e.initCause(ex);
            throw e;
        }
    }

    final Map getMapObject() {
        return (Map)this.getObject();
    }

    @Override
    public final RubyHash convertToHash() {
        return this.getOrCreateRubyHashMap(this.getRuntime());
    }

    @Deprecated
    public IRubyObject op_aset19(ThreadContext context, IRubyObject key2, IRubyObject value2) {
        return this.getOrCreateRubyHashMap(context.runtime).op_aset19(context, key2, value2);
    }

    @Deprecated
    public IRubyObject sort(ThreadContext context, Block block) {
        return this.getOrCreateRubyHashMap(context.runtime).sort(context, block);
    }

    private static final class RubyHashMap
    extends RubyHash {
        static final RubyHash.RubyHashEntry[] EMPTY_TABLE = new RubyHash.RubyHashEntry[0];
        private static final Map.Entry[] NULL_MAP_ENTRY = new Map.Entry[0];
        private final MapJavaProxy receiver;

        RubyHashMap(Ruby runtime2, MapJavaProxy receiver2) {
            super(runtime2, runtime2.getHash(), runtime2.getNil(), EMPTY_TABLE, 0);
            this.receiver = receiver2;
        }

        private Map mapDelegate() {
            return this.receiver.getMapObject();
        }

        @Override
        public int size() {
            return this.mapDelegate().size();
        }

        @Override
        public RubyFixnum rb_size(ThreadContext context) {
            return context.runtime.newFixnum(this.mapDelegate().size());
        }

        @Override
        public RubyBoolean empty_p(ThreadContext context) {
            return this.mapDelegate().isEmpty() ? context.tru : context.fals;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IRubyObject inspect(ThreadContext context) {
            Ruby runtime2 = context.runtime;
            Map map2 = this.mapDelegate();
            RubyString buf = Inspector.inspectPrefix(context, this.receiver.getMetaClass());
            RubyStringBuilder.cat(runtime2, buf, Inspector.SPACE);
            if (this.size() == 0) {
                RubyStringBuilder.cat(runtime2, buf, Inspector.EMPTY_HASH_BL);
            } else if (runtime2.isInspecting(map2)) {
                RubyStringBuilder.cat(runtime2, buf, Inspector.RECURSIVE_HASH_BL);
            } else {
                try {
                    runtime2.registerInspecting(map2);
                    buf.cat19(this.inspectHash(context));
                }
                finally {
                    runtime2.unregisterInspecting(map2);
                }
            }
            return RubyStringBuilder.cat(runtime2, buf, Inspector.GT);
        }

        @Override
        public RubyArray to_a(ThreadContext context) {
            return super.to_a(context);
        }

        @Override
        public RubyFixnum hash(ThreadContext context) {
            return this.getRuntime().newFixnum(this.mapDelegate().hashCode());
        }

        @Override
        public IRubyObject delete(ThreadContext context, IRubyObject key2, Block block) {
            this.modify();
            Object value2 = this.mapDelegate().remove(key2.toJava(Object.class));
            if (value2 != null) {
                return JavaUtil.convertJavaToUsableRubyObject(this.getRuntime(), value2);
            }
            if (block.isGiven()) {
                return block.yield(context, key2);
            }
            return context.nil;
        }

        @Override
        public IRubyObject internalPut(IRubyObject key2, IRubyObject value2) {
            return this.internalPutNoResize(key2, value2, true);
        }

        @Override
        protected final IRubyObject internalPutNoResize(IRubyObject key2, IRubyObject value2, boolean checkForExisting) {
            Ruby runtime2 = this.getRuntime();
            Map map2 = this.mapDelegate();
            Object javaValue = value2.toJava(Object.class);
            Object existing = map2.put(key2.toJava(Object.class), javaValue);
            if (existing != null) {
                if (existing == javaValue) {
                    return value2;
                }
                return JavaUtil.convertJavaToUsableRubyObject(runtime2, existing);
            }
            return null;
        }

        @Override
        protected final void op_asetForString(Ruby runtime2, RubyString key2, IRubyObject value2) {
            Map map2 = this.mapDelegate();
            map2.put(key2.decodeString(), value2.toJava(Object.class));
        }

        @Override
        protected final void op_asetSmallForString(Ruby runtime2, RubyString key2, IRubyObject value2) {
            this.op_asetForString(runtime2, key2, value2);
        }

        @Override
        public IRubyObject internalGet(IRubyObject key2) {
            Object result2 = this.mapDelegate().get(key2.toJava(Object.class));
            if (result2 == null) {
                return null;
            }
            return JavaUtil.convertJavaToUsableRubyObject(this.getRuntime(), result2);
        }

        @Override
        public RubyHash.RubyHashEntry internalGetEntry(IRubyObject key2) {
            Object convertedKey;
            Map map2 = this.mapDelegate();
            Object value2 = map2.get(convertedKey = key2.toJava(Object.class));
            if (value2 != null) {
                return new RubyHash.RubyHashEntry(key2.hashCode(), key2, JavaUtil.convertJavaToUsableRubyObject(this.getRuntime(), value2), null, null);
            }
            return NO_ENTRY;
        }

        @Override
        public RubyHash.RubyHashEntry internalDelete(IRubyObject key2) {
            Object convertedKey;
            Map map2 = this.mapDelegate();
            Object value2 = map2.get(convertedKey = key2.toJava(Object.class));
            if (value2 != null) {
                map2.remove(convertedKey);
                return new RubyHash.RubyHashEntry(key2.hashCode(), key2, JavaUtil.convertJavaToUsableRubyObject(this.getRuntime(), value2), null, null);
            }
            return NO_ENTRY;
        }

        @Override
        public RubyHash.RubyHashEntry internalDeleteEntry(RubyHash.RubyHashEntry entry) {
            Object convertedKey;
            Map map2 = this.mapDelegate();
            if (map2.containsKey(convertedKey = ((IRubyObject)entry.getKey()).toJava(Object.class))) {
                map2.remove(convertedKey);
                return entry;
            }
            return NO_ENTRY;
        }

        @Override
        public <T> void visitAll(ThreadContext context, RubyHash.VisitorWithStateI visitor) {
            Ruby runtime2 = this.getRuntime();
            Map map2 = this.mapDelegate();
            Map.Entry[] entries2 = map2.entrySet().toArray(NULL_MAP_ENTRY);
            int index2 = 0;
            for (Map.Entry entry : entries2) {
                IRubyObject key2 = JavaUtil.convertJavaToUsableRubyObject(runtime2, entry.getKey());
                IRubyObject value2 = JavaUtil.convertJavaToUsableRubyObject(runtime2, entry.getValue());
                visitor.visit(context, this, key2, value2, index2++);
            }
        }

        @Override
        public <T> void visitAll(ThreadContext context, RubyHash.VisitorWithState visitor, T state2) {
            this.visitAll(context, (ctx, self2, key2, value2, index2) -> visitor.visit(ctx, self2, key2, value2, index2, state2));
        }

        @Override
        public boolean hasKey(IRubyObject key2) {
            return this.mapDelegate().containsKey(key2);
        }

        @Override
        public RubyBoolean has_key_p(ThreadContext context, IRubyObject key2) {
            return this.mapDelegate().containsKey(key2.toJava(Object.class)) ? context.tru : context.fals;
        }

        @Override
        public RubyBoolean has_value_p(ThreadContext context, IRubyObject val) {
            return this.mapDelegate().containsValue(val.toJava(Object.class)) ? context.tru : context.fals;
        }

        @Override
        public RubyHash rehash(ThreadContext context) {
            return this;
        }

        @Override
        public RubyBoolean compare_by_identity_p(ThreadContext context) {
            return RubyBoolean.newBoolean(context, this.mapDelegate() instanceof IdentityHashMap);
        }

        @Override
        public IRubyObject any_p(ThreadContext context, IRubyObject[] args2, Block block) {
            boolean patternGiven;
            int argc = Arity.checkArgumentCount(context, args2, 0, 1);
            boolean bl = patternGiven = argc > 0;
            if (this.isEmpty()) {
                return context.fals;
            }
            if (!block.isGiven() && !patternGiven) {
                return context.tru;
            }
            if (patternGiven) {
                return this.any_p_p(context, args2[0]);
            }
            if (block.getSignature().arityValue() > 1) {
                return this.any_p_i_fast(context, block);
            }
            return this.any_p_i(context, block);
        }

        private RubyBoolean any_p_i(ThreadContext context, Block block) {
            Ruby runtime2 = context.runtime;
            for (Map.Entry entry : this.entrySet()) {
                IRubyObject val;
                IRubyObject key2 = JavaUtil.convertJavaToUsableRubyObject(runtime2, entry.getKey());
                if (!block.yield(context, RubyArray.newArray(runtime2, key2, val = JavaUtil.convertJavaToUsableRubyObject(runtime2, entry.getValue()))).isTrue()) continue;
                return runtime2.getTrue();
            }
            return runtime2.getFalse();
        }

        private RubyBoolean any_p_i_fast(ThreadContext context, Block block) {
            Ruby runtime2 = context.runtime;
            for (Map.Entry entry : this.entrySet()) {
                IRubyObject val;
                IRubyObject key2 = JavaUtil.convertJavaToUsableRubyObject(runtime2, entry.getKey());
                if (!block.yieldArray(context, runtime2.newArray(key2, val = JavaUtil.convertJavaToUsableRubyObject(runtime2, entry.getValue())), null).isTrue()) continue;
                return runtime2.getTrue();
            }
            return runtime2.getFalse();
        }

        private RubyBoolean any_p_p(ThreadContext context, IRubyObject pattern) {
            Ruby runtime2 = context.runtime;
            for (Map.Entry entry : this.entrySet()) {
                IRubyObject val;
                IRubyObject key2 = JavaUtil.convertJavaToUsableRubyObject(runtime2, entry.getKey());
                if (!pattern.callMethod(context, "===", RubyArray.newArray(runtime2, key2, val = JavaUtil.convertJavaToUsableRubyObject(runtime2, entry.getValue()))).isTrue()) continue;
                return runtime2.getTrue();
            }
            return runtime2.getFalse();
        }

        @Override
        public RubyHash rb_clear(ThreadContext context) {
            this.mapDelegate().clear();
            return this;
        }

        @Override
        public IRubyObject shift(ThreadContext context) {
            throw this.getRuntime().newNotImplementedError("Java Maps do not preserve insertion order and do not support shift");
        }

        @Override
        public RubyHash to_hash(ThreadContext context) {
            Ruby runtime2 = context.runtime;
            RubyHash hash2 = new RubyHash(runtime2);
            Set entries2 = this.mapDelegate().entrySet();
            for (Map.Entry entry : entries2) {
                IRubyObject key2 = JavaUtil.convertJavaToUsableRubyObject(runtime2, entry.getKey());
                IRubyObject value2 = JavaUtil.convertJavaToUsableRubyObject(runtime2, entry.getValue());
                hash2.fastASetCheckString(runtime2, key2, value2);
            }
            return hash2;
        }

        @Override
        public final Set keySet() {
            return this.mapDelegate().keySet();
        }

        @Override
        public final Set directKeySet() {
            return this.keySet();
        }

        @Override
        public final Collection values() {
            return this.mapDelegate().values();
        }

        @Override
        public final Collection directValues() {
            return this.values();
        }

        @Override
        public final Set<Map.Entry> entrySet() {
            return this.mapDelegate().entrySet();
        }

        @Override
        public final Set directEntrySet() {
            return this.entrySet();
        }

        @Override
        protected void replaceWith(ThreadContext context, RubyHash otherHash) {
            this.replaceExternally(context, otherHash);
        }
    }
}

