/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jruby.ir.Tuple;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.listeners.InstructionsListener;
import org.jruby.ir.representations.BasicBlock;

public class IGVInstrListener
implements InstructionsListener {
    private Map<BasicBlock, List<Instr>> removedInstrs = new HashMap<BasicBlock, List<Instr>>();
    private List<Tuple<Instr, Instr>> removedEdges = new ArrayList<Tuple<Instr, Instr>>();

    public List<Tuple<Instr, Instr>> getRemovedEdges() {
        return this.removedEdges;
    }

    public List<Instr> removedList(BasicBlock basicBlock) {
        List<Instr> removedList = this.removedInstrs.get(basicBlock);
        if (removedList == null) {
            removedList = new ArrayList<Instr>();
            this.removedInstrs.put(basicBlock, removedList);
        }
        return removedList;
    }

    @Override
    public void instrChanged(BasicBlock basicBlock, Instr oldInstr, Instr newInstr, int index2, InstructionsListener.OperationType op) {
        switch (op) {
            case REMOVE: {
                if (index2 > 0) {
                    Instr previousInstr = basicBlock.getInstrs().get(index2 - 1);
                    this.removedEdges.add(new Tuple<Instr, Instr>(previousInstr, oldInstr));
                }
                this.removedList(basicBlock).add(oldInstr);
            }
        }
    }

    public void reset() {
        this.removedInstrs = new HashMap<BasicBlock, List<Instr>>();
        this.removedEdges = new ArrayList<Tuple<Instr, Instr>>();
    }
}

