// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// HashType hash type
//
// swagger:model hash_type
type HashType struct {
	// function
	// Enum: ["sdbm","djb2","wt6","crc32","none"]
	// +kubebuilder:validation:Enum="sdbm","djb2","wt6","crc32","none";
	Function string `json:"function,omitempty"`

	// method
	// Enum: ["map-based","consistent"]
	// +kubebuilder:validation:Enum="map-based","consistent";
	Method string `json:"method,omitempty"`

	// modifier
	// Enum: ["avalanche"]
	// +kubebuilder:validation:Enum="avalanche";
	Modifier string `json:"modifier,omitempty"`
}

// Validate validates this hash type
func (m *HashType) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateFunction(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMethod(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateModifier(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var hashTypeTypeFunctionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["sdbm","djb2","wt6","crc32","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		hashTypeTypeFunctionPropEnum = append(hashTypeTypeFunctionPropEnum, v)
	}
}

const (

	// HashTypeFunctionSdbm captures enum value "sdbm"
	HashTypeFunctionSdbm string = "sdbm"

	// HashTypeFunctionDjb2 captures enum value "djb2"
	HashTypeFunctionDjb2 string = "djb2"

	// HashTypeFunctionWt6 captures enum value "wt6"
	HashTypeFunctionWt6 string = "wt6"

	// HashTypeFunctionCrc32 captures enum value "crc32"
	HashTypeFunctionCrc32 string = "crc32"

	// HashTypeFunctionNone captures enum value "none"
	HashTypeFunctionNone string = "none"
)

// prop value enum
func (m *HashType) validateFunctionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, hashTypeTypeFunctionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *HashType) validateFunction(formats strfmt.Registry) error {
	if swag.IsZero(m.Function) { // not required
		return nil
	}

	// value enum
	if err := m.validateFunctionEnum("function", "body", m.Function); err != nil {
		return err
	}

	return nil
}

var hashTypeTypeMethodPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["map-based","consistent"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		hashTypeTypeMethodPropEnum = append(hashTypeTypeMethodPropEnum, v)
	}
}

const (

	// HashTypeMethodMapDashBased captures enum value "map-based"
	HashTypeMethodMapDashBased string = "map-based"

	// HashTypeMethodConsistent captures enum value "consistent"
	HashTypeMethodConsistent string = "consistent"
)

// prop value enum
func (m *HashType) validateMethodEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, hashTypeTypeMethodPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *HashType) validateMethod(formats strfmt.Registry) error {
	if swag.IsZero(m.Method) { // not required
		return nil
	}

	// value enum
	if err := m.validateMethodEnum("method", "body", m.Method); err != nil {
		return err
	}

	return nil
}

var hashTypeTypeModifierPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["avalanche"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		hashTypeTypeModifierPropEnum = append(hashTypeTypeModifierPropEnum, v)
	}
}

const (

	// HashTypeModifierAvalanche captures enum value "avalanche"
	HashTypeModifierAvalanche string = "avalanche"
)

// prop value enum
func (m *HashType) validateModifierEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, hashTypeTypeModifierPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *HashType) validateModifier(formats strfmt.Registry) error {
	if swag.IsZero(m.Modifier) { // not required
		return nil
	}

	// value enum
	if err := m.validateModifierEnum("modifier", "body", m.Modifier); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this hash type based on context it is used
func (m *HashType) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *HashType) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashType) UnmarshalBinary(b []byte) error {
	var res HashType
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
