﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/application-signals/model/ListAuditFindingsResult.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::ApplicationSignals::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListAuditFindingsResult::ListAuditFindingsResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListAuditFindingsResult& ListAuditFindingsResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("AuditFindings")) {
    Aws::Utils::Array<JsonView> auditFindingsJsonList = jsonValue.GetArray("AuditFindings");
    for (unsigned auditFindingsIndex = 0; auditFindingsIndex < auditFindingsJsonList.GetLength(); ++auditFindingsIndex) {
      m_auditFindings.push_back(auditFindingsJsonList[auditFindingsIndex].AsObject());
    }
    m_auditFindingsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("NextToken")) {
    m_nextToken = jsonValue.GetString("NextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
