﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/athena/Athena_EXPORTS.h>
#include <aws/athena/model/TableMetadata.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Athena {
namespace Model {
class ListTableMetadataResult {
 public:
  AWS_ATHENA_API ListTableMetadataResult() = default;
  AWS_ATHENA_API ListTableMetadataResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_ATHENA_API ListTableMetadataResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>A list of table metadata.</p>
   */
  inline const Aws::Vector<TableMetadata>& GetTableMetadataList() const { return m_tableMetadataList; }
  template <typename TableMetadataListT = Aws::Vector<TableMetadata>>
  void SetTableMetadataList(TableMetadataListT&& value) {
    m_tableMetadataListHasBeenSet = true;
    m_tableMetadataList = std::forward<TableMetadataListT>(value);
  }
  template <typename TableMetadataListT = Aws::Vector<TableMetadata>>
  ListTableMetadataResult& WithTableMetadataList(TableMetadataListT&& value) {
    SetTableMetadataList(std::forward<TableMetadataListT>(value));
    return *this;
  }
  template <typename TableMetadataListT = TableMetadata>
  ListTableMetadataResult& AddTableMetadataList(TableMetadataListT&& value) {
    m_tableMetadataListHasBeenSet = true;
    m_tableMetadataList.emplace_back(std::forward<TableMetadataListT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A token generated by the Athena service that specifies where to continue
   * pagination if a previous request was truncated. To obtain the next set of pages,
   * pass in the NextToken from the response object of the previous page call.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListTableMetadataResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListTableMetadataResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<TableMetadata> m_tableMetadataList;
  bool m_tableMetadataListHasBeenSet = false;

  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Athena
}  // namespace Aws
