# GitHub Authentication Deprecation

## What's going on?

GitHub now [requires token-based authentication][token-auth] to
call their APIs, and in the future, use Git itself.

This means Git credential helpers such as [Git Credential Manager (GCM) for
Windows][gcm-windows], and old versions of [GCM][gcm] that offer
username/password flows **will not be able to create new access tokens** for
accessing Git repositories.

If you already have tokens generated by Git credential helpers like GCM for
Windows, they will continue to work until they expire or are revoked/deleted.

## What should I do now?

### Windows command-line users

The best thing to do right now is upgrade to the latest Git for Windows (at
least version 2.29), which includes a version of Git Credential Manager that
uses supported OAuth token-based authentication.

[Download the latest Git for Windows ⬇️][git-windows]

### Visual Studio users

Please update to the latest supported release of Visual Studio, that includes
GCM and support for OAuth token-based authentication.

- [Visual Studio 2019 ⬇️][vs-2019]
- [Visual Studio 2017 ⬇️][vs-2017]

### SSH, macOS, and Linux users

If you are using SSH this change does **not** affect you.

If you are using an older version of Git Credential Manager (before
2.0.124-beta) please upgrade to the latest version following [these
instructions][gcm-install].

## What if I cannot upgrade Git for Windows?

If you are unable to upgrade Git for Windows, you can manually install Git
Credential Manager as a standalone install. This will override the older,
GCM for Windows bundled with the Git for Windows installation.

[Download Git Credential Manager standalone ⬇️][gcm-latest]

## What if I cannot use Git Credential Manager?

If you are unable to use Git Credential Manager due to a bug or
compatibility issue we'd [like to know why][gcm-new-issue]!

## Help! I cannot make any changes to my Windows machine without an Administrator

If you do not have permission to change your installation (for example in a
corporate environment) you can use the per-user installer. Check out the [latest
release][gcm-latest] and download the `gcmcoreuser-win-*.exe`
executable.

### Help! I still cannot or don't want to install anything

There is a workaround which should work and doesn't require installing anything.

1. Tell your system administrator they should start planning to upgrade the
   installed version of Git for Windows to at least 2.29! 😁

1. [Create a new personal access token][github-pat] (see official
   [documentation][github-pat-docs])

1. Enter a name ("note") for the token and ensure the `repo`, `gist`, and
   `workflow` scopes are selected:
   ![image][github-pat-note-image]
   ...
   ![image][github-pat-repo-scope-image]
   ...
   ![image][github-pat-gist-scope-image]
   ...
   ![image][github-pat-workflow-scope-image]

1. Click "Generate Token"

   ![image][github-generate-pat-image]

1. **[IMPORTANT]** Keep the resulting page open as this contains your new token
   (this will only be displayed once!)

   ![image][github-display-pat-image]

1. Save the generated PAT in the Windows Credential Manager:

   1. If you prefer to use the command-line, open a command prompt (cmd.exe) and
      type the following:

      ```bash
      cmdkey /generic:git:https://github.com /user:PersonalAccessToken /pass
      ```

      You will be prompted to enter a password – copy the newly generated PAT in
      step 4 and paste it here, and press the `Enter` key

      ![image][windows-cli-save-pat-image]

   1. If you do not wish to use the command-line, [open the Credential Manager
      via Control Panel][windows-credential-manager]
      and select the "Windows Credentials" tab.

      ![image][windows-gui-credentials-image]

      Click "Add a generic credential", and enter the following details:

      - Internet or network address: `git:https://github.com`
      - Username: `PersonalAccessToken`
      - Password: _(copy and paste the PAT generated in step 4 here)_

      ![image][windows-gui-add-pat-image]

## What about GitHub Enterprise Server (GHES)?

As mentioned in [the blog post][github-token-authentication-requirements],
the new token-based authentication requirements **DO NOT** apply to GHES:

> We have not announced any changes to GitHub Enterprise Server, which remains
> unaffected at this time.

[token-auth]: https://github.blog/2020-07-30-token-authentication-requirements-for-api-and-git-operations/
[gcm]: https://aka.ms/gcm
[gcm-install]: ../README.md#download-and-install
[gcm-latest]: https://aka.ms/gcm/latest
[gcm-new-issue]: https://github.com/git-ecosystem/git-credential-manager/issues/new/choose
[gcm-windows]: https://github.com/microsoft/Git-Credential-Manager-for-Windows
[git-windows]: https://git-scm.com/download/win
[github-display-pat-image]: img/github-display-pat.png
[github-generate-pat-image]: img/github-generate-pat.png
[github-pat]: https://github.com/settings/tokens/new?scopes=repo,gist,workflow
[github-pat-docs]: https://docs.github.com/en/free-pro-team@latest/github/authenticating-to-github/creating-a-personal-access-token
[github-pat-gist-scope-image]: img/github-pat-gist-scope.png
[github-pat-note-image]: img/github-pat-note.png
[github-pat-repo-scope-image]: img/github-pat-repo-scope.png
[github-pat-workflow-scope-image]: img/github-pat-workflow-scope.png
[github-token-authentication-requirements]: https://github.blog/2020-07-30-token-authentication-requirements-for-api-and-git-operations/
[windows-cli-save-pat-image]: img/windows-cli-save-pat.png
[vs-2019]: https://docs.microsoft.com/en-us/visualstudio/install/update-visual-studio?view=vs-2019
[vs-2017]: https://docs.microsoft.com/en-us/visualstudio/install/update-visual-studio?view=vs-2017
[windows-credential-manager]: https://support.microsoft.com/en-us/windows/accessing-credential-manager-1b5c916a-6a16-889f-8581-fc16e8165ac0
[windows-gui-add-pat-image]: img/windows-gui-add-pat.png
[windows-gui-credentials-image]: img/windows-gui-credentials.png
