// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/apigateway/v1/apigateway_service.proto

#include "google/cloud/apigateway/v1/internal/api_gateway_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace apigateway_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

ApiGatewayServiceTracingConnection::ApiGatewayServiceTracingConnection(
    std::shared_ptr<apigateway_v1::ApiGatewayServiceConnection> child)
    : child_(std::move(child)) {}

StreamRange<google::cloud::apigateway::v1::Gateway>
ApiGatewayServiceTracingConnection::ListGateways(
    google::cloud::apigateway::v1::ListGatewaysRequest request) {
  auto span = internal::MakeSpan(
      "apigateway_v1::ApiGatewayServiceConnection::ListGateways");
  internal::OTelScope scope(span);
  auto sr = child_->ListGateways(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::apigateway::v1::Gateway>(std::move(span), std::move(sr));
}

StatusOr<google::cloud::apigateway::v1::Gateway>
ApiGatewayServiceTracingConnection::GetGateway(
    google::cloud::apigateway::v1::GetGatewayRequest const& request) {
  auto span = internal::MakeSpan(
      "apigateway_v1::ApiGatewayServiceConnection::GetGateway");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetGateway(request));
}

future<StatusOr<google::cloud::apigateway::v1::Gateway>>
ApiGatewayServiceTracingConnection::CreateGateway(
    google::cloud::apigateway::v1::CreateGatewayRequest const& request) {
  auto span = internal::MakeSpan(
      "apigateway_v1::ApiGatewayServiceConnection::CreateGateway");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateGateway(request));
}

future<StatusOr<google::cloud::apigateway::v1::Gateway>>
ApiGatewayServiceTracingConnection::UpdateGateway(
    google::cloud::apigateway::v1::UpdateGatewayRequest const& request) {
  auto span = internal::MakeSpan(
      "apigateway_v1::ApiGatewayServiceConnection::UpdateGateway");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateGateway(request));
}

future<StatusOr<google::cloud::apigateway::v1::OperationMetadata>>
ApiGatewayServiceTracingConnection::DeleteGateway(
    google::cloud::apigateway::v1::DeleteGatewayRequest const& request) {
  auto span = internal::MakeSpan(
      "apigateway_v1::ApiGatewayServiceConnection::DeleteGateway");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteGateway(request));
}

StreamRange<google::cloud::apigateway::v1::Api>
ApiGatewayServiceTracingConnection::ListApis(
    google::cloud::apigateway::v1::ListApisRequest request) {
  auto span = internal::MakeSpan(
      "apigateway_v1::ApiGatewayServiceConnection::ListApis");
  internal::OTelScope scope(span);
  auto sr = child_->ListApis(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::apigateway::v1::Api>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::apigateway::v1::Api>
ApiGatewayServiceTracingConnection::GetApi(
    google::cloud::apigateway::v1::GetApiRequest const& request) {
  auto span =
      internal::MakeSpan("apigateway_v1::ApiGatewayServiceConnection::GetApi");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetApi(request));
}

future<StatusOr<google::cloud::apigateway::v1::Api>>
ApiGatewayServiceTracingConnection::CreateApi(
    google::cloud::apigateway::v1::CreateApiRequest const& request) {
  auto span = internal::MakeSpan(
      "apigateway_v1::ApiGatewayServiceConnection::CreateApi");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateApi(request));
}

future<StatusOr<google::cloud::apigateway::v1::Api>>
ApiGatewayServiceTracingConnection::UpdateApi(
    google::cloud::apigateway::v1::UpdateApiRequest const& request) {
  auto span = internal::MakeSpan(
      "apigateway_v1::ApiGatewayServiceConnection::UpdateApi");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateApi(request));
}

future<StatusOr<google::cloud::apigateway::v1::OperationMetadata>>
ApiGatewayServiceTracingConnection::DeleteApi(
    google::cloud::apigateway::v1::DeleteApiRequest const& request) {
  auto span = internal::MakeSpan(
      "apigateway_v1::ApiGatewayServiceConnection::DeleteApi");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteApi(request));
}

StreamRange<google::cloud::apigateway::v1::ApiConfig>
ApiGatewayServiceTracingConnection::ListApiConfigs(
    google::cloud::apigateway::v1::ListApiConfigsRequest request) {
  auto span = internal::MakeSpan(
      "apigateway_v1::ApiGatewayServiceConnection::ListApiConfigs");
  internal::OTelScope scope(span);
  auto sr = child_->ListApiConfigs(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::apigateway::v1::ApiConfig>(std::move(span), std::move(sr));
}

StatusOr<google::cloud::apigateway::v1::ApiConfig>
ApiGatewayServiceTracingConnection::GetApiConfig(
    google::cloud::apigateway::v1::GetApiConfigRequest const& request) {
  auto span = internal::MakeSpan(
      "apigateway_v1::ApiGatewayServiceConnection::GetApiConfig");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetApiConfig(request));
}

future<StatusOr<google::cloud::apigateway::v1::ApiConfig>>
ApiGatewayServiceTracingConnection::CreateApiConfig(
    google::cloud::apigateway::v1::CreateApiConfigRequest const& request) {
  auto span = internal::MakeSpan(
      "apigateway_v1::ApiGatewayServiceConnection::CreateApiConfig");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateApiConfig(request));
}

future<StatusOr<google::cloud::apigateway::v1::ApiConfig>>
ApiGatewayServiceTracingConnection::UpdateApiConfig(
    google::cloud::apigateway::v1::UpdateApiConfigRequest const& request) {
  auto span = internal::MakeSpan(
      "apigateway_v1::ApiGatewayServiceConnection::UpdateApiConfig");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateApiConfig(request));
}

future<StatusOr<google::cloud::apigateway::v1::OperationMetadata>>
ApiGatewayServiceTracingConnection::DeleteApiConfig(
    google::cloud::apigateway::v1::DeleteApiConfigRequest const& request) {
  auto span = internal::MakeSpan(
      "apigateway_v1::ApiGatewayServiceConnection::DeleteApiConfig");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteApiConfig(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<apigateway_v1::ApiGatewayServiceConnection>
MakeApiGatewayServiceTracingConnection(
    std::shared_ptr<apigateway_v1::ApiGatewayServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn =
        std::make_shared<ApiGatewayServiceTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace apigateway_v1_internal
}  // namespace cloud
}  // namespace google
