// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/api/apikeys/v2/apikeys.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_APIKEYS_V2_INTERNAL_API_KEYS_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_APIKEYS_V2_INTERNAL_API_KEYS_TRACING_CONNECTION_H

#include "google/cloud/apikeys/v2/api_keys_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace apikeys_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class ApiKeysTracingConnection : public apikeys_v2::ApiKeysConnection {
 public:
  ~ApiKeysTracingConnection() override = default;

  explicit ApiKeysTracingConnection(
      std::shared_ptr<apikeys_v2::ApiKeysConnection> child);

  Options options() override { return child_->options(); }

  future<StatusOr<google::api::apikeys::v2::Key>> CreateKey(
      google::api::apikeys::v2::CreateKeyRequest const& request) override;

  StreamRange<google::api::apikeys::v2::Key> ListKeys(
      google::api::apikeys::v2::ListKeysRequest request) override;

  StatusOr<google::api::apikeys::v2::Key> GetKey(
      google::api::apikeys::v2::GetKeyRequest const& request) override;

  StatusOr<google::api::apikeys::v2::GetKeyStringResponse> GetKeyString(
      google::api::apikeys::v2::GetKeyStringRequest const& request) override;

  future<StatusOr<google::api::apikeys::v2::Key>> UpdateKey(
      google::api::apikeys::v2::UpdateKeyRequest const& request) override;

  future<StatusOr<google::api::apikeys::v2::Key>> DeleteKey(
      google::api::apikeys::v2::DeleteKeyRequest const& request) override;

  future<StatusOr<google::api::apikeys::v2::Key>> UndeleteKey(
      google::api::apikeys::v2::UndeleteKeyRequest const& request) override;

  StatusOr<google::api::apikeys::v2::LookupKeyResponse> LookupKey(
      google::api::apikeys::v2::LookupKeyRequest const& request) override;

 private:
  std::shared_ptr<apikeys_v2::ApiKeysConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<apikeys_v2::ApiKeysConnection> MakeApiKeysTracingConnection(
    std::shared_ptr<apikeys_v2::ApiKeysConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace apikeys_v2_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_APIKEYS_V2_INTERNAL_API_KEYS_TRACING_CONNECTION_H
