// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/compute/region_health_check_services/v1/region_health_check_services.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_REGION_HEALTH_CHECK_SERVICES_V1_INTERNAL_REGION_HEALTH_CHECK_SERVICES_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_REGION_HEALTH_CHECK_SERVICES_V1_INTERNAL_REGION_HEALTH_CHECK_SERVICES_TRACING_CONNECTION_H

#include "google/cloud/compute/region_health_check_services/v1/region_health_check_services_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_region_health_check_services_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class RegionHealthCheckServicesTracingConnection
    : public compute_region_health_check_services_v1::
          RegionHealthCheckServicesConnection {
 public:
  ~RegionHealthCheckServicesTracingConnection() override = default;

  explicit RegionHealthCheckServicesTracingConnection(
      std::shared_ptr<compute_region_health_check_services_v1::
                          RegionHealthCheckServicesConnection>
          child);

  Options options() override { return child_->options(); }

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  DeleteHealthCheckService(
      google::cloud::cpp::compute::region_health_check_services::v1::
          DeleteHealthCheckServiceRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::HealthCheckService>
  GetHealthCheckService(
      google::cloud::cpp::compute::region_health_check_services::v1::
          GetHealthCheckServiceRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  InsertHealthCheckService(
      google::cloud::cpp::compute::region_health_check_services::v1::
          InsertHealthCheckServiceRequest const& request) override;

  StreamRange<google::cloud::cpp::compute::v1::HealthCheckService>
  ListRegionHealthCheckServices(
      google::cloud::cpp::compute::region_health_check_services::v1::
          ListRegionHealthCheckServicesRequest request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  PatchHealthCheckService(
      google::cloud::cpp::compute::region_health_check_services::v1::
          PatchHealthCheckServiceRequest const& request) override;

 private:
  std::shared_ptr<compute_region_health_check_services_v1::
                      RegionHealthCheckServicesConnection>
      child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<compute_region_health_check_services_v1::
                    RegionHealthCheckServicesConnection>
MakeRegionHealthCheckServicesTracingConnection(
    std::shared_ptr<compute_region_health_check_services_v1::
                        RegionHealthCheckServicesConnection>
        conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_region_health_check_services_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_REGION_HEALTH_CHECK_SERVICES_V1_INTERNAL_REGION_HEALTH_CHECK_SERVICES_TRACING_CONNECTION_H
