// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataproc/v1/batches.proto

#include "google/cloud/dataproc/v1/batch_controller_connection.h"
#include "google/cloud/dataproc/v1/batch_controller_options.h"
#include "google/cloud/dataproc/v1/internal/batch_controller_connection_impl.h"
#include "google/cloud/dataproc/v1/internal/batch_controller_option_defaults.h"
#include "google/cloud/dataproc/v1/internal/batch_controller_stub_factory.h"
#include "google/cloud/dataproc/v1/internal/batch_controller_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace dataproc_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

BatchControllerConnection::~BatchControllerConnection() = default;

future<StatusOr<google::cloud::dataproc::v1::Batch>>
BatchControllerConnection::CreateBatch(
    google::cloud::dataproc::v1::CreateBatchRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dataproc::v1::Batch>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::dataproc::v1::Batch>
BatchControllerConnection::GetBatch(
    google::cloud::dataproc::v1::GetBatchRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::dataproc::v1::Batch>
BatchControllerConnection::ListBatches(
    google::cloud::dataproc::v1::
        ListBatchesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::dataproc::v1::Batch>>();
}

Status BatchControllerConnection::DeleteBatch(
    google::cloud::dataproc::v1::DeleteBatchRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<BatchControllerConnection> MakeBatchControllerConnection(
    std::string const& location, Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 BatchControllerPolicyOptionList>(options,
                                                                  __func__);
  options = dataproc_v1_internal::BatchControllerDefaultOptions(
      location, std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = dataproc_v1_internal::CreateDefaultBatchControllerStub(
      background->cq(), options);
  return dataproc_v1_internal::MakeBatchControllerTracingConnection(
      std::make_shared<dataproc_v1_internal::BatchControllerConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

std::shared_ptr<BatchControllerConnection> MakeBatchControllerConnection(
    Options options) {
  return MakeBatchControllerConnection(std::string{}, std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataproc_v1
}  // namespace cloud
}  // namespace google
