// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataproc/v1/workflow_templates.proto

#include "google/cloud/dataproc/v1/internal/workflow_template_logging_decorator.h"
#include "google/cloud/internal/log_wrapper.h"
#include "google/cloud/status_or.h"
#include <google/cloud/dataproc/v1/workflow_templates.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace dataproc_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

WorkflowTemplateServiceLogging::WorkflowTemplateServiceLogging(
    std::shared_ptr<WorkflowTemplateServiceStub> child,
    TracingOptions tracing_options, std::set<std::string> const& components)
    : child_(std::move(child)),
      tracing_options_(std::move(tracing_options)),
      stream_logging_(components.find("rpc-streams") != components.end()) {}

StatusOr<google::cloud::dataproc::v1::WorkflowTemplate>
WorkflowTemplateServiceLogging::CreateWorkflowTemplate(
    grpc::ClientContext& context,
    google::cloud::dataproc::v1::CreateWorkflowTemplateRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::dataproc::v1::CreateWorkflowTemplateRequest const&
                 request) {
        return child_->CreateWorkflowTemplate(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::dataproc::v1::WorkflowTemplate>
WorkflowTemplateServiceLogging::GetWorkflowTemplate(
    grpc::ClientContext& context,
    google::cloud::dataproc::v1::GetWorkflowTemplateRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::dataproc::v1::GetWorkflowTemplateRequest const&
                 request) {
        return child_->GetWorkflowTemplate(context, request);
      },
      context, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
WorkflowTemplateServiceLogging::AsyncInstantiateWorkflowTemplate(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::dataproc::v1::InstantiateWorkflowTemplateRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::dataproc::v1::InstantiateWorkflowTemplateRequest const&
              request) {
        return child_->AsyncInstantiateWorkflowTemplate(cq, std::move(context),
                                                        options, request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
WorkflowTemplateServiceLogging::AsyncInstantiateInlineWorkflowTemplate(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::dataproc::v1::InstantiateInlineWorkflowTemplateRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             Options const& options,
             google::cloud::dataproc::v1::
                 InstantiateInlineWorkflowTemplateRequest const& request) {
        return child_->AsyncInstantiateInlineWorkflowTemplate(
            cq, std::move(context), options, request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::dataproc::v1::WorkflowTemplate>
WorkflowTemplateServiceLogging::UpdateWorkflowTemplate(
    grpc::ClientContext& context,
    google::cloud::dataproc::v1::UpdateWorkflowTemplateRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::dataproc::v1::UpdateWorkflowTemplateRequest const&
                 request) {
        return child_->UpdateWorkflowTemplate(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::dataproc::v1::ListWorkflowTemplatesResponse>
WorkflowTemplateServiceLogging::ListWorkflowTemplates(
    grpc::ClientContext& context,
    google::cloud::dataproc::v1::ListWorkflowTemplatesRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::dataproc::v1::ListWorkflowTemplatesRequest const&
                 request) {
        return child_->ListWorkflowTemplates(context, request);
      },
      context, request, __func__, tracing_options_);
}

Status WorkflowTemplateServiceLogging::DeleteWorkflowTemplate(
    grpc::ClientContext& context,
    google::cloud::dataproc::v1::DeleteWorkflowTemplateRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::dataproc::v1::DeleteWorkflowTemplateRequest const&
                 request) {
        return child_->DeleteWorkflowTemplate(context, request);
      },
      context, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
WorkflowTemplateServiceLogging::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::longrunning::GetOperationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             Options const& options,
             google::longrunning::GetOperationRequest const& request) {
        return child_->AsyncGetOperation(cq, std::move(context), options,
                                         request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

future<Status> WorkflowTemplateServiceLogging::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::longrunning::CancelOperationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             Options const& options,
             google::longrunning::CancelOperationRequest const& request) {
        return child_->AsyncCancelOperation(cq, std::move(context), options,
                                            request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataproc_v1_internal
}  // namespace cloud
}  // namespace google
