// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/cx/v3/agent.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DIALOGFLOW_CX_INTERNAL_AGENTS_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DIALOGFLOW_CX_INTERNAL_AGENTS_TRACING_CONNECTION_H

#include "google/cloud/dialogflow_cx/agents_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace dialogflow_cx_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class AgentsTracingConnection : public dialogflow_cx::AgentsConnection {
 public:
  ~AgentsTracingConnection() override = default;

  explicit AgentsTracingConnection(
      std::shared_ptr<dialogflow_cx::AgentsConnection> child);

  Options options() override { return child_->options(); }

  StreamRange<google::cloud::dialogflow::cx::v3::Agent> ListAgents(
      google::cloud::dialogflow::cx::v3::ListAgentsRequest request) override;

  StatusOr<google::cloud::dialogflow::cx::v3::Agent> GetAgent(
      google::cloud::dialogflow::cx::v3::GetAgentRequest const& request)
      override;

  StatusOr<google::cloud::dialogflow::cx::v3::Agent> CreateAgent(
      google::cloud::dialogflow::cx::v3::CreateAgentRequest const& request)
      override;

  StatusOr<google::cloud::dialogflow::cx::v3::Agent> UpdateAgent(
      google::cloud::dialogflow::cx::v3::UpdateAgentRequest const& request)
      override;

  Status DeleteAgent(
      google::cloud::dialogflow::cx::v3::DeleteAgentRequest const& request)
      override;

  future<StatusOr<google::cloud::dialogflow::cx::v3::ExportAgentResponse>>
  ExportAgent(google::cloud::dialogflow::cx::v3::ExportAgentRequest const&
                  request) override;

  future<StatusOr<google::protobuf::Struct>> RestoreAgent(
      google::cloud::dialogflow::cx::v3::RestoreAgentRequest const& request)
      override;

  StatusOr<google::cloud::dialogflow::cx::v3::AgentValidationResult>
  ValidateAgent(google::cloud::dialogflow::cx::v3::ValidateAgentRequest const&
                    request) override;

  StatusOr<google::cloud::dialogflow::cx::v3::AgentValidationResult>
  GetAgentValidationResult(
      google::cloud::dialogflow::cx::v3::GetAgentValidationResultRequest const&
          request) override;

  StatusOr<google::cloud::dialogflow::cx::v3::GenerativeSettings>
  GetGenerativeSettings(
      google::cloud::dialogflow::cx::v3::GetGenerativeSettingsRequest const&
          request) override;

  StatusOr<google::cloud::dialogflow::cx::v3::GenerativeSettings>
  UpdateGenerativeSettings(
      google::cloud::dialogflow::cx::v3::UpdateGenerativeSettingsRequest const&
          request) override;

 private:
  std::shared_ptr<dialogflow_cx::AgentsConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<dialogflow_cx::AgentsConnection> MakeAgentsTracingConnection(
    std::shared_ptr<dialogflow_cx::AgentsConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_cx_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DIALOGFLOW_CX_INTERNAL_AGENTS_TRACING_CONNECTION_H
