// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/v2/conversation_profile.proto

#include "google/cloud/dialogflow_es/conversation_profiles_connection.h"
#include "google/cloud/dialogflow_es/conversation_profiles_options.h"
#include "google/cloud/dialogflow_es/internal/conversation_profiles_connection_impl.h"
#include "google/cloud/dialogflow_es/internal/conversation_profiles_option_defaults.h"
#include "google/cloud/dialogflow_es/internal/conversation_profiles_stub_factory.h"
#include "google/cloud/dialogflow_es/internal/conversation_profiles_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace dialogflow_es {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ConversationProfilesConnection::~ConversationProfilesConnection() = default;

StreamRange<google::cloud::dialogflow::v2::ConversationProfile>
ConversationProfilesConnection::ListConversationProfiles(
    google::cloud::dialogflow::v2::
        ListConversationProfilesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::dialogflow::v2::ConversationProfile>>();
}

StatusOr<google::cloud::dialogflow::v2::ConversationProfile>
ConversationProfilesConnection::GetConversationProfile(
    google::cloud::dialogflow::v2::GetConversationProfileRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::dialogflow::v2::ConversationProfile>
ConversationProfilesConnection::CreateConversationProfile(
    google::cloud::dialogflow::v2::CreateConversationProfileRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::dialogflow::v2::ConversationProfile>
ConversationProfilesConnection::UpdateConversationProfile(
    google::cloud::dialogflow::v2::UpdateConversationProfileRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status ConversationProfilesConnection::DeleteConversationProfile(
    google::cloud::dialogflow::v2::DeleteConversationProfileRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::dialogflow::v2::ConversationProfile>>
ConversationProfilesConnection::SetSuggestionFeatureConfig(
    google::cloud::dialogflow::v2::SetSuggestionFeatureConfigRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dialogflow::v2::ConversationProfile>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::dialogflow::v2::ConversationProfile>>
ConversationProfilesConnection::ClearSuggestionFeatureConfig(
    google::cloud::dialogflow::v2::ClearSuggestionFeatureConfigRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::dialogflow::v2::ConversationProfile>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

std::shared_ptr<ConversationProfilesConnection>
MakeConversationProfilesConnection(std::string const& location,
                                   Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 ConversationProfilesPolicyOptionList>(
      options, __func__);
  options = dialogflow_es_internal::ConversationProfilesDefaultOptions(
      location, std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = dialogflow_es_internal::CreateDefaultConversationProfilesStub(
      background->cq(), options);
  return dialogflow_es_internal::MakeConversationProfilesTracingConnection(
      std::make_shared<
          dialogflow_es_internal::ConversationProfilesConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

std::shared_ptr<ConversationProfilesConnection>
MakeConversationProfilesConnection(Options options) {
  return MakeConversationProfilesConnection(std::string{}, std::move(options));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_es
}  // namespace cloud
}  // namespace google
